/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedPages;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedTemplates;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTemplate;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.StringID;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public final class NamedTemplatesDigester
extends ObjectDigester {
    private PDFNamedTemplates namedTemplates;
    private PDFNamedPages namedPages;

    public NamedTemplatesDigester(PDFDocument pdfDoc, PDFNamedTemplates namedTemplates, PDFNamedPages namedPages, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.namedTemplates = namedTemplates;
        this.namedPages = namedPages;
        this.sigField = sigField;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.namedTemplates != null) {
            this.digestTemplates();
        }
        if (this.namedPages != null) {
            this.digestPages();
        }
        byte[] digest = super.digest();
        return digest;
    }

    private void digestTemplates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        TreeSet sortedSet = new TreeSet(new NamedTemplatesComparator());
        Iterator iter = this.namedTemplates.iterator();
        while (iter.hasNext()) {
            sortedSet.add(iter.next());
        }
        for (PDFTree.Entry ntEntry : sortedSet) {
            byte[] name = ((ASString)ntEntry.getKey()).getBytes();
            PDFTemplate template = (PDFTemplate)ntEntry.getValue();
            if (!this.selector.shouldDigestTemplate(false)) continue;
            this.digestTemplate(name, (PDFPage)template);
        }
    }

    private void digestPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        TreeSet sortedSet = new TreeSet(new NamedPagesComparator());
        Iterator iter = this.namedPages.iterator();
        while (iter.hasNext()) {
            sortedSet.add(iter.next());
        }
        for (PDFTree.Entry npEntry : sortedSet) {
            ASString name = (ASString)npEntry.getKey();
            PDFPage page = (PDFPage)npEntry.getValue();
            if (!this.selector.shouldDigestTemplate(false)) continue;
            this.digestTemplate(name.getBytes(), page);
        }
    }

    private void digestTemplate(byte[] name, PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
        localDigester.update(new ASString(name));
        if (this.selector.shouldDigestTemplate(true) && page.getContents() != null) {
            byte[] tcDigest = this.digestTemplateContents(page);
            localDigester.update(tcDigest);
        }
        PDFAnnotationList annots = page.getAnnotationList();
        localDigester.update(annots);
        byte[] digest = localDigester.digest();
        this.update(digest);
    }

    static class NamedPagesComparator
    implements Comparator {
        NamedPagesComparator() {
        }

        public int compare(Object o1, Object o2) {
            StringID id1 = null;
            StringID id2 = null;
            try {
                PDFTree.Entry npNode1 = (PDFTree.Entry)o1;
                PDFTree.Entry npNode2 = (PDFTree.Entry)o2;
                id1 = StringID.getID(((ASString)npNode1.getKey()).getBytes(), null);
                id2 = StringID.getID(((ASString)npNode2.getKey()).getBytes(), null);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            if (id1 == null && id2 == null) {
                return 0;
            }
            if (id2 == null) {
                return 1;
            }
            return id1.compareTo(id2);
        }
    }

    static class NamedTemplatesComparator
    implements Comparator {
        NamedTemplatesComparator() {
        }

        public int compare(Object o1, Object o2) {
            StringID id1 = null;
            StringID id2 = null;
            try {
                PDFTree.Entry ntNode1 = (PDFTree.Entry)o1;
                PDFTree.Entry ntNode2 = (PDFTree.Entry)o2;
                id1 = StringID.getID(((ASString)ntNode1.getKey()).getBytes(), null);
                id2 = StringID.getID(((ASString)ntNode2.getKey()).getBytes(), null);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            return id1.compareTo(id2);
        }
    }
}

