/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSASigningUtils;
import com.adobe.internal.pdftoolkit.services.digsig.spi.RevocationInfoProvider;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.attributes.NonStandardAttribute;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.pkcs7.SignerInfo;
import java.util.Enumeration;
import java.util.Vector;

public final class RSARevInfoUtil {
    public static X501Attributes createAdobeRevocationInfo(RevocationInfoProvider revProvider) throws PDFSignatureException {
        X501Attributes attributeList = new X501Attributes();
        NonStandardAttribute revocationAttrib = RSARevInfoUtil.createAdobeRevocationInfoAttribute(revProvider);
        attributeList.addAttribute((X501Attribute)revocationAttrib);
        return attributeList;
    }

    public static NonStandardAttribute createAdobeRevocationInfoAttribute(RevocationInfoProvider revProvider) throws PDFSignatureException {
        NonStandardAttribute revocationAttrib = new NonStandardAttribute();
        byte[] oid = new byte[]{42, -122, 72, -122, -9, 47, 1, 1, 8};
        revocationAttrib.setOID(oid, 0, oid.length);
        byte[] revInfoBytes = RSARevInfoUtil.createASN(revProvider);
        revocationAttrib.setValue(revInfoBytes, 0, revInfoBytes.length);
        return revocationAttrib;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] createASN(RevocationInfoProvider revInfoProvider) throws PDFSignatureException {
        try {
            EncodedContainer ocspContainer;
            EncodedContainer crlContainer;
            boolean embedCRL = revInfoProvider.embedCRL();
            boolean embedOCSP = revInfoProvider.embedOCSP();
            boolean embedOtherRevInfo = revInfoProvider.embedOtherRevInfo();
            byte[][] ocspResponseArray = revInfoProvider.getOCSPResponses();
            byte[][] crlResponseArray = revInfoProvider.getCRLS();
            byte[][] otherRevInfoArray = revInfoProvider.getOtherRevInfo();
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OfContainer crlOf = new OfContainer(0xA10000, embedCRL, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            if (embedCRL) {
                if (crlResponseArray.length <= 0) throw new PDFSignatureException("No crl response provided for embedding into the signature");
                for (int index = 0; index < crlResponseArray.length; ++index) {
                    crlContainer = new EncodedContainer(0, embedCRL, 0, crlResponseArray[index], 0, crlResponseArray[index].length);
                    crlOf.addContainer((ASN1Container)crlContainer);
                }
            } else {
                crlContainer = new EncodedContainer(0, embedCRL, 0, null, 0, 0);
                crlOf.addContainer((ASN1Container)crlContainer);
            }
            OfContainer ocspsOf = new OfContainer(0xA10001, embedOCSP, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            if (embedOCSP) {
                if (ocspResponseArray.length <= 0) throw new PDFSignatureException("No ocsp response provided for embedding into the signature");
                for (int index = 0; index < ocspResponseArray.length; ++index) {
                    ocspContainer = new EncodedContainer(0, embedOCSP, 0, ocspResponseArray[index], 0, ocspResponseArray[index].length);
                    ocspsOf.addContainer((ASN1Container)ocspContainer);
                }
            } else {
                ocspContainer = new EncodedContainer(0, embedOCSP, 0, null, 0, 0);
                ocspsOf.addContainer((ASN1Container)ocspContainer);
            }
            OfContainer otherRevInfoOf = new OfContainer(10551298, embedOtherRevInfo, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            if (embedOtherRevInfo) {
                if (otherRevInfoArray.length <= 0) throw new PDFSignatureException("No other rev info provided for embedding into the signature");
                for (int index = 0; index < otherRevInfoArray.length; ++index) {
                    EncodedContainer otherRevInfoContainer = new EncodedContainer(0, embedOtherRevInfo, 0, otherRevInfoArray[index], 0, otherRevInfoArray[index].length);
                    otherRevInfoOf.addContainer((ASN1Container)otherRevInfoContainer);
                }
            } else {
                EncodedContainer otherRevInfoContainer = new EncodedContainer(0, embedOtherRevInfo, 0, null, 0, 0);
                otherRevInfoOf.addContainer((ASN1Container)otherRevInfoContainer);
            }
            ASN1Container[] asn1Def = new ASN1Container[]{seq, crlOf, ocspsOf, otherRevInfoOf, endContainer};
            return ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception e) {
            throw new PDFSignatureException("Problem encountered when DER encoding the Adobe Revocation Information Archival attribute", (Throwable)e);
        }
    }

    public static void addRevocationAttributeToSignerInfo(SignedData signedData, RevocationInfoProvider revInfoProvider) throws PDFSignatureException {
        if (revInfoProvider == null) {
            throw new PDFSignatureException("No revocation provider has been registered with the SignatureManager");
        }
        Vector listOfSigners = signedData.getSignerInfos();
        NonStandardAttribute revInfoAttribute = RSARevInfoUtil.createAdobeRevocationInfoAttribute(revInfoProvider);
        Enumeration e = listOfSigners.elements();
        while (e.hasMoreElements()) {
            SignerInfo retrievedSigner = (SignerInfo)e.nextElement();
            try {
                RSASigningUtils.addAuthenticatedAttribute(retrievedSigner, (X501Attribute)revInfoAttribute);
            }
            catch (PKCS7Exception e1) {
                throw new PDFSignatureException("Could not set the revocation information as an authenticated attribute of SignerInfo", (Throwable)e1);
            }
        }
    }
}

