/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAMessageDigester;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.CompositeContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.CertPolicies;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import java.io.ByteArrayInputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

class RSAASNUtilities {
    RSAASNUtilities() {
    }

    static ASN1Container getASNContainerForAlgorithmIdentifer(String algorithmName, boolean nullParameter) throws ASN_Exception {
        OIDContainer digestAlgorithmOIDConainer = new OIDContainer(0, true, 0, algorithmName, 11);
        ASN1Container[] asn1DefAlgorithmIdentifier = null;
        if (nullParameter) {
            EncodedContainer encodedContainerNullParameter = new EncodedContainer(65536, false, 5, null, 0, 0);
            asn1DefAlgorithmIdentifier = new ASN1Container[]{new SequenceContainer(0), digestAlgorithmOIDConainer, encodedContainerNullParameter, new EndContainer()};
        } else {
            asn1DefAlgorithmIdentifier = new ASN1Container[]{new SequenceContainer(0), digestAlgorithmOIDConainer, new EndContainer()};
        }
        return new CompositeContainer(asn1DefAlgorithmIdentifier);
    }

    static ASN1Container getASNContainerForHash(byte[] dataToBeDigested, String algorithmName) throws ASN_Exception, NoSuchAlgorithmException, PDFIOException, PDFSignatureException {
        RSAMessageDigester digester = new RSAMessageDigester(algorithmName);
        digester.feedDataToDigester(new ByteArrayInputStream(dataToBeDigested));
        byte[] digest = digester.calculateDigest();
        return new OctetStringContainer(0, true, 0, digest, 0, digest.length);
    }

    static ASN1Container getASNContainerForIssuerSerial(X509Certificate rsaSigningCertificate) throws ASN_Exception, NoSuchAlgorithmException, NameException {
        X500Name issuerName = rsaSigningCertificate.getIssuerName();
        byte[] issuerNameBytes = new byte[issuerName.getDERLen(0)];
        issuerName.getDEREncoding(issuerNameBytes, 0, 0);
        GeneralName issuerGeneralName = new GeneralName();
        issuerGeneralName.setGeneralName((Object)issuerName, 5);
        GeneralNames issuerGeneralNames = new GeneralNames();
        issuerGeneralNames.addGeneralName(issuerGeneralName);
        byte[] issuerData = new byte[issuerGeneralNames.getDERLen(0)];
        issuerGeneralNames.getDEREncoding(issuerData, 0, 0);
        EncodedContainer issuerNameContainer = new EncodedContainer(0, true, 0, null, 0, 0);
        issuerNameContainer.addData(issuerData, 0, issuerData.length, true, true);
        byte[] serialNumber = rsaSigningCertificate.getSerialNumber();
        IntegerContainer serialNumberContainer = new IntegerContainer(0, true, 0, serialNumber, 0, serialNumber.length, true);
        ASN1Container[] asn1DefIssuerSerial = new ASN1Container[]{new SequenceContainer(65536), issuerNameContainer, serialNumberContainer, new EndContainer()};
        return new CompositeContainer(asn1DefIssuerSerial);
    }

    static ASN1Container getASNContainerForESSCertIDvX(String certificateHashAlgorithmName, X509Certificate signingCertificate) throws ASN_Exception, CertificateException, NoSuchAlgorithmException, NameException, PDFIOException, PDFSignatureException {
        byte[] certificateBytesDerEncoded = new byte[signingCertificate.getDERLen(0)];
        signingCertificate.getDEREncoding(certificateBytesDerEncoded, 0, 0);
        ASN1Container certificateHashContainer = RSAASNUtilities.getASNContainerForHash(certificateBytesDerEncoded, certificateHashAlgorithmName);
        ASN1Container issuerSerialContainer = RSAASNUtilities.getASNContainerForIssuerSerial(signingCertificate);
        ASN1Container[] asn1DefESSCertIDv2 = null;
        if (!certificateHashAlgorithmName.equalsIgnoreCase("SHA1")) {
            ASN1Container algorithmIdentifierContainer = RSAASNUtilities.getASNContainerForAlgorithmIdentifer(certificateHashAlgorithmName, true);
            asn1DefESSCertIDv2 = new ASN1Container[]{new SequenceContainer(0), algorithmIdentifierContainer, certificateHashContainer, issuerSerialContainer, new EndContainer()};
        } else {
            asn1DefESSCertIDv2 = new ASN1Container[]{new SequenceContainer(0), certificateHashContainer, issuerSerialContainer, new EndContainer()};
        }
        return new CompositeContainer(asn1DefESSCertIDv2);
    }

    static ASN1Container getASNContainerForPolicyInformationSequence(X509Certificate signingCertificate) throws CertificateException, ASN_Exception {
        CertPolicies certificatePolicies = RSAASNUtilities.getCertificatePolicies(signingCertificate);
        if (certificatePolicies != null && certificatePolicies.getPoliciesCount() > 0) {
            ASN1Container[] asn1DefinitionPolicyInformationSequence = new ASN1Container[certificatePolicies.getPoliciesCount() + 2];
            asn1DefinitionPolicyInformationSequence[0] = new SequenceContainer(0);
            for (int i = 0; i < certificatePolicies.getPoliciesCount(); ++i) {
                CompositeContainer policyInformationContainer = RSAASNUtilities.getASNContainerForPolicyInformation(certificatePolicies.getCertPolicyId(i), certificatePolicies.getPolicyQualifiers(i));
                asn1DefinitionPolicyInformationSequence[i + 1] = policyInformationContainer;
            }
            asn1DefinitionPolicyInformationSequence[asn1DefinitionPolicyInformationSequence.length - 1] = new EndContainer();
            byte[] policyInformationSequenceDerEncodedBytes = ASN1.derEncode((ASN1Container[])asn1DefinitionPolicyInformationSequence);
            EncodedContainer policyInformationSequenceContainer = new EncodedContainer(65536, true, 0, policyInformationSequenceDerEncodedBytes, 0, policyInformationSequenceDerEncodedBytes.length);
            return policyInformationSequenceContainer;
        }
        return null;
    }

    private static CompositeContainer getASNContainerForPolicyInformation(byte[] policyID, PolicyQualifiers policyQualifiers) throws CertificateException, ASN_Exception {
        OIDContainer policyOIDContainer = new OIDContainer(0x1000000, true, 0, policyID, 0, policyID.length, -1);
        EncodedContainer policyQualifierContainer = null;
        ASN1Container[] asn1DefPolicyInformation = null;
        if (policyQualifiers != null) {
            byte[] policyQualifiersDerEncodedBytes = new byte[policyQualifiers.getDERLen(0)];
            policyQualifiers.getDEREncoding(policyQualifiersDerEncodedBytes, 0, 0);
            policyQualifierContainer = new EncodedContainer(65536, true, 5, policyQualifiersDerEncodedBytes, 0, policyQualifiersDerEncodedBytes.length);
            asn1DefPolicyInformation = new ASN1Container[]{new SequenceContainer(0), policyOIDContainer, policyQualifierContainer, new EndContainer()};
        } else {
            asn1DefPolicyInformation = new ASN1Container[]{new SequenceContainer(0), policyOIDContainer, new EndContainer()};
        }
        CompositeContainer policyInformationContainer = new CompositeContainer(asn1DefPolicyInformation);
        return policyInformationContainer;
    }

    static byte[] getSigningCertificateVXDerEncoded(String certificateHashAlgorithmName, X509Certificate signingCertificate, boolean isPolicyInformationRequired) throws CertificateException, ASN_Exception, NoSuchAlgorithmException, NameException, PDFIOException, PDFSignatureException {
        ASN1Container essCertIDvXContainer = RSAASNUtilities.getASNContainerForESSCertIDvX(certificateHashAlgorithmName, signingCertificate);
        ASN1Container policyInformationSequenceContainer = null;
        if (isPolicyInformationRequired) {
            policyInformationSequenceContainer = RSAASNUtilities.getASNContainerForPolicyInformationSequence(signingCertificate);
        }
        OfContainer essCertIDV2OfContainer = new OfContainer(0, true, 0, 12288, essCertIDvXContainer);
        essCertIDV2OfContainer.addContainer(essCertIDvXContainer);
        ASN1Container[] asn1DefSigningCertificateV2 = null;
        asn1DefSigningCertificateV2 = policyInformationSequenceContainer != null ? new ASN1Container[]{new SequenceContainer(0), essCertIDV2OfContainer, policyInformationSequenceContainer, new EndContainer()} : new ASN1Container[]{new SequenceContainer(0), essCertIDV2OfContainer, new EndContainer()};
        return ASN1.derEncode((ASN1Container[])asn1DefSigningCertificateV2);
    }

    static byte[] getPolicyIdentiferAttributeDerEncoded(String policyHashAlgorithmName, X509Certificate signingCertificate, byte[] policyID) throws CertificateException, ASN_Exception, NoSuchAlgorithmException, NameException, PDFIOException, PDFSignatureException {
        CertPolicies certificatePolicies = RSAASNUtilities.getCertificatePolicies(signingCertificate);
        if (certificatePolicies != null && certificatePolicies.getPoliciesCount() > 0) {
            for (int i = 0; i < certificatePolicies.getPoliciesCount(); ++i) {
                byte[] currentPolicyID = certificatePolicies.getCertPolicyId(i);
                if (!Arrays.equals(currentPolicyID, policyID)) continue;
                CompositeContainer policyInformationContainer = RSAASNUtilities.getASNContainerForPolicyInformation(currentPolicyID, certificatePolicies.getPolicyQualifiers(i));
                ASN1Container[] asnDefPolicyInformation = policyInformationContainer.getContainers();
                ASN1Container policyHashContainer = RSAASNUtilities.getASNContainerForHash(ASN1.derEncode((ASN1Container[])asnDefPolicyInformation), policyHashAlgorithmName);
                ASN1Container algorithmIdentifierContainer = RSAASNUtilities.getASNContainerForAlgorithmIdentifer(policyHashAlgorithmName, false);
                ASN1Container[] asn1DefOtherHashAlgAndValue = new ASN1Container[]{new SequenceContainer(0), algorithmIdentifierContainer, policyHashContainer, new EndContainer()};
                CompositeContainer otherHashAlgAndValueContainer = new CompositeContainer(asn1DefOtherHashAlgAndValue);
                ASN1Container[] asn1DefSignaturePolicyId = null;
                asn1DefSignaturePolicyId = asnDefPolicyInformation.length == 3 ? new ASN1Container[]{new SequenceContainer(0), asnDefPolicyInformation[1], otherHashAlgAndValueContainer, new EndContainer()} : new ASN1Container[]{new SequenceContainer(0), asnDefPolicyInformation[1], otherHashAlgAndValueContainer, asnDefPolicyInformation[2], new EndContainer()};
                return ASN1.derEncode((ASN1Container[])asn1DefSignaturePolicyId);
            }
        }
        return null;
    }

    static CertPolicies getCertificatePolicies(X509Certificate certificate) throws CertificateException {
        X509V3Extensions extensions = certificate.getExtensions();
        if (extensions != null) {
            return (CertPolicies)extensions.getExtensionByType(32);
        }
        return null;
    }
}

