/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.BCUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class DocumentTimeStampVerifier
extends Verifier {
    private static final int CHUNK_SIZE = 8192;

    @Override
    public boolean verify(InputStream inputStream, byte[] signaturePacketData) throws PDFSignatureException {
        try {
            TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(signaturePacketData));
            return BCUtilities.verifyTimestampToken(timeStampToken) && this.verifyMessageImprint(inputStream, timeStampToken);
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error Verifying Time Stamp Signature", (Throwable)e);
        }
    }

    private boolean verifyMessageImprint(InputStream inputStream, TimeStampToken timeStampToken) throws IOException, NoSuchAlgorithmException {
        TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
        ASN1ObjectIdentifier digestAlgOID = timeStampTokenInfo.getMessageImprintAlgOID();
        String digestAlgName = SignatureUtils.getAlgorithmName(digestAlgOID);
        byte[] digestInSignature = timeStampTokenInfo.getMessageImprintDigest();
        MessageDigest digester = MessageDigest.getInstance(digestAlgName);
        byte[] signedContentBytes = new byte[8192];
        while (inputStream.available() > 0) {
            int bytesRead = inputStream.read(signedContentBytes, 0, 8192);
            digester.update(signedContentBytes, 0, bytesRead);
        }
        byte[] recalculatedDigest = digester.digest();
        return Arrays.equals(recalculatedDigest, digestInSignature);
    }
}

