/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveLinearOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsLeanDoc;

public class SignatureOptionsDocMDP
extends SignatureOptionsLeanDoc {
    private PDFDocMDPPermissions docMDPPermissions;
    private String transformDigestMethod;
    private String legalAttestation;
    private boolean lockDynXFACertifyingField = false;

    protected SignatureOptionsDocMDP() {
        this.setSaveOptions((PDFSaveOptions)PDFSaveLinearOptions.newInstance((PDFVersion)PDFVersion.vLatest));
    }

    public static SignatureOptionsDocMDP newInstance() {
        return new SignatureOptionsDocMDP();
    }

    public boolean hasPermissions() {
        return this.docMDPPermissions != null;
    }

    public PDFDocMDPPermissions getDocMDPPermissions() {
        return this.docMDPPermissions;
    }

    public void setDocMDPPermissions(PDFDocMDPPermissions docMDPPermissions) {
        this.docMDPPermissions = docMDPPermissions;
    }

    public boolean hasTransformDigestMethod() {
        return this.transformDigestMethod != null;
    }

    public String getTransformDigestMethod() {
        return this.transformDigestMethod;
    }

    public void setTransformDigestMethod(String digestMethod) {
        if (!this.isTransformDigestSupported(digestMethod)) {
            throw new PDFUnsupportedFeatureException("Digest method " + digestMethod + " not supported");
        }
        this.transformDigestMethod = digestMethod;
    }

    public boolean hasLegalAttestation() {
        return this.legalAttestation != null;
    }

    public String getLegalAttestation() {
        return this.legalAttestation;
    }

    public void setLegalAttestation(String attestation) {
        this.legalAttestation = attestation;
    }

    public void enableLockDynXFACertifyingField() {
        this.lockDynXFACertifyingField = true;
    }

    public void disableLockDynXFACertifyingField() {
        this.lockDynXFACertifyingField = false;
    }

    public boolean lockDynXFACertifyingField() {
        return this.lockDynXFACertifyingField;
    }

    private boolean isTransformDigestSupported(String digest) {
        return digest.equalsIgnoreCase(PDFSignature.k_MD5.asString(true)) || digest.equalsIgnoreCase(PDFSignature.k_SHA1.asString(true));
    }

    public static SignatureOptionsDocMDP getDefaultInstance() {
        return SignatureOptionsDocMDP.newInstance();
    }
}

