/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl.barcode;

import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import java.lang.ref.SoftReference;

class BarcodeUtils {
    private static final ASName HELVETICA_FONT_KEY = ASName.create((String)"Helv");
    private static SoftReference<FontData> helveticaFontDataHolder = new SoftReference<Object>(null);
    private static double fxfontSizeMin = 4.0;
    private static double fxfontSizeMax = 144.0;
    static CCInfoRec[] sccUCSTable = new CCInfoRec[]{new CCInfoRec(0, 8, CClass.kCM), new CCInfoRec(9, 9, CClass.kBA), new CCInfoRec(10, 10, CClass.kLF), new CCInfoRec(11, 11, CClass.kCM), new CCInfoRec(12, 12, CClass.kBK), new CCInfoRec(13, 13, CClass.kCR), new CCInfoRec(14, 31, CClass.kCM), new CCInfoRec(32, 32, CClass.kSP), new CCInfoRec(33, 33, CClass.kEX), new CCInfoRec(34, 34, CClass.kQU), new CCInfoRec(35, 35, CClass.kAL), new CCInfoRec(36, 36, CClass.kPR), new CCInfoRec(37, 37, CClass.kPO), new CCInfoRec(38, 38, CClass.kAL), new CCInfoRec(39, 39, CClass.kQU), new CCInfoRec(40, 40, CClass.kOP), new CCInfoRec(41, 41, CClass.kCL), new CCInfoRec(42, 42, CClass.kAL), new CCInfoRec(43, 43, CClass.kPR), new CCInfoRec(44, 44, CClass.kIS), new CCInfoRec(45, 45, CClass.kHY), new CCInfoRec(46, 46, CClass.kIS), new CCInfoRec(47, 47, CClass.kSY), new CCInfoRec(48, 57, CClass.kNU), new CCInfoRec(58, 59, CClass.kIS), new CCInfoRec(60, 62, CClass.kAL), new CCInfoRec(63, 63, CClass.kEX), new CCInfoRec(64, 90, CClass.kAL), new CCInfoRec(91, 91, CClass.kOP), new CCInfoRec(92, 92, CClass.kPR), new CCInfoRec(93, 93, CClass.kCL), new CCInfoRec(94, 122, CClass.kAL), new CCInfoRec(123, 123, CClass.kOP), new CCInfoRec(124, 124, CClass.kBA), new CCInfoRec(125, 125, CClass.kCL), new CCInfoRec(126, 126, CClass.kAL), new CCInfoRec(127, 159, CClass.kCM), new CCInfoRec(160, 160, CClass.kGL), new CCInfoRec(161, 161, CClass.kAL), new CCInfoRec(162, 162, CClass.kPO), new CCInfoRec(163, 165, CClass.kPR), new CCInfoRec(166, 170, CClass.kAL), new CCInfoRec(171, 171, CClass.kQU), new CCInfoRec(172, 172, CClass.kAL), new CCInfoRec(173, 173, CClass.kBA), new CCInfoRec(174, 175, CClass.kAL), new CCInfoRec(176, 176, CClass.kPO), new CCInfoRec(177, 177, CClass.kPR), new CCInfoRec(178, 179, CClass.kAL), new CCInfoRec(180, 180, CClass.kBB), new CCInfoRec(181, 186, CClass.kAL), new CCInfoRec(187, 187, CClass.kQU), new CCInfoRec(188, 544, CClass.kAL), new CCInfoRec(546, 563, CClass.kAL), new CCInfoRec(592, 685, CClass.kAL), new CCInfoRec(688, 711, CClass.kAL), new CCInfoRec(712, 712, CClass.kBB), new CCInfoRec(713, 715, CClass.kAL), new CCInfoRec(716, 716, CClass.kBB), new CCInfoRec(717, 750, CClass.kAL), new CCInfoRec(768, 847, CClass.kCM), new CCInfoRec(864, 879, CClass.kCM), new CCInfoRec(884, 885, CClass.kAL), new CCInfoRec(890, 890, CClass.kAL), new CCInfoRec(894, 894, CClass.kAL), new CCInfoRec(900, 906, CClass.kAL), new CCInfoRec(908, 908, CClass.kAL), new CCInfoRec(910, 929, CClass.kAL), new CCInfoRec(931, 974, CClass.kAL), new CCInfoRec(976, 1014, CClass.kAL), new CCInfoRec(1024, 1154, CClass.kAL), new CCInfoRec(1155, 1158, CClass.kCM), new CCInfoRec(1160, 1161, CClass.kCM), new CCInfoRec(1162, 1230, CClass.kAL), new CCInfoRec(1232, 1269, CClass.kAL), new CCInfoRec(1272, 1273, CClass.kAL), new CCInfoRec(1280, 1295, CClass.kAL), new CCInfoRec(4352, 4441, CClass.kID), new CCInfoRec(4447, 4447, CClass.kID), new CCInfoRec(4448, 4514, CClass.kCM), new CCInfoRec(4520, 4601, CClass.kCM), new CCInfoRec(7680, 7835, CClass.kAL), new CCInfoRec(7840, 7929, CClass.kAL), new CCInfoRec(7936, 7957, CClass.kAL), new CCInfoRec(7960, 7965, CClass.kAL), new CCInfoRec(7968, 8005, CClass.kAL), new CCInfoRec(8008, 8013, CClass.kAL), new CCInfoRec(8016, 8023, CClass.kAL), new CCInfoRec(8025, 8025, CClass.kAL), new CCInfoRec(8027, 8027, CClass.kAL), new CCInfoRec(8029, 8029, CClass.kAL), new CCInfoRec(8031, 8061, CClass.kAL), new CCInfoRec(8064, 8116, CClass.kAL), new CCInfoRec(8118, 8132, CClass.kAL), new CCInfoRec(8134, 8147, CClass.kAL), new CCInfoRec(8150, 8155, CClass.kAL), new CCInfoRec(8157, 8175, CClass.kAL), new CCInfoRec(8178, 8180, CClass.kAL), new CCInfoRec(8182, 8190, CClass.kAL), new CCInfoRec(8192, 8198, CClass.kBA), new CCInfoRec(8199, 8199, CClass.kGL), new CCInfoRec(8200, 8202, CClass.kBA), new CCInfoRec(8203, 8203, CClass.kZW), new CCInfoRec(8204, 8207, CClass.kCM), new CCInfoRec(8208, 8208, CClass.kBA), new CCInfoRec(8209, 8209, CClass.kGL), new CCInfoRec(8210, 8211, CClass.kBA), new CCInfoRec(8212, 8212, CClass.kB2), new CCInfoRec(8213, 8215, CClass.kAL), new CCInfoRec(8216, 8217, CClass.kQU), new CCInfoRec(8218, 8218, CClass.kOP), new CCInfoRec(8219, 8221, CClass.kQU), new CCInfoRec(8222, 8222, CClass.kOP), new CCInfoRec(8223, 8223, CClass.kQU), new CCInfoRec(8224, 8227, CClass.kAL), new CCInfoRec(8228, 8230, CClass.kIN), new CCInfoRec(8231, 8231, CClass.kBA), new CCInfoRec(8232, 8233, CClass.kBK), new CCInfoRec(8234, 8238, CClass.kCM), new CCInfoRec(8239, 8239, CClass.kGL), new CCInfoRec(8240, 8247, CClass.kPO), new CCInfoRec(8248, 8248, CClass.kAL), new CCInfoRec(8249, 8250, CClass.kQU), new CCInfoRec(8251, 8251, CClass.kAL), new CCInfoRec(8252, 8252, CClass.kNS), new CCInfoRec(8253, 8259, CClass.kAL), new CCInfoRec(8260, 8260, CClass.kNS), new CCInfoRec(8261, 8261, CClass.kOP), new CCInfoRec(8262, 8262, CClass.kCL), new CCInfoRec(8263, 8274, CClass.kAL), new CCInfoRec(8279, 8279, CClass.kAL), new CCInfoRec(8287, 8287, CClass.kBA), new CCInfoRec(8288, 8288, CClass.kGL), new CCInfoRec(8289, 8291, CClass.kAL), new CCInfoRec(8298, 8303, CClass.kCM), new CCInfoRec(8304, 8305, CClass.kAL), new CCInfoRec(8308, 8316, CClass.kAL), new CCInfoRec(8317, 8317, CClass.kOP), new CCInfoRec(8318, 8318, CClass.kCL), new CCInfoRec(8319, 8332, CClass.kAL), new CCInfoRec(8333, 8333, CClass.kOP), new CCInfoRec(8334, 8334, CClass.kCL), new CCInfoRec(8352, 8358, CClass.kPR), new CCInfoRec(8359, 8359, CClass.kPO), new CCInfoRec(8360, 8369, CClass.kPR), new CCInfoRec(8400, 8426, CClass.kCM), new CCInfoRec(8448, 8450, CClass.kAL), new CCInfoRec(8451, 8451, CClass.kPO), new CCInfoRec(8452, 8456, CClass.kAL), new CCInfoRec(8457, 8457, CClass.kPO), new CCInfoRec(8458, 8469, CClass.kAL), new CCInfoRec(8470, 8470, CClass.kPR), new CCInfoRec(8471, 8485, CClass.kAL), new CCInfoRec(8486, 8486, CClass.kPO), new CCInfoRec(8487, 8506, CClass.kAL), new CCInfoRec(8509, 8523, CClass.kAL), new CCInfoRec(8531, 8579, CClass.kAL), new CCInfoRec(8592, 8721, CClass.kAL), new CCInfoRec(8722, 8723, CClass.kPR), new CCInfoRec(8724, 9000, CClass.kAL), new CCInfoRec(9001, 9001, CClass.kOP), new CCInfoRec(9002, 9002, CClass.kCL), new CCInfoRec(9003, 9139, CClass.kAL), new CCInfoRec(9140, 9140, CClass.kOP), new CCInfoRec(9141, 9141, CClass.kCL), new CCInfoRec(9142, 9142, CClass.kQU), new CCInfoRec(9143, 9166, CClass.kAL), new CCInfoRec(9216, 9254, CClass.kAL), new CCInfoRec(9280, 9290, CClass.kAL), new CCInfoRec(9312, 9470, CClass.kAL), new CCInfoRec(9472, 9747, CClass.kAL), new CCInfoRec(9750, 9751, CClass.kAL), new CCInfoRec(9753, 9853, CClass.kAL), new CCInfoRec(9856, 9865, CClass.kAL), new CCInfoRec(9985, 9988, CClass.kAL), new CCInfoRec(9990, 9993, CClass.kAL), new CCInfoRec(9996, 10023, CClass.kAL), new CCInfoRec(10025, 10059, CClass.kAL), new CCInfoRec(10061, 10061, CClass.kAL), new CCInfoRec(10063, 10066, CClass.kAL), new CCInfoRec(10070, 10070, CClass.kAL), new CCInfoRec(10072, 10074, CClass.kAL), new CCInfoRec(10075, 10078, CClass.kQU), new CCInfoRec(10081, 10081, CClass.kAL), new CCInfoRec(10082, 10083, CClass.kEX), new CCInfoRec(10084, 10087, CClass.kAL), new CCInfoRec(10088, 10088, CClass.kOP), new CCInfoRec(10089, 10089, CClass.kCL), new CCInfoRec(10090, 10090, CClass.kOP), new CCInfoRec(10091, 10091, CClass.kCL), new CCInfoRec(10092, 10092, CClass.kOP), new CCInfoRec(10093, 10093, CClass.kCL), new CCInfoRec(10094, 10094, CClass.kOP), new CCInfoRec(10095, 10095, CClass.kCL), new CCInfoRec(10096, 10096, CClass.kOP), new CCInfoRec(10097, 10097, CClass.kCL), new CCInfoRec(10098, 10098, CClass.kOP), new CCInfoRec(10099, 10099, CClass.kCL), new CCInfoRec(10100, 10100, CClass.kOP), new CCInfoRec(10101, 10101, CClass.kCL), new CCInfoRec(10102, 10132, CClass.kAL), new CCInfoRec(10136, 10159, CClass.kAL), new CCInfoRec(10161, 10174, CClass.kAL), new CCInfoRec(10192, 10213, CClass.kAL), new CCInfoRec(10214, 10214, CClass.kOP), new CCInfoRec(10215, 10215, CClass.kCL), new CCInfoRec(10216, 10216, CClass.kOP), new CCInfoRec(10217, 10217, CClass.kCL), new CCInfoRec(10218, 10218, CClass.kOP), new CCInfoRec(10219, 10219, CClass.kCL), new CCInfoRec(10224, 10626, CClass.kAL), new CCInfoRec(10627, 10627, CClass.kOP), new CCInfoRec(10628, 10628, CClass.kCL), new CCInfoRec(10629, 10629, CClass.kOP), new CCInfoRec(10630, 10630, CClass.kCL), new CCInfoRec(10631, 10631, CClass.kOP), new CCInfoRec(10632, 10632, CClass.kCL), new CCInfoRec(10633, 10633, CClass.kOP), new CCInfoRec(10634, 10634, CClass.kCL), new CCInfoRec(10635, 10635, CClass.kOP), new CCInfoRec(10636, 10636, CClass.kCL), new CCInfoRec(10637, 10637, CClass.kOP), new CCInfoRec(10638, 10638, CClass.kCL), new CCInfoRec(10639, 10639, CClass.kOP), new CCInfoRec(10640, 10640, CClass.kCL), new CCInfoRec(10641, 10641, CClass.kOP), new CCInfoRec(10642, 10642, CClass.kCL), new CCInfoRec(10643, 10643, CClass.kOP), new CCInfoRec(10644, 10644, CClass.kCL), new CCInfoRec(10645, 10645, CClass.kOP), new CCInfoRec(10646, 10646, CClass.kCL), new CCInfoRec(10647, 10647, CClass.kOP), new CCInfoRec(10648, 10648, CClass.kCL), new CCInfoRec(10649, 10711, CClass.kAL), new CCInfoRec(10712, 10712, CClass.kOP), new CCInfoRec(10713, 10713, CClass.kCL), new CCInfoRec(10714, 10714, CClass.kOP), new CCInfoRec(10715, 10715, CClass.kCL), new CCInfoRec(10716, 10747, CClass.kAL), new CCInfoRec(10748, 10748, CClass.kOP), new CCInfoRec(10749, 10749, CClass.kCL), new CCInfoRec(10750, 11007, CClass.kAL), new CCInfoRec(11904, 11929, CClass.kID), new CCInfoRec(11931, 12019, CClass.kID), new CCInfoRec(12032, 12245, CClass.kID), new CCInfoRec(12272, 12283, CClass.kID), new CCInfoRec(12288, 12288, CClass.kID), new CCInfoRec(12289, 12290, CClass.kCL), new CCInfoRec(12291, 12292, CClass.kID), new CCInfoRec(12293, 12293, CClass.kNS), new CCInfoRec(12294, 12295, CClass.kID), new CCInfoRec(12296, 12296, CClass.kOP), new CCInfoRec(12297, 12297, CClass.kCL), new CCInfoRec(12298, 12298, CClass.kOP), new CCInfoRec(12299, 12299, CClass.kCL), new CCInfoRec(12300, 12300, CClass.kOP), new CCInfoRec(12301, 12301, CClass.kCL), new CCInfoRec(12302, 12302, CClass.kOP), new CCInfoRec(12303, 12303, CClass.kCL), new CCInfoRec(12304, 12304, CClass.kOP), new CCInfoRec(12305, 12305, CClass.kCL), new CCInfoRec(12306, 12307, CClass.kID), new CCInfoRec(12308, 12308, CClass.kOP), new CCInfoRec(12309, 12309, CClass.kCL), new CCInfoRec(12310, 12310, CClass.kOP), new CCInfoRec(12311, 12311, CClass.kCL), new CCInfoRec(12312, 12312, CClass.kOP), new CCInfoRec(12313, 12313, CClass.kCL), new CCInfoRec(12314, 12314, CClass.kOP), new CCInfoRec(12315, 12315, CClass.kCL), new CCInfoRec(12316, 12316, CClass.kNS), new CCInfoRec(12317, 12317, CClass.kOP), new CCInfoRec(12318, 12319, CClass.kCL), new CCInfoRec(12320, 12329, CClass.kID), new CCInfoRec(12330, 12335, CClass.kCM), new CCInfoRec(12336, 12346, CClass.kID), new CCInfoRec(12347, 12348, CClass.kNS), new CCInfoRec(12349, 12351, CClass.kID), new CCInfoRec(12353, 12353, CClass.kNS), new CCInfoRec(12354, 12354, CClass.kID), new CCInfoRec(12355, 12355, CClass.kNS), new CCInfoRec(12356, 12356, CClass.kID), new CCInfoRec(12357, 12357, CClass.kNS), new CCInfoRec(12358, 12358, CClass.kID), new CCInfoRec(12359, 12359, CClass.kNS), new CCInfoRec(12360, 12360, CClass.kID), new CCInfoRec(12361, 12361, CClass.kNS), new CCInfoRec(12362, 12386, CClass.kID), new CCInfoRec(12387, 12387, CClass.kNS), new CCInfoRec(12388, 12418, CClass.kID), new CCInfoRec(12419, 12419, CClass.kNS), new CCInfoRec(12420, 12420, CClass.kID), new CCInfoRec(12421, 12421, CClass.kNS), new CCInfoRec(12422, 12422, CClass.kID), new CCInfoRec(12423, 12423, CClass.kNS), new CCInfoRec(12424, 12429, CClass.kID), new CCInfoRec(12430, 12430, CClass.kNS), new CCInfoRec(12431, 12436, CClass.kID), new CCInfoRec(12437, 12438, CClass.kNS), new CCInfoRec(12441, 12442, CClass.kCM), new CCInfoRec(12443, 12446, CClass.kNS), new CCInfoRec(12447, 12447, CClass.kID), new CCInfoRec(12448, 12449, CClass.kNS), new CCInfoRec(12450, 12450, CClass.kID), new CCInfoRec(12451, 12451, CClass.kNS), new CCInfoRec(12452, 12452, CClass.kID), new CCInfoRec(12453, 12453, CClass.kNS), new CCInfoRec(12454, 12454, CClass.kID), new CCInfoRec(12455, 12455, CClass.kNS), new CCInfoRec(12456, 12456, CClass.kID), new CCInfoRec(12457, 12457, CClass.kNS), new CCInfoRec(12458, 12482, CClass.kID), new CCInfoRec(12483, 12483, CClass.kNS), new CCInfoRec(12484, 12514, CClass.kID), new CCInfoRec(12515, 12515, CClass.kNS), new CCInfoRec(12516, 12516, CClass.kID), new CCInfoRec(12517, 12517, CClass.kNS), new CCInfoRec(12518, 12518, CClass.kID), new CCInfoRec(12519, 12519, CClass.kNS), new CCInfoRec(12520, 12525, CClass.kID), new CCInfoRec(12526, 12526, CClass.kNS), new CCInfoRec(12527, 12532, CClass.kID), new CCInfoRec(12533, 12534, CClass.kNS), new CCInfoRec(12535, 12538, CClass.kID), new CCInfoRec(12539, 12542, CClass.kNS), new CCInfoRec(12543, 12543, CClass.kID), new CCInfoRec(12549, 12588, CClass.kID), new CCInfoRec(12593, 12686, CClass.kID), new CCInfoRec(12688, 12727, CClass.kID), new CCInfoRec(12784, 12799, CClass.kNS), new CCInfoRec(12800, 12828, CClass.kID), new CCInfoRec(12832, 12867, CClass.kID), new CCInfoRec(12881, 12923, CClass.kID), new CCInfoRec(12927, 13003, CClass.kID), new CCInfoRec(13008, 13054, CClass.kID), new CCInfoRec(13056, 13174, CClass.kID), new CCInfoRec(13179, 13277, CClass.kID), new CCInfoRec(13280, 13310, CClass.kID), new CCInfoRec(13312, 19893, CClass.kID), new CCInfoRec(19968, 40869, CClass.kID), new CCInfoRec(40960, 42124, CClass.kID), new CCInfoRec(42128, 42182, CClass.kID), new CCInfoRec(44032, 55203, CClass.kID), new CCInfoRec(55296, 56319, CClass.kHS), new CCInfoRec(56320, 57343, CClass.kLS), new CCInfoRec(63744, 64045, CClass.kID), new CCInfoRec(64048, 64106, CClass.kID), new CCInfoRec(64256, 64262, CClass.kAL), new CCInfoRec(65056, 65059, CClass.kCM), new CCInfoRec(65072, 65076, CClass.kID), new CCInfoRec(65077, 65077, CClass.kOP), new CCInfoRec(65078, 65078, CClass.kCL), new CCInfoRec(65079, 65079, CClass.kOP), new CCInfoRec(65080, 65080, CClass.kCL), new CCInfoRec(65081, 65081, CClass.kOP), new CCInfoRec(65082, 65082, CClass.kCL), new CCInfoRec(65083, 65083, CClass.kOP), new CCInfoRec(65084, 65084, CClass.kCL), new CCInfoRec(65085, 65085, CClass.kOP), new CCInfoRec(65086, 65086, CClass.kCL), new CCInfoRec(65087, 65087, CClass.kOP), new CCInfoRec(65088, 65088, CClass.kCL), new CCInfoRec(65089, 65089, CClass.kOP), new CCInfoRec(65090, 65090, CClass.kCL), new CCInfoRec(65091, 65091, CClass.kOP), new CCInfoRec(65092, 65092, CClass.kCL), new CCInfoRec(65093, 65094, CClass.kID), new CCInfoRec(65097, 65103, CClass.kID), new CCInfoRec(65104, 65104, CClass.kCL), new CCInfoRec(65105, 65105, CClass.kID), new CCInfoRec(65106, 65106, CClass.kCL), new CCInfoRec(65108, 65109, CClass.kNS), new CCInfoRec(65110, 65111, CClass.kEX), new CCInfoRec(65112, 65112, CClass.kID), new CCInfoRec(65113, 65113, CClass.kOP), new CCInfoRec(65114, 65114, CClass.kCL), new CCInfoRec(65115, 65115, CClass.kOP), new CCInfoRec(65116, 65116, CClass.kCL), new CCInfoRec(65117, 65117, CClass.kOP), new CCInfoRec(65118, 65118, CClass.kCL), new CCInfoRec(65119, 65126, CClass.kID), new CCInfoRec(65128, 65128, CClass.kID), new CCInfoRec(65129, 65129, CClass.kPR), new CCInfoRec(65130, 65130, CClass.kPO), new CCInfoRec(65131, 65131, CClass.kID), new CCInfoRec(65279, 65279, CClass.kGL), new CCInfoRec(65281, 65281, CClass.kEX), new CCInfoRec(65282, 65283, CClass.kID), new CCInfoRec(65284, 65284, CClass.kPR), new CCInfoRec(65285, 65285, CClass.kPO), new CCInfoRec(65286, 65287, CClass.kID), new CCInfoRec(65288, 65288, CClass.kOP), new CCInfoRec(65289, 65289, CClass.kCL), new CCInfoRec(65290, 65291, CClass.kID), new CCInfoRec(65292, 65292, CClass.kCL), new CCInfoRec(65293, 65293, CClass.kID), new CCInfoRec(65294, 65294, CClass.kCL), new CCInfoRec(65295, 65305, CClass.kID), new CCInfoRec(65306, 65307, CClass.kNS), new CCInfoRec(65308, 65310, CClass.kID), new CCInfoRec(65311, 65311, CClass.kEX), new CCInfoRec(65312, 65338, CClass.kID), new CCInfoRec(65339, 65339, CClass.kOP), new CCInfoRec(65340, 65340, CClass.kID), new CCInfoRec(65341, 65341, CClass.kCL), new CCInfoRec(65342, 65370, CClass.kID), new CCInfoRec(65371, 65371, CClass.kOP), new CCInfoRec(65372, 65372, CClass.kID), new CCInfoRec(65373, 65373, CClass.kCL), new CCInfoRec(65374, 65374, CClass.kID), new CCInfoRec(65375, 65375, CClass.kOP), new CCInfoRec(65376, 65377, CClass.kCL), new CCInfoRec(65378, 65378, CClass.kOP), new CCInfoRec(65379, 65380, CClass.kCL), new CCInfoRec(65381, 65381, CClass.kNS), new CCInfoRec(65382, 65382, CClass.kAL), new CCInfoRec(65383, 65392, CClass.kNS), new CCInfoRec(65393, 65437, CClass.kAL), new CCInfoRec(65438, 65439, CClass.kNS), new CCInfoRec(65440, 65470, CClass.kAL), new CCInfoRec(65474, 65479, CClass.kAL), new CCInfoRec(65482, 65487, CClass.kAL), new CCInfoRec(65490, 65495, CClass.kAL), new CCInfoRec(65498, 65500, CClass.kAL), new CCInfoRec(65504, 65504, CClass.kPO), new CCInfoRec(65505, 65505, CClass.kPR), new CCInfoRec(65506, 65508, CClass.kID), new CCInfoRec(65509, 65510, CClass.kPR), new CCInfoRec(65512, 65518, CClass.kAL), new CCInfoRec(65529, 65531, CClass.kCM), new CCInfoRec(65532, 65532, CClass.kB2), new CCInfoRec(65533, 65533, CClass.kAL)};
    private static int[][] sccUCSTableAcc = new int[][]{{0, 52}, {52, 52}, {52, 59}, {60, 69}, {70, 75}, {76, 76}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {77, 80}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {81, 82}, {83, 98}, {99, 145}, {146, 157}, {157, 159}, {159, 166}, {167, 169}, {170, 170}, {170, 173}, {174, 210}, {210, 210}, {210, 241}, {241, 241}, {0, -1}, {0, -1}, {0, -1}, {242, 243}, {244, 245}, {246, 325}, {326, 329}, {330, 334}, {335, 337}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {338, 338}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {339, 339}, {340, 340}, {340, 340}, {340, 340}, {340, 340}, {340, 341}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {342, 342}, {343, 343}, {343, 343}, {343, 343}, {343, 343}, {344, 344}, {344, 344}, {344, 344}, {344, 344}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {345, 345}, {345, 346}, {347, 347}, {0, -1}, {0, -1}, {348, 385}, {386, 431}};

    BarcodeUtils() {
    }

    private static FontData getHelveticaFontData() throws PDFFontException {
        FontData fontData = helveticaFontDataHolder.get();
        if (fontData == null) {
            try {
                fontData = ((FontImpl)Base14.helveticaRegular).getFontData();
                helveticaFontDataHolder = new SoftReference<FontData>(fontData);
            }
            catch (InvalidFontException e) {
                throw new PDFFontException((Throwable)e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFFontException((Throwable)e);
            }
            catch (FontLoadingException e) {
                throw new PDFFontException((Throwable)e);
            }
        }
        return fontData;
    }

    private static void flow(String captionStr, PDFFontSimple font, ASRectangle fr, double fxFontSize, ContentWriter writer) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFParseException, PDFInvalidParameterException, PDFFontException {
        BarcodeUtils.flowVector(captionStr, font, fr, fxFontSize, writer);
    }

    static void flowEx(ContentWriter writer, String captionStr, PDFFontSimple font, ASRectangle fr) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFParseException, PDFInvalidParameterException, PDFFontException {
        double fxFontSize = BarcodeUtils.stringMaxFontSize(captionStr, font, fr.width(), fr.height(), 0.0625);
        if (fxFontSize < 0.0) {
            fxFontSize = fxfontSizeMin;
        }
        writer.write(InstructionFactory.newTextFont((ASName)HELVETICA_FONT_KEY, (double)fxFontSize));
        BarcodeUtils.flow(captionStr, font, fr, fxFontSize, writer);
    }

    private static void flowVector(String captionStr, PDFFontSimple font, ASRectangle fr, double fxFontSize, ContentWriter writer) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFParseException, PDFInvalidParameterException, PDFFontException {
        double ht = font.getBBox().height();
        double fxWidth = fr.width();
        double fxHeight = fxFontSize * (ht / 1000.0);
        double fxDescent = font.getDescent() / 1000.0;
        double fxY = fr.top();
        if (fr.top() - fr.bottom() < fxHeight) {
            fxY += fxHeight - (fr.top() - fr.bottom()) - fxDescent;
        }
        writer.write(InstructionFactory.newTextPosition((double)fr.left(), (double)(fxY - fxHeight)));
        double fxLineWidth = BarcodeUtils.EStrMeasure(captionStr, false) * fxFontSize;
        double fxTweak = (fxWidth - fxLineWidth) / 2.0;
        writer.write(InstructionFactory.newTextLeading((double)fxHeight));
        if (fxTweak != 0.0) {
            writer.write(InstructionFactory.newTextPosition((double)fxTweak, (double)0.0));
        }
        int[] ccodes = new int[captionStr.length()];
        for (int i = 0; i < captionStr.length(); ++i) {
            char unicodeValue = captionStr.charAt(i);
            ccodes[i] = font.getCharCode(unicodeValue);
        }
        writer.write(InstructionFactory.newShowText((ASHexString)new ASHexString(ccodes, 1, 0)));
    }

    private static double stringMaxFontSize(String captionStr, PDFFontSimple font, double fxMaxWidth, double fxMaxHeight, double fxGranularity) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        double fxSize;
        boolean tooBig;
        if (fxGranularity == 0.0) {
            fxGranularity = 0.0625;
        }
        double fxTextHeight = 0.0;
        double fxTextWidth = 0.0;
        int maxIts = 32;
        ASRectangle fontBbox = font.getBBox();
        double ht = fontBbox.height();
        double fxFSLowerBound = fxfontSizeMin;
        double fxFSUpperBound = fxfontSizeMax + fxGranularity;
        double fxFontWidth = BarcodeUtils.EStrMeasure(captionStr, true);
        fxTextWidth = fxFontWidth * fxfontSizeMax;
        fxTextHeight = ht / 1000.0 * fxfontSizeMax;
        if (fxTextHeight <= fxMaxHeight && fxTextWidth <= fxMaxWidth) {
            return fxfontSizeMax;
        }
        fxTextWidth = fxFontWidth * fxfontSizeMin;
        if (fxTextWidth > fxMaxWidth) {
            return -1.0;
        }
        if (fxfontSizeMax == 10.5) {
            fxFSUpperBound += 0.5;
        }
        do {
            tooBig = false;
            fxSize = (fxFSLowerBound + fxFSUpperBound) / 2.0;
            fxTextHeight = ht / 1000.0 * fxSize;
            fxTextWidth = fxFontWidth * fxSize;
            if (fxTextHeight < 0.0 || fxTextHeight > fxMaxHeight || fxTextWidth < 0.0 || fxTextWidth > fxMaxWidth) {
                tooBig = true;
            }
            if (tooBig) {
                fxFSUpperBound = fxSize;
            } else {
                fxFSLowerBound = fxSize;
            }
            if (maxIts-- > 0 && !(fxFSUpperBound - fxFSLowerBound < fxGranularity)) continue;
            fxSize = fxFSLowerBound;
            break;
        } while (tooBig || !(fxTextHeight + fxGranularity > fxMaxHeight) && !(fxTextWidth + fxGranularity > fxMaxWidth));
        if (fxSize < fxfontSizeMin) {
            fxSize = fxfontSizeMin;
        } else if (fxSize > fxfontSizeMax) {
            fxSize = fxfontSizeMax;
        }
        return fxSize;
    }

    private static double EStrMeasure(String captionStr, boolean bCountTrailingSpaces) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        return BarcodeUtils.measureToEnd(bCountTrailingSpaces, captionStr) / 1000.0;
    }

    private static double measureToEnd(boolean bCountTrailingSpaces, String captionStr) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        double fxWidthTotal = 0.0;
        double fxTrailingSpaceWidth = 0.0;
        try {
            for (int index = 0; index < captionStr.length(); ++index) {
                char unicodeValue = captionStr.charAt(index);
                int gid = BarcodeUtils.getHelveticaFontData().getGlyphForChar((int)unicodeValue);
                double fxWidth = BarcodeUtils.getHelveticaFontData().getHorizontalAdvance(gid);
                fxWidthTotal += fxWidth;
                if (bCountTrailingSpaces) continue;
                CClass cclass = BarcodeUtils.CharClassFromUCS(unicodeValue);
                if (BarcodeUtils.IsControlChar(cclass) || cclass == CClass.kSP) {
                    fxTrailingSpaceWidth += fxWidth;
                    continue;
                }
                fxTrailingSpaceWidth = 0.0;
            }
        }
        catch (InvalidFontException e) {
            throw new PDFFontException((Throwable)e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException((Throwable)e);
        }
        return bCountTrailingSpaces ? fxWidthTotal : fxWidthTotal - fxTrailingSpaceWidth;
    }

    private static boolean IsControlChar(CClass charClass) {
        return charClass == CClass.kCR || charClass == CClass.kLF || charClass == CClass.kBK || charClass == CClass.kCM;
    }

    static CClass CharClassFromUCS(int nChar) {
        int nFront = sccUCSTableAcc[nChar & 0xFF][0];
        int nBack = sccUCSTableAcc[nChar & 0xFF][1];
        while (nFront <= nBack) {
            int nMid = (nFront + nBack) / 2;
            if (nChar < BarcodeUtils.sccUCSTable[nMid].nLow) {
                nBack = nMid - 1;
                continue;
            }
            if (nChar > BarcodeUtils.sccUCSTable[nMid].nHigh) {
                nFront = nMid + 1;
                continue;
            }
            return BarcodeUtils.sccUCSTable[nMid].cClass;
        }
        return CClass.kAL;
    }

    static class CCInfoRec {
        int nHigh;
        int nLow;
        CClass cClass;

        CCInfoRec(int h, int l, CClass c) {
            this.nHigh = h;
            this.nLow = l;
            this.cClass = c;
        }
    }

    static enum CClass {
        kOP,
        kCL,
        kQU,
        kGL,
        kNS,
        kEX,
        kSY,
        kIS,
        kPR,
        kPO,
        kNU,
        kAL,
        kID,
        kIN,
        kHY,
        kBA,
        kBB,
        kB2,
        kZW,
        kCM,
        kClassCount,
        kSP,
        kCR,
        kLF,
        kBK,
        kHS,
        kLS,
        kXX;

    }
}

