/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.fontengine.font.Font;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.pdfport.PDFPort;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import java.io.IOException;
import java.util.HashMap;

public abstract class TextAppearance {
    private static final int defaultFormType = 1;

    public static void buildAppearanceCharacteristics(PDFAppearanceCharacteristics apCharact, PDFRectangle bBoxRect, PDFBorderStyle bs, PDFField field, RCGOptions options, ContentWriter xobjectContentWriter) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (apCharact == null) {
            return;
        }
        double[] backgroundColor = null;
        if (apCharact.hasBackgroundColor()) {
            backgroundColor = apCharact.getBackgroundColor();
            switch (backgroundColor.length) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    ContentModifier.addFillRectangle((ContentWriter)xobjectContentWriter, (PDFRectangle)bBoxRect, (double[])backgroundColor);
                    break;
                }
                default: {
                    throw new PDFInvalidParameterException("illegal background color");
                }
            }
        }
        if (apCharact.hasBorderColor()) {
            double[] borderColor = apCharact.getBorderColor();
            switch (borderColor.length) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    double width = 1.0;
                    double[] dash = new double[]{};
                    PDFBorderStyle.Style style = null;
                    if (bs != null) {
                        if (bs.hasWidth()) {
                            width = bs.getWidth();
                        }
                        if (bs.hasStyle()) {
                            style = bs.getStyle();
                            if (style == PDFBorderStyle.Style.Dashed && bs.hasDash()) {
                                dash = bs.getDash();
                            }
                            if (style == PDFBorderStyle.Style.Beveled || style == PDFBorderStyle.Style.Inset) {
                                ContentModifier.addFillBeveledOrInset((ContentWriter)xobjectContentWriter, (PDFBorderStyle.Style)style, (double)bBoxRect.left(), (double)bBoxRect.bottom(), (double)bBoxRect.right(), (double)bBoxRect.top(), (double)width, (double[])backgroundColor);
                            }
                        }
                    }
                    ContentModifier.addStrokeRectangle((ContentWriter)xobjectContentWriter, (PDFRectangle)bBoxRect, (double)1.0, (double[])borderColor, style, (double[])dash, (double)width);
                    if (!(field instanceof PDFFieldText) || !((PDFFieldText)field).isComb() || style != null && style != PDFBorderStyle.Style.Solid && style != PDFBorderStyle.Style.Dashed) break;
                    ContentModifier.addCombDividers((ContentWriter)xobjectContentWriter, (PDFRectangle)bBoxRect, (int)((PDFFieldText)field).getMaxLen(), (double)width);
                    break;
                }
                default: {
                    throw new PDFInvalidParameterException("illegal border color");
                }
            }
        }
    }

    public static PDFXObjectForm buildTextAppearance(PDFDocument doc, PDFFontSet pdfFonts, PDFAnnotation annot, PDFField field, HashMap afePDFFontMap, AppearanceAttributes appearanceAttributes, TextFormatter textFormatter) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException {
        String textString = appearanceAttributes.getTextValue();
        try {
            boolean alwaysRegen = true;
            PDFXObjectForm appearance = PDFXObjectForm.newInstance((PDFDocument)doc);
            PDFResources resources = PDFResources.newInstance((PDFDocument)doc);
            OutputByteStream xobjectContents = doc.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, (long)textString.length());
            ContentWriter xobjectContentWriter = ContentWriter.newInstance((PDFDocument)doc, (OutputByteStream)xobjectContents);
            PDFXObjectForm xobjectForm = annot.getNormalStateAppearance();
            if (alwaysRegen || xobjectForm == null) {
                PDFRectangle bBoxRect = null;
                PDFBorderStyle bs = null;
                if (annot instanceof PDFAnnotationWidget) {
                    bBoxRect = AppearanceUtils.getBBoxRectangle((PDFAnnotationWidget)annot);
                    if (((PDFAnnotationWidget)annot).hasAppearanceCharacteristics()) {
                        bs = annot.getBorderStyle();
                        TextAppearance.buildAppearanceCharacteristics(((PDFAnnotationWidget)annot).getAppearanceCharacteristics(), bBoxRect, bs, field, appearanceAttributes.getRcgOptions(), xobjectContentWriter);
                    }
                } else if (annot instanceof PDFAnnotationRedaction) {
                    PDFRectangle annotRect = ((PDFAnnotationRedaction)annot).getRedactionAreaBBox();
                    bBoxRect = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)0.0, (double)0.0, (double)annotRect.width(), (double)annotRect.height());
                }
                ContentModifier.addBeginMarkedContent((ContentWriter)xobjectContentWriter);
                double[] clipPadding = appearanceAttributes.getClipPadding();
                ContentModifier.addClippingPath((ContentWriter)xobjectContentWriter, (PDFRectangle)bBoxRect, (double)clipPadding[0], (double)clipPadding[1], (double)clipPadding[2], (double)clipPadding[3]);
                appearanceAttributes.setTextValue(textString);
                PDFRectangle annotRect = annot.getRect();
                PDFRectangle pageRect = null;
                PDFPage page = annot.getPage();
                pageRect = null == page ? PDFRectangle.newInstance((PDFDocument)doc, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : page.getCropBox();
                appearanceAttributes.setAnnotRect(annotRect);
                appearanceAttributes.setPageRect(pageRect);
                TextAppearance.formatText(xobjectContentWriter, doc, resources, pdfFonts, afePDFFontMap, appearanceAttributes, textFormatter);
                ContentModifier.addEndMarkedContent((ContentWriter)xobjectContentWriter);
            } else {
                Content content = Content.newInstance((PDFXObjectForm)xobjectForm);
                ContentReader reader = ContentReader.newInstance((Content)content);
                Instruction instruction = null;
                boolean foundEMC = false;
                boolean stop = false;
                boolean foundBMC = false;
                while (reader.hasNext()) {
                    instruction = reader.next();
                    ASName operator = instruction.getOperator();
                    if (operator == ASName.k_BMC) {
                        if (foundBMC) {
                            throw new PDFInvalidContentException("Multiple BT were found.");
                        }
                        foundBMC = true;
                        xobjectContentWriter.write(instruction);
                        stop = true;
                        appearanceAttributes.setTextValue(textString);
                        TextAppearance.formatText(xobjectContentWriter, doc, resources, pdfFonts, afePDFFontMap, appearanceAttributes, textFormatter);
                    } else if (operator == ASName.k_EMC) {
                        foundEMC = true;
                        xobjectContentWriter.write(instruction);
                    }
                    if (stop) {
                        if (!foundEMC) continue;
                        stop = false;
                        continue;
                    }
                    xobjectContentWriter.write(instruction);
                }
            }
            InputByteStream streamData = xobjectContents.closeAndConvert();
            xobjectContents = null;
            if (streamData.length() == 0L) {
                return null;
            }
            appearance.setFormType(1);
            appearance.setResources(resources);
            appearance.setStream(streamData);
            streamData = null;
            if (annot instanceof PDFAnnotationWidget) {
                double[] matrixValues;
                PDFRectangle bBoxRect = AppearanceUtils.getBBoxRectangle((PDFAnnotationWidget)annot);
                ASMatrix matrix = null;
                matrix = ASMatrix.createIdentityMatrix();
                if (alwaysRegen) {
                    matrix = ASMatrix.createIdentityMatrix();
                } else if (annot.getNormalStateAppearance() != null && (matrixValues = annot.getNormalStateAppearance().getMatrix()) != null) {
                    matrix = new ASMatrix(matrixValues);
                }
                if ((alwaysRegen || annot.getNormalStateAppearance() == null) && ((PDFAnnotationWidget)annot).hasAppearanceCharacteristics()) {
                    PDFAppearanceCharacteristics apCharact = ((PDFAnnotationWidget)annot).getAppearanceCharacteristics();
                    matrix = AppearanceUtils.getRotationMatrix(matrix, apCharact, bBoxRect);
                }
                if (matrix != null) {
                    matrixValues = new double[]{matrix.geta(), matrix.getb(), matrix.getc(), matrix.getd(), matrix.getx(), matrix.gety()};
                    appearance.setMatrix(matrixValues);
                }
                appearance.setBBox(bBoxRect);
            } else if (annot instanceof PDFAnnotationRedaction) {
                double[] matrixValues;
                PDFRectangle annotRect = ((PDFAnnotationRedaction)annot).getRedactionAreaBBox();
                PDFRectangle bBoxRect = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)0.0, (double)0.0, (double)annotRect.width(), (double)annotRect.height());
                ASMatrix matrix = null;
                matrix = ASMatrix.createIdentityMatrix();
                if (alwaysRegen) {
                    matrix = ASMatrix.createIdentityMatrix();
                } else if (annot.getNormalStateAppearance() != null && (matrixValues = annot.getNormalStateAppearance().getMatrix()) != null) {
                    matrix = new ASMatrix(matrixValues);
                }
                if (matrix != null) {
                    matrixValues = new double[]{matrix.geta(), matrix.getb(), matrix.getc(), matrix.getd(), matrix.getx(), matrix.gety()};
                    appearance.setMatrix(matrixValues);
                }
                appearance.setBBox(bBoxRect);
            }
            return appearance;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    public static void formatText(ContentWriter xobjectContentWriter, PDFDocument doc, PDFResources resources, PDFFontSet pdfFontSet, HashMap afePDFFontMap, AppearanceAttributes appearanceAttributes, TextFormatter textFormatter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFFontException {
        PDFFontSetImpl pdfFonts = (PDFFontSetImpl)pdfFontSet;
        String textValue = appearanceAttributes.getTextValue();
        if (textValue == null || textValue.trim().equals("")) {
            return;
        }
        PDFFontMap fontMap = PDFFontMap.newInstance((PDFDocument)doc);
        resources.setFontMap(fontMap);
        ASName[] names = new ASName[]{ASName.k_PDF, ASName.k_Text};
        resources.setProcSetList(names);
        Font psFont = null;
        if (!appearanceAttributes.isRichText()) {
            psFont = FontResources.findFont((String)appearanceAttributes.getStyleAttributes().getFontName(), (PDFDocument)doc, (PDFFontSetImpl)pdfFonts, (HashMap)afePDFFontMap);
        }
        if (afePDFFontMap.isEmpty()) {
            afePDFFontMap = null;
        }
        PDFPort pdfPort = new PDFPort(xobjectContentWriter, resources, afePDFFontMap);
        pdfPort.setAnnotRect(appearanceAttributes.getAnnotRect());
        pdfPort.setPageRect(appearanceAttributes.getPageRect());
        textFormatter.formatAndRenderText(appearanceAttributes, (PDFFontSet)pdfFonts, psFont, pdfPort);
        pdfPort.closePDFPort();
    }
}

