/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.TextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.XFAAttributesUtils;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;
import com.adobe.xfa.template.containers.Field;
import java.util.Locale;

class PushButtonXFACaptionFormatter
extends TextFormatterImpl {
    PushButtonXFACaptionFormatter(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        super(pdfDoc);
    }

    @Override
    public AppearanceAttributes fetchAppearanceAttributes(PDFAnnotation annot, PDFResources defResources, Locale locale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException, PDFInvalidParameterException, PDFFontException {
        boolean attributesFetchedFromXFA;
        PDFField field = PDFField.getInstance((CosObject)annot.getCosObject());
        PDFVariableText varText = PDFVariableText.getInstance((CosObject)field.getCosObject());
        PDFDocument curDoc = field.getPDFDocument();
        AppearanceAttributes appearanceAttributes = super.getAppearanceAttributesFromCOS(annot, field, curDoc, defResources, locale, varText);
        try {
            attributesFetchedFromXFA = this.getAppearanceAttributesFromXFA(annot, field, appearanceAttributes, false);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException("Error fetching attributes from XFA", (Throwable)e);
        }
        if (!attributesFetchedFromXFA) {
            return null;
        }
        appearanceAttributes.setMultiLine(true);
        appearanceAttributes.setRichText(true);
        appearanceAttributes.setField(field);
        super.adjustAlignment(appearanceAttributes.getStyleAttributes());
        return appearanceAttributes;
    }

    @Override
    protected RCGOptions getOptions(PDFAnnotation annot, PDFField field, boolean autoSize) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle targetRect = null;
        if (annot instanceof PDFAnnotationWidget) {
            targetRect = AppearanceUtils.getBBoxRectangle((PDFAnnotationWidget)annot);
        } else {
            PDFRectangle annotRect = annot.getRect();
            targetRect = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)0.0, (double)0.0, (double)annotRect.width(), (double)annotRect.height());
        }
        RCGOptions options = new RCGOptions(targetRect.width(), targetRect.height());
        options.setWrap(RCGWrapOption.Emergency);
        options.setOverflow(autoSize ? RCGOverflowMode.ShrinkToFit : RCGOverflowMode.Auto);
        return options;
    }

    @Override
    protected boolean getAppearanceAttributesFromXFA(PDFAnnotation annot, PDFField field, AppearanceAttributes appearanceAttributes, boolean isLegacyXFAProcessingRequired) throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFFontException {
        Field oField = XFAAttributesUtils.getXFAField(this.xfaDom, field);
        if (oField == null) {
            return false;
        }
        XFAAttributesUtils.ATSCaptionTextAttributesFromXFAField(appearanceAttributes, oField);
        XFAAttributesUtils.ATSGetCaptionMarginFromXFAField(oField, appearanceAttributes);
        appearanceAttributes.setTextValue(XFAAttributesUtils.GetXFACaption(oField, appearanceAttributes));
        return true;
    }
}

