/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.ap.extension.APExtensionException;
import com.adobe.internal.pdftoolkit.services.ap.extension.ButtonApProvider;
import com.adobe.internal.pdftoolkit.services.ap.impl.RadioCheckButtonAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.impl.XFAAttributesUtils;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;

public class CheckBoxAPProviderImpl
extends RadioCheckButtonAppearanceGenerator
implements ButtonApProvider {
    private XFADOM xfaDom;

    private CheckBoxAPProviderImpl(APResources apResources, PDFDocument pdfDoc, PDFResources defResources) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        super(apResources, pdfDoc, defResources);
        this.buttonDefaultStyle = "4";
        this.circularBorderForCircleStyle = false;
        if (XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            this.xfaDom = XFADOMService.ensureXFADOMCreated(pdfDoc);
        }
    }

    public static CheckBoxAPProviderImpl getInstance(APResources apResources, PDFDocument pdfDoc) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (pdfDoc == null) {
            throw new PDFInvalidParameterException("PDFDocument cant be passed as null");
        }
        PDFInteractiveForm form = pdfDoc.getInteractiveForm();
        if (form == null) {
            return null;
        }
        return new CheckBoxAPProviderImpl(apResources, pdfDoc, form.getResources());
    }

    @Override
    public void generateAppearance(PDFFieldButton buttonField) throws APExtensionException {
        try {
            if (buttonField == null || !buttonField.isCheckBox()) {
                return;
            }
            this.neutralAppearance = XFAAttributesUtils.allowNeutral(XFAAttributesUtils.getXFAField(this.xfaDom, (PDFField)buttonField), this.xfaDom);
            super.generateFieldAppearance(buttonField);
        }
        catch (Exception e) {
            throw new APExtensionException("Error generating appearance for button field (Object number: " + buttonField.getCosObject().getObjNum(), e);
        }
    }
}

