/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpacePattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquiggly;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotAPWriter;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import java.io.IOException;
import java.io.InputStream;

class SquigglyAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationSquiggly> {
    private static final double N1 = 55.0;
    private static final double N2 = 1.0;
    private PDFPatternTiling squigglyPattern = null;

    SquigglyAnnotApGenerator() {
    }

    private ASCoordinate[] quadToPoints(AnnotationAppearanceGenerator.Quad q) {
        return new ASCoordinate[]{new ASCoordinate((q.bl.x() * 55.0 + q.tl.x() * 1.0) / 56.0, (q.bl.y() * 55.0 + q.tl.y() * 1.0) / 56.0), new ASCoordinate((q.br.x() * 55.0 + q.tr.x() * 1.0) / 56.0, (q.br.y() * 55.0 + q.tr.y() * 1.0) / 56.0)};
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationSquiggly annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        PDFRectangle rectangle = annot.getRect();
        ASMatrix rotationfm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            rotationfm = this.applyRotation(Math.toRadians(annot.getRotation()), rectangle);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)rotationfm.geta(), (double)rotationfm.getb(), (double)rotationfm.getc(), (double)rotationfm.getd(), (double)rotationfm.getx(), (double)rotationfm.gety()));
        }
        double[] strokeColor = annot.getColor();
        this.writer.writeGraphicsInfo((PDFAnnotation)annot, true, null, null, annot.getOpacity(), null);
        double[] co = annot.getQuadPoints();
        int nSize = co.length;
        ASCoordinate[] fp = null;
        for (int n = 0; n < nSize; n += 8) {
            AnnotationAppearanceGenerator.Quad q = new AnnotationAppearanceGenerator.Quad(co, n);
            fp = this.quadToPoints(q);
            double asfWidth = (Math.abs(q.tr.y() - q.br.y()) + Math.abs(q.tr.x() - q.br.x())) / 16.0;
            ASMatrix fm = ASMatrix.createIdentityMatrix();
            fm = fm.translate(-fp[0].x(), -fp[0].y());
            double theta = Math.atan2(fp[1].y() - fp[0].y(), fp[1].x() - fp[0].x());
            double cosine = Math.cos(-theta);
            double sine = Math.sin(-theta);
            ASMatrix fm2 = new ASMatrix(cosine, sine, -sine, cosine, 0.0, 0.0);
            fm = fm.concat(fm2);
            double fxScaleX = 2.5;
            double fxScaleY = 4.5;
            if (asfWidth != 0.0) {
                fm = fm.scale(fxScaleX / asfWidth, fxScaleY / asfWidth);
            }
            ASCoordinate[] fpT = new ASCoordinate[2];
            ASMatrix fmi = fm.getInverse();
            fpT[0] = fp[0].transform(fm);
            fpT[1] = fp[1].transform(fm);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fmi.geta(), (double)fmi.getb(), (double)fmi.getc(), (double)fmi.getd(), (double)fmi.getx(), (double)fmi.gety()));
            AnnotAPWriter c2 = new AnnotAPWriter((PDFAnnotation)annot);
            PDFColorSpacePattern coCS = PDFColorSpacePattern.newInstance((PDFDocument)annot.getPDFDocument());
            switch (strokeColor.length) {
                case 3: {
                    coCS.setPatternColorSpaceName(ASName.k_DeviceRGB);
                    break;
                }
                case 4: {
                    coCS.setPatternColorSpaceName(ASName.k_DeviceCMYK);
                    break;
                }
                default: {
                    coCS.setPatternColorSpaceName(ASName.k_DeviceGray);
                }
            }
            c2.contentWriter.write((PDFColorSpace)coCS, true);
            this.createPattern(annot.getPDFDocument());
            c2.contentWriter.write((PDFPattern)this.squigglyPattern, true, strokeColor);
            ASRectangle frDraw = new ASRectangle(fpT[0].x(), fpT[0].y(), fpT[1].x(), fpT[0].y() + 12.0);
            c2.writeRect(frDraw);
            c2.fillStroke(true, false);
            PDFRectangle rectAfter = c2.getAdjustedBBox(annot.getPDFDocument());
            PDFXObjectForm xObj = c2.createAppearance(annot.getPDFDocument(), rectAfter);
            this.writer.contentWriter.write((PDFXObject)xObj);
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            this.writer.updateBulgeto(q.bl.x(), q.bl.y(), q.tl.x(), q.tl.y());
            this.writer.updateBulgeto(q.tr.x(), q.tr.y(), q.br.x(), q.br.y());
        }
        PDFRectangle rectAfter = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, rectAfter, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rectAfter, null);
            this.createAndSetAppearance(annot, rectAfter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPattern(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.squigglyPattern != null) {
            return;
        }
        this.squigglyPattern = PDFPatternTiling.newInstance((PDFDocument)pdfDoc, (PDFRectangle)PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)0.0, (double)0.0, (double)10.0, (double)12.0), (PDFResources)PDFResources.newInstance((PDFDocument)pdfDoc), (int)2, (int)3, (double)10.0, (double)13.0);
        ContentWriter temp = ContentWriter.newInstance((PDFDocument)pdfDoc);
        temp.write(InstructionFactory.newGSave());
        temp.write(InstructionFactory.newFlatness((double)1.0));
        temp.write(InstructionFactory.newLineCapStyle((int)1));
        temp.write(InstructionFactory.newLineJoin((int)1));
        temp.write(InstructionFactory.newLineWidth((double)1.0));
        temp.write(InstructionFactory.newMiterLimit((double)10.0));
        temp.write(InstructionFactory.newMoveTo((double)0.0, (double)1.0));
        temp.write(InstructionFactory.newLineTo((double)5.0, (double)11.0));
        temp.write(InstructionFactory.newLineTo((double)10.0, (double)1.0));
        temp.write(InstructionFactory.newStrokePath());
        temp.write(InstructionFactory.newGRestore());
        InputByteStream ibs = null;
        InputStream is = null;
        try {
            ibs = temp.close().getContentStream();
            is = ibs.toInputStream();
            this.squigglyPattern.setStreamData(is);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            try {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                finally {
                    if (ibs != null) {
                        ibs.close();
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
    }
}

