/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFVertices;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;

class PolyLineAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationPolyline> {
    PolyLineAnnotApGenerator() {
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationPolyline annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        PDFRectangle rectangle = annot.getRect();
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectangle);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fm.geta(), (double)fm.getb(), (double)fm.getc(), (double)fm.getd(), (double)fm.getx(), (double)fm.gety()));
        }
        this.writer.writeGraphicsInfo((PDFAnnotation)annot, true, annot.getColor(), annot.getInteriorColor(), annot.getOpacity(), null);
        PDFVertices coPts = annot.getVertices();
        int nPts = coPts.size();
        if (nPts > 3) {
            ASCoordinate[] startPoint = new ASCoordinate[2];
            ASCoordinate[] endPoint = new ASCoordinate[2];
            if ((nPts & 1) != 0) {
                throw new PDFInvalidDocumentException("Polyline annotation has odd number of vertices.");
            }
            startPoint[0] = new ASCoordinate(((PDFCosNumeric)coPts.get(0)).doubleValue(), ((PDFCosNumeric)coPts.get(1)).doubleValue());
            startPoint[1] = new ASCoordinate(((PDFCosNumeric)coPts.get(2)).doubleValue(), ((PDFCosNumeric)coPts.get(3)).doubleValue());
            endPoint[0] = new ASCoordinate(((PDFCosNumeric)coPts.get(nPts - 2)).doubleValue(), ((PDFCosNumeric)coPts.get(nPts - 1)).doubleValue());
            endPoint[1] = new ASCoordinate(((PDFCosNumeric)coPts.get(nPts - 4)).doubleValue(), ((PDFCosNumeric)coPts.get(nPts - 3)).doubleValue());
            for (int nPt = 0; nPt < nPts; nPt += 2) {
                ASCoordinate p = new ASCoordinate(((PDFCosNumeric)coPts.get(nPt)).doubleValue(), ((PDFCosNumeric)coPts.get(nPt + 1)).doubleValue());
                if (nPt > 0) {
                    this.writer.lineTo(p.x(), p.y());
                    continue;
                }
                this.writer.moveTo(p.x(), p.y());
            }
            this.writer.fillStroke(false, this.writer.stroke);
            PDFAnnotationLine.LineEnding[] lineEnding = annot.getLineEnds();
            this.writer.drawLineEnding(this.writer.lineWidth, startPoint, lineEnding[0], false);
            this.writer.drawLineEnding(this.writer.lineWidth, endPoint, lineEnding[1], false);
        }
        PDFRectangle rect = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, rect, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rect, null);
            this.createAndSetAppearance(annot, rect);
        }
    }
}

