/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFInkList;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.CurveFit;
import java.util.ArrayList;

class InkAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationInk> {
    InkAnnotApGenerator() {
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationInk annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        PDFRectangle rectangle = annot.getRect();
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectangle);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fm.geta(), (double)fm.getb(), (double)fm.getc(), (double)fm.getd(), (double)fm.getx(), (double)fm.gety()));
        }
        this.writer.writeGraphicsInfo((PDFAnnotation)annot, true, annot.getColor(), null, annot.getOpacity(), null);
        PDFInkList co = annot.getInkList();
        int nSize = co.size();
        for (int n = 0; n < nSize; ++n) {
            PDFInk coPts = (PDFInk)co.get(n);
            int nPts = coPts.size();
            if (nPts <= 0) continue;
            if (nPts > 1000) {
                for (int nPt = 0; nPt < nPts; nPt += 2) {
                    ASCoordinate p = new ASCoordinate(((PDFCosNumeric)coPts.get(nPt)).doubleValue(), ((PDFCosNumeric)coPts.get(nPt + 1)).doubleValue());
                    if (nPt != 0) {
                        this.writer.lineTo(p.x(), p.y());
                        continue;
                    }
                    this.writer.moveTo(p.x(), p.y());
                }
            } else {
                int nPt;
                int nBez = nPts * 3;
                ASCoordinate[] pts = new ASCoordinate[nPts / 2];
                ASCoordinate fpLast = null;
                int nDups = 0;
                for (nPt = 0; nPt < nPts; nPt += 2) {
                    ASCoordinate p = new ASCoordinate(((PDFCosNumeric)coPts.get(nPt)).doubleValue(), ((PDFCosNumeric)coPts.get(nPt + 1)).doubleValue());
                    if (nPt != 0 && p.x() == fpLast.x() && p.y() == fpLast.y()) {
                        ++nDups;
                    } else {
                        pts[nPt / 2 - nDups] = p;
                    }
                    fpLast = p;
                }
                ArrayList<ASCoordinate> bez = new ArrayList<ASCoordinate>();
                CurveFit.fitCurve(pts, nPts / 2 - nDups, 1.0, bez);
                nBez = bez.size();
                for (nPt = 0; nPt < nBez; nPt += 4) {
                    if (nPt == 0) {
                        this.writer.moveTo(((ASCoordinate)bez.get(nPt)).x(), ((ASCoordinate)bez.get(nPt)).y());
                    }
                    this.writer.curveTo(((ASCoordinate)bez.get(nPt + 1)).x(), ((ASCoordinate)bez.get(nPt + 1)).y(), ((ASCoordinate)bez.get(nPt + 2)).x(), ((ASCoordinate)bez.get(nPt + 2)).y(), ((ASCoordinate)bez.get(nPt + 3)).x(), ((ASCoordinate)bez.get(nPt + 3)).y());
                }
            }
            this.writer.fillStroke(false, this.writer.stroke);
        }
        PDFRectangle rect = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, rect, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rect, null);
            this.createAndSetAppearance(annot, rect);
        }
    }
}

