/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.internal.afml.AFMLExceptionInvalidParameter;
import com.adobe.internal.afml.AFMLExceptionUnsupportedFeature;
import com.adobe.internal.agm.AGMException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderEffects;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.impl.PDFDefaultAppearanceWrapper;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.CloudUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.DefaultFont;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontSetUtil;
import com.adobe.internal.pdftoolkit.services.pdfport.PDFPort;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGTargetRegion;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfatext.FormatXFAText;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class FreeTextAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationFreeText> {
    private static final double COORDINATE_SLOP = 0.001;
    private PDFFontSet pdfFontSet = null;
    private PDFDefaultAppearanceWrapper defaultAp = null;

    protected FreeTextAnnotApGenerator(PDFFontSet pdfFontSet) {
        this.pdfFontSet = pdfFontSet;
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationFreeText annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        ASName asaIntent = ASName.create((String)annot.getIntent());
        try {
            if (asaIntent == ASName.k_FreeTextCallout) {
                this.doGenerateCalloutAppearance(annot);
            } else {
                this.doGeneratePlainAppearance(annot);
            }
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFConfigurationException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    private void doGenerateCalloutAppearance(PDFAnnotationFreeText annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException {
        PDFRectangle rectOrig = this.getRect((PDFAnnotation)annot, annot.getFringe());
        ASCoordinate[] points = new ASCoordinate[]{new ASCoordinate(0.0, 0.0), new ASCoordinate(0.0, 0.0), new ASCoordinate(0.0, 0.0)};
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.OnlyPageRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectOrig);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fm.geta(), (double)fm.getb(), (double)fm.getc(), (double)fm.getd(), (double)fm.getx(), (double)fm.gety()));
        }
        boolean bOk = this.getCalloutPoints(annot, rectOrig, points);
        this.layOutCallout(annot, points, bOk, rectOrig);
        this.layoutRichText(annot, rectOrig);
        this.maybeWrapForOpacity(annot, annot.getOpacity(), null);
        PDFRectangle fxrBBoxNew = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            PDFRectangle pdfRectangle = this.writer.getAdjustedBBox(annot.getPDFDocument());
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, pdfRectangle, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rectOrig, fxrBBoxNew);
            this.createAndSetAppearance(annot, this.writer.getAdjustedBBox(annot.getPDFDocument()));
        }
    }

    private void layOutCallout(PDFAnnotationFreeText annot, ASCoordinate[] points, boolean bOK, PDFRectangle textBox) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        if (bOK) {
            PDFAnnotationLine.LineEnding asaLineEnding = PDFAnnotationLine.LineEnding.getInstance((String)annot.getLineEnds().asString());
            this.defaultAp = this.defaultAp == null ? new PDFDefaultAppearanceWrapper(annot.getDefaultFreeTextAppearance()) : this.defaultAp;
            double[] strokeColor = this.defaultAp.getFillColor();
            this.writer.writeGraphicsInfo((PDFAnnotation)annot, true, strokeColor, annot.getColor(), annot.getOpacity(), null);
            ASCoordinate fxEndPoint = points[2];
            ASCoordinate fxKneePoint = points[1];
            ASCoordinate fxStartPoint = points[0];
            if (this.backOffLineForArrowHead(asaLineEnding)) {
                double dx = fxStartPoint.x() - fxKneePoint.x();
                double dy = fxStartPoint.y() - fxKneePoint.y();
                double fxLineLen = Math.sqrt(dx * dx + dy * dy);
                dx = (fxStartPoint.x() - fxKneePoint.x()) * this.writer.lineWidth / fxLineLen;
                dy = (fxStartPoint.y() - fxKneePoint.y()) * this.writer.lineWidth / fxLineLen;
                fxStartPoint = fxStartPoint.translate(-dx, -dy);
            }
            this.writer.moveTo(fxStartPoint.x(), fxStartPoint.y());
            this.writer.lineTo(fxKneePoint.x(), fxKneePoint.y());
            this.writer.lineTo(fxEndPoint.x(), fxEndPoint.y());
            this.writer.moveTo(fxStartPoint.x(), fxStartPoint.y());
            this.writer.closePathFillStroke(false, this.writer.stroke);
            ASCoordinate[] calloutLinePoints = new ASCoordinate[]{fxStartPoint, fxKneePoint};
            this.writer.drawLineEnding(this.writer.lineWidth, calloutLinePoints, asaLineEnding, false);
        }
        this.layOutTextBox(annot, textBox);
    }

    private boolean getCalloutPoints(PDFAnnotationFreeText annot, PDFRectangle textBox, ASCoordinate[] points) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int nLength;
        boolean bOK = false;
        ASCoordinate startPoint = points[0];
        ASCoordinate kneePoint = points[1];
        ASCoordinate endPoint = points[2];
        double[] coCalloutLine = annot.getCalloutLine();
        if (coCalloutLine != null && ((nLength = coCalloutLine.length) == 4 || nLength == 6)) {
            startPoint = startPoint.translate(coCalloutLine[0], coCalloutLine[1]);
            if (nLength == 4) {
                kneePoint = endPoint = endPoint.translate(coCalloutLine[2], coCalloutLine[3]);
                bOK = true;
            } else if (nLength == 6) {
                kneePoint = kneePoint.translate(coCalloutLine[2], coCalloutLine[3]);
                endPoint = endPoint.translate(coCalloutLine[4], coCalloutLine[5]);
                bOK = true;
                ASRectangle textBoxRect = textBox.getRectangle();
                if (!this.pointLiesOnBottomSide(textBoxRect, endPoint, 0.001) && !this.pointLiesOnLeftSide(textBoxRect, endPoint, 0.001) && !this.pointLiesOnRightSide(textBoxRect, endPoint, 0.001) && !this.pointLiesOnTopSide(textBoxRect, endPoint, 0.001) && (this.pointLiesOnBottomSide(textBoxRect, kneePoint, 0.001) || this.pointLiesOnLeftSide(textBoxRect, kneePoint, 0.001) || this.pointLiesOnRightSide(textBoxRect, kneePoint, 0.001) || this.pointLiesOnTopSide(textBoxRect, kneePoint, 0.001))) {
                    ASCoordinate temp = endPoint;
                    endPoint = kneePoint;
                    kneePoint = temp;
                }
            }
        }
        points[0] = startPoint;
        points[1] = kneePoint;
        points[2] = endPoint;
        return bOK;
    }

    private boolean pointLiesOnBottomSide(ASRectangle rect, ASCoordinate point, double tolerance) {
        return Math.abs(point.y() - rect.bottom()) < tolerance && point.x() >= rect.left() && point.x() <= rect.right();
    }

    private boolean pointLiesOnLeftSide(ASRectangle rect, ASCoordinate point, double tolerance) {
        return Math.abs(point.x() - rect.left()) < tolerance && point.y() >= rect.bottom() && point.y() <= rect.top();
    }

    private boolean pointLiesOnRightSide(ASRectangle rect, ASCoordinate point, double tolerance) {
        return Math.abs(point.x() - rect.right()) < tolerance && point.y() >= rect.bottom() && point.y() <= rect.top();
    }

    private boolean pointLiesOnTopSide(ASRectangle rect, ASCoordinate point, double tolerance) {
        return Math.abs(point.y() - rect.top()) < tolerance && point.x() >= rect.left() && point.x() <= rect.right();
    }

    private void doGeneratePlainAppearance(PDFAnnotationFreeText annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFUnableToCompleteOperationException {
        PDFRectangle rectOrig = this.getRect((PDFAnnotation)annot, annot.getFringe());
        this.writer.adjustedBBox = rectOrig.getValues();
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        boolean isRotate = false;
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.OnlyPageRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectOrig);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fm.geta(), (double)fm.getb(), (double)fm.getc(), (double)fm.getd(), (double)fm.getx(), (double)fm.gety()));
        }
        this.layOutTextBox(annot, rectOrig);
        this.layoutRichText(annot, rectOrig);
        this.maybeWrapForOpacity(annot, annot.getOpacity(), null);
        PDFRectangle rectAfter = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            PDFRectangle pdfRectangle = this.writer.getAdjustedBBox(annot.getPDFDocument());
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, pdfRectangle, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rectOrig, rectAfter);
            this.createAndSetAppearance(annot, this.writer.getAdjustedBBox(annot.getPDFDocument()));
        }
    }

    private void layoutRichText(PDFAnnotationFreeText annot, PDFRectangle textBox) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        PDFRectangle fxrCtrl = textBox;
        if (this.writer.lineWidth != 0.0) {
            double fxMargin = this.writer.lineWidth * 2.0;
            fxrCtrl = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)(textBox.left() + fxMargin), (double)(textBox.bottom() + fxMargin), (double)(textBox.right() - fxMargin), (double)(textBox.top() - fxMargin));
        }
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        ASMatrix fmI = fm.getInverse();
        fxrCtrl = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (ASRectangle)fxrCtrl.getRectangle().transform(fmI));
        this.writer.contentWriter.write(InstructionFactory.newGSave());
        this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fm.geta(), (double)fm.getb(), (double)fm.getc(), (double)fm.getd(), (double)fm.getx(), (double)fm.gety()));
        this.writer.writeRect(fxrCtrl.getRectangle());
        this.writer.contentWriter.write(InstructionFactory.newClipPath());
        this.writer.contentWriter.write(InstructionFactory.newEndPathNoOp());
        String richContents = annot.getRichContents();
        InputStream richContentStream = null;
        try {
            boolean autoSize;
            String ds = annot.getDefaultStyle();
            StyleAttributes style = ds != null ? new StyleAttributes(ds) : null;
            boolean bl = autoSize = richContents == null && (style == null || style != null && style.getFontSize() == 0.0);
            if (style == null) {
                style = AppearanceUtils.makeStyle(annot.getPDFDocument(), null, annot.getDefaultFreeTextAppearance().asString(), annot.getJustification(), annot.getPDFDocument().getInteractiveForm() != null ? annot.getPDFDocument().getInteractiveForm().getResources() : null, annot.getPDFDocument().getDocumentLocale());
            } else {
                style.setTextAlignment(annot.getJustification());
            }
            RCGOptions rcgOptions = new RCGOptions(fxrCtrl.width(), fxrCtrl.height());
            if (autoSize) {
                if (style.getFontSize() == 0.0) {
                    style.setFontSize(DefaultFont.getDefaultSize(annot.getPDFDocument().getDocumentLocale()));
                }
                rcgOptions.setOverflow(RCGOverflowMode.ShrinkToFit);
            } else {
                rcgOptions.setVerticalAlignment(RCGAlignment.Top);
                rcgOptions.setOverflow(RCGOverflowMode.Auto);
                rcgOptions.setDefaultStyle(style.getStyleString());
            }
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)1.0, (double)0.0, (double)0.0, (double)1.0, (double)fxrCtrl.llx(), (double)fxrCtrl.lly()));
            if (richContents != null) {
                richContentStream = new ByteArrayInputStream(RichTextHandler.processRichTextString(richContents).getBytes("UTF-8"));
                this.generateTextContent(annot.getPDFDocument(), richContentStream, rcgOptions, null, true);
            } else if (annot.getContents() != null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(annot.getContents());
                richContents = RichTextHandler.processRichTextString(RichTextHandler.convertString2RichText(list));
                richContentStream = new ByteArrayInputStream(richContents.getBytes());
                this.generateTextContent(annot.getPDFDocument(), richContentStream, rcgOptions, FontResources.findFont((String)this.defaultAp.getFontName(), (PDFDocument)annot.getPDFDocument(), (PDFFontSetImpl)((PDFFontSetImpl)this.pdfFontSet), null), false);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
        finally {
            try {
                if (richContentStream != null) {
                    richContentStream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
        this.writer.contentWriter.write(InstructionFactory.newGRestore());
    }

    private void generateTextContent(PDFDocument pdfDocument, InputStream richTextStream, RCGOptions rcgOptions, Font afeFont, boolean richText) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        PDFPort pdfPort = null;
        boolean preserve_old_behavior = false;
        try {
            pdfPort = new PDFPort(this.writer.contentWriter, this.writer.resources);
            RCGTargetRegion targetRegion = rcgOptions.getTargetRegion();
            PDFFontSet workingFontSet = PDFFontSetUtil.buildWorkingFontSet((PDFDocument)pdfDocument, (PDFFontSet)this.pdfFontSet, null, null);
            FormatXFAText richTextFormatter = new FormatXFAText();
            if (rcgOptions.getVerticalAlignment() == RCGAlignment.Middle) {
                preserve_old_behavior = true;
            }
            if (richText) {
                richTextFormatter.processXFAText(targetRegion.toString(), rcgOptions.getDefaultStyle(), richTextStream, pdfPort, workingFontSet, preserve_old_behavior);
            } else {
                richTextFormatter.processPlainText(targetRegion.toString(), rcgOptions.getDefaultStyle(), richTextStream, pdfPort, afeFont, this.pdfFontSet.getFallbackFontSet(), preserve_old_behavior);
            }
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AFMLExceptionUnsupportedFeature e) {
            throw new PDFUnsupportedFeatureException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FormattingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontException e) {
            throw new PDFFontException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        finally {
            if (pdfPort != null) {
                pdfPort.closePDFPort();
            }
        }
    }

    private void layOutTextBox(PDFAnnotationFreeText annot, PDFRectangle textBoxIn) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        ASName style;
        this.defaultAp = this.defaultAp == null ? new PDFDefaultAppearanceWrapper(annot.getDefaultFreeTextAppearance()) : this.defaultAp;
        double[] strokeColor = this.defaultAp.getFillColor();
        this.writer.writeGraphicsInfo((PDFAnnotation)annot, true, strokeColor, annot.getColor(), null, null);
        double halfBorderWidth = this.writer.lineWidth / 2.0;
        PDFRectangle textBox = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)(textBoxIn.left() + halfBorderWidth), (double)(textBoxIn.bottom() + halfBorderWidth), (double)(textBoxIn.right() - halfBorderWidth), (double)(textBoxIn.top() - halfBorderWidth));
        textBox = textBox.normalized(annot.getPDFDocument());
        PDFBorderEffects borderEffect = annot.getBorderEffects();
        double cloudIntensity = borderEffect != null ? borderEffect.getIntensity() : 0.0;
        ASName aSName = style = borderEffect != null ? borderEffect.getStyle() : ASName.k_S;
        if (style == ASName.k_C && cloudIntensity > 0.0) {
            ArrayList<ASCoordinate> vVertex = new ArrayList<ASCoordinate>();
            ASCoordinate vertex = new ASCoordinate(textBox.left(), textBox.top());
            vVertex.add(vertex);
            vertex = new ASCoordinate(textBox.right(), vertex.y());
            vVertex.add(vertex);
            vertex = new ASCoordinate(vertex.x(), textBox.bottom());
            vVertex.add(vertex);
            vertex = new ASCoordinate(textBox.left(), vertex.y());
            vVertex.add(vertex);
            vertex = new ASCoordinate(vertex.x(), textBox.top());
            vVertex.add(vertex);
            List<AnnotationAppearanceGenerator.Arc> vArc = CloudUtils.cloudifyPolyLine(cloudIntensity, this.writer.lineWidth, vVertex);
            Iterator<AnnotationAppearanceGenerator.Arc> itr = vArc.iterator();
            AnnotationAppearanceGenerator.Arc arc = null;
            boolean first = true;
            while (itr.hasNext()) {
                arc = itr.next();
                this.writer.arcto(arc.m_center.x(), arc.m_center.y(), arc.m_radius, arc.t2 - 0.39269908169872414, arc.t1, true, first);
                this.writer.arcto(arc.m_center.x(), arc.m_center.y(), arc.m_radius, arc.t2 - 0.39269908169872414, arc.t2, false, false);
                first = false;
            }
            this.writer.contentWriter.write(InstructionFactory.newClosePath());
        } else {
            this.writer.writeRect(textBox.getRectangle());
        }
        if (this.writer.lineWidth > 0.0) {
            this.writer.fillStroke(this.writer.fill, this.writer.stroke);
        } else {
            this.writer.fillStroke(this.writer.fill, false);
        }
    }
}

