/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.StandardFontUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotAPWriter;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;

class CaretAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationCaret> {
    private static final int Unicode_Paragraph_Symbol = 182;

    CaretAnnotApGenerator() {
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationCaret annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        ASName asaSymbol = annot.getSymbol();
        int rotate = annot.getRotation();
        PDFRectangle rectOrig = this.getRect((PDFAnnotation)annot, annot.getFringe());
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if (rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectOrig);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fm.geta(), (double)fm.getb(), (double)fm.getc(), (double)fm.getd(), (double)fm.getx(), (double)fm.gety()));
        }
        double fxWidth = rectOrig.width();
        double fxHeight = rectOrig.height();
        PDFRectangle rect = rotate == 180 ? PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)0.0, (double)0.0, (double)fxHeight, (double)fxWidth) : PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)0.0, (double)0.0, (double)fxWidth, (double)fxHeight);
        double[] strokeColor = annot.getColor();
        for (int i = 0; i < strokeColor.length; ++i) {
            strokeColor[0] = 1.0 - strokeColor[0];
            strokeColor[1] = 1.0 - strokeColor[1];
            strokeColor[2] = 1.0 - strokeColor[2];
        }
        this.writer.writeGraphicsInfo((PDFAnnotation)annot, false, strokeColor, strokeColor, annot.getOpacity(), ASName.k_Difference);
        this.writer.lineWidth = Math.min((rect.top() - rect.bottom()) / 10.0, 5.0);
        this.writer.contentWriter.write(InstructionFactory.newLineWidth((double)this.writer.lineWidth));
        this.writer.moveTo(rect.left(), rect.bottom());
        this.writer.curveTo((rect.left() + rect.right()) / 2.0, rect.bottom(), (rect.left() + rect.right()) / 2.0, (rect.top() + rect.bottom()) / 2.0, (rect.right() - rect.left()) / 2.0 + rect.left(), rect.top());
        this.writer.curveTo((rect.left() + rect.right()) / 2.0, (rect.top() + rect.bottom()) / 2.0, (rect.left() + rect.right()) / 2.0, rect.bottom(), rect.right(), rect.bottom());
        this.writer.contentWriter.write(InstructionFactory.newClosePath());
        this.writer.fillStroke(this.writer.fill, false);
        this.writer.fillStroke(false, this.writer.stroke);
        double fxHeight2 = fxHeight;
        double fxWidth2 = fxWidth;
        PDFRectangle frSymb = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)rect.right(), (double)rect.bottom(), (double)(rect.right() + (rotate % 180 != 0 ? fxHeight2 : fxWidth2)), (double)(rect.bottom() + (rotate % 180 != 0 ? fxWidth2 : fxHeight2)));
        if (asaSymbol == ASName.k_P) {
            try {
                Font font = StandardFontUtils.getBase14Font((String)"Helvetica", (boolean)true);
                this.writer.writeGraphicsInfo((PDFAnnotation)annot, false, null, strokeColor, null, null);
                int gid = ((FontImpl)font).getFontData().getGlyphForChar(182);
                double fxFontSize = this.stringMaxFontSize(gid, font, frSymb.width(), frSymb.height(), 0.5, 72.0, 0.0);
                PDFFontSimple pdfFont = PDFFontSimple.newInstance((PDFDocument)annot.getPDFDocument(), (ASName)ASName.k_Helvetica, (ASName)ASName.k_Type1);
                this.writer.contentWriter.write((PDFFont)pdfFont, fxFontSize);
                this.writer.contentWriter.write(InstructionFactory.newBeginText());
                double fxAdjustDown = frSymb.height() * 0.35;
                PDFRectangle frPara = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)frSymb.llx(), (double)(frSymb.lly() - fxAdjustDown), (double)frSymb.urx(), (double)(frSymb.ury() - fxAdjustDown));
                this.flow(font, fxFontSize, frPara, this.writer, gid);
                this.writer.contentWriter.write(InstructionFactory.newEndText());
                this.writer.updateBBox(frSymb.left(), frSymb.top(), true);
                this.writer.updateBBox(frSymb.right(), frSymb.bottom(), true);
                this.writer.updateBBox(frPara.left(), frPara.top(), true);
                this.writer.updateBBox(frPara.right(), frPara.bottom(), true);
            }
            catch (FontLoadingException e) {
                throw new PDFFontException((Throwable)e);
            }
            catch (InvalidFontException e) {
                throw new PDFFontException((Throwable)e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFFontException((Throwable)e);
            }
        } else if (asaSymbol == ASName.k_S) {
            double left = frSymb.left();
            double right = frSymb.right();
            double top = frSymb.top();
            double bottom = frSymb.bottom();
            this.writer.lineWidth = Math.min((rect.top() - rect.bottom()) / 9.0, 5.0);
            this.writer.contentWriter.write(InstructionFactory.newLineWidth((double)this.writer.lineWidth));
            double fBottomAdjust = 0.0;
            this.writer.moveTo(left * 0.7 + right * 0.3, bottom * 0.8 + top * 0.2 + fBottomAdjust);
            this.writer.lineTo(left * 0.7 + right * 0.3, bottom + fBottomAdjust);
            this.writer.lineTo(right, bottom + fBottomAdjust);
            this.writer.lineTo(right, bottom * 0.8 + top * 0.2 + fBottomAdjust);
            this.writer.fillStroke(false, this.writer.stroke);
        }
        PDFRectangle frBBox = this.writer.getAdjustedBBox(annot.getPDFDocument());
        PDFRectangle frDelta = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)(frBBox.left() - rect.left()), (double)(frBBox.bottom() - rect.bottom()), (double)(frBBox.right() - rect.right()), (double)(frBBox.top() - rect.top()));
        frDelta = frDelta.rotate(rotate);
        PDFRectangle frAfter = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)(rectOrig.left() + frDelta.left()), (double)(rectOrig.bottom() + frDelta.bottom()), (double)(rectOrig.right() + frDelta.right()), (double)(rectOrig.top() + frDelta.top()));
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, frBBox, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rectOrig, frAfter);
            this.createAndSetAppearance(annot, frBBox);
        }
    }

    private void flow(Font font, double fxFontSize, PDFRectangle fr, AnnotAPWriter writer, int gid) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        Rect fontBBox = ((FontImpl)font).getFontData().getFontBBox();
        double fxWidth = fr.width();
        double fxHeight = fxFontSize * ((fontBBox.ymax - fontBBox.ymin) / 1000.0);
        double descent = font.getLineMetrics().descender;
        double fxDescent = descent / 1000.0 * fxFontSize;
        if (fxDescent == 0.0) {
            fxDescent = fontBBox.ymin / 1000.0 * fxFontSize;
        }
        double fxY = fr.top();
        if (fr.top() - fr.bottom() < fxHeight) {
            fxY += fxHeight - (fr.top() - fr.bottom()) - fxDescent;
        }
        writer.contentWriter.write(InstructionFactory.newTextPosition((double)fr.left(), (double)(fxY - fxHeight)));
        writer.contentWriter.write(InstructionFactory.newTextLeading((double)fxHeight));
        double fxLineWidth = font.getPDFFontDescription().getAdvance(gid) / 1000.0 * fxFontSize;
        double fxTweak = (fxWidth - fxLineWidth) / 2.0;
        writer.contentWriter.write(InstructionFactory.newTextPosition((double)fxTweak, (double)0.0));
        writer.contentWriter.write(InstructionFactory.newShowText((ASHexString)new ASHexString(new byte[]{-74})));
    }

    private double stringMaxFontSize(int gid, Font basefont, double fxMaxWidth, double fxMaxHeight, double fxFontSizeMin, double fxFontSizeMax, double fxGranularity) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        double fxSize;
        boolean tooBig;
        if (fxGranularity == 0.0) {
            fxGranularity = 0.0625;
        }
        double fxTextHeight = 0.0;
        double fxTextWidth = 0.0;
        int maxIts = 32;
        double fxFSLowerBound = fxFontSizeMin;
        double fxFSUpperBound = fxFontSizeMax + fxGranularity;
        Rect fontBBox = ((FontImpl)basefont).getFontData().getFontBBox();
        double fxFontWidth = basefont.getPDFFontDescription().getAdvance(gid) / 1000.0;
        fxTextWidth = fxFontWidth * fxFontSizeMax;
        fxTextHeight = (fontBBox.ymax - fontBBox.ymin) / 1000.0 * fxFontSizeMax;
        if (fxTextHeight <= fxMaxHeight && fxTextWidth <= fxMaxWidth) {
            return fxFontSizeMax;
        }
        fxTextWidth = fxFontWidth * fxFontSizeMin;
        if (fxTextWidth > fxMaxWidth) {
            return -1.0;
        }
        if (fxFontSizeMax == 10.5) {
            fxFSUpperBound += 0.5;
        }
        do {
            tooBig = false;
            fxSize = (fxFSLowerBound + fxFSUpperBound) / 2.0;
            fxTextHeight = (fontBBox.ymax - fontBBox.ymin) / 1000.0 * fxSize;
            fxTextWidth = fxFontWidth * fxSize;
            if (fxTextHeight < 0.0 || fxTextHeight > fxMaxHeight || fxTextWidth < 0.0 || fxTextWidth > fxMaxWidth) {
                tooBig = true;
            }
            if (tooBig) {
                fxFSUpperBound = fxSize;
            } else {
                fxFSLowerBound = fxSize;
            }
            if (maxIts-- > 0 && !(fxFSUpperBound - fxFSLowerBound < fxGranularity)) continue;
            fxSize = fxFSLowerBound;
            break;
        } while (tooBig || !(fxTextHeight + fxGranularity > fxMaxHeight) && !(fxTextWidth + fxGranularity > fxMaxWidth));
        if (fxSize < fxFontSizeMin) {
            fxSize = fxFontSizeMin;
        } else if (fxSize > fxFontSizeMax) {
            fxSize = fxFontSizeMax;
        }
        return fxSize;
    }
}

