/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationHighlight;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquiggly;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStrikeOut;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUnderline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithFringe;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotAPWriter;
import com.adobe.internal.pdftoolkit.services.ap.annot.CaretAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.CircleAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.FreeTextAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.HighlightAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.InkAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.LineAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.PolyLineAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.PolygonAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.SquareAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.SquigglyAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.StrikeOutAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.UnderlineAnnotApGenerator;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class AnnotationAppearanceGenerator<T extends PDFAnnotation> {
    protected static final double ONE_EIGHTH_PI_DOUBLE = 0.39269908169872414;
    protected AnnotAPWriter writer = null;
    private static PDFAnnotationRotationEnum rotationEnum = PDFAnnotationRotationEnum.NoRotate;

    public static void generateAppearance(PDFAnnotation annot, PDFFontSet pdfFontSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        if (annot instanceof PDFAnnotationCircle) {
            new CircleAnnotApGenerator().generateAppearanceInternal((PDFAnnotationCircle)annot);
        } else if (annot instanceof PDFAnnotationSquare) {
            new SquareAnnotApGenerator().generateAppearanceInternal((PDFAnnotationSquare)annot);
        } else if (annot instanceof PDFAnnotationPolyline) {
            new PolyLineAnnotApGenerator().generateAppearanceInternal((PDFAnnotationPolyline)annot);
        } else if (annot instanceof PDFAnnotationPolygon) {
            new PolygonAnnotApGenerator().generateAppearanceInternal((PDFAnnotationPolygon)annot);
        } else if (annot instanceof PDFAnnotationHighlight) {
            new HighlightAnnotApGenerator().generateAppearanceInternal((PDFAnnotationHighlight)annot);
        } else if (annot instanceof PDFAnnotationUnderline) {
            new UnderlineAnnotApGenerator().generateAppearanceInternal((PDFAnnotationUnderline)annot);
        } else if (annot instanceof PDFAnnotationSquiggly) {
            new SquigglyAnnotApGenerator().generateAppearanceInternal((PDFAnnotationSquiggly)annot);
        } else if (annot instanceof PDFAnnotationStrikeOut) {
            new StrikeOutAnnotApGenerator().generateAppearanceInternal((PDFAnnotationStrikeOut)annot);
        } else if (annot instanceof PDFAnnotationLine) {
            new LineAnnotApGenerator().generateAppearanceInternal((PDFAnnotationLine)annot);
        } else if (annot instanceof PDFAnnotationCaret) {
            new CaretAnnotApGenerator().generateAppearanceInternal((PDFAnnotationCaret)annot);
        } else if (annot instanceof PDFAnnotationInk) {
            new InkAnnotApGenerator().generateAppearanceInternal((PDFAnnotationInk)annot);
        } else if (annot instanceof PDFAnnotationFreeText) {
            new FreeTextAnnotApGenerator(pdfFontSet).generateAppearanceInternal((PDFAnnotationFreeText)annot);
        }
    }

    public static void generateAppearance(PDFAnnotation annot, PDFFontSet pdfFontSet, PDFAnnotationRotationEnum rotationType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        rotationEnum = rotationType;
        if (rotationEnum != PDFAnnotationRotationEnum.NoAPRegeneration) {
            AnnotationAppearanceGenerator.generateAppearance(annot, pdfFontSet);
        }
    }

    protected void generateAppearanceInternal(T annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        this.initialize(annot);
    }

    protected void initialize(T annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer = new AnnotAPWriter((PDFAnnotation)annot);
        this.writer.setRotationType(rotationEnum);
    }

    protected void setRect(T annot, PDFRectangle rect, PDFRectangle pBBoxIn) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFRectangle pBBox = pBBoxIn != null ? pBBoxIn : rect;
        rect.normalized(annot.getPDFDocument());
        pBBox.normalized(annot.getPDFDocument());
        annot.setRect(pBBox);
        if (annot instanceof PDFAnnotationWithFringe) {
            ((PDFAnnotationWithFringe)annot).setFringe(new double[]{rect.left() - pBBox.left(), rect.bottom() - pBBox.bottom(), rect.right() - pBBox.right(), rect.top() - pBBox.top()});
        }
    }

    protected void createAndSetAppearance(T annot, PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectForm xobj = this.writer.createAppearance(annot.getPDFDocument(), rect);
        PDFAppearance app = PDFAppearance.newInstance((PDFDocument)annot.getPDFDocument());
        app.setNormalAppearance(xobj);
        annot.setAppearance(app);
    }

    protected void createAndSetAppearance(T annot, PDFRectangle rect, PDFRectangle bbox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectForm xobj = this.writer.createAppearance(annot.getPDFDocument(), rect);
        PDFAppearance app = PDFAppearance.newInstance((PDFDocument)annot.getPDFDocument());
        app.setNormalAppearance(xobj);
        annot.setAppearance(app);
        xobj.setBBox(bbox);
    }

    protected void maybeWrapForOpacity(T annot, Number fxOpacity, ASName asaBlendMode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if ((asaBlendMode == null || asaBlendMode == ASName.k_Normal) && (fxOpacity == null || fxOpacity.doubleValue() < 0.0 || fxOpacity.doubleValue() >= 1.0)) {
            return;
        }
        PDFRectangle rectAfter = this.writer.getAdjustedBBox(annot.getPDFDocument());
        this.setRect(annot, rectAfter, null);
        PDFXObjectForm co = this.writer.createAppearance(annot.getPDFDocument(), rectAfter);
        AnnotAPWriter c1 = new AnnotAPWriter((PDFAnnotation)annot);
        c1.contentWriter.write((PDFXObject)co);
        ASRectangle transformedBBox = co.getBBox().getRectangle().transform(new ASMatrix(co.getMatrix()));
        c1.updateBBox(transformedBBox.left(), transformedBBox.top(), false);
        c1.updateBBox(transformedBBox.right(), transformedBBox.bottom(), false);
        AnnotAPWriter c2 = new AnnotAPWriter((PDFAnnotation)annot);
        c2.writeGraphicsInfo((PDFAnnotation)annot, false, null, null, fxOpacity, asaBlendMode);
        rectAfter = c1.getAdjustedBBox(annot.getPDFDocument());
        co = c1.createAppearance(annot.getPDFDocument(), rectAfter);
        c2.contentWriter.write((PDFXObject)co);
        transformedBBox = co.getBBox().getRectangle().transform(new ASMatrix(co.getMatrix()));
        c2.updateBBox(transformedBBox.left(), transformedBBox.top(), false);
        c2.updateBBox(transformedBBox.right(), transformedBBox.bottom(), false);
        this.writer = c2;
    }

    protected boolean backOffLineForArrowHead(PDFAnnotationLine.LineEnding asaHead) {
        return asaHead != PDFAnnotationLine.LineEnding.None && asaHead != PDFAnnotationLine.LineEnding.ROpenArrow && asaHead != PDFAnnotationLine.LineEnding.RClosedArrow && asaHead != PDFAnnotationLine.LineEnding.Slash && asaHead != PDFAnnotationLine.LineEnding.Butt;
    }

    protected PDFRectangle getRect(PDFAnnotation annot, double[] fringe) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle rect = annot.getRect();
        if (rect != null) {
            if (fringe != null) {
                rect = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)(rect.left() + fringe[0]), (double)(rect.bottom() + fringe[1]), (double)(rect.right() - fringe[2]), (double)(rect.top() - fringe[3]));
                rect = rect.normalized(annot.getPDFDocument());
            }
        } else {
            rect = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return rect;
    }

    protected ASMatrix applyRotation(double rotation, PDFRectangle rectOrig) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        fm = fm.rotate(rotation);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(rotation);
        Point2D llPoint = this.transformPoint2D(rectOrig.llx(), rectOrig.lly(), affineTransform);
        Point2D urPoint = this.transformPoint2D(rectOrig.urx(), rectOrig.ury(), affineTransform);
        if (rotation > 0.0) {
            fm = fm.translate((llPoint.getX() + urPoint.getX()) / 2.0, (llPoint.getY() + urPoint.getY()) / 2.0);
        }
        if (rotation < 0.0) {
            fm = fm.translate(Math.min(llPoint.getX(), urPoint.getX()), Math.min(llPoint.getY(), urPoint.getY()));
        }
        return fm;
    }

    protected Point2D transformPoint2D(double x, double y, AffineTransform affineTransform) {
        Point2D.Double ptSrc = new Point2D.Double(x, y);
        Point2D.Double ptDst = new Point2D.Double(0.0, 0.0);
        affineTransform.transform(ptSrc, ptDst);
        ((Point2D)ptDst).setLocation(x - ((Point2D)ptDst).getX(), y - ((Point2D)ptDst).getY());
        return ptDst;
    }

    protected PDFRectangle getTransformedRectangle(PDFAnnotation annot, PDFRectangle rectangle, double x, double y) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int rotation = annot.getRotation();
        double lx = rectangle.llx();
        double ly = rectangle.lly();
        double rx = rectangle.urx();
        double ry = rectangle.ury();
        rectangle = rotation > 0 ? rectangle.rotate(rotation) : rectangle.rotate(rotation);
        rectangle = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)Math.min(rectangle.llx(), lx), (double)Math.min(rectangle.lly(), ly), (double)Math.max(rectangle.urx(), rx), (double)Math.max(rectangle.ury(), ry));
        return rectangle;
    }

    public static void setRotationEnum(PDFAnnotationRotationEnum rotationEnum) {
        AnnotationAppearanceGenerator.rotationEnum = rotationEnum;
    }

    protected static class Quad {
        protected ASCoordinate br;
        protected ASCoordinate bl;
        protected ASCoordinate tr;
        protected ASCoordinate tl;

        protected Quad(double[] co, int offset) {
            this.br = new ASCoordinate(co[offset + 6], co[offset + 7]);
            this.bl = new ASCoordinate(co[offset + 4], co[offset + 5]);
            this.tr = new ASCoordinate(co[offset + 2], co[offset + 3]);
            this.tl = new ASCoordinate(co[offset + 0], co[offset + 1]);
        }
    }

    protected static class Arc {
        protected double t1;
        protected double t2;
        protected double m_radius;
        protected ASCoordinate m_center;

        protected Arc(double t1, double t2, ASCoordinate m_center, double m_radius) {
            this.t1 = t1;
            this.t2 = t2;
            this.m_center = m_center;
            this.m_radius = m_radius;
        }
    }
}

