/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDashPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorder;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import java.io.IOException;

class AnnotAPWriter {
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double PI_BY_FOUR = 0.7853981633974483;
    boolean fill;
    boolean stroke;
    double lineWidth = 1.0;
    double maxLineWidth = 0.0;
    ContentWriter contentWriter = null;
    double[] adjustedBBox = null;
    boolean bBoxAdjusted = false;
    PDFResources resources = null;
    private PDFAnnotationRotationEnum rotationType = PDFAnnotationRotationEnum.NoRotate;

    AnnotAPWriter(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resources = PDFResources.newInstance((PDFDocument)annot.getPDFDocument());
        this.contentWriter = ContentWriter.newInstance((ModifiableContent)ModifiableContent.newInstance((PDFContents)PDFContents.newInstance((PDFDocument)annot.getPDFDocument()), (PDFResources)this.resources));
        this.adjustedBBox = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MIN_VALUE, Double.MIN_VALUE};
    }

    void writeStrokeColor(double[] strokeColor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (strokeColor != null) {
            this.stroke = true;
            switch (strokeColor.length) {
                case 1: {
                    this.contentWriter.write(InstructionFactory.newDeviceGrayStroke((double)strokeColor[0]));
                    break;
                }
                case 3: {
                    this.contentWriter.write(InstructionFactory.newDeviceRGBStroke((double)strokeColor[0], (double)strokeColor[1], (double)strokeColor[2]));
                    break;
                }
                case 4: {
                    this.contentWriter.write(InstructionFactory.newDeviceCMYKStroke((double)strokeColor[0], (double)strokeColor[1], (double)strokeColor[2], (double)strokeColor[3]));
                }
            }
        }
    }

    void writeFillColor(double[] fillColor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fillColor != null) {
            this.fill = true;
            switch (fillColor.length) {
                case 1: {
                    this.contentWriter.write(InstructionFactory.newDeviceGrayFill((double)fillColor[0]));
                    break;
                }
                case 3: {
                    this.contentWriter.write(InstructionFactory.newDeviceRGBFill((double)fillColor[0], (double)fillColor[1], (double)fillColor[2]));
                    break;
                }
                case 4: {
                    this.contentWriter.write(InstructionFactory.newDeviceCMYKFill((double)fillColor[0], (double)fillColor[1], (double)fillColor[2], (double)fillColor[3]));
                }
            }
        }
    }

    void updateBBox(double px, double py, boolean bAccountForLineWidth) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double fxXformedHalfLineWidth;
        double d = fxXformedHalfLineWidth = bAccountForLineWidth ? this.lineWidth / 2.0 : 0.0;
        if (px - fxXformedHalfLineWidth < this.adjustedBBox[0]) {
            this.adjustedBBox[0] = px - fxXformedHalfLineWidth;
            this.bBoxAdjusted = true;
        }
        if (px + fxXformedHalfLineWidth > this.adjustedBBox[2]) {
            this.adjustedBBox[2] = px + fxXformedHalfLineWidth;
            this.bBoxAdjusted = true;
        }
        if (py - fxXformedHalfLineWidth < this.adjustedBBox[1]) {
            this.adjustedBBox[1] = py - fxXformedHalfLineWidth;
            this.bBoxAdjusted = true;
        }
        if (py + fxXformedHalfLineWidth > this.adjustedBBox[3]) {
            this.adjustedBBox[3] = py + fxXformedHalfLineWidth;
            this.bBoxAdjusted = true;
        }
    }

    void arcto(double cx, double cy, double r, double t1, double t2, boolean ccw, boolean bMoveToFirstPoint) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        while (t1 > t2) {
            t2 += Math.PI * 2;
        }
        double dt = t2 - t1;
        double dt2 = dt / 2.0;
        if (dt > 0.7853981633974483) {
            if (ccw) {
                this.arcto(cx, cy, r, t1 + dt2, t2, ccw, bMoveToFirstPoint);
                this.arcto(cx, cy, r, t1, t1 + dt2, ccw, false);
            } else {
                this.arcto(cx, cy, r, t1, t1 + dt2, ccw, bMoveToFirstPoint);
                this.arcto(cx, cy, r, t1 + dt2, t2, ccw, false);
            }
        } else {
            double sineThetaR;
            double a;
            ASCoordinate fp0 = new ASCoordinate(Math.cos(dt2), -Math.sin(dt2));
            ASCoordinate fp1 = new ASCoordinate((4.0 - Math.cos(dt2)) / 3.0, (1.0 - Math.cos(dt2)) * (Math.cos(dt2) - 3.0) / (3.0 * Math.sin(dt2)));
            ASCoordinate fp2 = new ASCoordinate(fp1.x(), -fp1.y());
            ASCoordinate fp3 = new ASCoordinate(fp0.x(), -fp0.y());
            double theta = t1 + dt2;
            double d = a = r * Math.cos(theta);
            double b = sineThetaR = r * Math.sin(theta);
            double c = -sineThetaR;
            double x = cx;
            double y = cy;
            ASMatrix fm = new ASMatrix(a, b, c, d, x, y);
            fp0 = fp0.transform(fm);
            fp1 = fp1.transform(fm);
            fp2 = fp2.transform(fm);
            fp3 = fp3.transform(fm);
            if (ccw) {
                ASCoordinate temp = fp3;
                fp3 = fp0;
                fp0 = temp;
                temp = fp2;
                fp2 = fp1;
                fp1 = temp;
            }
            if (bMoveToFirstPoint) {
                this.moveTo(fp0.x(), fp0.y());
            }
            this.curveTo(fp1.x(), fp1.y(), fp2.x(), fp2.y(), fp3.x(), fp3.y());
        }
    }

    void moveTo(double x, double y) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.contentWriter.write(InstructionFactory.newMoveTo((double)x, (double)y));
        this.updateBBox(x, y, true);
    }

    void lineTo(double x, double y) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.contentWriter.write(InstructionFactory.newLineTo((double)x, (double)y));
        this.updateBBox(x, y, true);
    }

    void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.contentWriter.write(InstructionFactory.newCurveTo((double)x1, (double)y1, (double)x2, (double)y2, (double)x3, (double)y3));
        this.updateBBox(x1, y1, true);
        this.updateBBox(x2, y2, true);
        this.updateBBox(x3, y3, true);
    }

    void bulgeTo(double h, double v, double currentX, double currentY) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double dx = currentX - h;
        double dy = currentY - v;
        double d3 = 0.3333333333333333 * Math.sqrt(dx * dx + dy * dy);
        double a1 = Math.atan2(-dy, -dx) + 0.7853981633974483;
        double a2 = Math.atan2(dy, dx) - 0.7853981633974483;
        double px1 = currentX + d3 * Math.cos(a1);
        double py1 = currentY + d3 * Math.sin(a1);
        double px2 = h + d3 * Math.cos(a2);
        double py2 = v + d3 * Math.sin(a2);
        this.curveTo(px1, py1, px2, py2, h, v);
    }

    void fillStroke(boolean fill, boolean stroke) throws PDFIOException {
        if (fill && stroke) {
            this.contentWriter.write(InstructionFactory.newFillAndStrokePath());
        } else if (fill) {
            this.contentWriter.write(InstructionFactory.newFillPath());
        } else if (stroke) {
            this.contentWriter.write(InstructionFactory.newStrokePath());
        } else {
            this.contentWriter.write(InstructionFactory.newEndPathNoOp());
        }
        if (stroke) {
            this.maxLineWidth = Math.max(this.lineWidth, this.maxLineWidth);
        }
    }

    void closePathFillStroke(boolean fill, boolean stroke) throws PDFIOException {
        if (fill && stroke) {
            this.contentWriter.write(InstructionFactory.newCloseFillAndStrokePath());
        } else if (fill) {
            this.contentWriter.write(InstructionFactory.newFillPath());
        } else if (stroke) {
            this.contentWriter.write(InstructionFactory.newCloseAndStrokePath());
        } else {
            this.contentWriter.write(InstructionFactory.newEndPathNoOp());
        }
        if (stroke) {
            this.maxLineWidth = Math.max(this.lineWidth, this.maxLineWidth);
        }
    }

    PDFRectangle getAdjustedBBox(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.bBoxAdjusted && this.maxLineWidth > 0.0) {
            double fxOutset = -this.lineWidth / 2.0;
            return PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)(this.adjustedBBox[0] + fxOutset), (double)(this.adjustedBBox[1] + fxOutset), (double)(this.adjustedBBox[2] - fxOutset), (double)(this.adjustedBBox[3] - fxOutset));
        }
        return PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)this.adjustedBBox[0], (double)this.adjustedBBox[1], (double)this.adjustedBBox[2], (double)this.adjustedBBox[3]);
    }

    void writeEllipse(double x, double y, double w, double h) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double dHalfWidth = w / 2.0;
        double dHalfHeight = h / 2.0;
        double dWidthH = w / 4.5;
        double dWidthV = h / 4.5;
        this.moveTo(x + dHalfWidth, y + h);
        this.curveTo(x + w - dWidthH, y + h, x + w, y + h - dWidthV, x + w, y + dHalfHeight);
        this.curveTo(x + w, y + dWidthV, x + w - dWidthH, y, x + dHalfWidth, y);
        this.curveTo(x + dWidthH, y, x, y + dWidthV, x, y + dHalfHeight);
        this.curveTo(x, y + h - dWidthV, x + dWidthH, y + h, x + dHalfWidth, y + h);
        this.contentWriter.write(InstructionFactory.newClosePath());
    }

    void writeRect(ASRectangle rect) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.contentWriter.write(InstructionFactory.newRectangle((double)Math.min(rect.right(), rect.left()), (double)Math.min(rect.top(), rect.bottom()), (double)rect.width(), (double)rect.height()));
        this.updateBBox(rect.left(), rect.bottom(), true);
        this.updateBBox(rect.right(), rect.top(), true);
    }

    void writeGraphicsInfo(PDFAnnotation annot, boolean writeBorderInfo, double[] strokeColor, double[] fillColor, Number opacity, ASName blendMode) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        this.writeStrokeColor(strokeColor);
        this.writeFillColor(fillColor);
        if (writeBorderInfo) {
            PDFBorderStyle borderStyle = annot.getBorderStyle();
            PDFBorder border = annot.getBorder();
            if (borderStyle != null) {
                this.lineWidth = borderStyle.getWidth();
                this.contentWriter.write(InstructionFactory.newLineWidth((double)this.lineWidth));
                if (borderStyle.hasDash()) {
                    this.contentWriter.write(InstructionFactory.newLineDashPattern((double[])borderStyle.getDash(), (int)0));
                }
            } else if (border != null) {
                this.lineWidth = border.getWidth();
                this.contentWriter.write(InstructionFactory.newLineWidth((double)this.lineWidth));
                PDFDashPattern dashPattern = border.getDashPattern();
                if (dashPattern != null) {
                    this.contentWriter.write(InstructionFactory.newLineDashPattern((double[])dashPattern.getPattern(), (int)dashPattern.getPhase()));
                }
            }
        }
        if (opacity != null && opacity.doubleValue() != 1.0 || blendMode != null) {
            PDFExtGState gState = PDFExtGState.newInstance((PDFDocument)annot.getPDFDocument());
            gState.setOpacityFill(opacity.doubleValue());
            gState.setOpacityStroke(opacity.doubleValue());
            gState.setBlendMode(blendMode);
            this.contentWriter.write(gState);
        }
    }

    void updateBulgeto(double ch, double cv, double h, double v) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double dx = ch - h;
        double dy = cv - v;
        double d3 = 0.3333333333333333 * Math.sqrt(dx * dx + dy * dy);
        double a1 = Math.atan2(-dy, -dx) + 0.7853981633974483;
        double a2 = Math.atan2(dy, dx) - 0.7853981633974483;
        double px1 = ch + d3 * Math.cos(a1);
        double py1 = cv + d3 * Math.sin(a1);
        double px2 = h + d3 * Math.cos(a2);
        double py2 = v + d3 * Math.sin(a2);
        this.updateBBox(px1, py1, true);
        this.updateBBox(px2, py2, true);
        this.updateBBox(h, v, true);
        this.updateBBox(ch, cv, true);
    }

    void drawLineEnding(double lineWidth, ASCoordinate[] pfxPoint, PDFAnnotationLine.LineEnding asaLineEnding, boolean bReverseLine) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        boolean bReverseArrow;
        double fxWidth = 3.0 * lineWidth;
        if (fxWidth == 0.0) {
            fxWidth = 3.0;
        }
        boolean bl = bReverseArrow = asaLineEnding == PDFAnnotationLine.LineEnding.ROpenArrow || asaLineEnding == PDFAnnotationLine.LineEnding.RClosedArrow;
        if (bReverseLine) {
            boolean bl2 = bReverseArrow = !bReverseArrow;
        }
        if (asaLineEnding == PDFAnnotationLine.LineEnding.Square) {
            this.drawSquareHead(pfxPoint, fxWidth);
        } else if (asaLineEnding == PDFAnnotationLine.LineEnding.Circle) {
            this.drawCircleHead(pfxPoint, fxWidth);
        } else if (asaLineEnding == PDFAnnotationLine.LineEnding.Diamond) {
            this.drawDiamondHead(pfxPoint, fxWidth);
        } else if (asaLineEnding == PDFAnnotationLine.LineEnding.OpenArrow) {
            this.drawLineHead(pfxPoint, fxWidth, bReverseArrow);
        } else if (asaLineEnding == PDFAnnotationLine.LineEnding.ClosedArrow) {
            this.drawTriangleHead(pfxPoint, fxWidth, bReverseArrow);
        } else if (asaLineEnding == PDFAnnotationLine.LineEnding.Butt) {
            this.drawButtHead(pfxPoint, fxWidth);
        } else if (asaLineEnding == PDFAnnotationLine.LineEnding.ROpenArrow) {
            this.drawLineHead(pfxPoint, fxWidth, bReverseArrow);
        } else if (asaLineEnding == PDFAnnotationLine.LineEnding.RClosedArrow) {
            this.drawTriangleHead(pfxPoint, fxWidth, bReverseArrow);
        } else if (asaLineEnding == PDFAnnotationLine.LineEnding.Slash) {
            this.drawSlashHead(pfxPoint, fxWidth, true);
        }
    }

    private void drawButtHead(ASCoordinate[] pfxPoint, double width) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double y2;
        double y1;
        double dy;
        double x2;
        double x1 = pfxPoint[0].x();
        double dx = x1 - (x2 = pfxPoint[1].x());
        double d = Math.sqrt(dx * dx + (dy = (y1 = pfxPoint[0].y()) - (y2 = pfxPoint[1].y())) * dy);
        if (d != 0.0) {
            double sdx = dx * width / d;
            double sdy = dy * width / d;
            this.moveTo(x1 - sdy, y1 + sdx);
            this.lineTo(x1 + sdy, y1 - sdx);
            this.fillStroke(false, this.stroke);
        }
    }

    private void drawCircleHead(ASCoordinate[] pfxPoint, double fxWidth) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.writeEllipse(pfxPoint[0].x() - fxWidth, pfxPoint[0].y() - fxWidth, fxWidth * 2.0, fxWidth * 2.0);
        this.fillStroke(this.fill, this.stroke);
    }

    private void drawDiamondHead(ASCoordinate[] pfxPoint, double fxWidth) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.moveTo(pfxPoint[0].x() - fxWidth, pfxPoint[0].y());
        this.lineTo(pfxPoint[0].x(), pfxPoint[0].y() + fxWidth);
        this.lineTo(pfxPoint[0].x() + fxWidth, pfxPoint[0].y());
        this.lineTo(pfxPoint[0].x(), pfxPoint[0].y() - fxWidth);
        this.closePathFillStroke(this.fill, this.stroke);
    }

    private void drawArrow(ASCoordinate[] pfxPoint, double len, double angle, double fxWidth) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double alpha = Math.atan2(pfxPoint[0].y() - pfxPoint[1].y(), pfxPoint[0].x() - pfxPoint[1].x());
        double x = len * Math.cos(alpha - angle);
        double y = len * Math.sin(alpha - angle);
        double xs = pfxPoint[0].x();
        double ys = pfxPoint[0].y();
        double miter = fxWidth / Math.sin(angle) / 6.0;
        this.moveTo((xs -= miter * Math.cos(alpha)) - x, (ys -= miter * Math.sin(alpha)) - y);
        this.lineTo(xs, ys);
        x = len * Math.cos(alpha + angle);
        y = len * Math.sin(alpha + angle);
        this.lineTo(xs - x, ys - y);
    }

    private void drawLineHead(ASCoordinate[] pfxPoint, double fxWidth, boolean bReverse) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double fxAngle = 0.5235987755982988;
        this.drawArrow(pfxPoint, fxWidth * 3.0, fxAngle + (bReverse ? Math.PI : 0.0), fxWidth);
        this.fillStroke(false, this.stroke);
    }

    private void drawSlash(ASCoordinate[] pfxPoint, double len, double angle, double fxWidth) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double alpha = Math.atan2(pfxPoint[0].y() - pfxPoint[1].y(), pfxPoint[0].x() - pfxPoint[1].x());
        double x = len * Math.cos(alpha - angle);
        double y = len * Math.sin(alpha - angle);
        double xs = pfxPoint[0].x();
        double ys = pfxPoint[0].y();
        this.moveTo(xs - x, ys - y);
        this.lineTo(xs + x, ys + y);
    }

    private void drawSlashHead(ASCoordinate[] pfxPoint, double fxWidth, boolean bReverse) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double fxAngle = 0.5235987755982988;
        this.drawSlash(pfxPoint, fxWidth * 3.0, fxAngle + (bReverse ? 1.5707963267948966 : 0.0), fxWidth);
        this.fillStroke(false, this.stroke);
    }

    private void drawSquareHead(ASCoordinate[] pfxPoint, double fxWidth) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.writeRect(new ASRectangle(pfxPoint[0].x() - fxWidth, pfxPoint[0].y() - fxWidth, pfxPoint[0].x() + fxWidth, pfxPoint[0].y() + fxWidth));
        this.fillStroke(this.fill, this.stroke);
    }

    private void drawTriangleHead(ASCoordinate[] pfxPoint, double fxWidth, boolean bReverse) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double fxAngle = 0.5235987755982988;
        this.drawArrow(pfxPoint, fxWidth * 3.0, fxAngle + (bReverse ? Math.PI : 0.0), fxWidth);
        this.closePathFillStroke(this.fill, this.stroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PDFXObjectForm createAppearance(PDFDocument pdfDoc, PDFRectangle rectAfter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Content content = this.contentWriter.close();
        InputByteStream ibs = content.getContentStream();
        try {
            PDFXObjectForm xObj = PDFXObjectForm.newInstance((PDFDocument)pdfDoc, (PDFRectangle)rectAfter, (PDFResources)content.getResources(), (InputByteStream)ibs);
            ASMatrix matrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -rectAfter.left(), -rectAfter.bottom());
            xObj.setMatrix(matrix.getValues());
            PDFXObjectForm pDFXObjectForm = xObj;
            return pDFXObjectForm;
        }
        finally {
            try {
                if (ibs != null) {
                    ibs.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
    }

    protected PDFAnnotationRotationEnum getRotationType() {
        return this.rotationType;
    }

    protected void setRotationType(PDFAnnotationRotationEnum rotationType) {
        this.rotationType = rotationType;
    }
}

