/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.TextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.FieldAppearance;
import com.adobe.internal.pdftoolkit.services.ap.spi.APContext;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontSetUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class AppearanceService {
    private AppearanceService() {
    }

    public static void generateFieldAppearances(PDFDocument pdfDoc, PDFField pdfField, APContext apContext, TextFormatter textFormatter) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        if (pdfField instanceof PDFFieldText || pdfField instanceof PDFFieldChoice || pdfField instanceof PDFFieldButton || pdfField instanceof PDFFieldSignature && pdfField.getDictionaryValue(ASName.k_V) == null) {
            PDFInteractiveForm acroForm = pdfDoc.getInteractiveForm();
            if (acroForm == null) {
                throw new PDFInvalidDocumentException("Cannot find Acro Form.");
            }
            if (apContext == null) {
                apContext = new APContext(null, false, null);
            }
            PDFResources defResources = acroForm.getResources();
            PDFCatalog pdfCatalog = pdfDoc.requireCatalog();
            Locale locale = apContext.getLocale();
            if (locale == null) {
                if (pdfCatalog == null) {
                    throw new PDFInvalidDocumentException("Cannot find Catalog.");
                }
                String lang = pdfCatalog.getLang();
                if (lang != null) {
                    locale = AppearanceUtils.convertStringToLocale(lang);
                }
            }
            apContext.setLocale(locale);
            if (textFormatter == null) {
                textFormatter = new TextFormatterImpl(pdfDoc);
            }
            PDFFontSet pdfFonts = null;
            pdfFonts = apContext.isBuildFontSet() ? PDFFontSetUtil.buildWorkingFontSet((PDFDocument)pdfDoc, (PDFFontSet)apContext.getSystemFonts(), (Locale)locale, apContext.getAfePDFFontMap()) : apContext.getSystemFonts();
            if (pdfFonts == null) {
                pdfFonts = new PDFFontSetImpl();
            }
            apContext.setSystemFonts(pdfFonts);
            try {
                FieldAppearance.generateFieldAppearance(pdfField, pdfFonts, defResources, locale, apContext.getAfePDFFontMap(), apContext.getExtensionOptions(), textFormatter);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Bad field in the document.", (Throwable)e);
            }
        }
    }

    public static PDFXObjectForm generateAnnotAppearance(PDFDocument pdfDoc, PDFField pdfField, PDFAnnotation annot, APContext apContext, TextFormatter textFormatter) throws PDFFontException, PDFConfigurationException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        PDFXObjectForm appearanceStream = null;
        if (!(annot instanceof PDFAnnotationWidget)) {
            return null;
        }
        if (pdfField instanceof PDFFieldText || pdfField instanceof PDFFieldChoice || pdfField instanceof PDFFieldButton || pdfField instanceof PDFFieldSignature && pdfField.getDictionaryValue(ASName.k_V) == null) {
            PDFInteractiveForm acroForm = pdfDoc.getInteractiveForm();
            PDFResources defResources = null;
            if (acroForm == null) {
                throw new PDFInvalidDocumentException("Cannot find Acro Form.");
            }
            if (apContext == null) {
                apContext = new APContext(null, false, null);
            }
            if (textFormatter == null) {
                textFormatter = new TextFormatterImpl(pdfDoc);
            }
            PDFCatalog pdfCatalog = pdfDoc.requireCatalog();
            Locale locale = apContext.getLocale();
            if (locale == null) {
                if (pdfCatalog == null) {
                    throw new PDFInvalidDocumentException("Cannot find Catalog.");
                }
                String lang = pdfCatalog.getLang();
                if (lang != null) {
                    locale = AppearanceUtils.convertStringToLocale(lang);
                }
            }
            apContext.setLocale(locale);
            PDFFontSet pdfFonts = null;
            pdfFonts = apContext.isBuildFontSet() ? PDFFontSetUtil.buildWorkingFontSet((PDFDocument)pdfDoc, (PDFFontSet)apContext.getSystemFonts(), (Locale)locale, apContext.getAfePDFFontMap()) : apContext.getSystemFonts();
            if (pdfFonts == null) {
                pdfFonts = new PDFFontSetImpl();
            }
            apContext.setSystemFonts(pdfFonts);
            defResources = acroForm.getResources();
            appearanceStream = FieldAppearance.generateSingleAnnotAppearance(annot, pdfField, pdfDoc, pdfFonts, defResources, locale, apContext.getAfePDFFontMap(), textFormatter);
        }
        return appearanceStream;
    }

    public static void generateAppearances(PDFDocument pdfDoc, APContext apContext, TextFormatter textFormatter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException {
        PDFInteractiveForm acroForm = pdfDoc.getInteractiveForm();
        if (apContext == null) {
            apContext = new APContext(null, false, null);
        }
        PDFAnnotationRotationEnum rotationType = apContext.getAnnotationRotationType();
        EnumSet<PDFAnnotationEnum> annotsToBeProcessed = apContext.getAnnotationsToBeProcessed();
        if (annotsToBeProcessed == null || annotsToBeProcessed.isEmpty() || acroForm == null && annotsToBeProcessed.size() == 1 && annotsToBeProcessed.contains(PDFAnnotationEnum.Widget)) {
            return;
        }
        PDFCatalog pdfCatalog = pdfDoc.requireCatalog();
        Locale locale = apContext.getLocale();
        if (locale == null) {
            if (pdfCatalog == null) {
                return;
            }
            locale = pdfCatalog.getLang() != null ? AppearanceUtils.convertStringToLocale(pdfCatalog.getLang()) : PDFDocument.ROOT_LOCALE;
        }
        apContext.setLocale(locale);
        PDFFontSet pdfFonts = null;
        pdfFonts = apContext.isBuildFontSet() ? PDFFontSetUtil.buildWorkingFontSet((PDFDocument)pdfDoc, (PDFFontSet)apContext.getSystemFonts(), (Locale)locale, apContext.getAfePDFFontMap()) : apContext.getSystemFonts();
        if (pdfFonts == null) {
            pdfFonts = new PDFFontSetImpl();
        }
        apContext.setSystemFonts(pdfFonts);
        HashMap<String, AppearanceAttributes> valueListAPAttr = new HashMap<String, AppearanceAttributes>(1024);
        HashMap<String, PDFAnnotation> valueListPDFAnnot = new HashMap<String, PDFAnnotation>(1024);
        HashMap<String, PDFXObjectForm> valueListAPStream = new HashMap<String, PDFXObjectForm>(1024);
        if (acroForm != null && annotsToBeProcessed.contains(PDFAnnotationEnum.Widget)) {
            if (textFormatter == null) {
                textFormatter = new TextFormatterImpl(pdfDoc);
            }
            Iterator fieldIterator = acroForm.iterator(true);
            while (fieldIterator.hasNext()) {
                PDFField pdfField = (PDFField)fieldIterator.next();
                try {
                    FieldAppearance.generateFieldAppearance(pdfField, pdfFonts, acroForm.getResources(), locale, apContext.getAfePDFFontMap(), apContext.getExtensionOptions(), textFormatter, valueListAPAttr, valueListPDFAnnot, valueListAPStream);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException("Bad field in the document.", (Throwable)e);
                }
                if (acroForm == null) continue;
                acroForm.removeValue(ASName.k_NeedAppearances);
            }
        }
        Iterator pageItr = pdfDoc.requirePages().iterator();
        PDFAnnotationIterator annotItr = null;
        PDFPage pdfPage = null;
        PDFAnnotation annot = null;
        PDFAnnotationEnum annotEnum = null;
        while (pageItr.hasNext()) {
            pdfPage = (PDFPage)pageItr.next();
            annotItr = pdfPage.getAnnotationsIterator();
            while (annotItr.hasNext()) {
                annot = annotItr.next();
                annotEnum = PDFAnnotationEnum.getInstance((ASName)annot.getSubtype());
                if (annot.getSubtype() == ASName.k_Widget || annotEnum == null || !annotEnum.isAPGenerationSupported() || !annotsToBeProcessed.contains(annotEnum)) continue;
                AnnotationAppearanceGenerator.generateAppearance(annot, pdfFonts, rotationType);
            }
        }
    }
}

