/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.webcapture;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSourceInfo;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSourceInfoArray;

public abstract class PDFSpiderContentSet
extends PDFCosDictionary {
    private static final ASName k_SpiderContentSet = ASName.create((String)"SpiderContentSet");

    protected PDFSpiderContentSet(PDFDocument pdfDoc, ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super((CosObject)PDFCosObject.newCosDictionary((PDFDocument)pdfDoc));
        this.setType();
        this.setSubtype(subType);
    }

    protected PDFSpiderContentSet(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, k_SpiderContentSet);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFSourceInfoArray getSourceInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSourceInfoArray sourceInfoArray = null;
        CosObject sourceInfoObj = this.getDictionaryCosObjectValue(ASName.k_SI);
        if (sourceInfoObj != null) {
            if (sourceInfoObj.getType() == 5) {
                sourceInfoArray = PDFSourceInfoArray.getInstance(sourceInfoObj);
            } else {
                PDFSourceInfo sourceInfo = PDFSourceInfo.getInstance(sourceInfoObj);
                sourceInfoArray = PDFSourceInfoArray.newInstance(this.getPDFDocument());
                sourceInfoArray.add((PDFCosObjectContainer)sourceInfo);
            }
        }
        return sourceInfoArray;
    }

    public void setSourceInfo(PDFSourceInfoArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null || value.size() == 0) {
            throw new PDFInvalidParameterException("SourceInfo is a required key therefore cannot be removed.");
        }
        if (value.size() == 1) {
            this.setDictionaryValue(ASName.k_SI, (PDFCosObject)value.get(0));
        } else {
            this.setDictionaryValue(ASName.k_SI, (PDFCosObject)value);
        }
    }

    public boolean hasSourceInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_SI);
    }

    public ASString getContentType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_CT);
    }

    public void setContentType(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_CT, value);
    }

    public void setContentType(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_CT, value);
    }

    public boolean hasContentType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CT);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    private void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Subtype is a required key therefore cannot be removed.");
        }
        this.setDictionaryNameValue(ASName.k_S, value);
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public ASDate getTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_TS);
    }

    public abstract PDFCosArrayList getO() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public boolean hasO() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_O);
    }

    public void setTS(ASDate value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryDateValue(ASName.k_TS, value);
    }

    public boolean hasTimeStamp() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TS);
    }

    public ASString getID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_ID);
    }

    public void setID(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("ID is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_ID, value);
    }

    public void setID(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("ID is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_ID, value);
    }

    public ASString requireID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString name = this.getDictionaryStringValue(ASName.k_ID);
        if (name == null) {
            throw new PDFInvalidDocumentException("Could not get ID");
        }
        return name;
    }

    public boolean hasID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ID);
    }
}

