/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.navigation;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDimension;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDirectionOfMotion;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFTransition;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFTransitionStyle;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.XPDFCosObject;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFTransition
extends XPDFCosObject {
    private PDFTransition pdfTransition;

    public XPDFTransition(PDFTransition pdfTransition) {
        this.pdfTransition = pdfTransition;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        PDFDirectionOfMotion motion;
        PDFDimension dimension;
        PDFTransitionStyle style;
        ch.startElement(parentName);
        AttributesImpl attr = new AttributesImpl();
        if (this.pdfTransition.hasDuration()) {
            attr.addAttribute("", "Duration", "Duration", "CDATA", String.valueOf(this.pdfTransition.getDuration()));
        }
        if ((style = this.pdfTransition.getTransitionStyle()) != null) {
            attr.addAttribute("", "Style", "Style", "CDATA", style.toString());
        }
        if ((dimension = this.pdfTransition.getTransitionDimension()) != null) {
            attr.addAttribute("", "Dimension", "Dimension", "CDATA", dimension.toString());
        }
        if ((motion = this.pdfTransition.getTransitionDirectionOfMotion()) != null) {
            attr.addAttribute("", "Motion", "Motion", "CDATA", motion.toString());
        }
        if (this.pdfTransition.hasDirection()) {
            attr.addAttribute("", "Direction", "Direction", "CDATA", String.valueOf(this.pdfTransition.getDirection()));
        }
        if (this.pdfTransition.hasStartingScale()) {
            attr.addAttribute("", "FlyScale", "FlyScale", "CDATA", String.valueOf(this.pdfTransition.getStartingScale()));
        }
        if (this.pdfTransition.hasIsRectangular()) {
            attr.addAttribute("", "FlyRectangular", "FlyRectangular", "CDATA", String.valueOf(this.pdfTransition.getIsRectangular()));
        }
        ch.element("Trans", attr);
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String flyRectangular;
        String flyScale;
        String direction;
        String motion;
        String style;
        String duration = att.getValue("Duration");
        if (duration != null) {
            try {
                double d = Double.valueOf(duration);
                this.pdfTransition.setDuration(d);
            }
            catch (NumberFormatException e) {
                eh.XPDFError("Invalid value ('" + duration + "') for 'Duration' attribute");
            }
        }
        if ((style = att.getValue("Style")) != null) {
            try {
                PDFTransitionStyle tStyle = PDFTransitionStyle.getInstance((ASName)ASName.create((String)style));
                this.pdfTransition.setTransitionStyle(tStyle);
            }
            catch (PDFInvalidParameterException e) {
                eh.XPDFError("Invalid value ('" + style + "') for 'Style' attribute");
            }
        }
        String dimension = att.getValue("Dimension");
        if (style != null) {
            PDFDimension tDimension = PDFDimension.getInstance((ASName)ASName.create((String)dimension));
            this.pdfTransition.setTransitionDimension(tDimension);
        }
        if ((motion = att.getValue("Motion")) != null) {
            try {
                PDFDirectionOfMotion tDirectionOfMotion = PDFDirectionOfMotion.getInstance((ASName)ASName.create((String)motion));
                this.pdfTransition.setTransitionDirectionOfMotion(tDirectionOfMotion);
            }
            catch (PDFInvalidParameterException e) {
                eh.XPDFError("Invalid value ('" + motion + "') for 'Motion' attribute");
            }
        }
        if ((direction = att.getValue("Direction")) != null) {
            try {
                int i = Integer.valueOf(direction);
                this.pdfTransition.setDirection(i);
            }
            catch (NumberFormatException e) {
                eh.XPDFError("Invalid value ('" + direction + "') for 'Direction' attribute");
            }
        }
        if ((flyScale = att.getValue("FlyScale")) != null) {
            try {
                double d = Double.valueOf(flyScale);
                this.pdfTransition.setStartingScale(d);
            }
            catch (NumberFormatException e) {
                eh.XPDFError("Invalid value ('" + flyScale + "') for 'FlyScale' attribute");
            }
        }
        if ((flyRectangular = att.getValue("FlyScale")) != null) {
            try {
                boolean b = Boolean.valueOf(flyRectangular);
                this.pdfTransition.setIsRectangular(b);
            }
            catch (NumberFormatException e) {
                eh.XPDFError("Invalid value ('" + flyScale + "') for 'FlyScale' attribute");
            }
        }
    }
}

