/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.navigation;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.XPDFCosObject;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionFactory;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestinationFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFBookmark
extends XPDFCosObject {
    private PDFBookmark pdfBookMark;
    private StringBuilder title = null;
    private StringBuilder count = null;
    private boolean inAction = false;

    public XPDFBookmark(PDFBookmark pdfBookMark) {
        this.pdfBookMark = pdfBookMark;
    }

    private String colorToXPDF(double[] color) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            String s = Integer.toHexString((int)(color[i] * 255.0));
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private double[] colorFromXPDF(String color, XPDFErrorHandler eh) throws SAXException {
        double[] colors = new double[]{1.0, 1.0, 1.0};
        if (color.length() != 6) {
            eh.XPDFError("Invalid color value");
            return colors;
        }
        try {
            colors[0] = (double)Integer.parseInt(color.substring(0, 2), 16) / 255.0;
            colors[1] = (double)Integer.parseInt(color.substring(2, 4), 16) / 255.0;
            colors[2] = (double)Integer.parseInt(color.substring(4, 6), 16) / 255.0;
        }
        catch (NumberFormatException e) {
            eh.XPDFError("Invalid color value");
        }
        return colors;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        AttributesImpl att = new AttributesImpl();
        double[] color = this.pdfBookMark.getColor();
        if (color != null) {
            att.addAttribute("", "Color", "Color", "CDATA", this.colorToXPDF(color));
        }
        if (this.pdfBookMark.hasStyles()) {
            int styles = this.pdfBookMark.getStyles();
            String prefix = "";
            StringBuilder sb = new StringBuilder();
            if ((styles & 1) != 0) {
                sb.append("Italic");
                prefix = " ";
            }
            if ((styles & 2) != 0) {
                sb.append(prefix);
                sb.append("Bold");
            }
            att.addAttribute("", "Styles", "Styles", "CDATA", sb.toString());
        }
        ch.startElement(parentName, att);
        ch.startElement("Title", new AttributesImpl());
        ch.characters(this.pdfBookMark.getTitle());
        ch.endElement("Title");
        if (this.pdfBookMark.hasCount()) {
            ch.startElement("Count", new AttributesImpl());
            ch.characters(String.valueOf(this.pdfBookMark.getCount()));
            ch.endElement("Count");
        }
        if (this.pdfBookMark.hasDestination()) {
            XPDFDestinationFactory.newInstance(this.pdfBookMark.getDestination()).toXPDF(ch, "Dest");
        }
        if (this.pdfBookMark.hasAction()) {
            XPDFActionFactory.newXPDFActionInstance(this.pdfBookMark.getAction()).toXPDF(ch, "Action");
        }
        for (PDFBookmark children = this.pdfBookMark.getFirstKid(); children != null; children = children.getNext()) {
            XPDFBookmark xChildern = new XPDFBookmark(children);
            xChildern.toXPDF(ch, "Bookmark");
        }
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String style;
        String color = att.getValue("Color");
        if (color != null) {
            double[] colors = this.colorFromXPDF(color, eh);
            this.pdfBookMark.setColor(colors[0], colors[1], colors[2]);
        }
        if ((style = att.getValue("Styles")) != null) {
            String[] styles = style.split(" ");
            int s = 0;
            for (int i = 0; i < styles.length; ++i) {
                if ("Italic".equals(styles[i])) {
                    s |= 1;
                }
                if (!"Bold".equals(styles[i])) continue;
                s |= 2;
            }
            this.pdfBookMark.setStyles(s);
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (this.inAction) {
            PDFAction action = XPDFActionFactory.newSkeletonInstance(lName, this.pdfBookMark.getPDFDocument());
            if (action == null) {
                return eh.XPDFInvalidElement(lName);
            }
            this.pdfBookMark.setAction(action);
            return XPDFActionFactory.newXPDFActionInstance(action);
        }
        if ("Title".equals(lName)) {
            this.title = new StringBuilder();
            return null;
        }
        if ("Count".equals(lName)) {
            this.count = new StringBuilder();
            return null;
        }
        if ("Dest".equals(lName)) {
            PDFDestinationExplicit dest = PDFDestinationExplicit.newSkeletonInstance((PDFDocument)this.pdfBookMark.getPDFDocument());
            this.pdfBookMark.setDestination((PDFDestination)dest);
            XPDFDestinationExplicit xDest = new XPDFDestinationExplicit(dest);
            xDest.setIsInternalDestination(true);
            return xDest;
        }
        if ("Action".equals(lName)) {
            this.inAction = true;
            return null;
        }
        if ("Bookmark".equals(lName)) {
            PDFBookmark bookmark = PDFBookmark.newSkeletonInstance((PDFDocument)this.pdfBookMark.getPDFDocument());
            PDFBookmarkUtils.appendLastKid((PDFBookmark)bookmark, (PDFBookmarkNode)this.pdfBookMark);
            return new XPDFBookmark(bookmark);
        }
        return eh.XPDFInvalidElement(lName);
    }

    @Override
    public void fromXPDFCharacters(char[] chars, int start, int length, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (this.title != null) {
            this.title.append(chars, start, length);
        } else if (this.count != null) {
            this.count.append(chars, start, length);
        } else {
            super.fromXPDFCharacters(chars, start, length, eh);
        }
    }

    @Override
    public void fromXPDFEndElement(String lName, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.inAction) {
            this.inAction = false;
            return;
        }
        if ("Title".equals(lName)) {
            this.pdfBookMark.setTitle(this.title.toString());
            this.title = null;
            return;
        }
        if ("Count".equals(lName)) {
            this.pdfBookMark.setCount(Integer.valueOf(this.count.toString()).intValue());
            this.count = null;
            return;
        }
    }

    public String toString() {
        try {
            return this.pdfBookMark.getTitle();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PDFBookmark getPDFObject() {
        return this.pdfBookMark;
    }
}

