/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.multimedia;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFSound;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.XPDFCosObject;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFSound
extends XPDFCosObject {
    private PDFSound pdfSound;

    public XPDFSound(PDFSound pdfSound) {
        this.pdfSound = pdfSound;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        CosStream stream;
        AttributesImpl soundAttr = new AttributesImpl();
        soundAttr.addAttribute("", "SamplingRate", "SamplingRate", "CDATA", String.valueOf(this.pdfSound.getSamplingRate()));
        if (this.pdfSound.hasChannelsNumber()) {
            soundAttr.addAttribute("", "ChannelCount", "ChannelCount", "CDATA", String.valueOf(this.pdfSound.getChannelsNumber()));
        }
        if (this.pdfSound.hasBitsPerSample()) {
            soundAttr.addAttribute("", "BitsPerSample", "BitsPerSample", "CDATA", String.valueOf(this.pdfSound.getBitsPerSample()));
        }
        if (this.pdfSound.hasEncoding()) {
            soundAttr.addAttribute("", "Encoding", "Encoding", "CDATA", String.valueOf(this.pdfSound.getEncoding()));
        }
        if (this.pdfSound.hasCompressionFormat()) {
            soundAttr.addAttribute("", "Compression", "Compression", "CDATA", String.valueOf(this.pdfSound.getCompressionFormat()));
        }
        if ((stream = this.pdfSound.getCompressionParamsAsStream()) != null) {
            soundAttr.addAttribute("", "Compression_enc", "Compression_enc", "CDATA", stream.textValue());
        }
        ch.element("SoundFile", soundAttr);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String compression_enc;
        String compression;
        String encoding;
        String bitsPerSample;
        String channelCount;
        String sampleRate = att.getValue("SamplingRate");
        if (sampleRate != null) {
            try {
                double d = Double.valueOf(sampleRate);
                this.pdfSound.setSamplingRate(d);
            }
            catch (NumberFormatException e) {
                eh.XPDFError("Invalid value ('" + sampleRate + "') for 'SamplingRate' attribute");
            }
        }
        if ((channelCount = att.getValue("ChannelCount")) != null) {
            try {
                int i = Integer.valueOf(channelCount);
                this.pdfSound.setChannelsNumber(i);
            }
            catch (NumberFormatException e) {
                eh.XPDFError("Invalid value ('" + channelCount + "') for 'ChannelCount' attribute");
            }
        }
        if ((bitsPerSample = att.getValue("BitsPerSample")) != null) {
            try {
                int i = Integer.valueOf(bitsPerSample);
                this.pdfSound.setBitsPerSample(i);
            }
            catch (NumberFormatException e) {
                eh.XPDFError("Invalid value ('" + bitsPerSample + "') for 'BitsPerSample' attribute");
            }
        }
        if ((encoding = att.getValue("Encoding")) != null) {
            try {
                this.pdfSound.setEncoding(ASName.create((String)encoding));
            }
            catch (PDFInvalidParameterException e) {
                eh.XPDFError("Invalid value ('" + encoding + "') for 'Encoding' attribute");
            }
        }
        if ((compression = att.getValue("Compression")) != null) {
            try {
                this.pdfSound.setCompressionFormat(ASName.create((String)compression));
            }
            catch (PDFInvalidParameterException e) {
                eh.XPDFError("Invalid value ('" + compression + "') for 'Compression' attribute");
            }
        }
        if ((compression_enc = att.getValue("Compression_enc")) != null) {
            try {
                PDFDocument doc = this.pdfSound.getPDFDocument();
                byte[] bytes = compression_enc.getBytes();
                OutputByteStream stream = doc.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.FIXED, (long)bytes.length);
                stream.write(bytes);
                CosStream cstream = doc.getCosDocument().createCosStream(stream.closeAndConvert());
                this.pdfSound.setCompressionParams(cstream);
            }
            catch (PDFInvalidParameterException e) {
                eh.XPDFError("Invalid value ('" + compression_enc + "') for 'Compression_enc' attribute");
            }
            catch (IOException e) {
                eh.XPDFError("Invalid value ('" + compression_enc + "') for 'Compression_enc' attribute");
            }
        }
    }
}

