/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFEmbeddedTarget;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFUtils;
import com.adobe.internal.pdftoolkit.xpdf.model.XPDFCosObject;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFEmbeddedTarget
extends XPDFCosObject {
    private PDFEmbeddedTarget pdfEmbeddedTarget;

    public XPDFEmbeddedTarget(PDFEmbeddedTarget pdfEmbeddedTarget) {
        this.pdfEmbeddedTarget = pdfEmbeddedTarget;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        int annotIndex;
        String annotName;
        int pageNum;
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "Relationship", "Relationship", "CDATA", this.pdfEmbeddedTarget.getRelationship().equals((Object)ASName.k_P) ? "Parent" : "Child");
        ASString filename = this.pdfEmbeddedTarget.getName();
        if (filename != null) {
            String[] x = XPDFUtils.asStringToXPDF(filename);
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "Filename_enc", "Filename_enc", "CDATA", x[1]);
            }
            att.addAttribute("", "Filename", "Filename", "CDATA", x[0]);
        }
        if ((pageNum = this.pdfEmbeddedTarget.getPageIndex()) != -1) {
            att.addAttribute("", "PageNum", "PageNum", "CDATA", String.valueOf(this.pdfEmbeddedTarget.getPageIndex()));
        }
        if ((annotName = this.pdfEmbeddedTarget.getAnnotationName()) != null) {
            att.addAttribute("", "AnnotName", "AnnotName", "CDATA", annotName);
        }
        if ((annotIndex = this.pdfEmbeddedTarget.getAnnotationIndex()) != -1) {
            att.addAttribute("", "AnnotNum", "AnnotNum", "CDATA", String.valueOf(annotIndex));
        }
        ch.startElement(parentName, att);
        PDFEmbeddedTarget target = this.pdfEmbeddedTarget.getEmbeddedTarget();
        if (target != null) {
            new XPDFEmbeddedTarget(target).toXPDF(ch, "Target");
        }
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String annotIndex;
        String annotName;
        String pageIndex;
        String filename;
        String relationship = att.getValue("Relationship");
        if (relationship != null) {
            this.pdfEmbeddedTarget.setRelationship("Parent".equals(relationship) ? ASName.k_P : ASName.k_C);
        }
        if ((filename = att.getValue("Filename")) != null) {
            this.pdfEmbeddedTarget.setName(XPDFUtils.asStringFromXPDF(filename, att.getValue("Filename_enc"), eh));
        }
        if ((pageIndex = att.getValue("PageNum")) != null) {
            this.pdfEmbeddedTarget.setPageIndex(Integer.parseInt(pageIndex));
        }
        if ((annotName = att.getValue("AnnotName")) != null) {
            this.pdfEmbeddedTarget.setAnnotationName(annotName);
        }
        if ((annotIndex = att.getValue("AnnotNum")) != null) {
            this.pdfEmbeddedTarget.setAnnotationIndex(Integer.parseInt(annotIndex));
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Target".equals(lName)) {
            PDFEmbeddedTarget target = PDFEmbeddedTarget.newInstance((PDFDocument)this.pdfEmbeddedTarget.getPDFDocument());
            this.pdfEmbeddedTarget.setEmbeddedTarget(target);
            return new XPDFEmbeddedTarget(target);
        }
        return null;
    }
}

