/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionURI;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFUtils;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFActionURI
extends XPDFAction {
    private PDFActionURI pdfActionURI;

    public XPDFActionURI(PDFActionURI pdfActionURI) {
        super((PDFAction)pdfActionURI);
        this.pdfActionURI = pdfActionURI;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String[] x;
        ch.startElement(parentName);
        AttributesImpl att = new AttributesImpl();
        if (this.pdfActionURI.hasURI()) {
            x = XPDFUtils.asStringToXPDF(this.pdfActionURI.getURI());
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "URI_enc", "URI_enc", "CDATA", x[1]);
            }
        } else {
            throw new PDFInvalidDocumentException("Missing /URI key in a URI action dict.");
        }
        att.addAttribute("", "URI", "URI", "CDATA", x[0]);
        if (this.pdfActionURI.hasIsMap()) {
            att.addAttribute("", "IsMap", "IsMap", "CDATA", this.pdfActionURI.getIsMap() ? "true" : "false");
        }
        super.exportNextToXPDF(ch, parentName);
        ch.element("URI", att);
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String isMap;
        String uri = att.getValue("URI");
        if (null != uri) {
            this.pdfActionURI.setURI(XPDFUtils.asStringFromXPDF(uri, att.getValue("URI_enc"), eh));
        }
        if (null != (isMap = att.getValue("IsMap"))) {
            if (!"true".equals(isMap) && !"false".equals(isMap)) {
                eh.XPDFError("Invalid value ('" + isMap + "') for 'IsMap' attribute");
            }
            this.pdfActionURI.setIsMap("true".equals(isMap));
        }
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionURI.hasURI()) {
            eh.XPDFError("Missing 'URI' attribute");
        }
    }
}

