/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionTransition;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFTransition;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFTransition;
import org.xml.sax.SAXException;

public class XPDFActionTransition
extends XPDFAction {
    private PDFActionTransition pdfActionTransition;

    public XPDFActionTransition(PDFActionTransition pdfActionTransition) {
        super((PDFAction)pdfActionTransition);
        this.pdfActionTransition = pdfActionTransition;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ch.startElement(parentName);
        ch.startElement("Trans");
        if (!this.pdfActionTransition.hasTrans()) {
            throw new PDFInvalidDocumentException("Missing /Trans key in transition action dict.");
        }
        new XPDFTransition(this.pdfActionTransition.getTrans()).toXPDF(ch, "Trans");
        super.exportNextToXPDF(ch, parentName);
        ch.endElement("Trans");
        ch.endElement(parentName);
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Trans".equals(lName)) {
            PDFTransition trans = PDFTransition.newInstance((PDFDocument)this.pdfActionTransition.getPDFDocument());
            try {
                this.pdfActionTransition.setTrans(trans);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
            return new XPDFTransition(trans);
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionTransition.hasTrans()) {
            eh.XPDFError("One 'Trans' child element is required");
        }
    }
}

