/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionSound;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFSound;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import com.adobe.internal.pdftoolkit.xpdf.model.multimedia.XPDFSound;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFActionSound
extends XPDFAction {
    private PDFActionSound pdfActionSound;

    public XPDFActionSound(PDFActionSound pdfActionSound) {
        super((PDFAction)pdfActionSound);
        this.pdfActionSound = pdfActionSound;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ch.startElement(parentName);
        AttributesImpl att = new AttributesImpl();
        if (this.pdfActionSound.hasVolume()) {
            att.addAttribute("", "Volume", "Volume", "CDATA", String.valueOf(this.pdfActionSound.getVolume()));
        }
        if (this.pdfActionSound.hasSynchronous()) {
            att.addAttribute("", "Synchronous", "Synchronous", "CDATA", this.pdfActionSound.getSynchronous() ? "true" : "false");
        }
        if (this.pdfActionSound.hasRepeat()) {
            att.addAttribute("", "Repeat", "Repeat", "CDATA", this.pdfActionSound.getRepeat() ? "true" : "false");
        }
        if (this.pdfActionSound.hasMix()) {
            att.addAttribute("", "Mix", "Mix", "CDATA", this.pdfActionSound.getMix() ? "true" : "false");
        }
        ch.startElement("Sound", att);
        if (!this.pdfActionSound.hasSound()) {
            throw new PDFInvalidDocumentException("Missing /Sound key in sound action dict.");
        }
        new XPDFSound((PDFSound)this.pdfActionSound.getSound()).toXPDF(ch, "SoundFile");
        ch.endElement("Sound");
        super.exportNextToXPDF(ch, parentName);
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String mix;
        String repeat;
        String synchronous;
        String volume = att.getValue("Volume");
        if (volume != null) {
            try {
                int d = Integer.valueOf(volume);
                this.pdfActionSound.setVolume((double)d);
            }
            catch (NumberFormatException e) {
                eh.XPDFError("Invalid value ('" + volume + "') for 'Volume' attribute");
            }
        }
        if ((synchronous = att.getValue("Synchronous")) != null) {
            if (!"true".equals(synchronous) && !"false".equals(synchronous)) {
                eh.XPDFError("Invalid value ('" + synchronous + "') for 'Synchronous' attribute");
            }
            this.pdfActionSound.setSynchronous("true".equals(synchronous));
        }
        if ((repeat = att.getValue("Repeat")) != null) {
            if (!"true".equals(repeat) && !"false".equals(repeat)) {
                eh.XPDFError("Invalid value ('" + repeat + "') for 'Repeat' attribute");
            }
            this.pdfActionSound.setRepeat("true".equals(repeat));
        }
        if ((mix = att.getValue("Mix")) != null) {
            if (!"true".equals(mix) && !"false".equals(mix)) {
                eh.XPDFError("Invalid value ('" + mix + "') for 'Mix' attribute");
            }
            this.pdfActionSound.setMix("true".equals(mix));
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("SoundFile".equals(lName)) {
            PDFSound sound = PDFSound.newInstance((PDFDocument)this.pdfActionSound.getPDFDocument());
            this.pdfActionSound.setSound((PDFCosStream)sound);
            return new XPDFSound(sound);
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionSound.hasSound()) {
            eh.XPDFError("A 'Sound' child element is required");
        }
    }
}

