/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionSetOCGState;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFActionSetOCGState
extends XPDFAction {
    private PDFActionSetOCGState pdfActionSetOCGState;
    private CosArray states = null;

    public XPDFActionSetOCGState(PDFActionSetOCGState pdfActionSetOCGState) {
        super((PDFAction)pdfActionSetOCGState);
        this.pdfActionSetOCGState = pdfActionSetOCGState;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ch.startElement(parentName);
        AttributesImpl attr = new AttributesImpl();
        if (this.pdfActionSetOCGState.hasPreserveRB()) {
            attr.addAttribute("", "PreserveRB", "PreserveRB", "CDATA", this.pdfActionSetOCGState.getPreserveRB() ? "true" : "false");
        }
        ch.startElement("SetOCGState", attr);
        if (this.pdfActionSetOCGState.hasState()) {
            ch.startElement("State");
            CosArray states = this.pdfActionSetOCGState.getState();
            int size = states.size();
            for (int i = 0; i < size; ++i) {
                AttributesImpl groupAttr = new AttributesImpl();
                CosObject obj = states.get(i);
                if (obj.getType() == 3) {
                    ASName name = states.getName(i);
                    if (name != ASName.k_ON && name != ASName.k_OFF && name != ASName.create((String)"Toggle")) {
                        throw new PDFInvalidDocumentException("Acceptable values for modes in state dictionary are ON, OFF and Toggle");
                    }
                    groupAttr.addAttribute("", "Mode", "Mode", "CDATA", name.asString());
                } else if (obj.getType() == 6) {
                    CosDictionary group = states.getCosDictionary(i);
                    groupAttr.addAttribute("", "ref", "ref", "CDATA", String.valueOf(group.getObjNum()));
                }
                ch.element("Group", groupAttr);
            }
        } else {
            throw new PDFInvalidDocumentException("Missing /State entry in Set-OCG-State Actions dictionary");
        }
        ch.endElement("State");
        super.exportNextToXPDF(ch, parentName);
        ch.endElement("SetOCGState");
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String preserveRB = att.getValue("PreserveRB");
        if (preserveRB != null) {
            if (!"true".equals(preserveRB) && !"false".equals(preserveRB)) {
                eh.XPDFError("Invalid value ('" + preserveRB + "') for 'PreserveRB' attribute");
            }
            this.pdfActionSetOCGState.setPreserveRB("true".equals(preserveRB));
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("State".equals(lName)) {
            this.states = this.pdfActionSetOCGState.getPDFDocument().getCosDocument().createCosArray();
            return null;
        }
        if ("Group".equals(lName)) {
            if (this.states != null) {
                CosDocument doc = this.pdfActionSetOCGState.getPDFDocument().getCosDocument();
                String refStr = att.getValue("ref");
                if (refStr != null) {
                    CosDictionary dict;
                    CosObject name;
                    Integer ref = Integer.valueOf(refStr);
                    CosObject obj = doc.getIndirectObjectByNumber(ref.intValue());
                    if (obj instanceof CosDictionary && (name = (dict = (CosDictionary)obj).get(ASName.k_Type)) instanceof CosName && name.nameValue() == ASName.k_OCG) {
                        this.states.add((CosObject)dict);
                    }
                } else {
                    String mode = att.getValue("Mode");
                    if (mode != null) {
                        CosName cMode = doc.createCosName(ASName.create((String)mode));
                        this.states.add((CosObject)cMode);
                    }
                }
            }
            return null;
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEndElement(String lName, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ("State".equals(lName)) {
            try {
                this.pdfActionSetOCGState.setState(this.states);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
            this.states = null;
        }
        if ("Next".equals(lName)) {
            this.processingNextActions = false;
        }
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (this.pdfActionSetOCGState.getState() == null) {
            eh.XPDFError("A 'State' child element is required");
        }
    }
}

