/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNamed;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFUtils;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFActionNamed
extends XPDFAction {
    private PDFActionNamed pdfActionNamed;

    public XPDFActionNamed(PDFActionNamed pdfActionNamed) {
        super((PDFAction)pdfActionNamed);
        this.pdfActionNamed = pdfActionNamed;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String[] x;
        ch.startElement(parentName);
        AttributesImpl att = new AttributesImpl();
        if (this.pdfActionNamed.hasName()) {
            x = XPDFUtils.asNameToXPDF(this.pdfActionNamed.getName());
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "Name_enc", "Name_enc", "CDATA", x[1]);
            }
        } else {
            throw new PDFInvalidDocumentException("Missing /N key in a URI action dict.");
        }
        att.addAttribute("", "Name", "Name", "CDATA", x[0]);
        super.exportNextToXPDF(ch, parentName);
        ch.element("Named", att);
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String s = att.getValue("Name");
        if (s != null) {
            this.pdfActionNamed.setName(XPDFUtils.asNameFromXPDF(s, att.getValue("Name_enc"), eh));
        }
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionNamed.hasName()) {
            eh.XPDFError("Missing 'Name' attribute");
        }
    }
}

