/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import com.adobe.internal.pdftoolkit.xpdf.model.document.XPDFFileSpecification;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestinationFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFActionGoToRemote
extends XPDFAction {
    private PDFActionGoToRemote pdfActionGoToRemote;

    public XPDFActionGoToRemote(PDFActionGoToRemote pdfActionGoToRemote) {
        super((PDFAction)pdfActionGoToRemote);
        this.pdfActionGoToRemote = pdfActionGoToRemote;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ch.startElement(parentName);
        AttributesImpl att = new AttributesImpl();
        if (this.pdfActionGoToRemote.hasNewWindow()) {
            att.addAttribute("", "NewWindow", "NewWindow", "CDATA", this.pdfActionGoToRemote.getNewWindow() ? "true" : "false");
        }
        ch.startElement("GoToR", att);
        if (!this.pdfActionGoToRemote.hasDestination()) {
            throw new PDFInvalidDocumentException("Missing /D key in remote go-to action dict.");
        }
        XPDFDestinationFactory.newInstance(this.pdfActionGoToRemote.getDestination()).toXPDF(ch, "Dest");
        if (!this.pdfActionGoToRemote.hasFileSpecification()) {
            throw new PDFInvalidDocumentException("Missing /F key in remote go-to action dict.");
        }
        new XPDFFileSpecification(this.pdfActionGoToRemote.getFileSpecification()).toXPDF(ch, "File");
        super.exportNextToXPDF(ch, parentName);
        ch.endElement("GoToR");
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String newWindow = att.getValue("NewWindow");
        if (null != newWindow) {
            if (!"true".equals(newWindow) && !"false".equals(newWindow)) {
                eh.XPDFError("Invalid value ('" + newWindow + "') for 'NewWindow' attribute");
            }
            this.pdfActionGoToRemote.setNewWindow("true".equals(newWindow));
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Dest".equals(lName)) {
            PDFDestinationExplicit dest = PDFDestinationExplicit.newSkeletonInstance((PDFDocument)this.pdfActionGoToRemote.getPDFDocument());
            this.pdfActionGoToRemote.setDestination((PDFDestination)dest);
            XPDFDestinationExplicit xDest = new XPDFDestinationExplicit(dest);
            xDest.setIsInternalDestination(false);
            return xDest;
        }
        if ("File".equals(lName)) {
            PDFFileSpecification file = PDFFileSpecification.newSkeletonInstance((PDFDocument)this.pdfActionGoToRemote.getPDFDocument());
            this.pdfActionGoToRemote.setFileSpecification(file);
            return new XPDFFileSpecification(file);
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionGoToRemote.hasDestination()) {
            eh.XPDFError("A 'Dest' child element is required");
        }
        if (!this.pdfActionGoToRemote.hasFileSpecification()) {
            eh.XPDFError("A 'File' child element is required");
        }
    }
}

