/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToEmbedded;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFEmbeddedTarget;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFEmbeddedTarget;
import com.adobe.internal.pdftoolkit.xpdf.model.document.XPDFFileSpecification;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestinationFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFActionGoToEmbedded
extends XPDFActionGoToRemote {
    private PDFActionGoToEmbedded pdfActionGoToEmbedded;

    public XPDFActionGoToEmbedded(PDFActionGoToEmbedded pdfActionGoToEmbedded) {
        super((PDFActionGoToRemote)pdfActionGoToEmbedded);
        this.pdfActionGoToEmbedded = pdfActionGoToEmbedded;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ch.startElement(parentName);
        AttributesImpl att = new AttributesImpl();
        if (this.pdfActionGoToEmbedded.hasNewWindow()) {
            att.addAttribute("", "NewWindow", "NewWindow", "CDATA", this.pdfActionGoToEmbedded.getNewWindow() ? "true" : "false");
        }
        ch.startElement("GoToE", att);
        if (!this.pdfActionGoToEmbedded.hasDestination()) {
            throw new PDFInvalidDocumentException("Missing /D key in embedded go-to action dict");
        }
        XPDFDestinationFactory.newInstance(this.pdfActionGoToEmbedded.getDestination()).toXPDF(ch, "Dest");
        if (this.pdfActionGoToEmbedded.hasFileSpecification()) {
            new XPDFFileSpecification(this.pdfActionGoToEmbedded.getFileSpecification()).toXPDF(ch, "File");
        }
        if (this.pdfActionGoToEmbedded.hasEmbeddedTarget()) {
            new XPDFEmbeddedTarget(this.pdfActionGoToEmbedded.getEmbeddedTarget()).toXPDF(ch, "Target");
        }
        super.exportNextToXPDF(ch, parentName);
        ch.endElement("GoToE");
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String newWindow = att.getValue("NewWindow");
        if (newWindow != null) {
            if (!"true".equals(newWindow) && !"false".equals(newWindow)) {
                eh.XPDFError("Invalid value ('" + newWindow + "') for 'NewWindow' attribute");
            }
            this.pdfActionGoToEmbedded.setNewWindow("true".equals(newWindow));
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Dest".equals(lName)) {
            PDFDestinationExplicit dest = PDFDestinationExplicit.newSkeletonInstance((PDFDocument)this.pdfActionGoToEmbedded.getPDFDocument());
            this.pdfActionGoToEmbedded.setDestination((PDFDestination)dest);
            XPDFDestinationExplicit xDest = new XPDFDestinationExplicit(dest);
            xDest.setIsInternalDestination(false);
            return xDest;
        }
        if ("File".equals(lName)) {
            PDFFileSpecification file = PDFFileSpecification.newSkeletonInstance((PDFDocument)this.pdfActionGoToEmbedded.getPDFDocument());
            this.pdfActionGoToEmbedded.setFileSpecification(file);
            return new XPDFFileSpecification(file);
        }
        if ("Target".equals(lName)) {
            PDFEmbeddedTarget target = PDFEmbeddedTarget.newInstance((PDFDocument)this.pdfActionGoToEmbedded.getPDFDocument());
            this.pdfActionGoToEmbedded.setEmbeddedTarget(target);
            return new XPDFEmbeddedTarget(target);
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionGoToEmbedded.hasDestination()) {
            eh.XPDFError("A 'Dest' child element is required");
        }
        if (!this.pdfActionGoToEmbedded.hasFileSpecification() && !this.pdfActionGoToEmbedded.hasEmbeddedTarget()) {
            eh.XPDFError("One 'File' or 'Target' child element is required");
        }
    }
}

