/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.impl;

import com.adobe.internal.pdftoolkit.core.filter.Base64Engine;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.xml.sax.SAXException;

public class XPDFUtils {
    private static final String UTF8 = "UTF-8";
    private static final CharsetDecoder utf16beDecoder = Charset.forName("UTF-16BE").newDecoder();
    private static final CharsetDecoder utf8Decoder;

    public static String[] toXPDF(byte[] bytes) {
        String s = XPDFUtils.toXPDFAscii(bytes);
        if (s != null && XPDFUtils.isLegalInXML(s)) {
            return new String[]{s, "ASCII"};
        }
        s = XPDFUtils.toXPDFUTF16(bytes);
        if (s != null && XPDFUtils.isLegalInXML(s)) {
            return new String[]{s, "UTF-16"};
        }
        s = XPDFUtils.toXPDFUTF8(bytes);
        if (s != null && XPDFUtils.isLegalInXML(s)) {
            return new String[]{s, UTF8};
        }
        s = XPDFUtils.toXPDFPDFDocEncoding(bytes);
        if (s != null && XPDFUtils.isLegalInXML(s)) {
            return new String[]{s, "PDFDocEncoding"};
        }
        s = XPDFUtils.toXPDFBase64(bytes);
        return new String[]{s, "BASE64"};
    }

    private static boolean isLegalInXML(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ('\u0000' >= c || c >= '\u001f' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    private static String toXPDFAscii(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            if (32 <= bytes[i] && (bytes[i] & 0xFF) <= 127 || bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 13) continue;
            return null;
        }
        try {
            return new String(bytes, 0, bytes.length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("'US-ASCII' encoding not supported.", e);
        }
    }

    private static String toXPDFUTF16(byte[] bytes) {
        if (bytes.length < 2 || bytes[0] != -2 || bytes[1] != -1) {
            return null;
        }
        try {
            return utf16beDecoder.decode(ByteBuffer.wrap(bytes, 2, bytes.length - 2)).toString();
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    private static String toXPDFUTF8(byte[] bytes) {
        if (bytes.length < 3 || bytes[0] != -17 || bytes[1] != -69 || bytes[2] != -65) {
            return null;
        }
        try {
            return utf8Decoder.decode(ByteBuffer.wrap(bytes, 3, bytes.length - 3)).toString();
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    private static String toXPDFPDFDocEncoding(byte[] bytes) {
        try {
            return new String(PDFDocEncoding.decode((byte[])bytes, (int)0, (int)bytes.length));
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    private static String toXPDFBase64(byte[] bytes) {
        return new String(Base64Engine.encode((byte[])bytes, (int)0, (int)bytes.length));
    }

    public static byte[] fromXPDF(String s, String encoding) {
        try {
            if (encoding == null) {
                return PDFDocEncoding.fromUnicodeString((String)s, (boolean)false);
            }
            if (UTF8.equals(encoding)) {
                byte[] b = s.getBytes(UTF8);
                byte[] b2 = new byte[b.length + 3];
                b2[0] = -17;
                b2[1] = -69;
                b2[2] = -65;
                System.arraycopy(b, 0, b2, 3, b.length);
                return b2;
            }
            if ("UTF-16".equals(encoding)) {
                byte[] b = s.getBytes("UTF-16BE");
                byte[] b2 = new byte[b.length + 2];
                b2[0] = -2;
                b2[1] = -1;
                System.arraycopy(b, 0, b2, 2, b.length);
                return b2;
            }
            if ("BASE64".equals(encoding)) {
                return Base64Engine.decode((String)s);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 or UTF16 not supported", e);
        }
    }

    public static String[] asNameToXPDF(ASName name) {
        return XPDFUtils.toXPDF(name.getBytes());
    }

    public static ASName asNameFromXPDF(String s, String encoding, XPDFErrorHandler eh) throws SAXException {
        byte[] bytes = XPDFUtils.fromXPDF(s, encoding);
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                eh.XPDFError("invalid ASName (contains U+" + Integer.toHexString(bytes[i]) + ")");
                bytes[i] = 1;
            }
            return ASName.getName((byte[])bytes);
        }
        eh.XPDFError("Illegal string ('" + s + "') for encoding " + encoding);
        return null;
    }

    public static String[] asStringToXPDF(ASString string) {
        return XPDFUtils.toXPDF(string.getBytes());
    }

    public static ASString asStringFromXPDF(String s, String encoding, XPDFErrorHandler eh) throws SAXException {
        byte[] bytes = XPDFUtils.fromXPDF(s, encoding);
        if (bytes != null) {
            return new ASString(bytes);
        }
        eh.XPDFError("Illegal string ('" + s + "') for encoding " + encoding);
        return null;
    }

    private XPDFUtils() {
    }

    static {
        utf16beDecoder.onMalformedInput(CodingErrorAction.REPORT);
        utf8Decoder = Charset.forName(UTF8).newDecoder();
        utf8Decoder.onMalformedInput(CodingErrorAction.REPORT);
    }
}

