/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.impl;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFContentHandler {
    private ContentHandler ch;
    private static final Attributes nullAtt = new AttributesImpl();
    protected final String namespace;
    protected final String schemaVersion;

    public XPDFContentHandler(ContentHandler ch, String nameSpace) {
        this.ch = ch;
        this.namespace = nameSpace;
        this.schemaVersion = null;
    }

    public XPDFContentHandler(ContentHandler ch, String nameSpace, String version) {
        this.ch = ch;
        this.namespace = nameSpace;
        this.schemaVersion = version;
    }

    public ContentHandler getContentHandler() {
        return this.ch;
    }

    public void startDocument() throws SAXException {
        this.ch.startDocument();
        this.ch.startPrefixMapping("", this.namespace);
    }

    public void endDocument() throws SAXException {
        this.ch.endPrefixMapping("");
        this.ch.endDocument();
    }

    public void startPrefixMapping(String prefix, String ns) throws SAXException {
        this.ch.startPrefixMapping(prefix, ns);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.ch.endPrefixMapping(prefix);
    }

    public void startRootElement(String name, boolean namespacePrefixes) throws SAXException {
        AttributesImpl att = new AttributesImpl();
        if (namespacePrefixes) {
            att.addAttribute("", "", "xmlns", "CDATA", this.namespace);
            if (this.schemaVersion != null) {
                att.addAttribute("", "", "version", "CDATA", this.schemaVersion);
            }
        }
        this.startElement(name, att);
    }

    public void startElement(String name) throws SAXException {
        if (name != null) {
            this.startElement(name, nullAtt);
        }
    }

    public void startElement(String name, Attributes att) throws SAXException {
        this.ch.startElement(this.namespace, name, name, att);
    }

    public void characters(String s) throws SAXException {
        char[] chars = s.toCharArray();
        this.characters(chars, 0, chars.length);
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        while (length > 0) {
            int from = start;
            while (length > 0 && (chars[start] == '\t' || chars[start] == '\n' || chars[start] == '\r' || ' ' <= chars[start] && chars[start] <= '\ufffd')) {
                ++start;
                --length;
            }
            if (start != from) {
                this.ch.characters(chars, from, start - from);
            }
            if (length == 0) continue;
            ++start;
            --length;
        }
    }

    public void endElement(String name) throws SAXException {
        if (name != null) {
            this.ch.endElement(this.namespace, name, name);
        }
    }

    public void element(String name) throws SAXException {
        this.element(name, nullAtt);
    }

    public void element(String name, Attributes att) throws SAXException {
        this.startElement(name, att);
        this.endElement(name);
    }
}

