/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.io.NullOutputStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.xml.CopyBlobProcessElement;
import com.adobe.internal.pdftoolkit.xml.InsertionContentHandler;
import com.adobe.internal.pdftoolkit.xml.XMLConformer;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLElementCopier;
import com.adobe.internal.pdftoolkit.xml.XMLElementReplacer;
import com.adobe.internal.pdftoolkit.xml.XMLElementsRemover;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLUtils {
    public static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String surrogateCharacterReferencePatternString = "&#x([\\da-fA-F]+);";
    private static final Pattern surrogateCharacterReferencePattern = Pattern.compile("&#x([\\da-fA-F]+);");
    private static final TransformerFactory tFactory;
    public static final String NAMESPACES_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String DISALLOW_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";
    public static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final SAXParserFactory pNonValidatingNameSpaceAwareSaxParserFactory;
    private static final SAXParserFactory pNonValidatingSaxParserFactory;
    private static final SAXParserFactory pFactory;

    private XMLUtils() {
    }

    public static void transformToXML(Source inputXML, Result outputXML, boolean omitXMLDeclaration) throws TransformerException {
        Transformer xmlTransformer = XMLUtils.getTransformer();
        xmlTransformer.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        xmlTransformer.transform(inputXML, outputXML);
    }

    public static void transformToXML(InputSource source, ContentHandler handler, Result result, boolean omitXMLDeclaration) throws SAXException, TransformerException {
        XMLReader reader = XMLUtils.getXMLReader();
        reader.setContentHandler(handler);
        reader.setFeature(NAMESPACES, true);
        reader.setFeature(NAMESPACES_PREFIXES, true);
        XMLUtils.transformToXML(new SAXSource(reader, source), result, omitXMLDeclaration);
    }

    public static Result createNullResult() {
        return new StreamResult((OutputStream)new NullOutputStream());
    }

    public static Source createSource(InputSource source, XMLFilter filter) throws SAXException {
        return XMLUtils.createSource(source, filter, true);
    }

    public static Source createSource(InputSource source, XMLFilter filter, boolean attachToReader) throws SAXException {
        return XMLUtils.createSource(source, filter, true, false);
    }

    public static Source createSource(InputSource source, XMLFilter filter, boolean attachToReader, boolean enableDTDExpansion) throws SAXException {
        if (attachToReader) {
            XMLReader readerbase = XMLUtils.getXMLReader();
            filter.setParent(readerbase);
        }
        filter.setFeature(NAMESPACES, true);
        filter.setFeature(NAMESPACES_PREFIXES, true);
        if (enableDTDExpansion) {
            filter.setFeature(DISALLOW_DOCTYPE, false);
        }
        return new SAXSource(filter, source);
    }

    public static Source createSource(InputSource source, XMLFilter[] filters) throws SAXException {
        return XMLUtils.createSource(source, filters, true);
    }

    public static Source createSource(InputSource source, XMLFilter[] filters, boolean attachToReader) throws SAXException {
        return new SAXSource(XMLUtils.chainFilters(filters, attachToReader), source);
    }

    public static XMLFilter chainFilters(XMLFilter[] filters, boolean attachToReader) throws SAXException {
        XMLReader prev = attachToReader ? XMLUtils.getXMLReader() : null;
        for (int i = 0; i < filters.length; ++i) {
            if (prev != null) {
                filters[i].setParent(prev);
            }
            filters[i].setFeature(NAMESPACES, true);
            filters[i].setFeature(NAMESPACES_PREFIXES, true);
            prev = filters[i];
        }
        return filters[filters.length - 1];
    }

    public static Source createExtractionSource(InputSource source, XMLElement element, boolean includeElement) throws SAXException {
        XMLReader readerbase = XMLUtils.getXMLReader();
        XMLElementCopier reader = new XMLElementCopier(readerbase, element, includeElement);
        reader.setParent(readerbase);
        reader.setFeature(NAMESPACES, true);
        reader.setFeature(NAMESPACES_PREFIXES, true);
        return new SAXSource(reader, source);
    }

    public static Result createInsertionResult(ContentHandler contentHandler) {
        InsertionContentHandler handler = new InsertionContentHandler(contentHandler);
        return new SAXResult(handler);
    }

    public static Result createInsertionResult(ContentHandler contentHandler, XMLElement element) {
        InsertionContentHandler handler = new InsertionContentHandler(contentHandler, element);
        return new SAXResult(handler);
    }

    public static void applyXMLFilter(InputSource source, XMLFilter filter, Result result, boolean omitXMLDeclaration) throws SAXException, TransformerException {
        Source combinedSource = XMLUtils.createSource(source, filter);
        XMLUtils.transformToXML(combinedSource, result, omitXMLDeclaration);
    }

    public static boolean extractXMLElement(InputSource source, Result result, XMLElement element, boolean includeElement, boolean omitXMLDeclaration) throws TransformerException, SAXException {
        XMLReader readerbase = XMLUtils.getXMLReader();
        XMLElementCopier reader = new XMLElementCopier(readerbase, element, includeElement);
        reader.setFeature(NAMESPACES, true);
        reader.setFeature(NAMESPACES_PREFIXES, true);
        SAXSource combinedSource = new SAXSource(reader, source);
        XMLUtils.transformToXML(combinedSource, result, omitXMLDeclaration);
        return reader.succeeded();
    }

    public static boolean replaceXMLElement(InputSource source, Source replacement, Result result, XMLElement element, boolean includeElement, boolean insertElementIfNotFound, boolean omitXMLDeclaration) throws TransformerException, SAXException {
        XMLReader readerbase = XMLUtils.getXMLReader();
        XMLElementReplacer reader = new XMLElementReplacer(readerbase, element, replacement, includeElement, insertElementIfNotFound);
        reader.setFeature(NAMESPACES, true);
        reader.setFeature(NAMESPACES_PREFIXES, true);
        SAXSource combinedSource = new SAXSource(reader, source);
        XMLUtils.transformToXML(combinedSource, result, omitXMLDeclaration);
        return reader.succeeded();
    }

    public static boolean removeXMLElements(InputSource source, Result result, boolean omitXMLDeclaration, XMLElementsRemover elementRemoverFilter) throws TransformerException, SAXException {
        SAXSource combinedSource = new SAXSource(elementRemoverFilter, source);
        XMLUtils.transformToXML(combinedSource, result, omitXMLDeclaration);
        return elementRemoverFilter.succeeded();
    }

    public static boolean insertXML(Source source, ContentHandler content) throws SAXException, IOException {
        InsertionContentHandler handler = new InsertionContentHandler(content);
        return XMLUtils.insertXMLInternal(source, handler);
    }

    public static boolean insertXML(Source source, ContentHandler content, XMLElement element) throws SAXException, IOException {
        InsertionContentHandler handler = new InsertionContentHandler(content, element);
        return XMLUtils.insertXMLInternal(source, handler);
    }

    private static boolean insertXMLInternal(Source source, InsertionContentHandler handler) throws SAXException, IOException {
        XMLReader xmlReader = null;
        xmlReader = source instanceof SAXSource && ((SAXSource)source).getXMLReader() != null ? ((SAXSource)source).getXMLReader() : XMLUtils.getXMLReader();
        xmlReader.setContentHandler(handler);
        try {
            xmlReader.setProperty(LEXICAL_HANDLER, handler);
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        xmlReader.setFeature(NAMESPACES, true);
        xmlReader.setFeature(NAMESPACES_PREFIXES, true);
        xmlReader.parse(SAXSource.sourceToInputSource(source));
        return handler.succeeded();
    }

    public static boolean conformXML(InputSource xmlBase, Source newXML, Result result, XMLElement element, boolean omitXMLDeclaration) throws SAXException, TransformerException {
        XMLReader readerbase = XMLUtils.getXMLReader();
        XMLConformer reader = new XMLConformer(readerbase, newXML, element);
        reader.setFeature(NAMESPACES, true);
        reader.setFeature(NAMESPACES_PREFIXES, true);
        SAXSource combinedSource = new SAXSource(reader, xmlBase);
        XMLUtils.transformToXML(combinedSource, result, omitXMLDeclaration);
        return reader.succeeded();
    }

    public static boolean conformXML(InputSource xmlBase, Source newXML, Result result, boolean omitXMLDeclaration) throws SAXException, TransformerException {
        XMLReader readerbase = XMLUtils.getXMLReader();
        XMLConformer reader = new XMLConformer(readerbase, newXML);
        reader.setFeature(NAMESPACES, true);
        reader.setFeature(NAMESPACES_PREFIXES, true);
        SAXSource combinedSource = new SAXSource(reader, xmlBase);
        XMLUtils.transformToXML(combinedSource, result, omitXMLDeclaration);
        return reader.succeeded();
    }

    public static String stripTrailingCharacter(String s, char c) {
        if (s.charAt(s.length() - 1) == c) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static void parse(InputSource xmlBase) throws SAXException, IOException {
        XMLReader reader = XMLUtils.getXMLReader();
        reader.setFeature(NAMESPACES, true);
        reader.setFeature(NAMESPACES_PREFIXES, true);
        reader.parse(xmlBase);
    }

    public static String convertStringToXMLString(String s) {
        int cpCount = s.codePointCount(0, s.length());
        StringBuilder sb = new StringBuilder(cpCount);
        int charIndex = 0;
        for (int i = 0; i < cpCount; ++i) {
            int cp = s.codePointAt(charIndex);
            int charCount = Character.charCount(cp);
            charIndex += charCount;
            if (charCount > 1) {
                sb.append("&#x");
                sb.append(Integer.toHexString(cp));
                sb.append(";");
                continue;
            }
            sb.append(Character.toChars(cp));
        }
        return sb.toString();
    }

    public static String convertXMLStringToString(String s) throws PDFInvalidXMLException {
        StringBuilder sb = new StringBuilder();
        boolean found = false;
        Matcher characterEntityMatcher = surrogateCharacterReferencePattern.matcher(s);
        int lastMatchEndPointer = 0;
        int matchPointer = 0;
        char[] replacements = new char[2];
        char[] replacement = new char[1];
        while (characterEntityMatcher.find(lastMatchEndPointer)) {
            int entityValue;
            found = true;
            matchPointer = characterEntityMatcher.start();
            if (matchPointer > lastMatchEndPointer) {
                sb.append(s.substring(lastMatchEndPointer, matchPointer));
            }
            if ((entityValue = Integer.parseInt(characterEntityMatcher.group(1), 16)) > 0x10FFFF) {
                throw new PDFInvalidXMLException("Value is bigger than allowed in Unicode.");
            }
            if (entityValue > 65535) {
                replacements[0] = (char)(55232 + (entityValue >> 10));
                replacements[1] = (char)(56320 + (entityValue & 0x3FF));
                sb.append(replacements);
            } else {
                replacement[0] = (char)entityValue;
                sb.append(replacement);
            }
            lastMatchEndPointer = characterEntityMatcher.end();
        }
        replacements = null;
        replacement = null;
        if (found) {
            sb.append(s.substring(lastMatchEndPointer));
            return sb.toString();
        }
        return s;
    }

    public static void outputChars(ContentHandler handler, String s) throws SAXException {
        char[] c = s.toCharArray();
        handler.characters(c, 0, c.length);
    }

    public static String getQualifiedName(String uri, String localName, NamespaceSupport namespaceSupport) {
        StringBuilder builder = new StringBuilder();
        String prefix = namespaceSupport.getPrefix(uri);
        if (prefix != null) {
            builder.append(prefix);
            builder.append(":");
        }
        builder.append(localName);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParser getNonValidatingNameSpaceAwareSaxParser() throws ParserConfigurationException, SAXException {
        try {
            SAXParserFactory sAXParserFactory = pNonValidatingNameSpaceAwareSaxParserFactory;
            synchronized (sAXParserFactory) {
                return pNonValidatingNameSpaceAwareSaxParserFactory.newSAXParser();
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParser getNonValidatingSaxParser() throws ParserConfigurationException, SAXException {
        try {
            SAXParserFactory sAXParserFactory = pNonValidatingSaxParserFactory;
            synchronized (sAXParserFactory) {
                return pNonValidatingSaxParserFactory.newSAXParser();
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLReader getXMLReader() throws SAXException {
        try {
            SAXParserFactory sAXParserFactory = pFactory;
            synchronized (sAXParserFactory) {
                return pFactory.newSAXParser().getXMLReader();
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Transformer getTransformer() throws TransformerException {
        TransformerFactory transformerFactory = tFactory;
        synchronized (transformerFactory) {
            return tFactory.newTransformer();
        }
    }

    public static boolean matchNamespaces(String currentNamespace, String schemaNamespace) {
        if (currentNamespace.isEmpty() && schemaNamespace.isEmpty()) {
            return true;
        }
        if (!currentNamespace.isEmpty() && !schemaNamespace.isEmpty() && currentNamespace.length() == schemaNamespace.length()) {
            boolean nsLastCharHashOrSlash;
            boolean bl = nsLastCharHashOrSlash = currentNamespace.endsWith("#") && schemaNamespace.endsWith("/") || currentNamespace.endsWith("/") && schemaNamespace.endsWith("#");
            if (nsLastCharHashOrSlash) {
                return currentNamespace.regionMatches(0, schemaNamespace, 0, currentNamespace.length() - 1);
            }
            return currentNamespace.regionMatches(0, schemaNamespace, 0, currentNamespace.length());
        }
        return false;
    }

    static {
        Object temp = TransformerFactory.newInstance();
        try {
            ((TransformerFactory)temp).setFeature(NAMESPACES, true);
            ((TransformerFactory)temp).setFeature(NAMESPACES_PREFIXES, true);
            ((TransformerFactory)temp).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        tFactory = temp;
        temp = SAXParserFactory.newInstance();
        try {
            ((SAXParserFactory)temp).setNamespaceAware(true);
            ((SAXParserFactory)temp).setValidating(false);
            ((SAXParserFactory)temp).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            ((SAXParserFactory)temp).setFeature(DISALLOW_DOCTYPE, true);
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
        pNonValidatingNameSpaceAwareSaxParserFactory = temp;
        temp = SAXParserFactory.newInstance();
        try {
            ((SAXParserFactory)temp).setValidating(false);
            ((SAXParserFactory)temp).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            ((SAXParserFactory)temp).setFeature(DISALLOW_DOCTYPE, true);
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
        pNonValidatingSaxParserFactory = temp;
        temp = SAXParserFactory.newInstance();
        try {
            ((SAXParserFactory)temp).setFeature(NAMESPACES, true);
            ((SAXParserFactory)temp).setFeature(NAMESPACES_PREFIXES, true);
            ((SAXParserFactory)temp).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            ((SAXParserFactory)temp).setFeature(DISALLOW_DOCTYPE, true);
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        pFactory = temp;
    }

    public static class CopyString2Blob
    extends DefaultHandler {
        private ContentHandler outHandler = null;
        private StringBuilder content = null;
        private CopyBlobProcessElement checkElement = null;

        public CopyString2Blob(ContentHandler handler, CopyBlobProcessElement checkElement) {
            this.outHandler = handler;
            this.checkElement = checkElement;
        }

        public boolean copyBlob(String xmlBlob) throws PDFIOException, PDFInvalidXMLException, PDFConfigurationException {
            SAXParser saxParser;
            try {
                saxParser = XMLUtils.getNonValidatingNameSpaceAwareSaxParser();
            }
            catch (ParserConfigurationException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            catch (SAXException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            StringReader blobReader = new StringReader(xmlBlob);
            InputSource xmlSource = new InputSource(blobReader);
            try {
                saxParser.parse(xmlSource, (DefaultHandler)this);
            }
            catch (SAXException e) {
                throw new PDFInvalidXMLException((Throwable)e);
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            try {
                saxParser.getXMLReader().setFeature(XMLUtils.NAMESPACES_PREFIXES, true);
            }
            catch (SAXNotRecognizedException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            catch (SAXNotSupportedException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            catch (SAXException e) {
                throw new PDFInvalidXMLException((Throwable)e);
            }
            return true;
        }

        public String getRawContent() {
            return this.content != null ? this.content.toString() : null;
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) throws SAXException {
            Attributes newAttrs = null;
            if (this.checkElement != null) {
                newAttrs = this.checkElement.processElement(namespaceURI, sName, qName, elemAttrs);
            }
            if (newAttrs != null) {
                elemAttrs = newAttrs;
            }
            this.outHandler.startElement(namespaceURI, sName, qName, elemAttrs);
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            this.outHandler.endElement(namespaceURI, sName, qName);
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            this.outHandler.characters(buf, offset, len);
            if (this.content == null) {
                this.content = new StringBuilder(len);
            }
            this.content.append(buf, offset, len);
        }

        @Override
        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        @Override
        public void warning(SAXParseException err) throws SAXParseException {
            throw err;
        }
    }

    public static final class CopyBlob2String
    implements XMLReader {
        ContentHandler handler;
        static final String nsu = "";
        static final Attributes nullAtts = new AttributesImpl();
        static final String secondRoot = "annots";
        private CopyBlobProcessElement checkElement = null;
        private boolean copyMode;
        private Stack<Boolean> copyModeStack = new Stack();
        private StringWriter blob = null;
        private StringBuilder rawContent = null;

        public CopyBlob2String(CopyBlobProcessElement checkElement) throws PDFInvalidXMLException, PDFConfigurationException {
            Transformer xmlTransformer;
            this.setFeature(XMLUtils.NAMESPACES_PREFIXES, true);
            this.setFeature(XMLUtils.NAMESPACES, true);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            try {
                xmlTransformer = tFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            this.blob = new StringWriter();
            if (checkElement != null) {
                checkElement.setCaller(this);
            }
            try {
                xmlTransformer.transform(new SAXSource(this, new InputSource()), new StreamResult(this.blob));
            }
            catch (TransformerException e) {
                throw new PDFInvalidXMLException((Throwable)e);
            }
            this.checkElement = checkElement;
        }

        public CopyBlobProcessElement getProcessElement() {
            return this.checkElement;
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) throws SAXException {
            if (this.checkElement != null) {
                Attributes newAttrs = this.checkElement.processElement(namespaceURI, sName, qName, elemAttrs);
                if (newAttrs != null) {
                    elemAttrs = newAttrs;
                }
                this.copyMode = this.checkElement.isCopyMode(namespaceURI, sName, qName, elemAttrs);
                this.copyModeStack.push(this.copyMode);
            }
            this.handler.startElement(namespaceURI, sName, qName, elemAttrs);
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            this.copyModeStack.pop();
            this.copyMode = this.copyModeStack.size() != 0 ? this.copyModeStack.peek() : false;
            this.handler.endElement(namespaceURI, sName, qName);
        }

        @Override
        public void parse(InputSource source) throws IOException, SAXException {
            if (this.handler == null) {
                throw new SAXException("No content handler");
            }
        }

        public void copyCharacters(char[] buf, int offset, int len) throws SAXException {
            if (this.handler == null) {
                throw new SAXException("No content handler");
            }
            if (this.copyMode) {
                this.handler.characters(buf, offset, len);
                if (this.rawContent == null) {
                    this.rawContent = new StringBuilder(len);
                }
                this.rawContent.append(buf, offset, len);
            }
        }

        public void addRawContent(char[] buf, int offset, int len) throws SAXException {
            if (this.handler == null) {
                throw new SAXException("No content handler");
            }
            this.rawContent.append(buf, offset, len);
        }

        public String getBlob() {
            return this.blob != null ? this.blob.toString() : null;
        }

        public String getRawContent() {
            return this.rawContent != null ? this.rawContent.toString() : null;
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.handler = handler;
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.handler;
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return null;
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
        }

        @Override
        public DTDHandler getDTDHandler() {
            return null;
        }

        @Override
        public EntityResolver getEntityResolver() {
            return null;
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
        }

        @Override
        public Object getProperty(String name) {
            return null;
        }

        @Override
        public void setProperty(String name, Object value) {
        }

        @Override
        public void setFeature(String name, boolean value) {
        }

        @Override
        public boolean getFeature(String name) {
            return false;
        }
    }
}

