/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xobjhandler;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFApplicationData;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.compoundtype.PDFCompoundTypeInfo;

public final class XObjectContentType {
    public static final XObjectContentType Watermark = new XObjectContentType(ASName.create((String)"Watermark"));
    public static final XObjectContentType Background = new XObjectContentType(ASName.create((String)"Background"));
    public static final XObjectContentType Header = new XObjectContentType(ASName.create((String)"Header"));
    public static final XObjectContentType Footer = new XObjectContentType(ASName.create((String)"Footer"));
    public static final XObjectContentType General = new XObjectContentType(ASName.create((String)"General"));
    public static final XObjectContentType BatesN = new XObjectContentType(ASName.create((String)"BatesN"));
    private ASName value;

    private XObjectContentType(ASName type) {
        this.value = type;
    }

    static XObjectContentType getInstance(ASName style) {
        if (style == Watermark.getValue()) {
            return Watermark;
        }
        if (style == Background.getValue()) {
            return Background;
        }
        if (style == Header.getValue()) {
            return Header;
        }
        if (style == Footer.getValue()) {
            return Footer;
        }
        if (style == BatesN.getValue()) {
            return BatesN;
        }
        return General;
    }

    public ASName getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.asString(true);
    }

    public void applyPieceInfo(PDFXObjectForm pdfXObjectForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this != Watermark && this != Background && this != Header && this != Footer && this != BatesN) {
            return;
        }
        PDFCompoundTypeInfo typeInfo = PDFCompoundTypeInfo.newInstance(pdfXObjectForm.getPDFDocument(), this.getValue());
        PDFApplicationData pdfApplicationData = typeInfo.setType(pdfXObjectForm);
        ASDate lastModified = new ASDate();
        pdfApplicationData.setLastModified(lastModified);
        pdfXObjectForm.setLastModified(lastModified);
    }
}

