/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xobjhandler;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.MarkedContentOperands;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureArtifact;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureIDTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRole;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.interchange.structure.StructureListener;
import com.adobe.internal.pdftoolkit.services.interchange.structure.StructureUtil;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectContentType;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectUseOptions;
import java.util.ArrayList;
import java.util.HashSet;

public class XObjectApplyOptions {
    private double x_position = 0.0;
    private double y_position = 0.0;
    private double rotation = 0.0;
    private double vScale = 1.0;
    private double hScale = 1.0;
    private double opacity = 1.0;

    public void setPosition(double x, double y) {
        this.x_position = x;
        this.y_position = y;
    }

    public void setRotation(double degrees) {
        this.rotation = degrees;
    }

    public void setVScale(double scale) throws PDFInvalidParameterException {
        if (scale <= 0.0) {
            throw new PDFInvalidParameterException("Invalid non-positive use option vscale parameter");
        }
        this.vScale = scale;
    }

    public void setHScale(double scale) throws PDFInvalidParameterException {
        if (scale <= 0.0) {
            throw new PDFInvalidParameterException("Invalid non-positive use option hscale parameter");
        }
        this.hScale = scale;
    }

    public void setOpacity(double opacity) throws PDFInvalidParameterException {
        if (opacity < 0.0 || 1.0 < opacity) {
            throw new PDFInvalidParameterException("Invalid use option opacity parameter (must be 0=< opacity =<1)");
        }
        this.opacity = opacity;
    }

    double llx() {
        return this.x_position;
    }

    double lly() {
        return this.y_position;
    }

    double getRotation() {
        return this.rotation;
    }

    double getVScale() {
        return this.vScale;
    }

    double getHScale() {
        return this.hScale;
    }

    double getOpacity() {
        return this.opacity;
    }

    public void applyXObjectForm(PDFPage pdfPage, PDFXObjectForm pdfXObjectForm, XObjectUseOptions useOptions, PDFExtGState pdfExtgstate) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.applyXObjectForm(pdfPage, pdfXObjectForm, useOptions, null, false, null, 0, pdfExtgstate);
    }

    public void applyXObjectForm(PDFPage pdfPage, PDFXObjectForm pdfXObjectForm, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.applyXObjectForm(pdfPage, pdfXObjectForm, useOptions, null, false, null, 0, null);
    }

    public void applyXObjectFormBatesNumber(PDFPage pdfPage, PDFXObjectForm pdfXObjectForm, XObjectUseOptions useOptions, String[] batesNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!useOptions.getContentType().equals(XObjectContentType.BatesN)) {
            throw new PDFInvalidDocumentException("Incorrect content type for Bates Numbering. BatesN is required.");
        }
        ASString[] batesNumberAs = null;
        if (batesNumber == null || batesNumber.length == 0) {
            throw new PDFInvalidDocumentException("Bates number array is either null or empty.");
        }
        batesNumberAs = new ASString[batesNumber.length];
        for (int i = 0; i < batesNumber.length; ++i) {
            if (batesNumber[i] == null || batesNumber[i].length() == 0) {
                throw new PDFInvalidDocumentException("Cannot add null or empty bates number.");
            }
            batesNumberAs[i] = new ASString(PDFText.createString((PDFDocument)pdfPage.getPDFDocument(), (String)batesNumber[i]).byteArrayValue());
        }
        this.applyXObjectForm(pdfPage, pdfXObjectForm, useOptions, batesNumberAs, false, null, 0, null);
    }

    private void applyXObjectForm(PDFPage pdfPage, PDFXObjectForm pdfXObjectForm, XObjectUseOptions useOptions, ASString[] batesNumber, boolean isAccessible, PDFStructureElement structElem, int MCID, PDFExtGState pdfExtGState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix pageRotationMatrix;
        PDFDocument pdfDocument = pdfPage.getPDFDocument();
        PDFRectangle xobjBbox = pdfXObjectForm.getBBox();
        double[] xobjMatrix = pdfXObjectForm.getMatrix();
        if (xobjMatrix != null) {
            ASMatrix asMatrix = new ASMatrix(xobjMatrix);
            ASRectangle asRectangle = xobjBbox.getRectangle().transform(asMatrix);
            xobjBbox = PDFRectangle.newInstance((PDFDocument)pdfDocument, (ASRectangle)asRectangle);
        }
        PDFRotation pageRotation = pdfPage.getRotation();
        PDFRectangle pageCropBox = pdfPage.getCropBox();
        double pageHeight = pageCropBox.height();
        double pageWidth = pageCropBox.width();
        if (pageRotation == PDFRotation.ROTATE_90 || pageRotation == PDFRotation.ROTATE_270) {
            double temp = pageHeight;
            pageHeight = pageWidth;
            pageWidth = temp;
        }
        double vScale = this.getVScale();
        double hScale = this.getHScale();
        ASMatrix alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, pageCropBox.left(), pageCropBox.bottom());
        ASMatrix transMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -(hScale * xobjBbox.left()), -(vScale * xobjBbox.bottom()));
        ASMatrix rotationMatrix = new ASMatrix(ASMatrix.createIdentityMatrix().rotate(Math.toRadians(this.getRotation())));
        ASMatrix scaleMatrix = new ASMatrix(hScale, 0.0, 0.0, vScale, 0.0, 0.0);
        ASCoordinate oldCenter = new ASCoordinate((xobjBbox.left() + xobjBbox.right()) * hScale / 2.0, (xobjBbox.bottom() + xobjBbox.top()) * vScale / 2.0);
        ASCoordinate newCenter = oldCenter.transform(rotationMatrix);
        transMatrix = transMatrix.translate(oldCenter.x() - newCenter.x(), oldCenter.y() - newCenter.y());
        transMatrix = transMatrix.translate(this.llx(), this.lly());
        if (pageRotation == PDFRotation.ROTATE_90) {
            pageRotationMatrix = new ASMatrix(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(pageHeight, 0.0);
        } else if (pageRotation == PDFRotation.ROTATE_180) {
            pageRotationMatrix = new ASMatrix(-1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(pageWidth, pageHeight);
        } else if (pageRotation == PDFRotation.ROTATE_270) {
            pageRotationMatrix = new ASMatrix(0.0, -1.0, 1.0, 0.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(0.0, pageWidth);
        } else {
            pageRotationMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        }
        ASMatrix finalMatrix = ASMatrix.createIdentityMatrix();
        finalMatrix = alignmentMatrix.concat(finalMatrix);
        finalMatrix = pageRotationMatrix.concat(finalMatrix);
        finalMatrix = transMatrix.concat(finalMatrix);
        finalMatrix = rotationMatrix.concat(finalMatrix);
        finalMatrix = scaleMatrix.concat(finalMatrix);
        ModifiableContent content = ModifiableContent.newInstance((PDFPage)pdfPage);
        if (pdfExtGState == null) {
            pdfExtGState = PDFExtGState.newInstance((PDFDocument)pdfDocument);
            double opacity = this.getOpacity();
            pdfExtGState.setOpacityFill(opacity);
            pdfExtGState.setOpacityStroke(opacity);
        }
        ContentWriter writer = ContentWriter.newInstance((ModifiableContent)content);
        MarkedContentOperands structure = null;
        structure = isAccessible ? this.createStructureAccessible(structElem, MCID) : (batesNumber == null ? this.createStructureArtifact(pdfDocument, useOptions) : this.createStructureArtifactBatesNumber(batesNumber));
        if (useOptions.isForeground()) {
            writer.prepend(InstructionFactory.newGSave());
            writer.write(InstructionFactory.newGRestore());
            ContentModifier.addXObject((ContentWriter)writer, (PDFExtGState)pdfExtGState, (ASMatrix)finalMatrix, (PDFXObject)pdfXObjectForm, (MarkedContentOperands)structure);
        } else {
            ContentModifier.prependXObject((ContentWriter)writer, (PDFExtGState)pdfExtGState, (ASMatrix)finalMatrix, (PDFXObject)pdfXObjectForm, (MarkedContentOperands)structure);
        }
        Content newContent = writer.close();
        pdfPage.setResources(newContent.getResources());
        pdfPage.setContents(newContent.getContents());
    }

    public void applyXObjectImage(PDFPage pdfPage, PDFXObjectImage pdfXObjectImage, PDFExtGState gState, ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix pageRotationMatrix;
        PDFDocument pdfDocument = pdfPage.getPDFDocument();
        PDFRotation pageRotation = pdfPage.getRotation();
        PDFRectangle pageCropBox = pdfPage.getCropBox();
        double pageHeight = pageCropBox.height();
        double pageWidth = pageCropBox.width();
        if (pageRotation == PDFRotation.ROTATE_90 || pageRotation == PDFRotation.ROTATE_270) {
            double temp = pageHeight;
            pageHeight = pageWidth;
            pageWidth = temp;
        }
        if (matrix == null) {
            matrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        }
        ASMatrix alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, pageCropBox.left(), pageCropBox.bottom());
        ASMatrix rotationMatrix = new ASMatrix(ASMatrix.createIdentityMatrix().rotate(Math.toRadians(this.getRotation())));
        ASMatrix scaleMatrix = new ASMatrix(this.hScale, 0.0, 0.0, this.vScale, 0.0, 0.0);
        if (pageRotation == PDFRotation.ROTATE_90) {
            pageRotationMatrix = new ASMatrix(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(pageHeight, 0.0);
        } else if (pageRotation == PDFRotation.ROTATE_180) {
            pageRotationMatrix = new ASMatrix(-1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(pageWidth, pageHeight);
        } else if (pageRotation == PDFRotation.ROTATE_270) {
            pageRotationMatrix = new ASMatrix(0.0, -1.0, 1.0, 0.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(0.0, pageWidth);
        } else {
            pageRotationMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        }
        ASMatrix finalMatrix = ASMatrix.createIdentityMatrix();
        finalMatrix = alignmentMatrix.concat(finalMatrix);
        finalMatrix = pageRotationMatrix.concat(finalMatrix);
        finalMatrix = rotationMatrix.concat(finalMatrix);
        finalMatrix = scaleMatrix.concat(finalMatrix);
        finalMatrix = matrix.concat(finalMatrix);
        ModifiableContent content = ModifiableContent.newInstance((PDFPage)pdfPage);
        if (gState == null) {
            gState = PDFExtGState.newInstance((PDFDocument)pdfDocument);
            double opacity = this.getOpacity();
            gState.setOpacityFill(opacity);
            gState.setOpacityStroke(opacity);
        }
        ContentWriter writer = ContentWriter.newInstance((ModifiableContent)content);
        writer.prepend(InstructionFactory.newGSave());
        writer.write(InstructionFactory.newGRestore());
        ContentModifier.addXObject((ContentWriter)writer, (PDFExtGState)gState, (ASMatrix)finalMatrix, (PDFXObject)pdfXObjectImage);
        Content newContent = writer.close();
        pdfPage.setResources(newContent.getResources());
        pdfPage.setContents(newContent.getContents());
    }

    public void applyXObjectForm(PDFXObjectForm destXObject, PDFXObject appliedXObject, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix destXObjInverseMatrix;
        double xboxTop;
        double xboxBottom;
        double xboxRight;
        double xboxLeft;
        PDFDocument pdfDocument = destXObject.getPDFDocument();
        if (appliedXObject instanceof PDFXObjectForm) {
            PDFRectangle xobjBbox = ((PDFXObjectForm)appliedXObject).getBBox();
            xboxLeft = xobjBbox.left();
            xboxRight = xobjBbox.right();
            xboxBottom = xobjBbox.bottom();
            xboxTop = xobjBbox.top();
        } else if (appliedXObject instanceof PDFXObjectImage) {
            xboxLeft = 0.0;
            xboxRight = ((PDFXObjectImage)appliedXObject).getWidth();
            xboxBottom = 0.0;
            xboxTop = ((PDFXObjectImage)appliedXObject).getHeight();
        } else {
            throw new PDFInvalidDocumentException("Unexpected XObject Type " + appliedXObject);
        }
        double[] matrix = destXObject.getMatrix();
        ASMatrix destXObjMatrix = matrix == null ? ASMatrix.createIdentityMatrix() : new ASMatrix(matrix);
        PDFRectangle destXObjBBox = destXObject.getBBox();
        double vScale = this.getVScale();
        double hScale = this.getHScale();
        ASMatrix alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, destXObjBBox.left(), destXObjBBox.bottom());
        ASMatrix transMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -(hScale * xboxLeft), -(vScale * xboxBottom));
        ASMatrix rotationMatrix = new ASMatrix(ASMatrix.createIdentityMatrix().rotate(Math.toRadians(this.getRotation())));
        ASMatrix scaleMatrix = new ASMatrix(hScale, 0.0, 0.0, vScale, 0.0, 0.0);
        ASCoordinate oldCenter = new ASCoordinate((xboxLeft + xboxRight) * hScale / 2.0, (xboxBottom + xboxTop) * vScale / 2.0);
        ASCoordinate newCenter = oldCenter.transform(rotationMatrix);
        transMatrix = transMatrix.translate(oldCenter.x() - newCenter.x(), oldCenter.y() - newCenter.y());
        transMatrix = transMatrix.translate(this.llx(), this.lly());
        try {
            destXObjInverseMatrix = destXObjMatrix.getInverse();
        }
        catch (PDFInvalidParameterException e) {
            destXObjInverseMatrix = ASMatrix.createIdentityMatrix();
        }
        ASMatrix finalMatrix = ASMatrix.createIdentityMatrix();
        finalMatrix = alignmentMatrix.concat(finalMatrix);
        finalMatrix = destXObjInverseMatrix.concat(finalMatrix);
        finalMatrix = transMatrix.concat(finalMatrix);
        finalMatrix = rotationMatrix.concat(finalMatrix);
        finalMatrix = scaleMatrix.concat(finalMatrix);
        ModifiableContent content = ModifiableContent.newInstance((PDFXObjectForm)destXObject);
        PDFExtGState pdfExtGState = PDFExtGState.newInstance((PDFDocument)pdfDocument);
        double opacity = this.getOpacity();
        pdfExtGState.setOpacityFill(opacity);
        pdfExtGState.setOpacityStroke(opacity);
        ContentWriter writer = ContentWriter.newInstance((ModifiableContent)content);
        MarkedContentOperands structure = this.createStructureArtifact(pdfDocument, useOptions);
        if (useOptions.isForeground()) {
            writer.prepend(InstructionFactory.newGSave());
            writer.write(InstructionFactory.newGRestore());
            ContentModifier.addXObject((ContentWriter)writer, (PDFExtGState)pdfExtGState, (ASMatrix)finalMatrix, (PDFXObject)appliedXObject, (MarkedContentOperands)structure);
        } else {
            ContentModifier.prependXObject((ContentWriter)writer, (PDFExtGState)pdfExtGState, (ASMatrix)finalMatrix, (PDFXObject)appliedXObject, (MarkedContentOperands)structure);
        }
        Content newContent = writer.close();
        destXObject.setResources(newContent.getResources());
        destXObject.setStream(newContent.getContents().getContents());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyAccessibleXObjectForm(PDFPage page, PDFXObjectForm xObjectForm, String alt, String lang, XObjectUseOptions useOptions, ASName tag, PDFStructureRole role) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (page == null) {
            throw new PDFInvalidParameterException("Page is required.");
        }
        if (xObjectForm == null) {
            throw new PDFInvalidParameterException("xObjectForm is required.");
        }
        if (tag == null) {
            throw new PDFInvalidParameterException("Custom tag is required.");
        }
        if (useOptions == null) {
            throw new PDFInvalidParameterException("UseOptions is required.");
        }
        if (alt == null) {
            throw new PDFInvalidParameterException("Alternate text is required.");
        }
        PDFDocument pdfDoc = page.getPDFDocument();
        PDFStructureRoot structRoot = pdfDoc.requireCatalog().getStructureRoot();
        if (structRoot == null) {
            throw new PDFInvalidDocumentException("The document doesn't have structure.");
        }
        boolean mapRole = false;
        PDFStructureRoleMap roleMap = structRoot.getRoleMap();
        if (roleMap == null) {
            roleMap = PDFStructureRoleMap.newInstance((PDFDocument)pdfDoc);
        }
        if (role == null && roleMap.getRole(tag) == null) {
            role = PDFStructureRole.Note;
        } else if (role != null || roleMap.getRole(tag) == null) {
            if (roleMap.getRole(tag) == null) {
                mapRole = true;
            } else if (!role.getName().equals((Object)roleMap.getRole(tag))) {
                throw new PDFInvalidParameterException("Tag " + tag + " is already mapped to a standard structure type.");
            }
        }
        PDFStructureElement parentNode = null;
        PDFStructureContentArray pageElemArray = null;
        int indexFirstElementInK = 0;
        int indexLastElementInK = 0;
        if (PDFStructureUtils.hasStructParent((PDFCosDictionary)page)) {
            parentNode = PDFStructureUtils.getStructParentElement((PDFCosDictionary)page);
        } else {
            if (!PDFStructureUtils.hasStructParents((PDFCosDictionary)page)) throw new PDFInvalidDocumentException("Page doesn't contain structure.");
            pageElemArray = PDFStructureUtils.getStructParentArray((PDFCosDictionary)page);
            if (pageElemArray == null || pageElemArray.isEmpty()) throw new PDFInvalidDocumentException("StructParents array is either null or empty.");
            if (!useOptions.isForeground()) {
                PDFStructureContentInterface firstElement = this.getFirstOrLastNotNullElement(page, pageElemArray, false);
                if (!(firstElement instanceof PDFStructureElement)) {
                    throw new PDFInvalidDocumentException("The first item in the structure array is not type of StructureElement.");
                }
                parentNode = ((PDFStructureElement)firstElement).getParent();
                indexFirstElementInK = parentNode.getContentIndex(firstElement, false);
                if (indexFirstElementInK == -1) {
                    throw new PDFInvalidDocumentException("Cannot find the structure element in the Kids array /K.");
                }
            } else {
                PDFStructureContentInterface lastElement = this.getFirstOrLastNotNullElement(page, pageElemArray, true);
                if (!(lastElement instanceof PDFStructureElement)) {
                    throw new PDFInvalidDocumentException("The last item in the structure array is not type of StructureElement.");
                }
                parentNode = ((PDFStructureElement)lastElement).getParent();
                indexLastElementInK = parentNode.getContentIndex(lastElement, true);
                if (indexLastElementInK == -1) {
                    throw new PDFInvalidDocumentException("Cannot find the structure element in the Kids array /K.");
                }
            }
        }
        PDFStructureElement structElem = PDFStructureElement.newInstance((PDFDocument)pdfDoc, (ASName)tag, (PDFStructureNode)parentNode);
        structElem.setAlt(alt);
        if (lang != null) {
            structElem.setLang(lang);
        }
        int MCID = 0;
        if (PDFStructureUtils.hasStructParent((PDFCosDictionary)page)) {
            parentNode.addContent((PDFStructureContentInterface)structElem);
        } else if (PDFStructureUtils.hasStructParents((PDFCosDictionary)page)) {
            if (!useOptions.isForeground()) {
                MCID = 0;
                XObjectApplyOptions.updateMCID(page, 1);
                XObjectApplyOptions.updateK(PDFStructureUtils.getStructParentArray((PDFCosDictionary)page), 1);
                parentNode.addContent(indexFirstElementInK, (PDFStructureContentInterface)structElem);
                PDFStructureUtils.getStructParentArray((PDFCosDictionary)page).add(0, (PDFCosObjectContainer)structElem);
            } else {
                parentNode.addContent(indexLastElementInK + 1, (PDFStructureContentInterface)structElem);
                HashSet seenObjects = new HashSet();
                MCID = StructureUtil.getMaximumMCID((PDFPage)page, seenObjects) + 1;
                if (MCID < PDFStructureUtils.getStructParentArray((PDFCosDictionary)page).size()) {
                    MCID = PDFStructureUtils.getStructParentArray((PDFCosDictionary)page).size();
                }
                PDFStructureUtils.getStructParentArray((PDFCosDictionary)page).add((PDFCosObjectContainer)structElem);
            }
            structElem.setDictionaryIntValue(ASName.k_K, (long)MCID);
        }
        PDFStructureIDTree idTree = structRoot.getIdTree();
        StringBuilder id = new StringBuilder();
        id.append(tag);
        id.append(".").append(page.getPageNumber());
        if (PDFStructureUtils.hasStructParents((PDFCosDictionary)page)) {
            id.append(".").append(MCID);
        }
        boolean newIDTree = false;
        ASString idAsASString = new ASString(PDFText.createString((PDFDocument)pdfDoc, (String)id.toString()).byteArrayValue());
        ASString suffix = null;
        if (idTree == null) {
            idTree = PDFStructureIDTree.newInstance((PDFDocument)pdfDoc);
            newIDTree = true;
        }
        idAsASString = StructureUtil.checkID((ASString)idAsASString, suffix, (PDFStructureIDTree)idTree);
        idTree.addEntry((Object)idAsASString, (Object)structElem);
        if (newIDTree) {
            structRoot.setIDTree(idTree);
        }
        structElem.setPage(page);
        if (mapRole) {
            roleMap.addRole(tag, role.getName());
            structRoot.setRoleMap(roleMap);
        }
        this.applyXObjectForm(page, xObjectForm, useOptions, null, true, structElem, MCID, null);
    }

    static void updateMCID(PDFPage page, int addMCID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        StructureListener maxMCIDCache = StructureListener.getInstance((PDFDocument)page.getPDFDocument());
        maxMCIDCache.removeCacheMaxMCID(page.getCosObject().getObjNum());
        Content oldContent = Content.newInstance((PDFPage)page);
        ModifiableContent newContent = ModifiableContent.newInstance((PDFDocument)oldContent.getPDFDocument());
        StructureUtil.updateMCID((Content)oldContent, (ModifiableContent)newContent, (int)addMCID);
        page.setContents(newContent.getContents());
    }

    static void updateK(PDFStructureContentArray structArray, int indexOffset) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureContentIterator iterator = structArray.contentIterator();
        HashSet<PDFStructureContentInterface> seenObjects = new HashSet<PDFStructureContentInterface>();
        while (iterator.hasNext()) {
            PDFStructureContentInterface structElem = iterator.next();
            if (seenObjects.contains(structElem)) continue;
            seenObjects.add(structElem);
            if (structElem == null || structElem.getStructureType() != PDFStructureType.Element) continue;
            CosObject kValue = ((PDFStructureElement)structElem).getDictionaryValue(ASName.k_K);
            if (kValue instanceof CosNumeric) {
                ((PDFStructureNode)structElem).setDictionaryIntValue(ASName.k_K, (long)(((PDFStructureNode)structElem).getDictionaryIntValue(ASName.k_K) + indexOffset));
                continue;
            }
            if (!(kValue instanceof CosArray)) continue;
            PDFStructureContentArray childArray = PDFStructureContentArray.getInstance((CosObject)kValue);
            CosArray childCosArray = childArray.getCosArray();
            for (int i = 0; i < childCosArray.size(); ++i) {
                CosObject childValue = ((PDFStructureContentInterface)childArray.get(i)).getCosObject();
                if (seenObjects.contains(childArray.get(i))) continue;
                seenObjects.add(structElem);
                if (childValue instanceof CosNumeric) {
                    childCosArray.setInt(i, ((CosNumeric)childValue).intValue() + indexOffset);
                    continue;
                }
                if (!(childValue instanceof CosDictionary)) continue;
                PDFStructureContentInterface childContentDict = (PDFStructureContentInterface)childArray.get(i);
                XObjectApplyOptions.updateK(childContentDict, indexOffset, seenObjects);
            }
        }
    }

    static void updateK(PDFStructureContentInterface structElem, int indexOffset, HashSet seenObjects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (structElem.getStructureType() == PDFStructureType.Element) {
            CosObject kValue = ((PDFStructureElement)structElem).getDictionaryValue(ASName.k_K);
            if (seenObjects.contains(structElem)) {
                return;
            }
            seenObjects.add(structElem);
            if (kValue instanceof CosNumeric) {
                ((PDFStructureNode)structElem).setDictionaryIntValue(ASName.k_K, (long)(((PDFStructureNode)structElem).getDictionaryIntValue(ASName.k_K) + indexOffset));
            } else if (kValue instanceof CosArray) {
                PDFStructureContentArray childArray = PDFStructureContentArray.getInstance((CosObject)kValue);
                CosArray childCosArray = childArray.getCosArray();
                for (int i = 0; i < childCosArray.size(); ++i) {
                    CosObject childValue = ((PDFStructureContentInterface)childArray.get(i)).getCosObject();
                    if (childValue instanceof CosNumeric) {
                        childCosArray.setInt(i, ((CosNumeric)childValue).intValue() + indexOffset);
                        continue;
                    }
                    if (!(childValue instanceof CosDictionary)) continue;
                    PDFStructureContentInterface childContentDict = (PDFStructureContentInterface)childArray.get(i);
                    XObjectApplyOptions.updateK(childContentDict, indexOffset, seenObjects);
                }
            }
        }
    }

    private PDFStructureContentInterface getFirstOrLastNotNullElement(PDFPage page, PDFStructureContentArray pageElemArray, boolean isLast) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureRoot root = page.getPDFDocument().requireCatalog().getStructureRoot();
        if (pageElemArray.size() == 0) {
            throw new PDFInvalidDocumentException("Document doesn't contain a structure parent tree /ParentTree.");
        }
        ArrayList matchedElems = new ArrayList();
        PDFStructureElement elemFound = null;
        if (isLast) {
            elemFound = root.getLastElement(page, pageElemArray, matchedElems);
            if (elemFound == null && !matchedElems.isEmpty()) {
                elemFound = (PDFStructureElement)matchedElems.get(matchedElems.size() - 1);
            }
        } else {
            elemFound = root.getFirstElement(pageElemArray, matchedElems);
            if (elemFound == null && !matchedElems.isEmpty()) {
                elemFound = (PDFStructureElement)matchedElems.get(0);
            }
        }
        return elemFound;
    }

    private MarkedContentOperands createStructureArtifact(PDFDocument pdfDoc, XObjectUseOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDoc.requireCatalog().getStructureRoot() == null) {
            return null;
        }
        MarkedContentOperands artifactStruct = null;
        XObjectContentType contentType = options.getContentType();
        if (contentType.equals(XObjectContentType.Background)) {
            artifactStruct = null;
            PDFStructureArtifact backgroundArtifact = PDFStructureArtifact.newBackgroundArtifact((PDFDocument)pdfDoc, null, null);
            if (backgroundArtifact != null) {
                artifactStruct = new MarkedContentOperands(backgroundArtifact);
            }
            if (artifactStruct == null) {
                artifactStruct = new MarkedContentOperands(PDFStructureArtifact.newPaginationArtifact((PDFDocument)pdfDoc, null, null, null));
            }
        } else {
            ASName subtype = null;
            if (!contentType.equals(XObjectContentType.General)) {
                subtype = ASName.create((String)contentType.toString());
            }
            artifactStruct = new MarkedContentOperands(PDFStructureArtifact.newPaginationArtifact((PDFDocument)pdfDoc, (ASName)subtype, null, null));
        }
        return artifactStruct;
    }

    private MarkedContentOperands createStructureArtifactBatesNumber(ASString[] batesNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new MarkedContentOperands(PDFStructureArtifact.newPaginationArtifactBatesNumber(null, null, (ASString[])batesNumber));
    }

    private MarkedContentOperands createStructureAccessible(PDFStructureElement strucElem, int MCID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new MarkedContentOperands(strucElem, MCID);
    }
}

