/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xbm;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkUtils;
import com.adobe.internal.pdftoolkit.services.xbm.BookmarksHandler;
import com.adobe.internal.pdftoolkit.services.xbm.PDF2XMLBookmarksReader;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFSAXHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XBMService {
    static final String bookmarkNamespace = "http://ns.adobe.com/pdf/bookmarks";
    static final String bookmarkSchemaVersion = "1.0";
    static final String bookmarkIndentAmount = "2";

    private XBMService() {
    }

    public static void exportAllBookmarksToXML(PDFDocument doc, OutputStream ostream) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException {
        if (doc == null || ostream == null) {
            throw new PDFInvalidParameterException("invalid input to com.adobe.internal.pdftoolkit.services.xbm.exportAllBookmarksToXML");
        }
        PDFCatalog c = doc.requireCatalog();
        PDFBookmarkRoot r = c.getBookmarkRoot();
        XBMService.serialize(new PDF2XMLBookmarksReader(r == null ? null : r.getFirstKid()), ostream);
    }

    public static void exportBookmarksToXML(PDFDocument doc, List titles, OutputStream ostream) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException {
        if (doc == null || ostream == null || titles == null || titles.isEmpty()) {
            throw new PDFInvalidParameterException("invalid input to com.adobe.internal.pdftoolkit.services.xbm.exportBookmarksToXML");
        }
        PDFBookmark firstBookmark = doc.requireCatalog().getBookmarkRoot().getFirstKid();
        XBMService.serialize(new PDF2XMLBookmarksReader(firstBookmark, titles), ostream);
    }

    public static void importXMLBookmarks(PDFDocument targetDoc, InputStream inputXML) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        if (targetDoc == null || inputXML == null) {
            throw new PDFInvalidParameterException("invalid input to com.adobe.internal.pdftoolkit.services.xbm.importXMLBookmarks");
        }
        PDFBookmarkRoot newBookmarks = XBMService.parseXMLBookmarks(targetDoc, inputXML, null);
        XBMService.setCountEntryInBookmark((PDFBookmarkNode)newBookmarks);
        PDFCatalog catalog = targetDoc.requireCatalog();
        PDFBookmarkRoot bookmarkRoot = catalog.getBookmarkRoot();
        if (bookmarkRoot != null) {
            if (bookmarkRoot.hasCount()) {
                bookmarkRoot.setCount(bookmarkRoot.getCount() + Math.abs(newBookmarks.getCount()));
            }
            PDFBookmarkUtils.insertAfterKid((PDFBookmark)bookmarkRoot.getLastKid(), (PDFBookmark)newBookmarks.getFirstKid(), (PDFBookmarkNode)bookmarkRoot);
        } else {
            catalog.setBookmarkRoot(newBookmarks);
        }
    }

    public static void insertFirstXMLBookmarks(PDFDocument targetDoc, InputStream inputXML) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFConfigurationException {
        if (targetDoc == null || inputXML == null) {
            throw new PDFInvalidParameterException("invalid input to com.adobe.internal.pdftoolkit.services.xbm.insertFirstXMLBookmarks");
        }
        PDFBookmarkRoot newBookmarks = XBMService.parseXMLBookmarks(targetDoc, inputXML, null);
        PDFCatalog catalog = targetDoc.requireCatalog();
        PDFBookmarkRoot bookmarkRoot = catalog.getBookmarkRoot();
        if (bookmarkRoot != null) {
            PDFBookmarkUtils.insertAfterKid(null, (PDFBookmark)newBookmarks.getFirstKid(), (PDFBookmarkNode)bookmarkRoot);
        } else {
            catalog.setBookmarkRoot(newBookmarks);
        }
    }

    public static void replaceAllXMLBookmarks(PDFDocument targetDoc, InputStream inputXML) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException {
        if (targetDoc == null || inputXML == null) {
            throw new PDFInvalidParameterException("invalid input to com.adobe.internal.pdftoolkit.services.xbm.replaceAllXMLBookmarks");
        }
        PDFBookmarkRoot newBookmarks = XBMService.parseXMLBookmarks(targetDoc, inputXML, null);
        PDFCatalog catalog = targetDoc.requireCatalog();
        catalog.setBookmarkRoot(newBookmarks);
    }

    public static void replaceXMLBookmark(PDFDocument targetDoc, InputStream inputXML, String title) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        if (targetDoc == null || inputXML == null || title == null || title.length() == 0) {
            throw new PDFInvalidParameterException("invalid input to com.adobe.internal.pdftoolkit.services.xbm.replaceXMLBookmark");
        }
        PDFBookmarkRoot newBookmarks = XBMService.parseXMLBookmarks(targetDoc, inputXML, null);
        PDFCatalog catalog = targetDoc.requireCatalog();
        PDFBookmarkRoot bookmarkRoot = catalog.getBookmarkRoot();
        PDFBookmark toReplace = bookmarkRoot.findDepthFirst(title);
        if (toReplace == null) {
            return;
        }
        PDFBookmarkUtils.replaceKid((PDFBookmark)toReplace, (PDFBookmark)newBookmarks.getFirstKid(), (PDFBookmarkNode)toReplace.getParent());
    }

    public static void insertXMLBookmarks(PDFDocument targetDoc, InputStream inputXML, String title) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        if (targetDoc == null || inputXML == null || title == null || title.length() == 0) {
            throw new PDFInvalidParameterException("invalid input to com.adobe.internal.pdftoolkit.services.xbm.insertXMLBookmarks");
        }
        PDFBookmarkRoot newBookmarks = XBMService.parseXMLBookmarks(targetDoc, inputXML, null);
        PDFCatalog catalog = targetDoc.requireCatalog();
        PDFBookmarkRoot bookmarkRoot = catalog.getBookmarkRoot();
        PDFBookmark insertAfter = bookmarkRoot.findDepthFirst(title);
        if (insertAfter == null) {
            return;
        }
        PDFBookmarkUtils.insertAfterKid((PDFBookmark)insertAfter, (PDFBookmark)newBookmarks.getFirstKid(), (PDFBookmarkNode)insertAfter.getParent());
    }

    public static void insertChildXMLBookmarks(PDFDocument targetDoc, InputStream inputXML, String title) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        if (targetDoc == null || inputXML == null || title == null || title.length() == 0) {
            throw new PDFInvalidParameterException("invalid input to com.adobe.internal.pdftoolkit.services.xbm.insertChildXMLBookmarks");
        }
        PDFBookmarkRoot newBookmarks = XBMService.parseXMLBookmarks(targetDoc, inputXML, null);
        PDFCatalog catalog = targetDoc.requireCatalog();
        PDFBookmarkRoot bookmarkRoot = catalog.getBookmarkRoot();
        PDFBookmark childrenOf = bookmarkRoot.findDepthFirst(title);
        if (childrenOf == null) {
            return;
        }
        PDFBookmarkUtils.insertAfterKid((PDFBookmark)childrenOf.getLastKid(), (PDFBookmark)newBookmarks.getFirstKid(), (PDFBookmarkNode)childrenOf);
    }

    static PDFBookmarkRoot parseXMLBookmarks(PDFDocument targetDoc, InputStream inputXML, ErrorHandler eh) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFConfigurationException {
        if (targetDoc == null) {
            throw new PDFInvalidParameterException("No target document supplied.");
        }
        if (inputXML == null) {
            throw new PDFInvalidParameterException("No input XML supplied.");
        }
        BookmarksHandler h = new BookmarksHandler(targetDoc);
        try {
            SAXParser parser = XMLUtils.getNonValidatingNameSpaceAwareSaxParser();
            parser.parse(inputXML, (DefaultHandler)new XPDFSAXHandler(h, eh));
        }
        catch (FactoryConfigurationError e) {
            throw new PDFConfigurationException("Factory configuration error", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("Parser configuration error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException("SAX Exception", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("IO Exception", (Throwable)e);
        }
        return h.getBookmarkRoot();
    }

    static void serialize(XMLReader pdfParser, OutputStream outputStream) throws PDFInvalidXMLException, PDFConfigurationException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", Integer.valueOf(bookmarkIndentAmount));
            }
            catch (IllegalArgumentException exception) {
                // empty catch block
            }
            Transformer t = tf.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("standalone", "yes");
            t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", bookmarkIndentAmount);
            try {
                pdfParser.setFeature("http://xml.org/sax/features/namespaces", true);
                pdfParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            t.transform(new SAXSource(pdfParser, new InputSource()), new StreamResult(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"))));
        }
        catch (TransformerConfigurationException e) {
            throw new PDFConfigurationException("Transformer configuration error", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new PDFConfigurationException("TransformerFactory configuration error", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException("Transformer error", (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new PDFConfigurationException("Factory configuration error", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not create the OutputStreamWriter with UTF-8 encoding", e);
        }
    }

    private static void setCountEntryInBookmark(PDFBookmarkNode bookmarkNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (bookmarkNode == null) {
            return;
        }
        if (bookmarkNode.hasCount() && (!(bookmarkNode instanceof PDFBookmarkRoot) || bookmarkNode.getCount() != 0)) {
            return;
        }
        int num = 0;
        for (PDFBookmark kid = bookmarkNode.getFirstKid(); kid != null; kid = kid.getNext()) {
            ++num;
            XBMService.setCountEntryInBookmark((PDFBookmarkNode)kid);
        }
        if (num != 0) {
            if (bookmarkNode instanceof PDFBookmarkRoot) {
                bookmarkNode.setCount(num);
            } else {
                bookmarkNode.setCount(-1 * num);
            }
        }
    }
}

