/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.portfolio;

import com.adobe.agl.util.ULocale;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNavigator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNavigatorStringsTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionResourcesTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSWFLoadType;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSplit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionView;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import com.adobe.internal.pdftoolkit.services.portfolio.Portfolio;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.ucf.UCFContainer;
import com.adobe.internal.ucf.UCFException;
import com.adobe.internal.ucf.UCFFile;
import com.adobe.internal.ucf.UCFFileIterator;
import com.adobe.internal.ucf.UCFInvalidStateException;
import com.adobe.internal.ucf.UCFOpenOptions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.XMLFilterImpl;

public class PortfolioReader
extends Portfolio {
    private PortfolioReader() {
    }

    public static PDFPortableCollection embedNavigator(ByteReader byteReader, PDFPortableCollection collectionDict, ULocale locale) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (collectionDict == null) {
            throw new PDFInvalidParameterException("collectionDict can not be null");
        }
        UCFContainer container = null;
        try {
            TreeMap<String, String> localeFiles;
            PDFDocument pdfDocument = collectionDict.getPDFDocument();
            container = new UCFContainer(new UCFOpenOptions(), byteReader);
            PortfolioReader.validateMimeFile(container);
            UCFFile navXMLFile = container.getFile("navigator.xml");
            NavXML2InternalParameters navXMLParameterizer = new NavXML2InternalParameters();
            PortfolioReader.readNavXMLParameters(navXMLFile, navXMLParameterizer);
            if (!navXMLParameterizer.succeeded()) {
                throw new PDFInvalidParameterException(" The navigator XML is not valid");
            }
            StringsASF2InternalParameters stringsASFParameterizer = null;
            String localesXMLFileName = navXMLParameterizer.getLocalesXMLLocation();
            if (localesXMLFileName != null) {
                LocalesXML2InternalParameters localesXMLParameterizer = new LocalesXML2InternalParameters();
                UCFFile localesXMLFile = container.getFile(localesXMLFileName);
                PortfolioReader.readLocalesXMLFile(localesXMLFile, localesXMLParameterizer);
                localeFiles = localesXMLParameterizer.getLocalesMap();
            } else {
                localeFiles = navXMLParameterizer.getLocalesMap();
            }
            stringsASFParameterizer = new StringsASF2InternalParameters();
            String resolvedLocale = PortfolioReader.resolveLocale(pdfDocument, localeFiles, locale);
            String stringsFileName = null;
            if (localeFiles != null && resolvedLocale != null) {
                stringsFileName = localeFiles.get(resolvedLocale);
                UCFFile stringsASFXFile = container.getFile(stringsFileName);
                PortfolioReader.readStringsASFFile(stringsASFXFile, stringsASFParameterizer);
            }
            PDFCollectionNavigator navigator = PortfolioReader.buildNavigatorDictionary(pdfDocument, navXMLParameterizer, stringsASFParameterizer, container, resolvedLocale);
            collectionDict.setNavigator(navigator);
            collectionDict.setView(PDFCollectionView.custom);
            PDFCollectionSchema initFields = navigator.getInitialFields();
            if (initFields != null) {
                CosCloneMgr mgr = new CosCloneMgr(pdfDocument.getCosDocument());
                collectionDict.setSchema(PDFCollectionSchema.getInstance((CosObject)mgr.clone(initFields.getCosObject())));
            }
            PDFCollectionSplit collectionSplit = PortfolioReader.buildCollectionSplit(pdfDocument, navXMLParameterizer);
            collectionDict.setSplit(collectionSplit);
            byteReader.close();
        }
        catch (UCFException e) {
            throw new PDFInvalidParameterException("Invalid navigator file:", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFInvalidParameterException("I/O error while reading a navigator file:", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFInvalidParameterException("SAX error while reading a navigator file:", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidParameterException("Error while parsing a navigator file:", (Throwable)e);
        }
        return collectionDict;
    }

    private static boolean validateMimeFile(UCFContainer container) throws UCFInvalidStateException, IOException, PDFInvalidParameterException {
        UCFFile mimeUCFFile = container.getFile("mimetype");
        ByteArrayOutputStream mimeBuffer = new ByteArrayOutputStream();
        if (mimeUCFFile != null) {
            mimeUCFFile.copyData((OutputStream)mimeBuffer);
            String mimeFileContent = mimeBuffer.toString();
            if ("application/vnd.adobe.pdf-navigator".compareTo(mimeFileContent.trim()) != 0) {
                throw new PDFInvalidParameterException("Invalid MIME type in navigator file: " + mimeFileContent);
            }
            return true;
        }
        return true;
    }

    private static void readNavXMLParameters(UCFFile xmlFile, XMLFilter xmlParametrizer) throws UCFInvalidStateException, IOException, SAXException, TransformerException {
        ByteArrayOutputStream navBuffer = new ByteArrayOutputStream();
        xmlFile.copyData((OutputStream)navBuffer);
        InputSource xmlBase = new InputSource(new ByteArrayInputStream(navBuffer.toByteArray()));
        Source source = XMLUtils.createSource(xmlBase, xmlParametrizer, true, true);
        XMLUtils.transformToXML(source, XMLUtils.createNullResult(), false);
    }

    private static void readSWFFile(UCFContainer container, String swfLocation, PDFCollectionResourcesTree navResources) throws UCFInvalidStateException, IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, SAXException {
        UCFFile swfFile = container.getFile(swfLocation);
        PortfolioReader.copyUCFFileToPDFStream(navResources, swfFile, new ASString(swfLocation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyUCFFileToPDFStream(PDFCollectionResourcesTree navResources, UCFFile ucfFile, ASString path) throws IOException, UCFInvalidStateException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException, PDFInvalidParameterException {
        long streamSizeEstimate = Math.min(ucfFile.getSizeComp(), ucfFile.getSizeUncomp());
        try (OutputByteStream data = null;){
            data = navResources.getPDFDocument().getStreamManager().getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.CLEAR, ByteWriterFactory.Fixed.GROWABLE, streamSizeEstimate, false);
            boolean compressed = ucfFile.copyCompressedData(data);
            PDFStream fileStream = PDFStream.newInstance((PDFDocument)navResources.getPDFDocument());
            InputByteStream ibs = null;
            InputStream is = null;
            try {
                ibs = data.closeAndConvert();
                is = ibs.toInputStream();
                fileStream.setStreamData(is, compressed);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                finally {
                    if (ibs != null) {
                        ibs.close();
                    }
                }
            }
            data = null;
            fileStream.setOutputFilter(ASName.k_FlateDecode);
            if (path != null) {
                navResources.addEntry((Object)path, (Object)fileStream);
            }
        }
    }

    private static void readIconFile(UCFContainer container, String iconLocation, PDFCollectionResourcesTree navResources) throws UCFInvalidStateException, IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, SAXException {
        if (iconLocation != null) {
            UCFFile iconFile = container.getFile(iconLocation);
            PortfolioReader.copyUCFFileToPDFStream(navResources, iconFile, new ASString(iconLocation));
        }
    }

    private static void readSWFResourceFiles(UCFContainer container, String pathPrefix, PDFCollectionResourcesTree navResources) throws UCFInvalidStateException, IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, SAXException {
        UCFFileIterator iterator = container.fileIterator();
        while (iterator.hasNext()) {
            UCFFile file = (UCFFile)iterator.next();
            String path = file.getPathName();
            if (!path.startsWith(pathPrefix) || navResources.getEntry((Object)new ASString(path)) != null || path.contains("navigator.xml") || path.contains("locale/string") || path.contains("mimetype") || path.contains("locales.xml") || path.contains("strings.asfx")) continue;
            PortfolioReader.copyUCFFileToPDFStream(navResources, file, new ASString(path));
        }
    }

    private static void readLocalesXMLFile(UCFFile xmlFile, LocalesXML2InternalParameters localesXMLParameterizer) throws UCFInvalidStateException, IOException, SAXException, TransformerException {
        ByteArrayOutputStream localesBuffer = new ByteArrayOutputStream();
        xmlFile.copyData((OutputStream)localesBuffer);
        InputSource xmlBase = new InputSource(new ByteArrayInputStream(localesBuffer.toByteArray()));
        Source source = XMLUtils.createSource(xmlBase, localesXMLParameterizer, true, true);
        XMLUtils.transformToXML(source, XMLUtils.createNullResult(), false);
    }

    private static void readStringsASFFile(UCFFile xmlFile, StringsASF2InternalParameters stringsASFParameterizer) throws UCFInvalidStateException, IOException, SAXException, TransformerException {
        ByteArrayOutputStream stringsBuffer = new ByteArrayOutputStream();
        xmlFile.copyData((OutputStream)stringsBuffer);
        InputSource xmlBase = new InputSource(new ByteArrayInputStream(stringsBuffer.toByteArray()));
        Source source = XMLUtils.createSource(xmlBase, stringsASFParameterizer, true, true);
        XMLUtils.transformToXML(source, XMLUtils.createNullResult(), false);
    }

    private static String resolveLocale(PDFDocument pdfDocument, TreeMap<String, String> localesMap, ULocale userLocale) throws PDFInvalidParameterException {
        String preferredLocale;
        block8: {
            block7: {
                if (localesMap == null || localesMap.isEmpty()) {
                    return null;
                }
                preferredLocale = null;
                if (userLocale == null) break block7;
                if (!localesMap.containsKey(userLocale.getName())) break block8;
                preferredLocale = userLocale.getName();
                break block8;
            }
            String docLocale = pdfDocument.getDocumentLocale().getDisplayName();
            if (localesMap.containsKey(docLocale)) {
                preferredLocale = docLocale;
            } else if (localesMap.size() == 1) {
                preferredLocale = localesMap.firstKey();
            } else {
                String docLanguage = pdfDocument.getDocumentLocale().getLanguage();
                for (String localeID : localesMap.keySet()) {
                    if (docLanguage.compareToIgnoreCase(ULocale.getLanguage((String)localeID)) != 0) continue;
                    preferredLocale = localeID;
                    break;
                }
            }
        }
        if (preferredLocale == null) {
            preferredLocale = localesMap.containsKey("en_US") ? "en_US" : localesMap.firstKey();
        }
        return preferredLocale;
    }

    private static PDFCollectionNavigator buildNavigatorDictionary(PDFDocument pdfDocument, NavXML2InternalParameters navXMLParameterizer, StringsASF2InternalParameters stringsASFParameterizer, UCFContainer container, String resolvedLocale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, SAXException, UCFInvalidStateException, IOException {
        PDFCollectionNavigator navigator = PDFCollectionNavigator.newInstance((PDFDocument)pdfDocument);
        PDFCollectionResourcesTree navResources = PDFCollectionResourcesTree.newInstance((PDFDocument)pdfDocument);
        String nameID = navXMLParameterizer.getNameID();
        if (nameID == null) {
            navigator.setName(navXMLParameterizer.getNameCData());
        } else {
            navigator.setName(stringsASFParameterizer.getStringValue(nameID));
        }
        String descriptionID = navXMLParameterizer.getDescriptionID();
        if (descriptionID == null) {
            navigator.setDesc(navXMLParameterizer.getDescriptionCData());
        } else {
            navigator.setDesc(stringsASFParameterizer.getStringValue(descriptionID));
        }
        String categoryID = navXMLParameterizer.getCategoryID();
        if (categoryID == null) {
            navigator.setCategory(navXMLParameterizer.getCategoryCData());
        } else {
            navigator.setCategory(stringsASFParameterizer.getStringValue(categoryID));
        }
        navigator.setID(navXMLParameterizer.getId());
        navigator.setVersion(navXMLParameterizer.getVersion());
        navigator.setAPIVersion(navXMLParameterizer.getApiVersion());
        String loadAs = navXMLParameterizer.getLoadAs();
        if (loadAs != null) {
            if (loadAs.compareToIgnoreCase(PDFCollectionSWFLoadType.k_Default.asString()) == 0) {
                navigator.setLoadType(PDFCollectionSWFLoadType.defaultSWF);
            } else if (loadAs.compareToIgnoreCase(PDFCollectionSWFLoadType.k_Module.asString()) == 0) {
                navigator.setLoadType(PDFCollectionSWFLoadType.moduleSWF);
            }
        } else {
            navigator.setLoadType(PDFCollectionSWFLoadType.defaultSWF);
        }
        String swfLocation = navXMLParameterizer.getSwfSrcLocation();
        PortfolioReader.readSWFFile(container, swfLocation, navResources);
        navigator.setSWF(swfLocation);
        String iconLocation = navXMLParameterizer.getIconImgLocation();
        PortfolioReader.readIconFile(container, iconLocation, navResources);
        navigator.setIcon(iconLocation);
        PortfolioReader.readSWFResourceFiles(container, "", navResources);
        navigator.setResources(navResources);
        if (resolvedLocale != null) {
            navigator.setLocale(PDFCollectionNavigator.getLocaleFromString((String)resolvedLocale));
        }
        PDFCollectionNavigatorStringsTree navStrings = PDFCollectionNavigatorStringsTree.newInstance((PDFDocument)pdfDocument);
        if (stringsASFParameterizer.getStringsKeySet() != null) {
            PDFFilterFlate filter = PDFFilterFlate.newInstance((PDFDocument)pdfDocument, null);
            for (String stringID : stringsASFParameterizer.getStringsKeySet()) {
                PDFText pdfText = PDFText.newInstance((PDFDocument)pdfDocument, (String)stringsASFParameterizer.getStringValue(stringID));
                pdfText.setFilter(filter);
                navStrings.addEntry((Object)new ASString(stringID), (Object)pdfText);
            }
        }
        navigator.setStrings(navStrings);
        PDFCollectionSchema navInitialFields = PortfolioReader.buildInitialFields(pdfDocument, navXMLParameterizer, stringsASFParameterizer);
        navigator.setInitialFields(navInitialFields);
        return navigator;
    }

    private static PDFCollectionSchema buildInitialFields(PDFDocument pdfDocument, NavXML2InternalParameters navXMLParameterizer, StringsASF2InternalParameters stringsASFParameterizer) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCollectionSchema navInitialFields = null;
        navInitialFields = PDFCollectionSchema.newInstance((PDFDocument)pdfDocument, (boolean)false);
        ArrayList<NavXML2InternalParameters.FieldAttributes> fieldList = navXMLParameterizer.getFieldsList();
        if (fieldList != null) {
            int order = 0;
            for (NavXML2InternalParameters.FieldAttributes fieldAttribute : fieldList) {
                String name = fieldAttribute.getName();
                if (name == null) {
                    throw new PDFInvalidParameterException("Invalid filed in navigator file");
                }
                ASName fieldName = ASName.create((String)name);
                PDFCollectionFieldType pdfFieldType = null;
                String type = fieldAttribute.getType();
                if (type != null && (pdfFieldType = (PDFCollectionFieldType)NavXML2InternalParameters.FieldAttributes.strType2pdfType.get(type.toLowerCase())) == null) {
                    pdfFieldType = PDFCollectionFieldType.text;
                }
                String displayNameID = fieldAttribute.getDisplayNameID();
                String displayName = null;
                displayName = displayNameID == null ? fieldAttribute.getDisplayNameCData() : stringsASFParameterizer.getStringValue(displayNameID);
                if (displayName == null) {
                    displayName = name;
                }
                PDFCollectionField pdfField = PDFCollectionField.newInstance((PDFDocument)pdfDocument, (PDFCollectionFieldType)pdfFieldType, (String)displayName);
                String visible = fieldAttribute.getVisible();
                if (visible != null && visible.compareToIgnoreCase("false") == 0) {
                    pdfField.setVisibility(false);
                } else {
                    pdfField.setVisibility(true);
                }
                String editable = fieldAttribute.getEditable();
                if (editable != null && editable.compareToIgnoreCase("true") == 0) {
                    pdfField.setAllowEdit(true);
                } else {
                    pdfField.setAllowEdit(false);
                }
                pdfField.setOrder(order++);
                navInitialFields.set(fieldName, pdfField);
            }
        }
        return navInitialFields;
    }

    private static PDFCollectionSplit buildCollectionSplit(PDFDocument pdfDocument, NavXML2InternalParameters navXMLParameterizer) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCollectionSplit collectionSplit = null;
        String splitDirection = navXMLParameterizer.getSplitDirection();
        if (splitDirection != null) {
            collectionSplit = PDFCollectionSplit.newInstance((PDFDocument)pdfDocument);
            ASName asnameSplitDirection = navXMLParameterizer.splitType2ASName.get(splitDirection.toLowerCase());
            if (asnameSplitDirection == null) {
                asnameSplitDirection = ASName.k_N;
            }
            collectionSplit.setDirection(asnameSplitDirection);
            if (asnameSplitDirection != ASName.k_N) {
                String sSplitPosition = navXMLParameterizer.getSplitPosition();
                double dSplitPosition = Double.parseDouble(sSplitPosition);
                collectionSplit.setPosition(Double.valueOf(dSplitPosition));
            }
        }
        return collectionSplit;
    }

    static class StringsASF2InternalParameters
    extends XMLFilterImpl {
        private static final String asfNS = "http://ns.adobe.com/asf";
        private static final String dtdURI = "http://ns.adobe.com/asf/asf_1_0.dtd";
        private static final String resolvedDTD = "impl/resources/asf_1_0.dtd";
        private static final TreeMap<String, String> resolvedURIs = new TreeMap();
        private static final XMLElement ASFElement = new XMLElement("http://ns.adobe.com/asf", "asf", true);
        private static final XMLElement STRElement = new XMLElement("http://ns.adobe.com/asf", "str", true);
        private static final XMLElement VALElement = new XMLElement("http://ns.adobe.com/asf", "val", true);
        private String locale;
        private String version;
        private boolean inASF;
        private String stringID;
        private boolean inSTR;
        private boolean collectCData;
        private char[] cData;
        private String stringValue;
        private TreeMap<String, String> strings;

        StringsASF2InternalParameters() {
            resolvedURIs.put(dtdURI, resolvedDTD);
            this.inASF = false;
            this.inSTR = false;
            this.collectCData = false;
            this.stringValue = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (ASFElement.matches(uri, localName)) {
                this.locale = atts.getValue("locale");
                this.version = atts.getValue("version");
                this.inASF = true;
                this.strings = new TreeMap();
            } else if (STRElement.matches(uri, localName) && this.inASF) {
                this.stringID = atts.getValue("name");
                this.inSTR = true;
            } else if (VALElement.matches(uri, localName) && this.inSTR && this.stringValue == null) {
                this.collectCData = true;
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.collectCData) {
                int lengthLimit = Math.min(length, ch.length - start);
                int cDataLength = this.cData != null ? this.cData.length : 0;
                char[] newCData = new char[cDataLength + lengthLimit];
                if (this.cData != null) {
                    System.arraycopy(this.cData, 0, newCData, 0, cDataLength);
                }
                System.arraycopy(ch, start, newCData, cDataLength, lengthLimit);
                this.cData = newCData;
            }
            super.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ASFElement.matches(uri, localName)) {
                this.inASF = false;
            } else if (STRElement.matches(uri, localName) && this.inASF) {
                this.strings.put(this.stringID, this.stringValue);
                this.stringValue = null;
                this.inSTR = false;
            } else if (VALElement.matches(uri, localName) && this.inSTR && this.collectCData) {
                this.stringValue = new String(this.cData);
                this.cData = null;
                this.collectCData = false;
            }
            super.endElement(uri, localName, qName);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String resolvedURI = resolvedURIs.get(systemId);
            if (resolvedURI != null) {
                ClassLoader cl = this.getClass().getClassLoader();
                InputStream dtdStream = null;
                dtdStream = cl == null ? ClassLoader.getSystemResourceAsStream(resolvedURI) : new BufferedInputStream(PortfolioReader.class.getResourceAsStream(resolvedURI));
                return new InputSource(dtdStream);
            }
            throw new SAXException(" ERROR: SAX Exception: Doctype is disallowed!!");
        }

        String getStringValue(String stringID) {
            if (this.strings != null) {
                return this.strings.get(stringID);
            }
            return null;
        }

        Set<String> getStringsKeySet() {
            if (this.strings != null) {
                return this.strings.keySet();
            }
            return null;
        }

        String getLocale() {
            return this.locale;
        }

        String getVersion() {
            return this.version;
        }
    }

    static class LocalesXML2InternalParameters
    extends XMLFilterImpl {
        private static final String localesNS = "http://ns.adobe.com/pdf/navigator/locales/2007";
        private static final XMLElement LOCALESElement = new XMLElement("http://ns.adobe.com/pdf/navigator/locales/2007", "locales", true);
        private static final XMLElement LOCALEElement = new XMLElement("http://ns.adobe.com/pdf/navigator/locales/2007", "locale", true);
        private boolean inLocales = false;
        private TreeMap<String, String> localeFiles;

        LocalesXML2InternalParameters() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (LOCALESElement.matches(uri, localName)) {
                this.inLocales = true;
                this.localeFiles = new TreeMap();
            } else if (LOCALEElement.matches(uri, localName) && this.inLocales) {
                String id = atts.getValue("id");
                String stringsFileLocation = atts.getValue("strings");
                if (id != null && stringsFileLocation != null) {
                    this.localeFiles.put(id, stringsFileLocation);
                }
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (LOCALESElement.matches(uri, localName)) {
                this.inLocales = false;
            }
            super.endElement(uri, localName, qName);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            throw new SAXException(" ERROR: SAX Exception: Doctype is disallowed!!");
        }

        TreeMap<String, String> getLocalesMap() {
            return this.localeFiles;
        }
    }

    static class NavXML2InternalParameters
    extends XMLFilterImpl {
        private static final String navigatorNS = "http://ns.adobe.com/pdf/navigator/2007";
        private static final XMLElement NAVIGATORElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "navigator", true);
        private static final XMLElement NAMEElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "name", true);
        private static final XMLElement DESCRIPTIONElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "description", true);
        private static final XMLElement CATEGORYElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "category", true);
        private static final XMLElement ICONElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "icon", true);
        private static final XMLElement LOCALESElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "locales", true);
        private static final XMLElement INITFIELDSElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "initialFields", true);
        private static final XMLElement INITVIEWElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "initialView", true);
        private static final XMLElement LOCALEElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "locale", true);
        private static final XMLElement FIELDElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "field", true);
        private static final XMLElement DISPALYNAMEElement = new XMLElement("http://ns.adobe.com/pdf/navigator/2007", "displayName", true);
        private String swfSrcLocation;
        private String id;
        private String loadAs;
        private String version;
        private String apiVersion;
        private String nameID;
        private String nameCData;
        private String descriptionID;
        private String descriptionCData;
        private String categoryID;
        private String categoryCData;
        private boolean collectCData = false;
        private char[] cData;
        private String iconImgLocation;
        private String localesXMLLocation;
        private boolean inLocales = false;
        private TreeMap<String, String> localeFiles;
        private boolean inInitFields = false;
        private boolean inField = false;
        private ArrayList<FieldAttributes> fieldsList;
        private FieldAttributes fieldAttr = null;
        private String splitDirection = null;
        private String splitPosition = null;
        Map<String, ASName> splitType2ASName = new HashMap<String, ASName>();
        private boolean succeeded = false;

        NavXML2InternalParameters() {
            this.splitType2ASName.put("horizontal", ASName.k_H);
            this.splitType2ASName.put("vertical", ASName.k_V);
            this.splitType2ASName.put("none", ASName.k_N);
        }

        public boolean succeeded() {
            return this.succeeded;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (NAVIGATORElement.matches(uri, localName)) {
                this.succeeded = true;
                this.setSwfSrcLocation(atts.getValue("src"));
                this.id = atts.getValue("id");
                this.loadAs = atts.getValue("loadAs");
                this.version = atts.getValue("version");
                this.apiVersion = atts.getValue("apiVersion");
            } else if (NAMEElement.matches(uri, localName)) {
                this.nameID = atts.getValue("sID");
                if (this.nameID == null) {
                    this.collectCData = true;
                }
            } else if (DESCRIPTIONElement.matches(uri, localName)) {
                this.descriptionID = atts.getValue("sID");
                if (this.descriptionID == null) {
                    this.collectCData = true;
                }
            } else if (CATEGORYElement.matches(uri, localName)) {
                this.categoryID = atts.getValue("sID");
                if (this.categoryID == null) {
                    this.collectCData = true;
                }
            } else if (ICONElement.matches(uri, localName)) {
                this.setIconImgLocation(atts.getValue("src"));
            } else if (LOCALESElement.matches(uri, localName)) {
                this.localesXMLLocation = atts.getValue("src");
                if (this.localesXMLLocation == null) {
                    this.inLocales = true;
                    this.localeFiles = new TreeMap();
                } else {
                    this.inLocales = false;
                }
            } else if (LOCALEElement.matches(uri, localName) && this.inLocales) {
                String id = atts.getValue("id");
                String stringsFileLocation = atts.getValue("strings");
                if (id != null && stringsFileLocation != null) {
                    this.localeFiles.put(id, stringsFileLocation);
                }
            } else if (INITFIELDSElement.matches(uri, localName)) {
                this.inInitFields = true;
                this.fieldsList = new ArrayList();
            } else if (FIELDElement.matches(uri, localName) && this.inInitFields) {
                this.inField = true;
                String name = atts.getValue("name");
                String type = atts.getValue("type");
                String visible = atts.getValue("visible");
                String editable = atts.getValue("editable");
                this.fieldAttr = new FieldAttributes(name, type, visible, editable);
            } else if (DISPALYNAMEElement.matches(uri, localName) && this.inField) {
                String displayName = atts.getValue("sID");
                if (displayName == null) {
                    this.collectCData = true;
                } else {
                    this.fieldAttr.setDisplayNameID(displayName);
                }
            } else if (INITVIEWElement.matches(uri, localName)) {
                this.splitDirection = atts.getValue("splitDirection");
                this.splitPosition = atts.getValue("splitPosition");
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.collectCData) {
                int lengthLimit = Math.min(length, ch.length - start);
                int cDataLength = this.cData != null ? this.cData.length : 0;
                char[] newCData = new char[cDataLength + lengthLimit];
                if (this.cData != null) {
                    System.arraycopy(this.cData, 0, newCData, 0, cDataLength);
                }
                for (int j = 0; j < lengthLimit; ++j) {
                    newCData[cDataLength + j] = ch[start + j];
                }
                this.cData = newCData;
            }
            super.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (NAMEElement.matches(uri, localName) && this.collectCData) {
                this.nameCData = new String(this.cData);
                this.cData = null;
                this.collectCData = false;
            } else if (DESCRIPTIONElement.matches(uri, localName) && this.collectCData) {
                this.descriptionCData = new String(this.cData);
                this.cData = null;
                this.collectCData = false;
            } else if (CATEGORYElement.matches(uri, localName) && this.collectCData) {
                this.categoryCData = new String(this.cData);
                this.cData = null;
                this.collectCData = false;
            } else if (LOCALESElement.matches(uri, localName)) {
                this.inLocales = false;
            } else if (INITFIELDSElement.matches(uri, localName)) {
                this.inInitFields = false;
            } else if (FIELDElement.matches(uri, localName) && this.inInitFields) {
                this.inField = false;
                this.fieldsList.add(this.fieldAttr);
            } else if (DISPALYNAMEElement.matches(uri, localName) && this.inField && this.collectCData) {
                this.fieldAttr.setDisplayNameCData(new String(this.cData));
                this.cData = null;
                this.collectCData = false;
            }
            super.endElement(uri, localName, qName);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            throw new SAXException(" ERROR: SAX Exception: Doctype is disallowed!!");
        }

        private void setSwfSrcLocation(String swfSrcLocation) {
            this.swfSrcLocation = swfSrcLocation;
        }

        String getSwfSrcLocation() {
            return this.swfSrcLocation;
        }

        private void setIconImgLocation(String iconImgLocation) {
            this.iconImgLocation = iconImgLocation;
        }

        String getIconImgLocation() {
            return this.iconImgLocation;
        }

        String getLocalesXMLLocation() {
            return this.localesXMLLocation;
        }

        TreeMap<String, String> getLocalesMap() {
            return this.localeFiles;
        }

        String getNameID() {
            return this.nameID;
        }

        String getNameCData() {
            return this.nameCData;
        }

        String getDescriptionID() {
            return this.descriptionID;
        }

        String getDescriptionCData() {
            return this.descriptionCData;
        }

        String getCategoryID() {
            return this.categoryID;
        }

        String getCategoryCData() {
            return this.categoryCData;
        }

        String getId() {
            return this.id;
        }

        String getVersion() {
            return this.version;
        }

        String getApiVersion() {
            return this.apiVersion;
        }

        String getLoadAs() {
            return this.loadAs;
        }

        ArrayList<FieldAttributes> getFieldsList() {
            return this.fieldsList;
        }

        String getSplitDirection() {
            return this.splitDirection;
        }

        String getSplitPosition() {
            return this.splitPosition;
        }

        private static class FieldAttributes {
            private String mName;
            private String mType;
            private String mVisible;
            private String mEditable;
            private String mDisplayNameID;
            private String mDisplayNameCData;
            private static final Map<String, PDFCollectionFieldType> strType2pdfType = new HashMap<String, PDFCollectionFieldType>();

            FieldAttributes(String name, String type, String visible, String editable) {
                strType2pdfType.put("text", PDFCollectionFieldType.text);
                strType2pdfType.put("date", PDFCollectionFieldType.date);
                strType2pdfType.put("number", PDFCollectionFieldType.number);
                strType2pdfType.put("filename", PDFCollectionFieldType.file);
                strType2pdfType.put("desc", PDFCollectionFieldType.Desc);
                strType2pdfType.put("modDate", PDFCollectionFieldType.ModDate);
                strType2pdfType.put("creationDate", PDFCollectionFieldType.CreationDate);
                strType2pdfType.put("size", PDFCollectionFieldType.size);
                strType2pdfType.put("compressedSize", PDFCollectionFieldType.compressedSize);
                this.setName(name);
                this.setType(type);
                this.setVisible(visible);
                this.setEditable(editable);
            }

            void setName(String name) {
                this.mName = name;
            }

            String getName() {
                return this.mName;
            }

            void setType(String type) {
                this.mType = type;
            }

            String getType() {
                return this.mType;
            }

            void setVisible(String visible) {
                this.mVisible = visible;
            }

            String getVisible() {
                return this.mVisible;
            }

            void setEditable(String editable) {
                this.mEditable = editable;
            }

            String getEditable() {
                return this.mEditable;
            }

            void setDisplayNameID(String displayName) {
                this.mDisplayNameID = displayName;
            }

            String getDisplayNameID() {
                return this.mDisplayNameID;
            }

            void setDisplayNameCData(String mDisplayNameCData) {
                this.mDisplayNameCData = mDisplayNameCData;
            }

            String getDisplayNameCData() {
                return this.mDisplayNameCData;
            }
        }
    }
}

