/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.portfolio;

import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNavigator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionResourcesTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSplit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionView;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;

public class PortfolioCopier {
    public static PDFPortableCollection copyNavigator(PDFDocument sourceDoc, PDFDocument newDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPortableCollection targetCollectionDict = null;
        PDFPortableCollection sourcePortableCollection = sourceDoc.requireCatalog().getCollection();
        if (sourcePortableCollection != null) {
            CosCloneMgr mgr = new CosCloneMgr(newDoc.getCosDocument());
            targetCollectionDict = PDFPortableCollection.newInstance((PDFDocument)newDoc);
            PDFCollectionView view = sourcePortableCollection.getView();
            targetCollectionDict.setView(view);
            PDFCollectionNavigator sourceNavigator = sourcePortableCollection.getNavigator();
            PDFCollectionNavigator newNavigator = sourceNavigator == null ? null : PDFCollectionNavigator.getInstance((CosObject)mgr.clone(sourceNavigator.getCosObject()));
            if (newNavigator != null) {
                targetCollectionDict.setNavigator(newNavigator);
                PDFCollectionSchema newCollectionSchema = newNavigator.getInitialFields();
                if (newCollectionSchema == null) {
                    targetCollectionDict.setSchema(null);
                } else {
                    targetCollectionDict.setSchema(PDFCollectionSchema.getInstance((CosObject)mgr.clone(newCollectionSchema.getCosObject())));
                }
                PDFCollectionSplit split = sourcePortableCollection.getSplit();
                if (split != null) {
                    targetCollectionDict.setSplit(PDFCollectionSplit.getInstance((CosObject)mgr.clone(split.getCosObject())));
                }
            }
        }
        return targetCollectionDict;
    }

    public static PDFCollectionResourcesTree copyCollectionResourcesTree(PDFDocument sourceDoc, PDFDocument newDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionResourcesTree sourceResourcesTree;
        PDFCollectionResourcesTree targetResourcesTree = null;
        PDFPortableCollection sourcePortableCollection = sourceDoc.requireCatalog().getCollection();
        if (sourcePortableCollection != null && (sourceResourcesTree = sourcePortableCollection.getResources()) != null) {
            CosCloneMgr mgr = new CosCloneMgr(newDoc.getCosDocument());
            targetResourcesTree = PDFCollectionResourcesTree.getInstance((CosObject)mgr.clone(sourceResourcesTree.getCosObject()));
        }
        return targetResourcesTree;
    }
}

