/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPSimpleType;

class XMPInteger
extends XMPSimpleType {
    private static XMPInteger _xmpInteger = new XMPInteger();
    private static final String EXIF_SCHEMA_NS = "http://ns.adobe.com/tiff/1.0/";
    static final String PHOTOSHOP_SCHEMA_NS = "http://ns.adobe.com/photoshop/1.0/";
    static final String CAMERA_SCHEMA_NS = "http://ns.adobe.com/camera-rawsettings/1.0/";

    private XMPInteger() {
    }

    public static XMPInteger getInstance() {
        return _xmpInteger;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode a) {
        if (!super.isValid(a)) {
            return false;
        }
        String value = a.getValue();
        Integer i = null;
        try {
            i = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (PHOTOSHOP_SCHEMA_NS.equals(a.getNameSpaceURI())) {
            if (a.getName() != null && a.getName().equals("Urgency")) {
                return i >= 1 && i <= 8;
            }
        } else if ("http://ns.adobe.com/xap/1.0/g/".equals(a.getNameSpaceURI())) {
            if (a.getName() != null) {
                if (a.getName().equals("red") || a.getName().equals("green") || a.getName().equals("blue")) {
                    return i >= 0 && i <= 255;
                }
                if (a.getName().equals("A") || a.getName().equals("B")) {
                    return i >= -128 || i <= 127;
                }
            }
        } else if (CAMERA_SCHEMA_NS.equals(a.getNameSpaceURI()) && a.getName() != null) {
            if (a.getName().equals("BlueHue") || a.getName().equals("BlueSaturation") || a.getName().equals("ChromaticAberrationB") || a.getName().equals("ChromaticAberrationR") || a.getName().equals("GreenHue") || a.getName().equals("GreenSaturation") || a.getName().equals("RedHue") || a.getName().equals("RedSaturation") || a.getName().equals("Saturation") || a.getName().equals("ShadowTint") || a.getName().equals("VignetteAmount")) {
                return i >= -100 && i <= 100;
            }
            if (a.getName().equals("ColorNoiseReduction") || a.getName().equals("LuminanceSmoothing") || a.getName().equals("Shadows") || a.getName().equals("Sharpness") || a.getName().equals("VignetteMidpoint")) {
                return i >= 0 && i <= 100;
            }
            if (a.getName().equals("Brightness")) {
                return i >= 0 && i <= 150;
            }
            if (a.getName().equals("Contrast")) {
                return i >= -50 && i <= 100;
            }
            if (a.getName().equals("ColorNoiseReduction")) {
                return i >= 0 && i <= 100;
            }
            if (a.getName().equals("Temperature")) {
                return i >= 2000 && i <= 50000;
            }
            if (a.getName().equals("Tint")) {
                return i >= -150 && i <= 150;
            }
        }
        return true;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m, boolean closedChoice) {
        if (!closedChoice) {
            return this.isValid(m);
        }
        if (!super.isValid(m)) {
            return false;
        }
        String value = m.getValue();
        if (EXIF_SCHEMA_NS.equals(m.getNameSpaceURI())) {
            if (m.getName() == null) {
                return false;
            }
            if (m.getName().equals("Compression")) {
                // empty if block
            }
            if (m.getName().equals("Orientation")) {
                Integer i = null;
                try {
                    i = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return i >= 1 && i <= 8;
            }
            if (m.getName().equals("PhotometricInterpretation")) {
                return "2".equals(value) || "6".equals(value);
            }
            if ("PlanarConfiguration".equals(m.getName())) {
                return "1".equals(value) || "2".equals(value);
            }
            if (m.getName().equals("ResolutionUnit")) {
                return "2".equals(value) || "3".equals(value);
            }
            if (m.getName().equals("YCbCrPositioning")) {
                return "1".equals(value) || "2".equals(value);
            }
        }
        return true;
    }
}

