/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractCatalogErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorElementDoesNotUseStandardType;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.StructureTypeNameCollector;
import java.util.HashSet;

class StructureProcessor {
    private static final HashSet<ASName> STANDARD_STRUCT_TYPES = new HashSet();

    StructureProcessor() {
    }

    static void processStructureRoot(PDFStructureRoot structureRoot, PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errorCodes, PDFA2ConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int objNum = structureRoot.getCosObject().getObjNum();
        int objGen = structureRoot.getCosObject().getObjGen();
        PDFStructureRoleMap roleMap = structureRoot.getRoleMap();
        StructureTypeNameCollector nameCollector = new StructureTypeNameCollector(structureRoot);
        HashSet<ASName> structTypes = nameCollector.getStuctureTypeNames();
        for (ASName name : structTypes) {
            ASName nameFromRoleMap;
            if (STANDARD_STRUCT_TYPES.contains(name)) continue;
            ASName aSName = nameFromRoleMap = roleMap == null ? null : roleMap.getRole(name);
            if (nameFromRoleMap != null && STANDARD_STRUCT_TYPES.contains(nameFromRoleMap) || conversionHandler != null) continue;
            errorCodes.addErrorCode(new PDFA2CatalogErrorElementDoesNotUseStandardType(name.asString(), objNum, objGen));
        }
    }

    static {
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Document"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Part"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Art"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Sect"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Div"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"BlockQuote"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Caption"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"TOC"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"TOCI"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Index"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"NonStruct"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Private"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"P"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"H1"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"H2"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"H3"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"H4"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"H5"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"H6"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"L"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Lbl"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"LI"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"LBody"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Table"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"H"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"H1\u0096H6"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"TR"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"TH"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"TD"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"THead"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"TBody"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"TFoot"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Span"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Quote"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Note"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Reference"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"BibEntry"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Code"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Link"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Annot"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Ruby"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Warichu"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Ruby"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"RB"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"RT"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"RP"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"WT"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"WP"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Figure"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Formula"));
        STANDARD_STRUCT_TYPES.add(ASName.create((String)"Form"));
    }
}

