/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.services.pdfa.common.ColorSpaceAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceMapAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFShadingColorSpaceAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractPatternErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PatternErrorICCBasedCMYKColorSpaceUsedWithOPMSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PatternErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ContentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ExtGStateProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.GState;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TransparencyState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class PatternProcessor {
    PatternProcessor() {
    }

    static boolean process(PDFPatternMap patternMap, LinkedHashMap<ASName, ArrayList<GState>> referencedPatternNames, DocumentProcessor docProcessor, PDFResources parentResources, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, TransparencyState transparencyInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (patternMap == null || patternMap.isEmpty()) {
            return true;
        }
        if (referencedPatternNames == null || referencedPatternNames.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<ASName, ArrayList<GState>>> entriesItr = referencedPatternNames.entrySet().iterator();
        Map.Entry<ASName, ArrayList<GState>> entry = null;
        ASName patternName = null;
        ArrayList<GState> gStates = null;
        while (entriesItr.hasNext()) {
            entry = entriesItr.next();
            patternName = entry.getKey();
            gStates = entry.getValue();
            PDFPattern pattern = patternMap.get(patternName);
            if (!(pattern instanceof PDFPatternTiling ? !PatternProcessor.processTilingPattern(patternName, (PDFPatternTiling)pattern, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, gStates, transparencyInfo) : pattern instanceof PDFPatternShading && !PatternProcessor.processShadingPattern(patternName, (PDFPatternShading)pattern, docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, gStates))) continue;
            return false;
        }
        return true;
    }

    static boolean processTilingPattern(ASName name, PDFPatternTiling pattern, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, ArrayList<GState> gStates, TransparencyState transparencyInfo) throws PDFIOException, PDFSecurityException {
        if (pattern == null) {
            return true;
        }
        if (!validationHandler.beginPatternScan(name, (PDFPattern)pattern)) {
            return false;
        }
        PDFA2ErrorSet<PDFA2AbstractPatternErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractPatternErrorCode>();
        try {
            PDFResources resources;
            ModifiableContent content = ModifiableContent.newInstance((PDFPatternTiling)pattern);
            if (gStates == null || gStates.isEmpty()) {
                if (!ContentProcessor.process((Content)content, (PDFCosDictionary)pattern, null, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null, transparencyInfo)) {
                    return false;
                }
            } else {
                for (int i = 0; i < gStates.size(); ++i) {
                    if (ContentProcessor.process((Content)content, (PDFCosDictionary)pattern, null, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, gStates.get(i), transparencyInfo)) continue;
                    return false;
                }
            }
            if (conversionHandler != null && content.resourcesDetached() && (resources = content.getResources()) != null && !resources.isEmpty()) {
                try {
                    pattern.setResources(content.getResources());
                }
                catch (PDFInvalidParameterException e) {}
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2PatternErrorPDFGeneralFailure(0, 0));
        }
        if (errorCodes.hasErrors() && !validationHandler.patternError(errorCodes)) {
            return false;
        }
        return validationHandler.endPatternScan();
    }

    static boolean processShadingPattern(ASName name, PDFPatternShading pattern, DocumentProcessor docProcessor, PDFResources parentResources, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, ArrayList<GState> gStates) throws PDFIOException, PDFSecurityException {
        if (pattern == null) {
            return true;
        }
        if (!validationHandler.beginPatternScan(name, (PDFPattern)pattern)) {
            return false;
        }
        PDFA2ErrorSet<PDFA2AbstractPatternErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractPatternErrorCode>();
        try {
            PDFShading patternShading = pattern.getShading();
            PDFColorSpace cs = null;
            ColorSpaceAdapter csAdapter = null;
            if (patternShading != null) {
                CosObject colorSpaceCosObject = patternShading.getPDFCosObject().getDictionaryCosObjectValue(ASName.k_ColorSpace);
                if (colorSpaceCosObject instanceof CosName && colorSpaceCosObject.nameValue() != ASName.k_DeviceRGB && colorSpaceCosObject.nameValue() != ASName.k_DeviceCMYK && colorSpaceCosObject.nameValue() != ASName.k_DeviceGray) {
                    cs = parentResources.getColorSpace(colorSpaceCosObject.nameValue());
                    csAdapter = new PDFColorSpaceMapAdapter(parentResources.getColorSpaceMap(), colorSpaceCosObject.nameValue());
                }
                if (cs == null) {
                    cs = PDFColorSpaceFactory.getInstance((CosObject)colorSpaceCosObject);
                    csAdapter = new PDFShadingColorSpaceAdapter(patternShading);
                }
            }
            PDFExtGState extGState = pattern.getExtGState();
            boolean csValidatedWithGSState = false;
            if (extGState != null) {
                if (!ExtGStateProcessor.process(extGState, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                    return false;
                }
                if (extGState.hasOverprintMode()) {
                    try {
                        boolean isOverprintStrokeOrFill;
                        boolean bl = isOverprintStrokeOrFill = extGState.hasOverprintFill() && extGState.getOverprintFill() || extGState.hasOverprintStroke() && extGState.getOverprintStroke();
                        if (!ColorSpaceProcessor.validateCurrentCSWithCurrentOPM(isOverprintStrokeOrFill, extGState.getOverprintMode(), cs)) {
                            errorCodes.addErrorCode(new PDFA2PatternErrorICCBasedCMYKColorSpaceUsedWithOPMSet(0, 0));
                        }
                    }
                    catch (PDFInvalidContentException e) {
                        errorCodes.addErrorCode(new PDFA2PatternErrorPDFGeneralFailure(0, 0));
                    }
                    csValidatedWithGSState = true;
                }
            }
            if (cs != null && (!csValidatedWithGSState ? !ColorSpaceProcessor.process(csAdapter, cs.getName(), cs, docProcessor, validationHandler, parentResources, conversionOptions, conversionHandler, gStates) : !ColorSpaceProcessor.process(csAdapter, cs.getName(), cs, docProcessor, validationHandler, parentResources, conversionOptions, conversionHandler, null))) {
                return false;
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2PatternErrorPDFGeneralFailure(0, 0));
        }
        if (errorCodes.hasErrors() && !validationHandler.patternError(errorCodes)) {
            return false;
        }
        return validationHandler.endPatternScan();
    }
}

