/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecificationList;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFileStructureErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEmbeddedFileAFNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEmbeddedFileMIMETypeNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEmbeddedFileMIMETypeNotValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEmbeddedFileParamsDictNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEmbeddedFileParamsHasInvalidDate;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorFileSpecDictAFRelationshipNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorFileSpecDictFKeyNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorFileSpecDictUFKeyNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.EmbeddedFileProcessor;
import java.io.IOException;
import java.util.HashSet;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

class PDFA3EmbeddedFileProcessor
extends EmbeddedFileProcessor {
    private static PDFA3EmbeddedFileProcessor _instance = new PDFA3EmbeddedFileProcessor();

    private PDFA3EmbeddedFileProcessor() {
    }

    public static PDFA3EmbeddedFileProcessor getInstance() {
        return _instance;
    }

    @Override
    void process(CosObject cosObj, PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> flags, PDFA2ValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, HashSet<CosObject> associatedFiles) throws PDFIOException, PDFSecurityException, IOException {
        int objectNumber = cosObj.getObjNum();
        int genNumber = cosObj.getObjGen();
        if (cosObj instanceof CosDictionary) {
            CosDictionary cosDict = (CosDictionary)cosObj;
            try {
                CosObject typeCosObj = cosDict.get(ASName.k_Type);
                if (typeCosObj instanceof CosName && typeCosObj.nameValue() == ASName.k_Filespec) {
                    ASName afRelationShip;
                    if (cosDict.containsKey((Object)ASName.k_EF)) {
                        PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> embeddedES = this.validateEmbeddedFile(cosDict, validationHandler, conversionHandler, associatedFiles);
                        flags.mergeErrorSet(embeddedES);
                    }
                    if ((afRelationShip = cosDict.getName(ASName.k_AFRelationship)) == null) {
                        if (conversionHandler == null) {
                            flags.addErrorCode(new PDFA2FileStructureErrorFileSpecDictAFRelationshipNotPresent(objectNumber, genNumber));
                        } else {
                            cosDict.put(ASName.k_AFRelationship, ASName.k_Unspecified);
                        }
                    }
                    if (!cosDict.containsKey((Object)ASName.k_F)) {
                        flags.addErrorCode(new PDFA2FileStructureErrorFileSpecDictFKeyNotPresent(objectNumber, genNumber));
                    }
                    if (!cosDict.containsKey((Object)ASName.k_UF)) {
                        flags.addErrorCode(new PDFA2FileStructureErrorFileSpecDictUFKeyNotPresent(objectNumber, genNumber));
                    }
                }
            }
            catch (PDFInvalidDocumentException e) {
                flags.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(objectNumber, genNumber));
            }
        }
    }

    @Override
    PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> validateEmbeddedFile(CosDictionary fileSpecDict, PDFA2ValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, HashSet<CosObject> associatedFiles) throws PDFIOException, PDFSecurityException, IOException, PDFInvalidDocumentException {
        CosObject params;
        PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> set = new PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode>();
        CosStream embeddedFileDict = fileSpecDict.getCosDictionary(ASName.k_EF).getCosStream(ASName.k_F);
        int objectNumber = embeddedFileDict.getObjNum();
        int genNumber = embeddedFileDict.getObjGen();
        if (associatedFiles != null && !associatedFiles.contains(fileSpecDict)) {
            if (conversionHandler == null) {
                set.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileAFNotPresent(objectNumber, genNumber));
            } else {
                PDFDocument document = (PDFDocument)fileSpecDict.getDocument().getPdfDocument();
                PDFCatalog catalog = document.requireCatalog();
                PDFFileSpecificationList catalogAF = catalog.getAssociatedFiles();
                if (catalogAF == null) {
                    catalogAF = PDFFileSpecificationList.newInstance((PDFDocument)document);
                    catalog.setAssociatedFiles(catalogAF);
                }
                catalogAF.add((PDFCosObjectContainer)PDFFileSpecification.getInstance((CosObject)fileSpecDict));
                associatedFiles.add((CosObject)fileSpecDict);
            }
        }
        if ((params = embeddedFileDict.get(ASName.k_Params)) == null) {
            set.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileParamsDictNotPresent(objectNumber, genNumber));
        } else if (!(params instanceof CosDictionary)) {
            set.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileParamsDictNotPresent(objectNumber, genNumber));
        } else {
            CosDictionary paramsDict = (CosDictionary)params;
            CosObject modDate = paramsDict.get(ASName.k_ModDate);
            int objectNumberP = paramsDict.getObjNum();
            int genNumberP = paramsDict.getObjGen();
            if (modDate == null) {
                set.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileParamsHasInvalidDate(objectNumberP, genNumberP));
            } else if (!(modDate instanceof CosString)) {
                set.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileParamsHasInvalidDate(objectNumberP, genNumberP));
            } else {
                CosString modDateString = (CosString)modDate;
                try {
                    modDateString.asDate();
                }
                catch (Exception e) {
                    set.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileParamsHasInvalidDate(objectNumberP, genNumberP));
                }
            }
        }
        CosObject mime = embeddedFileDict.get(ASName.k_Subtype);
        boolean isMimePresentAndValid = false;
        if (mime instanceof CosName) {
            String mimeString = ((CosName)mime).nameValue().asString();
            try {
                new MimeType(mimeString);
                isMimePresentAndValid = true;
            }
            catch (MimeTypeParseException e) {
                // empty catch block
            }
        }
        if (!isMimePresentAndValid) {
            if (conversionHandler == null) {
                if (mime instanceof CosName) {
                    set.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileMIMETypeNotValid(objectNumber, genNumber));
                } else {
                    set.addErrorCode(new PDFA2FileStructureErrorEmbeddedFileMIMETypeNotPresent(objectNumber, genNumber));
                }
            } else {
                embeddedFileDict.put(ASName.k_Subtype, ASName.create((String)"application/octet-stream"));
            }
        }
        return set;
    }
}

