/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2SaveTypes;

class PDFA2SaveModes {
    public static final int incrementalSave = 1;
    public static final int linearSave = 2;
    public static final int fullSave = 4;
    public static final int partiallyFixBySave = 8;
    public static final int noSave = 0;
    private int flags;
    private boolean linearizationBlockingIncSave = false;

    PDFA2SaveModes(int arg) {
        this.flags = arg;
    }

    PDFA2SaveModes() {
        this.appendOptions(1);
        this.appendOptions(2);
        this.appendOptions(4);
    }

    public boolean incrementalSave() {
        return this.modeSet(1);
    }

    public boolean linearSave() {
        return this.modeSet(2);
    }

    public boolean fullSave() {
        return this.modeSet(4);
    }

    public boolean partiallyFixBySave() {
        return this.modeSet(8);
    }

    public boolean isLinearizationBlockingIncSave() {
        return this.linearizationBlockingIncSave;
    }

    void setLinearizationBlockingIncSave(boolean value) {
        this.linearizationBlockingIncSave = value;
    }

    void setOptions(int flags) {
        this.flags = flags;
    }

    public void appendOptions(int flags) {
        this.flags |= flags;
    }

    public void removeOptions(int flags) {
        int invertedFlag = ~flags;
        this.flags &= invertedFlag;
    }

    public int getOptions() {
        return this.flags;
    }

    public boolean modeSet(int mode) {
        return (this.flags & mode) == mode;
    }

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public void removeAllSaveOptions() {
        this.removeOptions(1);
        this.removeOptions(2);
        this.removeOptions(4);
    }

    static PDFA2SaveTypes convertToSaveType(PDFA2SaveModes modes) {
        if (modes.linearSave() && modes.fullSave() && modes.incrementalSave()) {
            return PDFA2SaveTypes.ANYSAVE;
        }
        if (modes.linearSave() || modes.fullSave()) {
            if (modes.linearizationBlockingIncSave) {
                return PDFA2SaveTypes.FULL_OR_LINEARSAVE_ONLY_LINEARIZATION_BLOCKING_INCRSAVE;
            }
            return PDFA2SaveTypes.FULL_OR_LINEARSAVE;
        }
        if (modes.partiallyFixBySave()) {
            if (modes.linearizationBlockingIncSave) {
                return PDFA2SaveTypes.PARTIALLYFIXABLE_BY_FULL_OR_LINEARSAVE_ONLY_LINEARIZATION_BLOCKING_INCRSAVE;
            }
            return PDFA2SaveTypes.PARTIALLYFIXABLE_BY_FULL_OR_LINEARSAVE;
        }
        if (modes.getOptions() == 0) {
            return PDFA2SaveTypes.UNFIXABLE_ERRORS;
        }
        return null;
    }
}

