/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPSchemaUsageValidator;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ExternalSchemas;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2InvalidNamespaceUsage;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractDocumentMetadataErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2DocumentMetadataErrorCatalogMissingMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2DocumentMetadataErrorMalformedMetadataXML;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2DocumentMetadataErrorPDFAConformanceScanMismatch;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2DocumentMetadataErrorPDFAInfoNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2DocumentMetadataErrorPDFAVersionScanMismatch;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2DocumentMetadataErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorInvalidPrefix;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorInvalidXMPHeader;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorMalformedMetadataXML;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorSchemaUsageNotValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.PDFA2XMLElementsRemover;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.SchemaInserter;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.XMPProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.XMPTypeValidator;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.Metadata;
import com.adobe.internal.pdftoolkit.services.xmp.MetadataOptions;
import com.adobe.internal.pdftoolkit.services.xmp.PDFDictionaryMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsage;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.xmp.XMPException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MetadataProcessor {
    private static final boolean DEBUG_SCHEMAS = false;
    private static final String NS_PDFA2_ID = "http://www.aiim.org/pdfa/ns/id/";
    private static final String DOC_INFO_CUSTOM_TYPE = "Text";
    private static final String DOC_INFO_CUSTOM_DESCRIPTION = "Custom Property for Entry from the Document Info Dictionary";
    private static final Pattern INVALID_HEADER_ATTRIBUTES_REGEX = Pattern.compile("^(bytes=)|(encoding=)");
    private static final PDFA2XMPSchema PDF_SCHEMA = new PDFA2XMPSchema("http://ns.adobe.com/pdf/1.3/", "pdf", "This schema specifies properties used with Adobe PDF documents.");
    private static final PDFA2XMPSchema XMPMM_SCHEMA;
    private static final XMLNamespaceUsage XMPMM_USAGE;
    private static final PDFA2XMPSchema PDFX_SCHEMA;
    private static final List<PDFA2XMPSchema> INSERTION_SCHEMAS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean process(PDFDocument document, XMPProcessor xmpProcessor, PDFA2ConformanceLevel conformanceLevel, TrackingConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, TrackingValidationHandler validationHandler, PDFA2ValidationOptions validationOptions) throws PDFIOException, PDFSecurityException {
        if (document == null) {
            return true;
        }
        if (!validationHandler.beginDocMetadataScan()) {
            return false;
        }
        PDFA2ErrorSet<PDFA2AbstractDocumentMetadataErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractDocumentMetadataErrorCode>();
        InputStream xmpStream = null;
        try {
            DocumentMetadata metadata = XMPService.getDocumentMetadata((PDFDocument)document);
            if (conversionHandler != null) {
                MetadataOptions existingOptions = metadata.getOptions();
                MetadataOptions.MetadataOptionsBuilder builder = MetadataOptions.MetadataOptionsBuilder.newInstance((MetadataOptions)existingOptions);
                builder.setAutoUpdate(true);
                builder.setRemoveFiltersFromXMP(true);
                builder.setFilterRemovalMarksXMPDirty(true);
                metadata.setOptions(builder.build());
            }
            if (!document.requireCatalog().dictionaryContains(ASName.k_Metadata)) {
                errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorCatalogMissingMetadata(0, 0));
            } else {
                String version;
                if (!metadata.wasInitialXMPValid()) {
                    errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorMalformedMetadataXML(0, 0));
                }
                if ((version = metadata.getProperty(NS_PDFA2_ID, "part")) == null) {
                    errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorPDFAInfoNotPresent(0, 0));
                } else if (conformanceLevel.getVersion().equals("2") || conformanceLevel == PDFA2ConformanceLevel.Level_3b) {
                    if (!conformanceLevel.getVersion().equals(version)) {
                        errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorPDFAVersionScanMismatch(version, 0, 0));
                    }
                } else {
                    throw new RuntimeException("a new PDFA2ConformanceLevel needs to be supported");
                }
                String conformance = metadata.getProperty(NS_PDFA2_ID, "conformance");
                if (conformance == null) {
                    errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorPDFAInfoNotPresent(0, 0));
                } else if (conformanceLevel.getVersion().equals("2") || conformanceLevel == PDFA2ConformanceLevel.Level_3b) {
                    if (!conformanceLevel.getConformance().equalsIgnoreCase(conformance.trim())) {
                        errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorPDFAConformanceScanMismatch(conformance, 0, 0));
                    }
                } else {
                    throw new RuntimeException("a new PDFA2ConformanceLevel needs to be supported");
                }
            }
            PDFCatalog catalog = document.requireCatalog();
            PDFA2XMPErrorCollector errorCodesXMP = new PDFA2XMPErrorCollector();
            MetadataProcessor.processXMPInternal(document, (PDFCosDictionary)catalog, xmpProcessor, (PDFDictionaryMetadata)metadata, conversionHandler, conversionOptions, validationHandler, validationOptions, errorCodesXMP, errorCodes);
            if (conversionHandler != null && (!conversionHandler.errorsFound() || conversionHandler.errorsFixed() && conversionOptions.getUpdatePDFAMetadataOnPartialConversion())) {
                MetadataProcessor.setPDFA2Info(conformanceLevel, (Metadata)metadata);
                errorCodes.removeAllErrorCodes();
                if (!conversionHandler.pdfaInfoSetInMetadata(conformanceLevel)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (errorCodesXMP.hasErrors() && !validationHandler.docXMPError(errorCodesXMP)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (PDFInvalidParameterException e) {
            errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorMalformedMetadataXML(0, 0));
        }
        catch (PDFInvalidXMLException e) {
            errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorMalformedMetadataXML(0, 0));
        }
        catch (PDFUnableToCompleteOperationException e) {
            errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorPDFAInfoNotPresent(0, 0));
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2DocumentMetadataErrorPDFGeneralFailure(0, 0));
        }
        finally {
            try {
                if (xmpStream != null) {
                    xmpStream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
        if (errorCodes.hasErrors() && !validationHandler.docMetadataError(errorCodes)) {
            return false;
        }
        return validationHandler.endDocMetadataScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processXMPInternal(PDFDocument document, PDFCosDictionary cosDictionary, XMPProcessor xmpProcessor, PDFDictionaryMetadata metadata, TrackingConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, TrackingValidationHandler validationHandler, PDFA2ValidationOptions validationOptions, PDFA2XMPErrorCollector errorCodes, PDFA2ErrorSet<PDFA2AbstractDocumentMetadataErrorCode> errorCodesDocument) throws PDFIOException, PDFSecurityException {
        InputStream xmpStream = null;
        try {
            if (xmpProcessor == null) {
                boolean bl = true;
                return bl;
            }
            Map nsQualifierSet = XMPService.getDocumentMetadata((PDFDocument)document).getNamespaceQualifierSet();
            XMPSchemaUsageValidator.setQualifierMap(nsQualifierSet);
            Set<PDFA2InvalidNamespaceUsage> invalidNamespaceUsageSet = xmpProcessor.getInvalidNamespaceUsage(nsQualifierSet);
            if (!invalidNamespaceUsageSet.isEmpty() && conversionHandler == null) {
                Set<PDFA2InvalidNamespaceUsage> invalidUsageSetForHandler = MetadataProcessor.deepCopyInvalidUsageSet(invalidNamespaceUsageSet);
                validationHandler.invalidNamespaceUsage(invalidUsageSetForHandler);
            }
            Map<String, PDFA2XMPSchema> existingSchemas = xmpProcessor.getEmbeddedSchemas();
            Map<String, PDFA2XMPSchema> referenceSchemas = xmpProcessor.getReferenceSchemas();
            if (conversionHandler != null) {
                PDFA2ExternalSchemas exteralSchemaHolder = conversionOptions.getExternalSchemas();
                Map<String, PDFA2XMPSchema> externalSchemas = exteralSchemaHolder == null ? null : exteralSchemaHolder.getSchemas();
                MetadataProcessor.insertSchemasIntoDocumentXMP(cosDictionary, conversionHandler, invalidNamespaceUsageSet, existingSchemas, externalSchemas, referenceSchemas);
            }
            if (!MetadataProcessor.checkXMPHeader(cosDictionary)) {
                errorCodes.addErrorCode(new PDFA2XMPErrorInvalidXMPHeader(0, 0));
            }
            PDFA2XMPErrorCollector xmpec = new PDFA2XMPErrorCollector();
            XMPTypeValidator typeValidator = new XMPTypeValidator(referenceSchemas, existingSchemas, xmpec);
            xmpStream = conversionHandler != null ? XMPProcessor.getStreamFromInternalXMP(cosDictionary) : XMPProcessor.getStreamFromExternalXMP(cosDictionary);
            if (xmpStream != null) {
                errorCodes.mergeErrorCodes(typeValidator.parse(document, xmpStream, null, cosDictionary.getCosDictionary()));
                if (!typeValidator.isValid()) {
                    boolean xmpFixed = false;
                    if (conversionHandler == null && errorCodes.getErrorCodes().errorCodeSet(PDFA2XMPErrorSchemaUsageNotValid.class) && validationOptions.getRemoveInvalidXMPProperties() && typeValidator.isSchemaUsageIssueFixable()) {
                        XMLElement historyElem = new XMLElement("http://ns.adobe.com/xap/1.0/mm/", "History");
                        if (typeValidator.getInvalidUsage().containsKey(historyElem)) {
                            errorCodes.removeErrorCode("http://ns.adobe.com/xap/1.0/mm/");
                            if (typeValidator.getInvalidUsage().size() == 1) {
                                xmpFixed = true;
                            }
                        }
                    }
                    if (conversionHandler != null && conversionOptions.getRemoveInvalidXMPProperties() && typeValidator.isSchemaUsageIssueFixable()) {
                        HashSet<XMLElement> set = new HashSet<XMLElement>(typeValidator.getInvalidUsage().keySet());
                        InputStream tempXMPStream = null;
                        InputStream xmpInputStream = null;
                        try {
                            tempXMPStream = XMPProcessor.getStreamFromInternalXMP(cosDictionary);
                            OutputByteStream newXMPStream = document.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, 1024L);
                            InputSource xmpSource = new InputSource(tempXMPStream);
                            XMLReader readerbase = XMLUtils.getXMLReader();
                            PDFA2XMLElementsRemover elementRemoverFilter = new PDFA2XMLElementsRemover(readerbase, set, invalidNamespaceUsageSet, errorCodes);
                            elementRemoverFilter.setFeature("http://xml.org/sax/features/namespaces", true);
                            elementRemoverFilter.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                            if (XMLUtils.removeXMLElements(xmpSource, new StreamResult((OutputStream)newXMPStream.toOutputStream()), true, elementRemoverFilter)) {
                                xmpFixed = true;
                                xmpInputStream = newXMPStream.closeAndConvert().toInputStream();
                                metadata.importXMP(xmpInputStream);
                            }
                        }
                        catch (IOException e) {
                            throw new PDFIOException((Throwable)e);
                        }
                        catch (SAXException e) {
                            throw new PDFInvalidXMLException((Throwable)e);
                        }
                        catch (TransformerException e) {
                            throw new PDFInvalidXMLException((Throwable)e);
                        }
                        finally {
                            try {
                                if (tempXMPStream != null) {
                                    tempXMPStream.close();
                                }
                            }
                            catch (IOException e) {
                                throw new PDFIOException((Throwable)e);
                            }
                            try {
                                if (xmpInputStream != null) {
                                    xmpInputStream.close();
                                }
                            }
                            catch (IOException e) {
                                throw new PDFIOException((Throwable)e);
                            }
                        }
                    }
                    if (!xmpFixed && !validationHandler.invalidTypeUsage(typeValidator.getInvalidUsage())) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            MetadataProcessor.addInvalidNameSpaceUsageErrorCodes(invalidNamespaceUsageSet, errorCodes);
        }
        catch (PDFInvalidParameterException e) {
            errorCodes.addErrorCode(new PDFA2XMPErrorMalformedMetadataXML(0, 0));
        }
        catch (PDFInvalidXMLException e) {
            errorCodes.addErrorCode(new PDFA2XMPErrorMalformedMetadataXML(0, 0));
        }
        catch (PDFUnableToCompleteOperationException e) {
            errorCodes.addErrorCode(new PDFA2XMPErrorPDFGeneralFailure(0, 0));
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2XMPErrorPDFGeneralFailure(0, 0));
        }
        catch (XMPException e) {
            if (errorCodesDocument != null) {
                errorCodesDocument.addErrorCode(new PDFA2DocumentMetadataErrorPDFAInfoNotPresent(0, 0));
            } else {
                errorCodes.addErrorCode(new PDFA2XMPErrorPDFGeneralFailure(0, 0));
            }
        }
        finally {
            XMPSchemaUsageValidator.getQualifierMap().clear();
            try {
                if (xmpStream != null) {
                    xmpStream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
        return true;
    }

    public static boolean processXMP(DocumentProcessor docProcesor, PDFDocument document, PDFCosDictionary cosDictionary, PDFA2ConformanceLevel conformanceLevel, TrackingConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, TrackingValidationHandler validationHandler, PDFA2ValidationOptions validationOptions, PDFA2XMPErrorCollector errorCodes) throws PDFIOException, PDFSecurityException {
        try {
            XMPProcessor xmpProcessor = null;
            xmpProcessor = conversionHandler != null ? new XMPProcessor(cosDictionary, docProcesor.globalExplicitSchemas, true) : new XMPProcessor(cosDictionary, docProcesor.globalExplicitSchemas, false);
            PDFDictionaryMetadata metadata = XMPService.getPDFDictionaryMetadata((PDFCosDictionary)cosDictionary, null);
            if (!MetadataProcessor.processXMPInternal(document, cosDictionary, xmpProcessor, metadata, conversionHandler, conversionOptions, validationHandler, validationOptions, errorCodes, null)) {
                return false;
            }
        }
        catch (PDFInvalidParameterException e) {
            errorCodes.addErrorCode(new PDFA2XMPErrorMalformedMetadataXML(0, 0));
        }
        catch (PDFInvalidXMLException e) {
            if (conversionHandler != null) {
                try {
                    cosDictionary.setMetadata(null);
                }
                catch (PDFInvalidDocumentException e1) {
                    errorCodes.addErrorCode(new PDFA2XMPErrorPDFGeneralFailure(0, 0));
                }
            } else {
                errorCodes.addErrorCode(new PDFA2XMPErrorMalformedMetadataXML(0, 0));
            }
        }
        catch (PDFUnableToCompleteOperationException e) {
            errorCodes.addErrorCode(new PDFA2XMPErrorPDFGeneralFailure(0, 0));
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2XMPErrorPDFGeneralFailure(0, 0));
        }
        catch (PDFConfigurationException e) {
            errorCodes.addErrorCode(new PDFA2XMPErrorPDFGeneralFailure(0, 0));
        }
        return true;
    }

    static void addInvalidNameSpaceUsageErrorCodes(Set<PDFA2InvalidNamespaceUsage> invalidNamespaceUsageSet, PDFA2XMPErrorCollector errorCodes) {
        if (!invalidNamespaceUsageSet.isEmpty()) {
            for (PDFA2InvalidNamespaceUsage invalidNamespace : invalidNamespaceUsageSet) {
                if (!invalidNamespace.prefixError()) continue;
                errorCodes.addErrorCode(new PDFA2XMPErrorInvalidPrefix(0, 0));
            }
        }
    }

    private static void setPDFA2Info(PDFA2ConformanceLevel conformanceLevel, Metadata metadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidXMLException {
        String part = "2";
        String conformance = "B";
        if (conformanceLevel == PDFA2ConformanceLevel.Level_2a) {
            part = "2";
            conformance = "A";
        } else if (conformanceLevel == PDFA2ConformanceLevel.Level_2b) {
            part = "2";
            conformance = "B";
        } else if (conformanceLevel == PDFA2ConformanceLevel.Level_2u) {
            part = "2";
            conformance = "U";
        } else if (conformanceLevel == PDFA2ConformanceLevel.Level_3a) {
            part = "3";
            conformance = "A";
        } else if (conformanceLevel == PDFA2ConformanceLevel.Level_3b) {
            part = "3";
            conformance = "B";
        } else if (conformanceLevel == PDFA2ConformanceLevel.Level_3u) {
            part = "3";
            conformance = "U";
        }
        metadata.addProperty(NS_PDFA2_ID, "part", part);
        metadata.addProperty(NS_PDFA2_ID, "conformance", conformance);
    }

    public static String getVersion(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        try {
            return XMPService.getDocumentMetadata((PDFDocument)document).getProperty(NS_PDFA2_ID, "part");
        }
        catch (PDFUnableToCompleteOperationException e) {
            return null;
        }
    }

    public static String getConformanceLevel(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        try {
            return XMPService.getDocumentMetadata((PDFDocument)document).getProperty(NS_PDFA2_ID, "conformance");
        }
        catch (PDFUnableToCompleteOperationException e) {
            return null;
        }
    }

    public static String getAmendmentID(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        try {
            return XMPService.getDocumentMetadata((PDFDocument)document).getProperty(NS_PDFA2_ID, "amd");
        }
        catch (PDFUnableToCompleteOperationException e) {
            return null;
        }
    }

    private static boolean checkXMPHeader(PDFCosDictionary cosDictionary) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFDictionaryMetadata metadata = XMPService.getPDFDictionaryMetadata((PDFCosDictionary)cosDictionary, null);
        String[] headerAttributes = metadata.getHeaderAttributesAsArray();
        return MetadataProcessor.checkXMPHeader(headerAttributes);
    }

    private static boolean checkXMPHeader(String[] headerAttributes) {
        for (String attribute : headerAttributes) {
            Matcher invalidAttributeMatcher = INVALID_HEADER_ATTRIBUTES_REGEX.matcher(attribute);
            if (!invalidAttributeMatcher.find()) continue;
            return false;
        }
        return true;
    }

    static boolean insertSchemasIntoDocumentXMP(PDFCosDictionary cosDict, PDFA2ConversionHandler conversionHandler, Set<PDFA2InvalidNamespaceUsage> invalidUsageSet, Map<String, PDFA2XMPSchema> existingSchemas, Map<String, PDFA2XMPSchema> externalSchemas, Map<String, PDFA2XMPSchema> referenceSchemas) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        boolean xmpHadSchemas = !existingSchemas.isEmpty();
        ArrayList<PDFA2XMPSchema> schemasToAdd = new ArrayList<PDFA2XMPSchema>();
        PDFDocument pdfDocument = cosDict.getPDFDocument();
        if (pdfDocument == null) {
            throw new PDFInvalidDocumentException("No PDF document to process.");
        }
        PDFMetadata pdfMeta = cosDict.getMetadata();
        long originalXMPSize = pdfMeta == null ? 0L : pdfMeta.getLength();
        StreamManager streamManager = pdfDocument.getStreamManager();
        PDFA2XMPSchema pdfxSchema = MetadataProcessor.addDocInfoCustomToSchema(pdfDocument, new PDFA2XMPSchema(PDFX_SCHEMA));
        if (cosDict instanceof PDFCatalog) {
            schemasToAdd.add(pdfxSchema);
            PDFA2InvalidNamespaceUsage xmpMM_copy = new PDFA2InvalidNamespaceUsage(XMPMM_USAGE);
            invalidUsageSet.add(xmpMM_copy);
        }
        Iterator<PDFA2InvalidNamespaceUsage> invalidUsageIter = invalidUsageSet.iterator();
        while (invalidUsageIter.hasNext()) {
            PDFA2InvalidNamespaceUsage invalidNamespace = invalidUsageIter.next();
            for (PDFA2XMPSchema knownSchema : INSERTION_SCHEMAS) {
                if (!invalidNamespace.removeSchema(knownSchema)) continue;
                schemasToAdd.add(knownSchema);
            }
            invalidNamespace.removeSchema(pdfxSchema);
            if (externalSchemas != null) {
                for (PDFA2XMPSchema knownSchema : externalSchemas.values()) {
                    if (!invalidNamespace.removeSchema(knownSchema)) continue;
                    schemasToAdd.add(knownSchema);
                }
            }
            if (!invalidNamespace.areErrorsCleared()) continue;
            invalidUsageIter.remove();
        }
        if (schemasToAdd.isEmpty()) {
            return true;
        }
        for (PDFA2XMPSchema schema : schemasToAdd) {
            PDFA2XMPSchema referenceSchema = referenceSchemas.get(schema.getURI());
            if (referenceSchema == null) {
                referenceSchemas.put(schema.getURI(), new PDFA2XMPSchema(schema));
                continue;
            }
            referenceSchema.mergeSchema(schema);
            referenceSchemas.put(schema.getURI(), referenceSchema);
        }
        Set<PDFA2InvalidNamespaceUsage> invalidUsageSetForHandler = MetadataProcessor.deepCopyInvalidUsageSet(invalidUsageSet);
        if (!conversionHandler.schemasForInsertion(invalidUsageSetForHandler, schemasToAdd)) {
            return false;
        }
        Set<PDFA2XMPSchema> mergedSchemas = MetadataProcessor.mergeSchemas(existingSchemas, schemasToAdd);
        OutputByteStream xmpOBS = null;
        SkippingOutputStream xmpOS = null;
        InputByteStream xmpIBS = null;
        InputStream xmpIS = null;
        OutputByteStream newXmpOBS = null;
        OutputStream newXmpOS = null;
        InputByteStream newXmpIBS = null;
        InputStream newXmpIS = null;
        try {
            xmpOBS = streamManager.getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, originalXMPSize);
            xmpOS = xmpOBS.toOutputStream();
            Object metadata = null;
            metadata = cosDict instanceof PDFCatalog ? XMPService.getDocumentMetadata((PDFDocument)pdfDocument) : XMPService.getPDFDictionaryMetadata((PDFCosDictionary)cosDict, null);
            metadata.exportXMP((OutputStream)xmpOS);
            xmpIBS = xmpOBS.closeAndConvert();
            xmpOBS = null;
            xmpOS.close();
            xmpOS = null;
            xmpIS = xmpIBS.toInputStream();
            InputSource xmpSource = new InputSource(xmpIS);
            newXmpOBS = streamManager.getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, originalXMPSize);
            newXmpOS = newXmpOBS.toOutputStream();
            StreamResult newXmpResult = new StreamResult(newXmpOS);
            SchemaInserter inserter = new SchemaInserter(mergedSchemas, xmpHadSchemas);
            try {
                XMLUtils.applyXMLFilter(xmpSource, inserter, newXmpResult, false);
            }
            catch (SAXException e) {
                throw new PDFUnableToCompleteOperationException("Error with XML reader or feature set.", (Throwable)e);
            }
            catch (TransformerException e) {
                throw new PDFUnableToCompleteOperationException("Error XML content.", (Throwable)e);
            }
            newXmpIBS = newXmpOBS.closeAndConvert();
            newXmpOBS = null;
            newXmpIS = newXmpIBS.toInputStream();
            metadata.importXMP(newXmpIS);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            try {
                if (xmpOBS != null) {
                    xmpOBS.close();
                }
                if (xmpOS != null) {
                    xmpOS.close();
                }
                if (xmpIBS != null) {
                    xmpIBS.close();
                }
                if (xmpIS != null) {
                    xmpIS.close();
                }
                if (newXmpOBS != null) {
                    newXmpOBS.close();
                }
                if (newXmpOS != null) {
                    newXmpOS.close();
                }
                if (newXmpIBS != null) {
                    newXmpIBS.close();
                }
                if (newXmpIS != null) {
                    newXmpIS.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException("Error during stream closure.", (Throwable)e);
            }
        }
        return true;
    }

    private static Set<PDFA2XMPSchema> mergeSchemas(Map<String, PDFA2XMPSchema> baseSchemaSet, List<PDFA2XMPSchema> ... addSchemaSets) {
        for (List<PDFA2XMPSchema> addSchemaSet : addSchemaSets) {
            for (PDFA2XMPSchema addSchema : addSchemaSet) {
                PDFA2XMPSchema baseSchema = baseSchemaSet.get(addSchema.getURI());
                if (baseSchema != null) {
                    baseSchema.mergeSchema(addSchema);
                    continue;
                }
                baseSchemaSet.put(addSchema.getURI(), addSchema);
            }
        }
        HashSet<PDFA2XMPSchema> mergeSet = new HashSet<PDFA2XMPSchema>();
        mergeSet.addAll(baseSchemaSet.values());
        return mergeSet;
    }

    private static PDFA2XMPSchema addDocInfoCustomToSchema(PDFDocument pdfDocument, PDFA2XMPSchema schema) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        DocumentMetadata metadata = XMPService.getDocumentMetadata((PDFDocument)pdfDocument);
        List customNames = metadata.getCustomPropertyNames();
        Iterator namesIter = customNames.iterator();
        if (!namesIter.hasNext()) {
            return schema;
        }
        while (namesIter.hasNext()) {
            PDFA2XMPSchema.PDFA2XMPProperty property = new PDFA2XMPSchema.PDFA2XMPProperty((String)namesIter.next(), DOC_INFO_CUSTOM_TYPE, PDFA2XMPSchema.PDFA2XMPProperty.Category.INTERNAL, DOC_INFO_CUSTOM_DESCRIPTION);
            schema.addProperty(property);
        }
        return schema;
    }

    private static Set<PDFA2InvalidNamespaceUsage> deepCopyInvalidUsageSet(Set<PDFA2InvalidNamespaceUsage> originalSet) {
        HashSet<PDFA2InvalidNamespaceUsage> copySet = new HashSet<PDFA2InvalidNamespaceUsage>(originalSet.size());
        for (PDFA2InvalidNamespaceUsage invalidNamespace : originalSet) {
            PDFA2InvalidNamespaceUsage copy = new PDFA2InvalidNamespaceUsage((XMLNamespaceUsage)invalidNamespace);
            copySet.add(copy);
        }
        return copySet;
    }

    private static boolean checkDocInfoConformance(DocumentMetadata.DocInfoConformanceState.EntryConformanceState conformanceState) {
        boolean conforms = true;
        if (conformanceState == null) {
            return false;
        }
        if (conformanceState.getDocInfoEntryExists()) {
            if (!conformanceState.getXMPEntryExists()) {
                conforms = false;
            } else if (!conformanceState.getBothEqual()) {
                conforms = false;
            }
        }
        return conforms;
    }

    static {
        PDFA2XMPSchema.PDFA2XMPProperty property = new PDFA2XMPSchema.PDFA2XMPProperty("Trapped", DOC_INFO_CUSTOM_TYPE, PDFA2XMPSchema.PDFA2XMPProperty.Category.INTERNAL, "A name object indicating whether the document has been modified to include trapping information");
        PDF_SCHEMA.addProperty(property);
        XMPMM_SCHEMA = new PDFA2XMPSchema("http://ns.adobe.com/xap/1.0/mm/", "xmpMM", "The XMP Media Management Schema is primarily for use by digital asset management (DAM) systems.");
        property = new PDFA2XMPSchema.PDFA2XMPProperty("InstanceID", "URI", PDFA2XMPSchema.PDFA2XMPProperty.Category.INTERNAL, "UUID based identifier for specific incarnation of a document");
        XMPMM_SCHEMA.addProperty(property);
        XMPMM_USAGE = new XMLNamespaceUsage("http://ns.adobe.com/xap/1.0/mm/");
        XMPMM_USAGE.addPrefix("xmpMM");
        XMPMM_USAGE.addElement("InstanceID");
        PDFX_SCHEMA = new PDFA2XMPSchema("http://ns.adobe.com/pdfx/1.3/", "pdfx", "PDF Extension schema");
        PDFX_SCHEMA.setDescription("PDF/X ID Schema");
        property = new PDFA2XMPSchema.PDFA2XMPProperty("GTS_PDFXVersion", DOC_INFO_CUSTOM_TYPE, PDFA2XMPSchema.PDFA2XMPProperty.Category.INTERNAL, "ID of PDF/X standard");
        PDFX_SCHEMA.addProperty(property);
        property = new PDFA2XMPSchema.PDFA2XMPProperty("GTS_PDFXConformance", DOC_INFO_CUSTOM_TYPE, PDFA2XMPSchema.PDFA2XMPProperty.Category.INTERNAL, "Conformance level of PDF/X standard");
        PDFX_SCHEMA.addProperty(property);
        INSERTION_SCHEMAS = new ArrayList<PDFA2XMPSchema>();
        INSERTION_SCHEMAS.add(PDF_SCHEMA);
        INSERTION_SCHEMAS.add(XMPMM_SCHEMA);
        INSERTION_SCHEMAS.add(PDFX_SCHEMA);
    }
}

