/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.cos.REPAIRTYPE;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosNumberParseRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosUnexpectedTypeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.FilterStream;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralDispatcher;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralTraverser;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.core.util.ParseOps;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFileStructureErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorCryptDecodeFilterPresentWithoutIdentity;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEndobjKwdNotFollowedByEOL;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEndobjKwdNotPrecededByEOL;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorEndstreamNotPrecededByEOL;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorHeaderCommentNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorHeaderPercentCharPosNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorHeaderVersionInvalid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorHexStrEvenNumCharsNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorIncorrectSpaceBtwObjKwdAndGenNum;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorIncorrectSpaceBtwObjNumAndGenNum;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorIndirectObjectNumberIncorrect;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorIntegerNumberValueTooHigh;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorIntegerNumberValueTooLow;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorLZWDecodeFilterPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorNameLengthIncorrect;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorNegativeValueTooCloseToZero;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorNonStandardFilterUsed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorObjKwdNotFollowedByEOL;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorObjectNumberNotPrecededByEOL;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorObjectNumberPrecededByMultipleEOL;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorPositiveValueTooCloseToZero;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorRealNumberValueTooHigh;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorRealNumberValueTooLow;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorStreamDLKeyInvalid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorStreamEOLMarkerNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorStreamFDecodeParamsKeyPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorStreamFFilterKeyPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorStreamFKeyPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorStreamLengthIncorrect;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorStreamSuffixCharsNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorStringLengthIncorrect;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorTrailerAdditionalDataPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorTrailerEncryptKwdPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorTrailerIDKwdNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorXRefTableEOLMarkerNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrorXrefTableDamagedNeedsRepair;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FileStructureErrormisMatchedKeyValuePairsInDict;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.EmbeddedFileProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.PDFA2ErrorFlags;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.PDFA2SaveModes;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ParserUtils;
import com.adobe.internal.util.ArrayListStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

class FileStructureProcessor {
    private static final int NUM_INDIRECT_OBJECTS = 0x7FFFFF;
    static final int MAX_LENGTH_STRING = Short.MAX_VALUE;
    static final double MIN_FLOAT_APPROACHING_TO_ZERO = 1.175E-38;
    private static final boolean DEBUG = false;
    private static final HashMap<ASName, SupportedFilters> nameToEnumMapping = new HashMap();

    FileStructureProcessor() {
    }

    public static boolean validate(PDFDocument doc, PDFA2ConformanceLevel conformanceLevel, PDFA2ValidationOptions validationOptions, PDFA2ValidationHandler validationHandler, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, HashSet<CosObject> associatedFileSpecList) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (doc == null) {
            return true;
        }
        if (!validationHandler.beginFileStructureScan()) {
            return false;
        }
        PDFA2ErrorFlags flags = new PDFA2ErrorFlags();
        if (conversionHandler == null) {
            flags.fixableErrors = null;
        }
        CosDocument cosDoc = doc.getCosDocument();
        boolean objectsFreed = false;
        if (conversionHandler != null) {
            try {
                objectsFreed = cosDoc.freeUnreferencedObjects();
            }
            catch (PDFCosParseException e) {
                throw new PDFInvalidDocumentException("Exception encountered while freeing unreferenced cos objects.", (Throwable)e);
            }
        }
        InputByteStream buf = cosDoc.getStream();
        try {
            long bufferPos = buf.getPosition();
            FileStructureProcessor.validateFileHeader(buf, cosDoc, flags);
            buf.seek(bufferPos);
            bufferPos = buf.getPosition();
            FileStructureProcessor.validateFileTrailer(buf, cosDoc, flags);
            buf.seek(bufferPos);
            bufferPos = buf.getPosition();
            FileStructureProcessor.validateCrossRefTable(cosDoc, buf, flags);
            buf.seek(bufferPos);
            bufferPos = buf.getPosition();
            FileStructureProcessor.validateCosObjects(cosDoc, flags);
            buf.seek(bufferPos);
            bufferPos = buf.getPosition();
            if (!FileStructureProcessor.validateStreamObjects(buf, cosDoc, flags, validationHandler, conversionHandler, conversionOptions, conformanceLevel, associatedFileSpecList)) {
                return false;
            }
            buf.seek(bufferPos);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        PDFA2SaveModes saveOptions = new PDFA2SaveModes();
        try {
            saveOptions = FileStructureProcessor.computeSaveOptions(doc, flags.errorsFound, validationOptions, objectsFreed);
        }
        catch (PDFInvalidDocumentException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(0, 0));
        }
        if (conversionHandler != null) {
            if (!conversionHandler.fileStructureErrorsFixed(flags.errorsFound, flags.fixableErrors)) {
                return false;
            }
            PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> unfixableErrors = flags.getUnFixableErrors();
            if (unfixableErrors.hasErrors() && !conversionHandler.fileStructureError(flags.getUnFixableErrors())) {
                return false;
            }
        } else if (flags.errorsFound.hasErrors() && !validationHandler.fileStructureError(flags.errorsFound)) {
            return false;
        }
        return validationHandler.endFileStructureScan(PDFA2SaveModes.convertToSaveType(saveOptions));
    }

    private static PDFA2SaveModes computeSaveOptions(PDFDocument pdfDoc, PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> flags, PDFA2ValidationOptions validationOptions, boolean objectsFreed) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFA2SaveModes options = new PDFA2SaveModes();
        PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> errors = flags;
        if (validationOptions.checkDocVersion() && pdfDoc.getOriginalVersion().greaterThan(PDFVersion.v1_7)) {
            options.removeOptions(1);
            options.appendOptions(8);
        }
        if (errors.errorCodeSet(PDFA2FileStructureErrorHeaderCommentNotPresent.class) || errors.errorCodeSet(PDFA2FileStructureErrorHeaderPercentCharPosNotAllowed.class) || errors.errorCodeSet(PDFA2FileStructureErrorHeaderVersionInvalid.class)) {
            options.removeOptions(1);
            options.appendOptions(8);
        }
        if (errors.errorCodeSet(PDFA2FileStructureErrorTrailerAdditionalDataPresent.class) || errors.errorCodeSet(PDFA2FileStructureErrorTrailerEncryptKwdPresent.class) || errors.errorCodeSet(PDFA2FileStructureErrorTrailerIDKwdNotPresent.class)) {
            options.removeOptions(1);
            options.appendOptions(8);
        }
        if (errors.errorCodeSet(PDFA2FileStructureErrorXRefTableEOLMarkerNotPresent.class)) {
            options.removeOptions(1);
            options.appendOptions(8);
        }
        if (errors.errorCodeSet(PDFA2FileStructureErrorStreamEOLMarkerNotPresent.class) || errors.errorCodeSet(PDFA2FileStructureErrorStreamSuffixCharsNotAllowed.class) || errors.errorCodeSet(PDFA2FileStructureErrorStreamLengthIncorrect.class) || errors.errorCodeSet(PDFA2FileStructureErrorEndstreamNotPrecededByEOL.class)) {
            options.removeOptions(1);
            options.appendOptions(8);
        }
        if (errors.errorCodeSet(PDFA2FileStructureErrorEndobjKwdNotFollowedByEOL.class) || errors.errorCodeSet(PDFA2FileStructureErrorObjectNumberNotPrecededByEOL.class) || errors.errorCodeSet(PDFA2FileStructureErrorEndobjKwdNotPrecededByEOL.class) || errors.errorCodeSet(PDFA2FileStructureErrorObjKwdNotFollowedByEOL.class) || errors.errorCodeSet(PDFA2FileStructureErrorIncorrectSpaceBtwObjKwdAndGenNum.class) || errors.errorCodeSet(PDFA2FileStructureErrorIncorrectSpaceBtwObjNumAndGenNum.class)) {
            options.removeOptions(1);
            options.appendOptions(8);
        }
        if (errors.errorCodeSet(PDFA2FileStructureErrorHexStrEvenNumCharsNotPresent.class)) {
            options.removeOptions(1);
            options.appendOptions(8);
        }
        if (errors.errorCodeSet(PDFA2FileStructureErrorStreamFDecodeParamsKeyPresent.class) || errors.errorCodeSet(PDFA2FileStructureErrorStreamFFilterKeyPresent.class) || errors.errorCodeSet(PDFA2FileStructureErrorStreamFKeyPresent.class)) {
            options.removeAllSaveOptions();
        }
        if (errors.errorCodeSet(PDFA2FileStructureErrorIndirectObjectNumberIncorrect.class) || errors.errorCodeSet(PDFA2FileStructureErrorIntegerNumberValueTooHigh.class) || errors.errorCodeSet(PDFA2FileStructureErrorIntegerNumberValueTooLow.class) || errors.errorCodeSet(PDFA2FileStructureErrorRealNumberValueTooHigh.class) || errors.errorCodeSet(PDFA2FileStructureErrorRealNumberValueTooLow.class) || errors.errorCodeSet(PDFA2FileStructureErrorPositiveValueTooCloseToZero.class) || errors.errorCodeSet(PDFA2FileStructureErrorNegativeValueTooCloseToZero.class) || errors.errorCodeSet(PDFA2FileStructureErrorStringLengthIncorrect.class) || errors.errorCodeSet(PDFA2FileStructureErrorNameLengthIncorrect.class)) {
            options.removeAllSaveOptions();
        }
        if (objectsFreed) {
            options.removeOptions(1);
        }
        if (pdfDoc.getCosDocument().isLinearized() && options.modeSet(1)) {
            options.removeOptions(1);
            options.setLinearizationBlockingIncSave(true);
        }
        return options;
    }

    private static void validateFileTrailer(InputByteStream buf, CosDocument cosDoc, PDFA2ErrorFlags flags) throws PDFIOException, IOException, PDFSecurityException {
        int objectNumber = 0;
        int genNumber = 0;
        try {
            FileStructureProcessor.validateHexStringsInTrailer(cosDoc.getTrailerList(), flags);
            CosDictionary trailer = cosDoc.getTrailer();
            objectNumber = trailer.getObjNum();
            genNumber = trailer.getObjGen();
            if (!trailer.containsKey((Object)ASName.k_ID)) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorTrailerIDKwdNotPresent(objectNumber, genNumber), "ID keyword not present in File Trailer");
            }
            if (trailer.containsKey((Object)ASName.k_Encrypt)) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorTrailerEncryptKwdPresent(objectNumber, genNumber), "Encrypt keyword present in File Trailer");
            }
            long eofpos = ParserUtils.getEOFPosition(buf);
            buf.seek(eofpos + 5L);
            byte cur = (byte)buf.read();
            if (cur == -1) {
                return;
            }
            if (cur == 13) {
                cur = (byte)buf.read();
                if (cur == -1) {
                    return;
                }
                if (cur != 10) {
                    FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorTrailerAdditionalDataPresent(objectNumber, genNumber), "Invalid Trailer: Trailer Trash Count > 0. Value = " + cosDoc.getTrailerTrashCount());
                    return;
                }
            } else if (cur != 10) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorTrailerAdditionalDataPresent(objectNumber, genNumber), "Invalid Trailer: Trailer Trash Count > 0. Value = " + cosDoc.getTrailerTrashCount());
                return;
            }
            if ((byte)buf.read() != -1) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorTrailerAdditionalDataPresent(objectNumber, genNumber), "Invalid Trailer: Trailer Trash Count > 0. Value = " + cosDoc.getTrailerTrashCount());
            }
        }
        catch (PDFCosParseException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(objectNumber, genNumber));
        }
    }

    private static void validateHexStringsInTrailer(CosDictionary[] trailerDicts, PDFA2ErrorFlags flags) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (trailerDicts != null) {
            for (int i = 0; i < trailerDicts.length; ++i) {
                FileStructureProcessor.checkDocIDHexStrings(trailerDicts[i], flags);
            }
        }
    }

    private static void checkDocIDHexStrings(CosDictionary trailerDict, PDFA2ErrorFlags flags) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray docIDArray;
        CosObject docIDTrailerEntry = trailerDict.get(ASName.k_ID);
        if (docIDTrailerEntry != null && docIDTrailerEntry instanceof CosArray && (docIDArray = (CosArray)trailerDict.get(ASName.k_ID)) != null) {
            FileStructureProcessor.checkOddBallHexStrings(docIDArray.getCosString(0), flags);
            FileStructureProcessor.checkOddBallHexStrings(docIDArray.getCosString(1), flags);
        }
    }

    private static void validateFileHeader(InputByteStream buf, CosDocument cosDoc, PDFA2ErrorFlags flags) throws PDFIOException, IOException {
        if (!FileStructureProcessor.isFileHeaderPercentCharPresentAtOffsetZero(cosDoc)) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorHeaderPercentCharPosNotAllowed(0, 0), "Header InValid: Header trash count = " + cosDoc.getHeaderTrashCount());
        } else {
            FileStructureProcessor.printDebugMsg("Header Valid: Header at 0 offset.");
        }
        FileStructureProcessor.validateHeaderVersion(buf, flags);
        byte charAfterHeaderString = (byte)ParserUtils.peekAtPos(buf, 8L);
        if (!ParserUtils.isEOLChar(charAfterHeaderString)) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorHeaderCommentNotPresent(0, 0), "Header Invalid: Second Line is not comment with 4 chars. There is some char after the %PDF-m.n");
        }
        ParserUtils.readLine(buf);
        if (!FileStructureProcessor.validateSecondLine(buf)) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorHeaderCommentNotPresent(0, 0), "Header Invalid: Second Line is not comment with at least 4 chars");
        } else {
            FileStructureProcessor.printDebugMsg("Header Valid: Second Line is comment with at least 4 chars");
        }
    }

    private static boolean validateSecondLine(InputByteStream buf) throws IOException {
        byte b = (byte)buf.read();
        if (b != 37) {
            return false;
        }
        int i = b & 0xFF;
        for (int j = 0; j < 4; ++j) {
            b = (byte)buf.read();
            i = b & 0xFF;
            if (i > 127) continue;
            return false;
        }
        return true;
    }

    private static void validateHeaderVersion(InputByteStream buf, PDFA2ErrorFlags flags) throws IOException {
        int versionNumber = 0;
        if (!ParserUtils.peekAndCheckAtPos(buf, "1.", 5L) || !Character.isDigit(versionNumber = ParserUtils.peekAtPos(buf, 7L)) || (versionNumber = Character.getNumericValue(versionNumber)) < 0 || versionNumber > 7) {
            long origPos = buf.getPosition();
            buf.seek(5L);
            String version = ParserUtils.readString(buf, 3);
            buf.seek(origPos);
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorHeaderVersionInvalid(version, 0, 0), "Header Invalid: Header version is not between 1.0 and 1.7");
        } else {
            FileStructureProcessor.printDebugMsg("Header Valid: Header version is between 1.0 and 1.7");
        }
    }

    private static boolean isFileHeaderPercentCharPresentAtOffsetZero(CosDocument cosDoc) throws IOException {
        return cosDoc.getHeaderTrashCount() <= 0;
    }

    private static void addErrorCode(PDFA2ErrorFlags flags, boolean fixable, PDFA2AbstractFileStructureErrorCode errorCode, String debugMsg) {
        flags.errorsFound.addErrorCode(errorCode);
        if (debugMsg != null) {
            FileStructureProcessor.printDebugMsg(debugMsg);
        }
        if (fixable && flags.fixableErrors != null) {
            flags.fixableErrors.addErrorCode(errorCode);
        }
    }

    private static void validateCrossRefTable(CosDocument cosDoc, InputByteStream buf, PDFA2ErrorFlags flags) throws PDFIOException, IOException {
        try {
            long lastXrefOffset = ParserUtils.getLastXRefSectionPosition(buf);
            FileStructureProcessor.validateEOLAfterXrefKwd(lastXrefOffset, buf, flags);
            if (cosDoc.getRepairTypes().contains(REPAIRTYPE.xrefRepair)) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorXrefTableDamagedNeedsRepair(0, 0), "CrossRef Table is damaged, Needs Repair");
            }
            CosDictionary[] trailers = cosDoc.getTrailerList();
            for (int i = 0; i < trailers.length; ++i) {
                CosObject prevXrefOffset = trailers[i].get(ASName.k_Prev);
                if (trailers[i] == null || !(prevXrefOffset instanceof CosNumeric)) continue;
                long xrefPos = ((CosNumeric)prevXrefOffset).longValue();
                FileStructureProcessor.validateEOLAfterXrefKwd(xrefPos, buf, flags);
            }
            FileStructureProcessor.printDebugMsg("Finished xref scan");
        }
        catch (PDFCosParseException e) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorPDFGeneralFailure(0, 0), "Problem While validating Xref tables.");
        }
        catch (PDFSecurityException e) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorPDFGeneralFailure(0, 0), "Problem While validating Xref tables.");
        }
    }

    private static void validateEOLAfterXrefKwd(long xrefPos, InputByteStream buf, PDFA2ErrorFlags flags) throws IOException {
        buf.seek(xrefPos);
        ParserUtils.skipWhiteCharacters(buf);
        if (ParserUtils.readAndCheck(buf, "xref")) {
            long curPos = buf.getPosition();
            if (ParserUtils.peekAtPos(buf, curPos) == 13) {
                if (ParserUtils.peekAtPos(buf, ++curPos) != 10) {
                    --curPos;
                }
            } else if (ParserUtils.peekAtPos(buf, curPos) != 10) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorXRefTableEOLMarkerNotPresent(0, 0), "CrossRefTable Invalid: xref not followed by eol");
            }
            buf.seek(++curPos);
            try {
                ParserUtils.readNumber(buf, (byte)43, true);
            }
            catch (PDFCosParseException e) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorXRefTableEOLMarkerNotPresent(0, 0), "CrossRefTable Invalid: xref<eol> not followed by number");
            }
        }
    }

    private static void validateCosObjects(CosDocument cosDoc, PDFA2ErrorFlags flags) throws IOException, PDFIOException, PDFSecurityException {
        FileStructureProcessor fp;
        FileStructureProcessor fileStructureProcessor = fp = new FileStructureProcessor();
        fileStructureProcessor.getClass();
        LocalDispatcher dispatcher = fileStructureProcessor.new LocalDispatcher(flags);
        GeneralTraverser traverser = new GeneralTraverser((GeneralDispatcher)dispatcher);
        try {
            CosDictionary root = cosDoc.getRoot();
            traverser.traverseCosGraph((CosContainer)root, null);
            CosDictionary docInfo = cosDoc.getInfo();
            if (docInfo != null) {
                traverser.traverseCosGraph((CosContainer)docInfo, null);
            }
        }
        catch (PDFInvalidDocumentException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(0, 0));
        }
        catch (PDFInvalidParameterException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(0, 0));
        }
        catch (PDFFontException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(0, 0));
        }
        catch (PDFCosNumberParseRuntimeException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(0, 0));
        }
    }

    private static boolean validateStreamObjects(InputByteStream buf, CosDocument cosDoc, PDFA2ErrorFlags flags, PDFA2ValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, PDFA2ConformanceLevel level, HashSet<CosObject> associatedFileSpecList) throws PDFIOException, PDFSecurityException, IOException {
        try {
            int numIndirectObjects = 0;
            int nObjects = cosDoc.getNumObjects();
            for (int j = 0; j < nObjects; ++j) {
                CosObject cosObj = cosDoc.getIndirectObjectByNumber(j);
                if (cosObj == null) continue;
                ++numIndirectObjects;
                if (!cosObj.isDirty()) {
                    FileStructureProcessor.validateIndirectObject(cosObj, flags);
                }
                if (cosObj instanceof CosStream) {
                    CosStream streamObj = (CosStream)cosObj;
                    long beginOfStream = streamObj.getObjPos();
                    Integer streamLength = streamObj.getInt(ASName.k_Length);
                    if (streamLength == null) {
                        throw new PDFInvalidDocumentException("Stream does not contain length entry.");
                    }
                    long dataOffset = streamObj.getStreamDataOffset();
                    long streamEndPos = 0L;
                    if (!cosObj.isDirty() && !FileStructureProcessor.validateStreamDLKey(streamObj, buf, beginOfStream + dataOffset, streamEndPos = FileStructureProcessor.validateStream(streamObj, buf, beginOfStream, streamLength.intValue(), flags, dataOffset), flags, conversionOptions, conversionHandler)) {
                        return false;
                    }
                    FileStructureProcessor.validateStreamFilters(streamObj, flags, conversionOptions, conversionHandler);
                    FileStructureProcessor.validateCosStreamDictKeys(streamObj, flags);
                }
                EmbeddedFileProcessor.getInstance(level).process(cosObj, flags.errorsFound, validationHandler, conversionHandler, associatedFileSpecList);
            }
            FileStructureProcessor.validateNumIndirectObjects(numIndirectObjects, flags);
        }
        catch (PDFCosUnexpectedTypeException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(0, 0));
        }
        catch (PDFInvalidDocumentException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(0, 0));
        }
        return true;
    }

    private static void validateIndirectObject(CosObject cosObj, PDFA2ErrorFlags flags) throws PDFIOException, PDFCosParseException, PDFSecurityException {
        try {
            byte inp;
            Number genno;
            Number objno;
            InputByteStream mBuf = cosObj.getDocument().getStream();
            long beginOfObjStream = cosObj.getObjPos();
            if (beginOfObjStream == 0L) {
                return;
            }
            mBuf.seek(beginOfObjStream);
            int objectNumber = cosObj.getObjNum();
            int genNumber = cosObj.getObjGen();
            if (!ParserUtils.isPreviousCharEOL(mBuf)) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorObjectNumberNotPrecededByEOL(objectNumber, genNumber), "IndirectObj Invalid: Indirect Obj not preceeded by EOL");
            }
            while (ParserUtils.skipEOL(mBuf)) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorObjectNumberPrecededByMultipleEOL(objectNumber, genNumber), "IndirectObj Invalid: Indirect Obj preceeded by multiple EOL");
            }
            while (ByteOps.isWhitespace((byte)((byte)ParserUtils.peek(mBuf)))) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorObjectNumberNotPrecededByEOL(objectNumber, genNumber), "IndirectObj Invalid: Indirect Obj not preceeded by EOL");
                mBuf.read();
            }
            try {
                objno = ParserUtils.readNumber(mBuf, (byte)43, true);
            }
            catch (PDFCosParseException e) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: First string is not a number in this object");
                if (flags.fixableErrors == null) {
                    flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(objectNumber, genNumber));
                }
                return;
            }
            if (!ParserUtils.readAndCheck(mBuf, (byte)32)) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorIncorrectSpaceBtwObjNumAndGenNum(objectNumber, genNumber), "IndirectObj Invalid: <num> not followed by single space");
            }
            while (ByteOps.isWhitespace((byte)((byte)ParserUtils.peek(mBuf)))) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorIncorrectSpaceBtwObjNumAndGenNum(objectNumber, genNumber), "IndirectObj Invalid: <num> not followed by single space");
                mBuf.read();
            }
            try {
                genno = ParserUtils.readNumber(mBuf, (byte)43, true);
            }
            catch (PDFCosParseException e) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: Number did not follow the space");
                if (flags.fixableErrors == null) {
                    flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(objectNumber, genNumber));
                }
                return;
            }
            if (!ParserUtils.readAndCheck(mBuf, (byte)32)) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorIncorrectSpaceBtwObjKwdAndGenNum(objectNumber, genNumber), "IndirectObj Invalid: <genno> not followed by space");
            }
            while (ByteOps.isWhitespace((byte)((byte)ParserUtils.peek(mBuf)))) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorIncorrectSpaceBtwObjKwdAndGenNum(objectNumber, genNumber), "IndirectObj Invalid: <genno> not followed by space");
                mBuf.read();
            }
            if (!ParserUtils.readAndCheck(mBuf, "obj")) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorIncorrectSpaceBtwObjKwdAndGenNum(objectNumber, genNumber), "IndirectObj Invalid: <genno><space> not followed by obj");
            }
            if (!ParserUtils.isEOLChar(inp = (byte)mBuf.read())) {
                FileStructureProcessor.printDebugMsg("Offset at problem location EOL: " + mBuf.getPosition() + " objno:" + objno.intValue() + " genno: " + genno.intValue());
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorObjKwdNotFollowedByEOL(objectNumber, genNumber), "IndirectObj Invalid: <obj> not followed by EOL");
            }
            CosToken.skipObject((CosDocument)cosObj.getDocument(), (InputByteStream)mBuf, (byte)CosToken.skipWhitespace((InputByteStream)mBuf));
            long endobjPos = ParseOps.getEndObjPos((InputByteStream)mBuf);
            boolean endObjLineFound = false;
            if (endobjPos != -1L) {
                endObjLineFound = true;
                mBuf.seek(endobjPos - 1L);
                if (!ParserUtils.isEOLChar((byte)mBuf.read())) {
                    FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorEndobjKwdNotPrecededByEOL(objectNumber, genNumber), "IndirectObj Invalid: <endobj> not preceeded by EOL");
                }
                mBuf.seek(endobjPos + 6L);
                if (!ParserUtils.isEOLChar((byte)mBuf.read())) {
                    FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorEndobjKwdNotFollowedByEOL(objectNumber, genNumber), "IndirectObj Invalid: <endobj> not followed by EOL");
                }
            }
            if (!endObjLineFound) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorEndobjKwdNotPrecededByEOL(objectNumber, genNumber), "IndirectObj Invalid: <endobj> not preceeded by EOL");
            }
        }
        catch (IOException e) {
            throw new PDFIOException("IOException occured while validating indirect objects for PDF/A-2b.", (Throwable)e);
        }
    }

    private static void validateStreamFilters(CosStream streamObj, PDFA2ErrorFlags flags, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler) throws PDFIOException, PDFSecurityException {
        try {
            CosArray streamFilters = streamObj.getInputFiltersList();
            block8: for (int i = 0; i < streamFilters.size(); ++i) {
                CosArray filterAtIndex = (CosArray)streamFilters.get(i);
                CosName filterName = (CosName)filterAtIndex.get(0);
                switch (SupportedFilters.getInstance(filterName.nameValue())) {
                    case ValidStandardInlineImageFilter: 
                    case ValidStandardFilter: {
                        continue block8;
                    }
                    case LZWDecode: {
                        FileStructureProcessor.validateLZWFilter(streamObj, flags, conversionOptions);
                        continue block8;
                    }
                    case Crypt: {
                        FileStructureProcessor.validateCryptFilter(streamObj, filterAtIndex, flags, conversionOptions);
                        continue block8;
                    }
                    default: {
                        FileStructureProcessor.validateNonStandardFilter(streamObj, filterName.nameValue(), flags, conversionOptions, conversionHandler);
                    }
                }
            }
        }
        catch (PDFCosParseException e) {
            flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorEndobjKwdNotPrecededByEOL(streamObj.getObjNum(), streamObj.getObjGen()));
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    private static void validateNonStandardFilter(CosStream streamObject, ASName filterName, PDFA2ErrorFlags flags, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        int objectNumber = streamObject.getObjNum();
        int genNumber = streamObject.getObjGen();
        if (conversionHandler == null || streamObject.getDocument().getOptions().getCustomFilterRegistry() == null || !streamObject.getDocument().getOptions().getCustomFilterRegistry().isDecodeFilterRegistered(filterName)) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorNonStandardFilterUsed(filterName.asString(), objectNumber, genNumber), "Stream Filters Invalid: " + filterName.toString() + "is not a standard filter");
            return;
        }
        if (!FileStructureProcessor.applyNewFilters(streamObject, conversionOptions.getDefaultSubstituteFilterList())) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorNonStandardFilterUsed(filterName.asString(), objectNumber, genNumber), "Stream Filters Invalid: " + filterName.toString() + "is not a standard filter");
            return;
        }
        FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorNonStandardFilterUsed(filterName.asString(), objectNumber, genNumber), "Stream Filters Invalid: " + filterName.toString() + "is not a standard filter");
    }

    private static void validateLZWFilter(CosStream streamObject, PDFA2ErrorFlags flags, PDFA2ConversionOptions conversionOptions) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        int objectNumber = streamObject.getObjNum();
        int genNumber = streamObject.getObjGen();
        if (conversionOptions == null) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorLZWDecodeFilterPresent(objectNumber, genNumber), "Stream Filters Invalid: LZWDecode Filter used");
            return;
        }
        if (!FileStructureProcessor.applyNewFilters(streamObject, conversionOptions.getLZWReplacementFilterList()) && !FileStructureProcessor.applyNewFilters(streamObject, conversionOptions.getDefaultSubstituteFilterList())) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorLZWDecodeFilterPresent(objectNumber, genNumber), "Stream Filters Invalid: LZWDecode Filter used");
            return;
        }
        FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorLZWDecodeFilterPresent(objectNumber, genNumber), "Stream Filters Invalid: LZWDecode Filter used");
    }

    private static void validateCryptFilter(CosStream streamObject, CosArray cryptFilter, PDFA2ErrorFlags flags, PDFA2ConversionOptions conversionOptions) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        int objectNumber = streamObject.getObjNum();
        int genNumber = streamObject.getObjGen();
        CosDictionary filterParams = cryptFilter.getCosDictionary(1);
        ASName cryptFilterName = filterParams.getName(ASName.k_Name);
        if (cryptFilterName == ASName.k_Identity) {
            return;
        }
        if (conversionOptions == null || !FileStructureProcessor.applyNewFilters(streamObject, conversionOptions.getCryptReplacementFilterList())) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorCryptDecodeFilterPresentWithoutIdentity(cryptFilterName.asString(), objectNumber, genNumber), "Stream Filters Invalid: Crypt Filter's Name key in parameters dictionary is not Identity");
            return;
        }
        FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorCryptDecodeFilterPresentWithoutIdentity(cryptFilterName.asString(), objectNumber, genNumber), "Stream Filters Invalid: Crypt Filter's Name key in parameters dictionary is not Identity");
    }

    private static boolean applyNewFilters(CosStream streamObj, PDFFilterList filterList) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (filterList == null) {
            return false;
        }
        streamObj.setOutputFiltersList(filterList.getCosArray());
        return true;
    }

    private static void validateCosStreamDictKeys(CosStream streamObj, PDFA2ErrorFlags flags) {
        int objectNumber = streamObj.getObjNum();
        int genNumber = streamObj.getObjGen();
        if (streamObj.containsKey((Object)ASName.k_FFilter)) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorStreamFFilterKeyPresent(objectNumber, genNumber), "Streams Invalid : FFilter key present");
        }
        if (streamObj.containsKey((Object)ASName.k_FDecodeParms)) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorStreamFDecodeParamsKeyPresent(objectNumber, genNumber), "Streams Invalid : FDecodeParams key present");
        }
        if (streamObj.containsKey((Object)ASName.k_F)) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorStreamFKeyPresent(objectNumber, genNumber), "Streams Invalid : F key present");
        }
    }

    private static void validateNumIndirectObjects(int numObjects, PDFA2ErrorFlags flags) {
        if (numObjects > 0x7FFFFF) {
            FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorIndirectObjectNumberIncorrect(numObjects, 0, 0), "Implementation Limits Violated : Allowed num indirect objects exceeded");
        }
    }

    private static long validateStream(CosStream streamObj, InputByteStream buf, long beginOfStream, long streamLength, PDFA2ErrorFlags flags, long dataOffset) throws IOException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        buf.seek(beginOfStream);
        FileStructureProcessor.printDebugMsg("Stream Begin = " + beginOfStream + " Data Offset = " + dataOffset);
        FileStructureProcessor.validateStreamStart(buf, beginOfStream + dataOffset, flags, streamObj);
        return FileStructureProcessor.validateStreamLength(buf, beginOfStream + dataOffset, streamLength, flags, streamObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateStreamDLKey(CosStream streamObj, InputByteStream buf, long streamStartPos, long streamEndPos, PDFA2ErrorFlags flags, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler) throws PDFIOException, PDFSecurityException, IOException, PDFInvalidDocumentException {
        if (streamStartPos == -1L || streamEndPos == -1L || streamObj.get(ASName.k_DL) == null) {
            return true;
        }
        int keyDLValue = streamObj.getInt(ASName.k_DL);
        InputByteStream data = null;
        InputStream dataToDecode = null;
        InputStream decodedData = null;
        try {
            data = buf.slice(streamStartPos, streamEndPos - streamStartPos);
            dataToDecode = data.toInputStream();
            decodedData = FileStructureProcessor.buildInputFilterStream(dataToDecode, streamObj);
            byte[] decodedBytes = new byte[32768];
            int numDecodedBytes = 0;
            int numBytesRead = 0;
            while ((numBytesRead = decodedData.read(decodedBytes)) > 0) {
                numDecodedBytes += numBytesRead;
            }
            if (numDecodedBytes != keyDLValue) {
                if (conversionHandler != null && conversionOptions.getRemoveStreamObjectDLKey()) {
                    streamObj.remove(ASName.k_DL);
                    FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorStreamDLKeyInvalid(keyDLValue, numDecodedBytes, streamObj.getObjNum(), streamObj.getObjGen()), "Streams Invalid : DL key value is not equal to number of decoded bytes of stream in document");
                    if (!conversionHandler.streamObjectDLKeyRemoved(PDFStream.getInstance((CosObject)streamObj))) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorStreamDLKeyInvalid(keyDLValue, numDecodedBytes, streamObj.getObjNum(), streamObj.getObjGen()), "Streams Invalid : DL key value is not equal to number of decoded bytes of stream in document");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (decodedData != null) {
                    decodedData.close();
                }
            }
            finally {
                try {
                    if (dataToDecode != null) {
                        dataToDecode.close();
                    }
                }
                finally {
                    if (data != null) {
                        data.close();
                    }
                }
            }
        }
    }

    private static InputStream buildInputFilterStream(InputStream inputStream, CosStream streamObj) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        Iterator filterIter;
        CosObject rawFilter = streamObj.get(ASName.k_Filter);
        FilterParams params = FilterStream.buildFilterParams((CosObject)streamObj.get(ASName.k_DecodeParms));
        if (rawFilter instanceof CosName) {
            CosArray filterList = streamObj.getDocument().createCosArray();
            filterList.add(rawFilter);
            filterIter = filterList.iterator();
        } else {
            filterIter = rawFilter == null ? streamObj.getDocument().createCosArray().iterator() : ((CosArray)rawFilter).iterator();
        }
        while (filterIter.hasNext()) {
            ASName curFilter = ((CosName)filterIter.next()).nameValue();
            if (curFilter == ASName.k_Crypt) continue;
            inputStream = FilterStream.applyFilter((InputStream)inputStream, (ASName)curFilter, (FilterParams)params, (CustomFilterRegistry)streamObj.getDocument().getOptions().getCustomFilterRegistry());
        }
        return inputStream;
    }

    private static void validateStreamStart(InputByteStream buf, long beginOfStreamData, PDFA2ErrorFlags flags, CosStream streamObj) throws IOException, PDFIOException {
        int objectNumber = streamObj.getObjNum();
        int genNumber = streamObj.getObjGen();
        buf.seek(beginOfStreamData);
        if (beginOfStreamData != -1L) {
            long curPos = beginOfStreamData - 1L;
            FileStructureProcessor.printDebugMsg("\nAt curPos Position we have: " + (char)ParserUtils.peekAtPos(buf, curPos));
            byte inp = (byte)ParserUtils.peekAtPos(buf, curPos);
            if (inp != 10) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorStreamSuffixCharsNotAllowed(objectNumber, genNumber), "Stream Invalid: Extra Characters after stream keyword at:" + buf.getPosition() + "Extra Char: " + inp);
            }
            inp = (byte)ParserUtils.peekAtPos(buf, --curPos);
            FileStructureProcessor.printDebugMsg("\nAt curPos Position we have: " + (char)ParserUtils.peekAtPos(buf, curPos));
            String str = null;
            str = inp == 13 ? ParserUtils.peekStringAtPos(buf, 6, curPos - 6L) : ParserUtils.peekStringAtPos(buf, 6, curPos - 5L);
            if (!"stream".equals(str)) {
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorStreamSuffixCharsNotAllowed(objectNumber, genNumber), "Stream Invalid: Extra Characters after stream keyword at:" + buf.getPosition() + "Extra Char: " + inp);
            }
        }
    }

    private static long validateStreamLength(InputByteStream buf, long streamStart, long streamLength, PDFA2ErrorFlags flags, CosStream streamObj) throws IOException {
        long curStreamPos;
        int objectNumber = streamObj.getObjNum();
        int genNumber = streamObj.getObjGen();
        long endStreamPos = curStreamPos = streamStart + streamLength;
        boolean streamLengthIncorrect = false;
        boolean eolNotBeforeEndStream = false;
        boolean eolNotPresent = false;
        byte peekedChar = (byte)ParserUtils.peekAtPos(buf, curStreamPos);
        if (peekedChar != 10) {
            if (peekedChar == 13) {
                peekedChar = (byte)ParserUtils.peekAtPos(buf, curStreamPos + 1L);
                if (peekedChar == 10) {
                    ++curStreamPos;
                }
            } else if (ParserUtils.peekAndCheckAtPos(buf, "endstream", curStreamPos)) {
                eolNotPresent = true;
            } else {
                streamLengthIncorrect = true;
                endStreamPos = -1L;
            }
        }
        if (!(streamLengthIncorrect || eolNotPresent || ParserUtils.peekAndCheckAtPos(buf, "endstream", ++curStreamPos))) {
            endStreamPos = -1L;
            eolNotBeforeEndStream = true;
        }
        if (streamLengthIncorrect) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorStreamLengthIncorrect(objectNumber, genNumber), "Stream length: No endstream:" + buf.getPosition() + "Extra Char: " + peekedChar + "\nStream Invalid: Incorrect Length Property set" + "\nStreamLength:" + streamLength);
        } else if (eolNotBeforeEndStream) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorEndstreamNotPrecededByEOL(objectNumber, genNumber), "Stream Invalid: Stream start = " + streamStart + " Stream length = " + "\nStream Invalid: peeked char = " + peekedChar + " Cur pos = " + curStreamPos);
        } else if (eolNotPresent) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorStreamEOLMarkerNotPresent(objectNumber, genNumber), "Stream Invalid: Stream start = " + streamStart + " Stream length = " + streamLength + "\nStream Invalid: peeked char = " + peekedChar + " Cur pos = " + curStreamPos);
        }
        return endStreamPos;
    }

    private static void checkOddBallHexStrings(CosString str, PDFA2ErrorFlags flags) throws PDFSecurityException {
        if (str.isOddBall()) {
            FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrorHexStrEvenNumCharsNotPresent(str.asString(), str.getObjNum(), str.getObjGen()), "HexString Invalid: Hex String has odd number of chars");
        }
    }

    private static void printCosObject(CosObject cosObj) {
        int rev = cosObj.getObjRevision();
        long pos = cosObj.getObjPos();
        long eof = cosObj.getObjEOF();
        String cls = cosObj.getClass().toString();
        FileStructureProcessor.printDebugMsg("Obj , " + cls.substring(cls.lastIndexOf(46) + 1) + ", rev " + rev + ", pos " + pos + ", eof " + eof);
    }

    private static void printCosScalar(CosObject cosObj) throws PDFSecurityException {
        if (cosObj instanceof CosNumeric) {
            FileStructureProcessor.printDebugMsg("\tNumericObj: " + cosObj.numberValue().toString());
        } else if (cosObj instanceof CosString) {
            CosString str = (CosString)cosObj;
            if (str.getWriteHex()) {
                FileStructureProcessor.printDebugMsg("\tHexStringObj: " + cosObj.stringValue().asString());
            } else {
                FileStructureProcessor.printDebugMsg("\tStringObj: " + cosObj.stringValue().asString());
            }
        } else if (cosObj instanceof CosName) {
            FileStructureProcessor.printDebugMsg("\tStringObj: " + cosObj.nameValue().asString());
        }
    }

    private static void printDebugMsg(String msg) {
    }

    static {
        nameToEnumMapping.put(ASName.k_ASCIIHexDecode, SupportedFilters.ValidStandardFilter);
        nameToEnumMapping.put(ASName.k_ASCII85Decode, SupportedFilters.ValidStandardFilter);
        nameToEnumMapping.put(ASName.k_LZWDecode, SupportedFilters.LZWDecode);
        nameToEnumMapping.put(ASName.k_FlateDecode, SupportedFilters.ValidStandardFilter);
        nameToEnumMapping.put(ASName.k_RunLengthDecode, SupportedFilters.ValidStandardFilter);
        nameToEnumMapping.put(ASName.k_CCITTFaxDecode, SupportedFilters.ValidStandardFilter);
        nameToEnumMapping.put(ASName.k_JBIG2Decode, SupportedFilters.ValidStandardFilter);
        nameToEnumMapping.put(ASName.k_DCTDecode, SupportedFilters.ValidStandardFilter);
        nameToEnumMapping.put(ASName.k_JPXDecode, SupportedFilters.ValidStandardFilter);
        nameToEnumMapping.put(ASName.k_Crypt, SupportedFilters.Crypt);
        nameToEnumMapping.put(ASName.k_AHx, SupportedFilters.ValidStandardInlineImageFilter);
        nameToEnumMapping.put(ASName.k_A85, SupportedFilters.ValidStandardInlineImageFilter);
        nameToEnumMapping.put(ASName.k_LZW, SupportedFilters.LZW);
        nameToEnumMapping.put(ASName.k_Fl, SupportedFilters.ValidStandardInlineImageFilter);
        nameToEnumMapping.put(ASName.k_RL, SupportedFilters.ValidStandardInlineImageFilter);
        nameToEnumMapping.put(ASName.k_CCF, SupportedFilters.ValidStandardInlineImageFilter);
        nameToEnumMapping.put(ASName.k_DCT, SupportedFilters.ValidStandardInlineImageFilter);
    }

    class LocalDispatcher
    implements GeneralDispatcher {
        PDFA2ErrorFlags flags;

        LocalDispatcher(PDFA2ErrorFlags flags) {
            this.flags = flags;
        }

        public boolean finishDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
            return true;
        }

        public boolean isCandidate(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) {
            return !wasSeen;
        }

        public boolean startDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosObject object = entry.getValue();
            this.validateCosObject(object, this.flags);
            return true;
        }

        void validateCosObject(CosObject object, PDFA2ErrorFlags flags) throws PDFSecurityException {
            CosDictionary dict;
            int objectNumber = object.getObjNum();
            int genNumber = object.getObjGen();
            if (object instanceof CosNumeric) {
                Number number = object.numberValue();
                if (number instanceof Integer || number instanceof Long) {
                    long num = number.longValue();
                    if (num < Integer.MIN_VALUE) {
                        FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorIntegerNumberValueTooLow(number, objectNumber, genNumber), "Integer Invalid: Value of given integer outside limits");
                    } else if (num > Integer.MAX_VALUE) {
                        FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorIntegerNumberValueTooHigh(number, objectNumber, genNumber), "Integer Invalid: Value of given integer outside limits");
                    }
                } else if (number instanceof Double || number instanceof Float) {
                    double num = number.doubleValue();
                    if (num > 3.4028234663852886E38) {
                        FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorRealNumberValueTooHigh(number, objectNumber, genNumber), "RealNumber Invalid: Value of given real number outside limits");
                    } else if (num < -3.4028234663852886E38) {
                        FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorRealNumberValueTooLow(number, objectNumber, genNumber), "RealNumber Invalid: Value of given real number outside limits");
                    } else if (num < 1.175E-38 && num > 0.0) {
                        FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorPositiveValueTooCloseToZero(number, objectNumber, genNumber), "RealNumber Invalid: Value of given real number outside limits");
                    } else if (num > -1.175E-38 && num < 0.0) {
                        FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorNegativeValueTooCloseToZero(number, objectNumber, genNumber), "RealNumber Invalid: Value of given real number outside limits");
                    }
                }
            } else if (object instanceof CosString) {
                CosString str = (CosString)object;
                FileStructureProcessor.checkOddBallHexStrings(str, flags);
                if (str.byteArrayValue().length > Short.MAX_VALUE) {
                    FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorStringLengthIncorrect(str.asString(), objectNumber, genNumber), "CosString Invalid: CosString has a byte length > 32,767");
                }
            } else if (object instanceof CosName) {
                CosName name = (CosName)object;
                if (name.nameValue().getBytes().length > 127) {
                    FileStructureProcessor.addErrorCode(flags, false, new PDFA2FileStructureErrorNameLengthIncorrect(name.nameValue().asString(), objectNumber, genNumber), "CosName Invalid: CosName has a length > 127");
                }
            } else if (object instanceof CosDictionary && (dict = (CosDictionary)object).isInvalidDict()) {
                FileStructureProcessor.printDebugMsg("CosDictionary Invalid: Number of keys differ from number of value");
                FileStructureProcessor.addErrorCode(flags, true, new PDFA2FileStructureErrormisMatchedKeyValuePairsInDict(objectNumber, genNumber), "Invalid Dict object: Number of keys differ from number of values");
            }
        }

        public boolean continueTraversing(PDFInvalidDocumentException e) {
            this.flags.errorsFound.addErrorCode(new PDFA2FileStructureErrorPDFGeneralFailure(0, 0));
            return true;
        }
    }

    static enum SupportedFilters {
        ValidStandardFilter,
        LZWDecode,
        LZW,
        Crypt,
        ValidStandardInlineImageFilter,
        UnknownFilter;


        static SupportedFilters getInstance(ASName filterName) {
            SupportedFilters filter = (SupportedFilters)((Object)nameToEnumMapping.get(filterName));
            return filter != null ? filter : UnknownFilter;
        }
    }
}

