/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.fontengine.font.opentype.Head;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.IContentStreamFilter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamTransformer;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecificationList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistryBase;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceN;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceSeparation;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfigList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderListContent;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectPostScript;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImageColorSpace;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.pdf.interactive.requirement.PDFRequirementsArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPart;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPartRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntentsList;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFMarkInfo;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.common.TextLayoutPreservingFilter;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractBookmarkErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractCatalogErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFieldErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFileStructureErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractOutputIntentErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractPageErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionGoTo3DViewNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionHideNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionImportDataNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionJavaScriptNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionLaunchNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionMovieNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionNoOpNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionRenditionNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionResetFormNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionSetOCGStateNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionSetStateNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionSoundNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorActionTransNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorNonPermittedNamedActionFound;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2BookmarkErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorAFEntryInCatalogNotValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionGoTo3DViewNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionHideNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionImportDataNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionJavaScriptNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionLaunchNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionMovieNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionNoOpNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionRenditionNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionResetFormNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionSetOCGStateNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionSetStateNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionSoundNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorActionTransNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorAdditionalActionsNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorAlternatePresentationsNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorMarkedInfoMissing;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorMarkedInfoNotTrue;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorNamedEmbeddedFilesAreNotValidPDFAFile;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorNamedJavaScriptsPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorNeedsRenderingNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorNonPermittedNamedActionFound;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorNullPageAsDestination;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorOptionalContentConfigDictHasAsKeyPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorOptionalContentConfigHasNameNotUnique;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorOptionalContentConfigHasNoNamePresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorOrderListDoesNotReferAllOCGs;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorPermissionsDictionaryHasKeyOtherThanUR3andDocMDP;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorPermissionsHasDocMDPAndSigRefHasDigestLocation;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorPermissionsHasDocMDPAndSigRefHasDigestMethod;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorPermissionsHasDocMDPAndSigRefHasDigestValue;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorRequirementsPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorStructureTreeRootEntryMissing;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorStructureTypeNameNotValidUTF8;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorXfaNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FieldErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorICCProfileCouldNotBeParsed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorICCProfileVersion3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorICCProfileVersion5OrNewer;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorICCProfileVersionOlderThan2;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorIncorrectValueForKeyN;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorInvalidColorSpaceInProfile;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorInvalidDestOutputProfile;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorInvalidDeviceClassProfile;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorMultipleDestOutputProfiles;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2OutputIntentErrorPDFXOutputIntentHasDestOutputProfileRef;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PageErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontEmbedder;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.AcroFormProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.EmbeddedFileProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.FileStructureProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.PageProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.SharedConstraints;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.StructureProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.XMPProcessor;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class DocumentProcessor {
    PDFDocument document;
    HashMap<ASName, Boolean> defaultColorSpacesNameToOutputIntent = null;
    private FontContext fontContext;
    Map<ASName, PDFColorSpaceSeparation> separationCSArrays = new HashMap<ASName, PDFColorSpaceSeparation>();
    Set<ASName> inconsistentSeparationCSNames = new HashSet<ASName>();
    boolean outputIntentReplaced;
    private boolean skippedCharacters;
    private static final ASName k_DestOutputProfileRef = ASName.create((String)"DestOutputProfileRef");
    Map<String, PDFA2XMPSchema> globalExplicitSchemas;
    HashSet<CosObject> associatedFileSpecList = new HashSet();

    public boolean isSkippedCharacters() {
        return this.skippedCharacters;
    }

    public void setSkippedCharacters(boolean skippedCharacters) {
        this.skippedCharacters = skippedCharacters;
    }

    boolean isValidOutputIntentPresent(ASName defaultDeviceColorSpaceName) {
        Boolean value = this.defaultColorSpacesNameToOutputIntent != null ? this.defaultColorSpacesNameToOutputIntent.get(defaultDeviceColorSpaceName) : false;
        return value != null ? value : false;
    }

    public boolean process(PDFDocument document, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler clientConversionHandler, PDFA2ValidationOptions validationOptions, PDFA2ValidationHandler clientValidationHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int umebmeddedFontCount;
        XMPProcessor xmpProcessor;
        TrackingValidationHandler validationHandler;
        TrackingConversionHandler conversionHandler;
        block39: {
            block38: {
                block37: {
                    PDFCatalog catalog;
                    block36: {
                        PDFOutputIntent outputIntent;
                        block35: {
                            if (document == null) {
                                return true;
                            }
                            this.document = document;
                            try {
                                ((DocumentListenerRegistryBase)document.getListenerRegistry()).sendMessage(new DocumentMessage(DocumentMessage.FLUSH_FONTS, document), true);
                            }
                            catch (PDFUnableToCompleteOperationException e) {
                                // empty catch block
                            }
                            conversionHandler = null;
                            validationHandler = null;
                            if (clientConversionHandler != null) {
                                conversionHandler = new TrackingConversionHandler(clientConversionHandler);
                                validationHandler = conversionHandler;
                            } else {
                                validationHandler = new TrackingValidationHandler(clientValidationHandler);
                            }
                            this.setFontContext(new FontContext(document));
                            if (validationHandler != null) {
                                Head.setFontHeaderValidationRequired((boolean)false);
                            }
                            if (!validationHandler.beginDocumentScan()) {
                                return false;
                            }
                            try {
                                PDFPageTree page = document.requirePages();
                                this.process(page, this, clientValidationHandler, conversionHandler, conversionOptions);
                            }
                            catch (PDFInvalidDocumentException e) {
                                // empty catch block
                            }
                            xmpProcessor = null;
                            try {
                                xmpProcessor = this.getDocumentLevelXMPProcessor(document, conversionHandler);
                                this.globalExplicitSchemas = xmpProcessor.getEmbeddedSchemas();
                            }
                            catch (Exception e1) {
                                // empty catch block
                            }
                            catalog = document.requireCatalog();
                            if (!this.processCatalog(catalog, conversionOptions, conversionHandler, validationOptions, validationHandler, conformance)) {
                                return false;
                            }
                            try {
                                PDFBookmarkRoot bmRoot = catalog.getBookmarkRoot();
                                if (!this.processBookMark(bmRoot, conversionOptions, conversionHandler, validationHandler)) {
                                    return false;
                                }
                            }
                            catch (PDFInvalidDocumentException e) {
                                if (validationHandler.catalogError(new PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode>(new PDFA2CatalogErrorPDFGeneralFailure(0, 0)))) break block35;
                                return false;
                            }
                        }
                        if (conversionHandler != null && (outputIntent = conversionOptions.getPDFAOutputIntent()) != null && conversionOptions.overWritePDFAOutputIntentSet()) {
                            PDFOutputIntentsList outputIntentsList = PDFOutputIntentsList.newInstance((PDFDocument)document);
                            outputIntentsList.add((PDFCosObjectContainer)outputIntent);
                            catalog.setOutputIntents(outputIntentsList);
                            conversionHandler.pdfaOutputIntentSet(outputIntent);
                        }
                        try {
                            PDFOutputIntentsList outputIntents = catalog.getOutputIntents();
                            if (!this.processOutputIntentList(outputIntents, validationHandler, validationOptions, conversionHandler, conversionOptions)) {
                                return false;
                            }
                            if (this.defaultColorSpacesNameToOutputIntent == null) {
                                this.defaultColorSpacesNameToOutputIntent = new HashMap(3);
                            }
                            this.defaultColorSpacesNameToOutputIntent.put(ASName.k_DefaultRGB, ColorSpaceProcessor.hasPDFAOutputIntentWithRGBCS(document));
                            this.defaultColorSpacesNameToOutputIntent.put(ASName.k_DefaultCMYK, ColorSpaceProcessor.hasPDFAOutputIntentWithCMYKCS(document));
                            this.defaultColorSpacesNameToOutputIntent.put(ASName.k_DefaultGray, ColorSpaceProcessor.hasPDFAOutputIntent(document));
                        }
                        catch (PDFInvalidDocumentException e) {
                            if (validationHandler.outputIntentsError(null, new PDFA2ErrorSet<PDFA2AbstractOutputIntentErrorCode>(new PDFA2OutputIntentErrorPDFGeneralFailure(0, 0)))) break block36;
                            return false;
                        }
                    }
                    try {
                        PDFInteractiveForm iform = catalog.getInteractiveForm();
                        if (!AcroFormProcessor.process(iform, conversionOptions, conversionHandler, validationHandler)) {
                            return false;
                        }
                    }
                    catch (PDFInvalidDocumentException e) {
                        if (validationHandler.formFieldError(new PDFA2ErrorSet<PDFA2AbstractFieldErrorCode>(new PDFA2FieldErrorPDFGeneralFailure(0, 0)))) break block37;
                        return false;
                    }
                }
                try {
                    PDFPageTree pages = document.requirePages();
                    if (!PageProcessor.process((PDFPageTreeNode)pages, this, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                        return false;
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    if (validationHandler.pageError(new PDFA2ErrorSet<PDFA2AbstractPageErrorCode>(new PDFA2PageErrorPDFGeneralFailure(0, 0)))) break block38;
                    return false;
                }
            }
            umebmeddedFontCount = this.getFontContext().getUnembeddedFonts().size();
            if (conversionHandler != null && umebmeddedFontCount > 0) {
                try {
                    if (!FontEmbedder.processUnembeddedFonts(this.getFontContext(), conversionHandler, validationHandler, conformance)) {
                        return false;
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    if (validationHandler.fontError(new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>(new PDFA2FontErrorPDFGeneralFailure(0, 0)))) break block39;
                    return false;
                }
            }
        }
        if (!FileStructureProcessor.validate(document, conformance, validationOptions, validationHandler, conversionOptions, conversionHandler, this.associatedFileSpecList)) {
            return false;
        }
        if (!MetadataProcessor.process(document, xmpProcessor, conformance, conversionHandler, conversionOptions, validationHandler, validationOptions)) {
            return false;
        }
        if (conversionHandler != null && (umebmeddedFontCount > 0 || this.isSkippedCharacters())) {
            DocumentProcessor.updateContentStream(this.fontContext, this);
        }
        if (validationHandler != null) {
            Head.setFontHeaderValidationRequired((boolean)true);
        }
        if (conversionHandler != null) {
            conversionHandler.conversionSummary(conversionHandler.errorsFixed(), conversionHandler.errorsFound());
        }
        return validationHandler.endDocumentScan(validationHandler.errorsFound());
    }

    private void process(PDFPageTree pages, DocumentProcessor documentProcessor, PDFA2ValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (conversionHandler == null) {
            return;
        }
        PDFOutputIntent outputIntent = conversionOptions.getPDFAOutputIntent();
        if (outputIntent == null) {
            return;
        }
        for (PDFPage page : pages) {
            Content content = ContentUtil.getContent((boolean)false, (PDFPage)page);
            UseColor uc = new UseColor();
            DocumentProcessor.process(content, documentProcessor, validationHandler, uc);
            if (!uc.found) continue;
            if (uc.useRGB) break;
            if (!uc.useCMYK) continue;
            if (outputIntent.getDestOutputProfileCMYK() != null) {
                outputIntent.setDestOutputProfile(outputIntent.getDestOutputProfileCMYK());
            }
            return;
        }
        if (outputIntent.getDestOutputProfileRGB() != null) {
            outputIntent.setDestOutputProfile(outputIntent.getDestOutputProfileRGB());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(Content content, DocumentProcessor docProcessor, PDFA2ValidationHandler validationHandler, UseColor uc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (content == null) {
            return;
        }
        PDFResources resources = content.getResources();
        if (!validationHandler.beginContentScan(content.getContents(), resources)) {
            return;
        }
        ContentReader reader = null;
        try {
            PDFColorSpaceMap colorSpaceMap = null;
            colorSpaceMap = resources != null ? resources.getColorSpaceMap() : PDFColorSpaceMap.newInstance((PDFDocument)docProcessor.document);
            Instruction instruction = null;
            reader = ContentReader.newInstance((Content)content);
            while (reader.hasNext()) {
                try {
                    CosObject csValue;
                    PDFShading shading;
                    InlineImageColorSpace cs;
                    instruction = reader.next();
                    ASName operator = instruction.getOperator();
                    PDFVersion opVers = instruction.getVersion();
                    OperandStack operands = instruction.getOperands();
                    if (opVers == null) continue;
                    if (operator == ASName.k_cs || operator == ASName.k_CS) {
                        ASName csName = operands.peekName();
                        if (csName == ASName.k_DeviceRGB) {
                            uc.found = true;
                            uc.useRGB = true;
                            break;
                        }
                        if (csName == ASName.k_DeviceCMYK) {
                            uc.found = true;
                            uc.useCMYK = true;
                            break;
                        }
                        if (csName == ASName.k_DeviceGray || csName == ASName.k_Pattern) continue;
                        PDFColorSpace colorSpace = colorSpaceMap.get(csName);
                        DocumentProcessor.processColorMap(colorSpace, uc);
                        if (!uc.found) {
                            continue;
                        }
                        break;
                    }
                    if (operator == ASName.k_rg || operator == ASName.k_RG) {
                        uc.found = true;
                        uc.useRGB = true;
                        break;
                    }
                    if (operator == ASName.k_k || operator == ASName.k_K) {
                        uc.found = true;
                        uc.useCMYK = true;
                        break;
                    }
                    if (operator == ASName.k_g || operator == ASName.k_G) continue;
                    if (operator == ASName.k_Do) {
                        PDFXObject xObject;
                        ASName xObjectName = operands.peekName();
                        if (resources == null || (xObject = resources.getXObject(xObjectName)) == null) continue;
                        if (xObject.dictionaryContains(ASName.k_OC)) {
                            // empty if block
                        }
                        if (xObject instanceof PDFXObjectForm || xObject instanceof PDFXObjectPostScript) {
                            // empty if block
                        }
                        if (!(xObject instanceof PDFXObjectImage)) continue;
                        PDFXObjectImage image = (PDFXObjectImage)xObject;
                        cs = image.getColorSpace();
                        if (cs instanceof PDFColorSpaceDeviceRGB) {
                            uc.found = true;
                            uc.useRGB = true;
                            break;
                        }
                        if (cs instanceof PDFColorSpaceDeviceCMYK) {
                            uc.found = true;
                            uc.useCMYK = true;
                            break;
                        }
                        if (cs instanceof PDFColorSpaceDeviceGray) continue;
                        continue;
                    }
                    if (operator == ASName.k_ID) {
                        InputByteStream imageData = operands.peekInputByteStream();
                        ASDictionary imageDict = operands.stackToImageDictionary();
                        InlineImage inlineImage = InlineImage.newInstance((Content)content, (ASDictionary)imageDict, (InputByteStream)imageData);
                        if (!imageDict.containsKey((Object)ASName.k_ColorSpace) && !imageDict.containsKey((Object)ASName.k_CS)) continue;
                        cs = inlineImage.getColorSpace();
                        if (cs.isIndexedColorSpace()) {
                            cs = cs.getIndexedColorSpaceBase();
                        }
                        ASName deviceCSName = null;
                        if (cs.isDeviceColorSpace()) {
                            deviceCSName = cs.getDeviceColorSpaceName();
                        } else if (cs.isExistingResourceColorSpaceName() || cs.isNewResourceColorSpace()) {
                            ASName csName = null;
                            PDFColorSpace pdfCS = null;
                            if (cs.isExistingResourceColorSpaceName() && colorSpaceMap != null) {
                                csName = cs.getExistingResourceColorSpaceName();
                                pdfCS = colorSpaceMap.get(csName);
                            } else if (cs.isNewResourceColorSpace()) {
                                pdfCS = cs.getNewResourceColorSpace();
                            }
                            if (pdfCS instanceof PDFColorSpaceIndexed) {
                                pdfCS = ((PDFColorSpaceIndexed)pdfCS).getBaseColorSpace();
                            }
                            if (pdfCS instanceof PDFColorSpaceDeviceRGB) {
                                deviceCSName = ASName.k_DeviceRGB;
                            } else if (pdfCS instanceof PDFColorSpaceDeviceCMYK) {
                                deviceCSName = ASName.k_DeviceCMYK;
                            } else if (pdfCS instanceof PDFColorSpaceDeviceGray) {
                                deviceCSName = ASName.k_DeviceGray;
                            } else if (csName != null) {
                                DocumentProcessor.processColorMap(colorSpaceMap.get(csName), uc);
                                if (uc.found) break;
                            }
                        }
                        if (deviceCSName == ASName.k_DeviceRGB) {
                            uc.found = true;
                            uc.useRGB = true;
                            break;
                        }
                        if (deviceCSName == ASName.k_DeviceCMYK) {
                            uc.found = true;
                            uc.useCMYK = true;
                            break;
                        }
                        if (deviceCSName == ASName.k_DeviceGray) continue;
                        continue;
                    }
                    if (operator != ASName.k_sh) continue;
                    ASName shadingName = operands.peekName();
                    PDFShadingMap shadingMap = resources.getShadingMap();
                    if (shadingMap == null || (shading = shadingMap.get(shadingName)) == null || (csValue = shading.getPDFCosObject().getCosDictionary().get(ASName.k_ColorSpace)) == null) continue;
                    if (csValue.getType() == 3) {
                        ASName csName = ((CosName)csValue).nameValue();
                        if (csName == ASName.k_DeviceRGB) {
                            uc.found = true;
                            uc.useRGB = true;
                            break;
                        }
                        if (csName == ASName.k_DeviceCMYK) {
                            uc.found = true;
                            uc.useCMYK = true;
                            break;
                        }
                        if (csName == ASName.k_DeviceGray) continue;
                        DocumentProcessor.processColorMap(colorSpaceMap.get(csName), uc);
                        if (!uc.found) {
                            continue;
                        }
                        break;
                    }
                    if (csValue.getType() != 5) continue;
                }
                finally {
                    try {
                        if (instruction == null) continue;
                        instruction.close();
                    }
                    catch (PDFIOException e) {}
                }
            }
        }
        catch (PDFIOException e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e2) {
                throw new PDFIOException("Failed to close a ContentReader.", (Throwable)e2);
            }
        }
        catch (PDFInvalidDocumentException e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e3) {
                throw new PDFIOException("Failed to close a ContentReader.", (Throwable)e3);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException("Failed to close a ContentReader.", (Throwable)e);
            }
        }
    }

    private static void processColorMap(PDFColorSpace colorSpace, UseColor uc) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFColorSpace altCS = null;
        if (colorSpace == null) {
            return;
        }
        if (colorSpace instanceof PDFColorSpaceDeviceRGB) {
            uc.useRGB = true;
            uc.found = true;
            return;
        }
        if (colorSpace instanceof PDFColorSpaceDeviceCMYK) {
            uc.useCMYK = true;
            uc.found = true;
            return;
        }
        if (colorSpace instanceof PDFColorSpaceDeviceGray || colorSpace instanceof PDFColorSpaceICCBased) {
            return;
        }
        if (colorSpace instanceof PDFColorSpaceSeparation) {
            PDFColorSpaceSeparation sepCS = (PDFColorSpaceSeparation)colorSpace;
            altCS = sepCS.getAlternateColorSpace();
        } else if (colorSpace instanceof PDFColorSpaceDeviceN) {
            PDFColorSpaceDeviceN sepCS = (PDFColorSpaceDeviceN)colorSpace;
            altCS = sepCS.getAlternateColorSpace();
        } else if (colorSpace instanceof PDFColorSpaceIndexed) {
            altCS = ((PDFColorSpaceIndexed)colorSpace).getBaseColorSpace();
        }
        if (altCS != null && altCS instanceof PDFColorSpaceDeviceRGB) {
            uc.found = true;
            uc.useRGB = true;
        } else if (altCS instanceof PDFColorSpaceDeviceCMYK) {
            uc.found = true;
            uc.useCMYK = true;
        }
    }

    private XMPProcessor getDocumentLevelXMPProcessor(PDFDocument document, PDFA2ConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        XMPProcessor xmpProcessor = null;
        xmpProcessor = conversionHandler != null ? new XMPProcessor(document, true) : new XMPProcessor(document, false);
        return xmpProcessor;
    }

    private boolean processCatalog(PDFCatalog catalog, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, PDFA2ValidationHandler validationHandler, PDFA2ConformanceLevel conformance) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode>();
        try {
            PDFStructureRoot structTreeRoot;
            PDFAdditionalActionsDocument aa;
            PDFOpenAction openAction;
            CosObject xfaObject;
            PDFInteractiveForm iform;
            PDFRequirementsArray requirements;
            if (conformance == PDFA2ConformanceLevel.Level_3b && !this.checkAndAddToAssociatedFileSet(catalog)) {
                errorCodes.addErrorCode(new PDFA2CatalogErrorAFEntryInCatalogNotValid(catalog.getCosObject().getObjNum(), catalog.getCosObject().getObjGen()));
            }
            if (conformance == PDFA2ConformanceLevel.Level_2a) {
                if (catalog.hasMarkInfo()) {
                    PDFMarkInfo markInfo = catalog.getMarkInfo();
                    if (!markInfo.hasMarked() || !markInfo.getMarked()) {
                        errorCodes.addErrorCode(new PDFA2CatalogErrorMarkedInfoNotTrue(catalog.getCosObject().getObjNum(), catalog.getCosObject().getObjGen()));
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2CatalogErrorMarkedInfoMissing(catalog.getCosObject().getObjNum(), catalog.getCosObject().getObjGen()));
                }
            }
            this.processStructure(conformance, catalog, errorCodes, conversionHandler);
            if (validationOptions.detectCertifiedDocumentEnabled()) {
                PDFPermissions perms = catalog.getPermissions();
                this.processPermissions(perms, errorCodes);
            }
            if ((requirements = catalog.getRequirements()) != null) {
                if (conversionHandler != null && conversionOptions.isRemoveRequirementsEntry()) {
                    catalog.removeValue(ASName.k_Requirements);
                    if (!conversionHandler.requirementsRemovedFromCatalog()) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2CatalogErrorRequirementsPresent(requirements.getCosObject().getObjNum(), requirements.getCosObject().getObjGen()));
                }
            }
            if ((iform = catalog.getInteractiveForm()) != null && (xfaObject = iform.getDictionaryCosObjectValue(ASName.k_XFA)) != null) {
                if (conversionHandler != null && conversionOptions.getRemoveXFA()) {
                    iform.removeXFA();
                    if (catalog.hasNeedsRendering()) {
                        catalog.removeValue(ASName.k_NeedsRendering);
                    }
                    if (!conversionHandler.xfaRemoved()) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2CatalogErrorXfaNotAllowed(xfaObject.getObjNum(), xfaObject.getObjGen()));
                }
            }
            if (catalog.hasNeedsRendering()) {
                errorCodes.addErrorCode(new PDFA2CatalogErrorNeedsRenderingNotAllowed(0, 0));
            }
            if (catalog.dictionaryContains(ASName.k_Names)) {
                CosObject altPresentations;
                CosObject javaScriptObject;
                PDFNameDictionary names = catalog.getNameDictionary();
                if (names.dictionaryContains(ASName.k_EmbeddedFiles)) {
                    PDFNamedEmbeddedFiles namedEmbeddedFiles = names.getNamedEmbeddedFiles();
                    Iterator iter = namedEmbeddedFiles.iterator();
                    while (iter.hasNext()) {
                        PDFTree.Entry entry = (PDFTree.Entry)iter.next();
                        PDFFileSpecification fileSpec = (PDFFileSpecification)entry.getValue();
                        try {
                            EmbeddedFileProcessor embeddedFileProcessor = EmbeddedFileProcessor.getInstance(conformance);
                            PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> eset = embeddedFileProcessor.validateEmbeddedFile((CosDictionary)fileSpec.getCosObject(), validationHandler, conversionHandler, null);
                            if (!eset.hasErrors()) continue;
                            if (conversionHandler != null && conversionOptions.isRemoveEmbeddedFileFromNameTree()) {
                                iter.remove();
                                if (conversionHandler.embeddedFileRemovedFromNameTree(fileSpec)) continue;
                                return false;
                            }
                            if (!conformance.getVersion().equals("2")) break;
                            errorCodes.addErrorCode(new PDFA2CatalogErrorNamedEmbeddedFilesAreNotValidPDFAFile(fileSpec.getFilename().asString(), fileSpec.getCosObject().getObjNum(), fileSpec.getCosObject().getObjGen()));
                        }
                        catch (Exception e) {
                            if (!conformance.getVersion().equals("2")) break;
                            errorCodes.addErrorCode(new PDFA2CatalogErrorNamedEmbeddedFilesAreNotValidPDFAFile(fileSpec.getFilename().asString(), fileSpec.getCosObject().getObjNum(), fileSpec.getCosObject().getObjGen()));
                        }
                        break;
                    }
                }
                if ((javaScriptObject = names.getDictionaryCosObjectValue(ASName.k_JavaScript)) != null) {
                    if (conversionHandler != null && conversionOptions.getRemoveJavaScriptNameTree()) {
                        names.removeNamedJavaScripts();
                        if (!conversionHandler.javaScriptNameTreeRemoved()) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2CatalogErrorNamedJavaScriptsPresent(javaScriptObject.getObjNum(), javaScriptObject.getObjGen()));
                    }
                }
                if ((altPresentations = names.getDictionaryCosObjectValue(ASName.k_AlternatePresentations)) != null) {
                    if (conversionHandler != null && conversionOptions.isRemoveAlternatePresentations()) {
                        names.removeValue(ASName.k_AlternatePresentations);
                        if (!conversionHandler.alternatePresentationsRemovedFromNameTree()) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2CatalogErrorAlternatePresentationsNotAllowed(altPresentations.getObjNum(), altPresentations.getObjGen()));
                    }
                }
            }
            if ((openAction = catalog.getOpenAction()) != null && openAction.isAction()) {
                PDFAction action = openAction.getAction();
                PDFAction.TreeIterator actionIter = action.treeIterator();
                while (actionIter.hasNext()) {
                    PDFPage page;
                    PDFActionGoTo goTo;
                    action = actionIter.next();
                    ASName subtype = action.getSubtype();
                    PDFA2AbstractCatalogErrorCode ec = DocumentProcessor.getCatalogActionErrorCode(subtype, action.getCosObject().getObjNum(), action.getCosObject().getObjGen());
                    if (ec != null) {
                        if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                            catalog.setOpenAction(null);
                            if (conversionHandler.openActionRemovedFromCatalog(openAction)) continue;
                            return false;
                        }
                        errorCodes.addErrorCode(ec);
                        continue;
                    }
                    if (subtype == ASName.k_Named) {
                        PDFActionNamed namedAction = (PDFActionNamed)action;
                        ASName actionName = namedAction.getName();
                        if (actionName == ASName.create((String)"NextPage") || actionName == ASName.create((String)"PrevPage") || actionName == ASName.create((String)"FirstPage") || actionName == ASName.create((String)"LastPage")) continue;
                        if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                            catalog.setOpenAction(null);
                            if (conversionHandler.openActionRemovedFromCatalog(openAction)) continue;
                            return false;
                        }
                        errorCodes.addErrorCode(new PDFA2CatalogErrorNonPermittedNamedActionFound(actionName != null ? actionName.toString() : null, openAction.getCosObject().getObjNum(), openAction.getCosObject().getObjGen()));
                        continue;
                    }
                    if (subtype != ASName.k_GoTo || !(goTo = (PDFActionGoTo)action).hasDestination() || (page = goTo.getDestination().getPage()) != null) continue;
                    errorCodes.addErrorCode(new PDFA2CatalogErrorNullPageAsDestination(goTo.getCosObject().getObjNum(), goTo.getCosObject().getObjGen()));
                }
            }
            if ((aa = catalog.getAdditionalActions()) != null) {
                if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                    catalog.removeValue(ASName.k_AA);
                    conversionHandler.illegalAdditionalActionsRemoved((PDFAdditionalActions)aa);
                } else {
                    errorCodes.addErrorCode(new PDFA2CatalogErrorAdditionalActionsNotAllowed(aa.getCosObject().getObjNum(), aa.getCosObject().getObjGen()));
                }
            }
            if ((structTreeRoot = catalog.getStructureRoot()) != null) {
                CosObject cosObject = structTreeRoot.getDictionaryCosObjectValue(ASName.k_K);
                if (!(cosObject instanceof CosDictionary) && !(cosObject instanceof CosArray)) {
                    errorCodes.addErrorCode(new PDFA2CatalogErrorPDFGeneralFailure(cosObject != null ? cosObject.getObjNum() : 0, cosObject != null ? cosObject.getObjGen() : 0));
                } else {
                    this.validateStructureElements(cosObject, errorCodes);
                }
            }
            if (!this.processOptionalContents(catalog, conversionOptions, conversionHandler, errorCodes)) {
                return false;
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2CatalogErrorPDFGeneralFailure(0, 0));
        }
        return !errorCodes.hasErrors() || validationHandler.catalogError(errorCodes);
    }

    private static PDFA2AbstractCatalogErrorCode getCatalogActionErrorCode(ASName subtype, int objectNumber, int genNumber) {
        if (subtype == ASName.k_Launch) {
            return new PDFA2CatalogErrorActionLaunchNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Sound) {
            return new PDFA2CatalogErrorActionSoundNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Movie) {
            return new PDFA2CatalogErrorActionMovieNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_ResetForm) {
            return new PDFA2CatalogErrorActionResetFormNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_ImportData) {
            return new PDFA2CatalogErrorActionImportDataNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Hide) {
            return new PDFA2CatalogErrorActionHideNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_SetOCGState) {
            return new PDFA2CatalogErrorActionSetOCGStateNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Rendition) {
            return new PDFA2CatalogErrorActionRenditionNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Trans) {
            return new PDFA2CatalogErrorActionTransNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_GoTo3DView) {
            return new PDFA2CatalogErrorActionGoTo3DViewNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_JavaScript) {
            return new PDFA2CatalogErrorActionJavaScriptNotAllowed(objectNumber, genNumber);
        }
        String typeString = subtype.asString();
        if ("set-state".equalsIgnoreCase(typeString) || "setstate".equalsIgnoreCase(typeString)) {
            return new PDFA2CatalogErrorActionSetStateNotAllowed(objectNumber, genNumber);
        }
        if ("no-op".equalsIgnoreCase(typeString) || "nop".equalsIgnoreCase(typeString)) {
            return new PDFA2CatalogErrorActionNoOpNotAllowed(objectNumber, genNumber);
        }
        return null;
    }

    private boolean validateStructureElements(CosObject structureElementDictOrArray, PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errorCodes) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (structureElementDictOrArray instanceof CosDictionary) {
            CosDictionary structureElementDict = (CosDictionary)structureElementDictOrArray;
            CosObject cosObject = structureElementDict.get(ASName.k_Type);
            if (cosObject == null || cosObject instanceof CosName && cosObject.nameValue() == ASName.k_StructElem) {
                cosObject = structureElementDict.get(ASName.k_S);
                if (cosObject instanceof CosName) {
                    if (!PDFText.isValidUTF8((byte[])cosObject.nameValue().getBytes())) {
                        errorCodes.addErrorCode(new PDFA2CatalogErrorStructureTypeNameNotValidUTF8(cosObject.nameValue().asString(), 0, 0));
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2CatalogErrorPDFGeneralFailure(0, 0));
                }
                return this.validateStructureElements(structureElementDict.get(ASName.k_K), errorCodes);
            }
        } else if (structureElementDictOrArray instanceof CosArray) {
            CosArray elementsArray = (CosArray)structureElementDictOrArray;
            CosObject elementAtIndex = null;
            ListIterator itr = elementsArray.listIterator();
            while (itr.hasNext()) {
                elementAtIndex = (CosObject)itr.next();
                if (!(elementAtIndex instanceof CosDictionary) || this.validateStructureElements(elementAtIndex, errorCodes)) continue;
                return false;
            }
        }
        return true;
    }

    private void processStructure(PDFA2ConformanceLevel conformanceLevel, PDFCatalog catalog, PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errorCodes, PDFA2ConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (conformanceLevel != PDFA2ConformanceLevel.Level_2a) {
            return;
        }
        if (catalog.hasStructureRoot()) {
            StructureProcessor.processStructureRoot(catalog.getStructureRoot(), errorCodes, conversionHandler);
        } else {
            errorCodes.addErrorCode(new PDFA2CatalogErrorStructureTreeRootEntryMissing(catalog.getCosObject().getObjNum(), catalog.getCosObject().getObjGen()));
        }
    }

    private void processPermissions(PDFPermissions perms, PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errorCodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (perms != null) {
            PDFSignatureReferenceList refList;
            PDFSignature docMDPSig;
            List keys = perms.getCosDictionary().getKeys();
            int objectNumber = perms.getCosObject().getObjNum();
            int genNumber = perms.getCosObject().getObjGen();
            if (keys.size() > 2) {
                errorCodes.addErrorCode(new PDFA2CatalogErrorPermissionsDictionaryHasKeyOtherThanUR3andDocMDP(objectNumber, genNumber));
            }
            if ((docMDPSig = perms.getDocMDP()) != null && (refList = docMDPSig.getSignatureReferences()) != null) {
                for (PDFSignatureReference sigRef : refList) {
                    if (sigRef.getDigestLocation() != null) {
                        errorCodes.addErrorCode(new PDFA2CatalogErrorPermissionsHasDocMDPAndSigRefHasDigestLocation(objectNumber, genNumber));
                    }
                    if (sigRef.getDigestMethod() != null) {
                        errorCodes.addErrorCode(new PDFA2CatalogErrorPermissionsHasDocMDPAndSigRefHasDigestMethod(objectNumber, genNumber));
                    }
                    if (sigRef.getDigest() == null) continue;
                    errorCodes.addErrorCode(new PDFA2CatalogErrorPermissionsHasDocMDPAndSigRefHasDigestValue(objectNumber, genNumber));
                }
            }
            keys.remove(ASName.k_UR3);
            keys.remove(ASName.k_DocMDP);
            if (!keys.isEmpty()) {
                errorCodes.addErrorCode(new PDFA2CatalogErrorPermissionsDictionaryHasKeyOtherThanUR3andDocMDP(objectNumber, genNumber));
            }
        }
    }

    private boolean processBookMark(PDFBookmarkRoot bmRoot, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        block9: {
            if (bmRoot == null) {
                return true;
            }
            try {
                PDFBookmarkNode.Iterator bmIter = bmRoot.iterator();
                int objectNumber = 0;
                int genNumber = 0;
                while (bmIter.hasNext()) {
                    PDFA2ErrorSet<PDFA2AbstractBookmarkErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractBookmarkErrorCode>();
                    PDFBookmark bm = bmIter.next();
                    if (bm.hasAction()) {
                        PDFAction action = bm.getAction();
                        PDFAction.TreeIterator actionIter = action.treeIterator();
                        while (actionIter.hasNext()) {
                            PDFActionNamed namedAction;
                            ASName actionName;
                            action = actionIter.next();
                            ASName subtype = action.getSubtype();
                            PDFA2AbstractBookmarkErrorCode ec = DocumentProcessor.getBookmarkActionErrorCode(subtype, objectNumber = action.getCosObject().getObjNum(), genNumber = action.getCosObject().getObjGen());
                            if (ec != null) {
                                if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                                    bm.removeValue(ASName.k_A);
                                    if (conversionHandler.illegalActionRemoved(action)) continue;
                                    return false;
                                }
                                errorCodes.addErrorCode(ec);
                                continue;
                            }
                            if (subtype != ASName.k_Named || (actionName = (namedAction = (PDFActionNamed)action).getName()) == ASName.create((String)"NextPage") || actionName == ASName.create((String)"PrevPage") || actionName == ASName.create((String)"FirstPage") || actionName == ASName.create((String)"LastPage")) continue;
                            if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                                bm.removeValue(ASName.k_A);
                                if (conversionHandler.illegalActionRemoved(action)) continue;
                                return false;
                            }
                            errorCodes.addErrorCode(new PDFA2BookmarkErrorNonPermittedNamedActionFound(actionName != null ? actionName.asString() : null, objectNumber, genNumber));
                        }
                    }
                    if (!errorCodes.hasErrors() || validationHandler.bookmarkError(bm, errorCodes)) continue;
                    return false;
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (validationHandler.bookmarkError(null, new PDFA2ErrorSet<PDFA2AbstractBookmarkErrorCode>(new PDFA2BookmarkErrorPDFGeneralFailure(0, 0)))) break block9;
                return false;
            }
        }
        return true;
    }

    public static PDFA2AbstractBookmarkErrorCode getBookmarkActionErrorCode(ASName subtype, int objectNumber, int genNumber) {
        if (subtype == ASName.k_Launch) {
            return new PDFA2BookmarkErrorActionLaunchNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Sound) {
            return new PDFA2BookmarkErrorActionSoundNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Movie) {
            return new PDFA2BookmarkErrorActionMovieNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_ResetForm) {
            return new PDFA2BookmarkErrorActionResetFormNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_ImportData) {
            return new PDFA2BookmarkErrorActionImportDataNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Hide) {
            return new PDFA2BookmarkErrorActionHideNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_SetOCGState) {
            return new PDFA2BookmarkErrorActionSetOCGStateNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Rendition) {
            return new PDFA2BookmarkErrorActionRenditionNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_Trans) {
            return new PDFA2BookmarkErrorActionTransNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_GoTo3DView) {
            return new PDFA2BookmarkErrorActionGoTo3DViewNotAllowed(objectNumber, genNumber);
        }
        if (subtype == ASName.k_JavaScript) {
            return new PDFA2BookmarkErrorActionJavaScriptNotAllowed(objectNumber, genNumber);
        }
        String typeString = subtype.asString();
        if ("set-state".equalsIgnoreCase(typeString) || "setstate".equalsIgnoreCase(typeString)) {
            return new PDFA2BookmarkErrorActionSetStateNotAllowed(objectNumber, genNumber);
        }
        if ("no-op".equalsIgnoreCase(typeString) || "nop".equalsIgnoreCase(typeString)) {
            return new PDFA2BookmarkErrorActionNoOpNotAllowed(objectNumber, genNumber);
        }
        return null;
    }

    private boolean processOptionalContents(PDFCatalog catalog, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCProperties ocProperties = catalog.getOCProperties();
        if (ocProperties == null) {
            return true;
        }
        PDFOCGroupArray allOCGs = ocProperties.getOCGs();
        HashSet<String> ocConfigNames = new HashSet<String>();
        HashSet<PDFOCConfig> configsWithoutName = new HashSet<PDFOCConfig>();
        PDFOCConfig defaultConfig = ocProperties.getDefaultOCConfigDict();
        if (!this.processOptionalContentConfigDict(defaultConfig, allOCGs, errors, ocConfigNames, configsWithoutName, conversionOptions, conversionHandler)) {
            return false;
        }
        PDFOCConfigList configList = ocProperties.getOCConfigsArray();
        if (configList != null) {
            for (PDFOCConfig config : configList) {
                if (this.processOptionalContentConfigDict(config, allOCGs, errors, ocConfigNames, configsWithoutName, conversionOptions, conversionHandler)) continue;
                return false;
            }
        }
        if (conversionHandler != null && !configsWithoutName.isEmpty()) {
            for (PDFOCConfig config : configsWithoutName) {
                String name = conversionHandler.getConfigName(config, ocConfigNames);
                if (name != null) {
                    config.setName(name);
                    ocConfigNames.add(name);
                    continue;
                }
                CosObject obj = config.getCosObject();
                errors.addErrorCode(new PDFA2CatalogErrorOptionalContentConfigHasNoNamePresent(obj.getObjNum(), obj.getObjGen()));
            }
        }
        return true;
    }

    private boolean processOptionalContentConfigDict(PDFOCConfig config, PDFOCGroupArray allOCGs, PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errors, Set<String> ocConfigNames, HashSet<PDFOCConfig> configsWithoutName, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCOrderList orderList;
        if (config == null) {
            return true;
        }
        String configName = config.getName();
        int objectNumber = config.getCosObject().getObjNum();
        int genNumber = config.getCosObject().getObjGen();
        if (configName == null) {
            if (conversionHandler != null) {
                configsWithoutName.add(config);
            } else {
                errors.addErrorCode(new PDFA2CatalogErrorOptionalContentConfigHasNoNamePresent(objectNumber, genNumber));
            }
        } else if (ocConfigNames.contains(configName)) {
            errors.addErrorCode(new PDFA2CatalogErrorOptionalContentConfigHasNameNotUnique(objectNumber, genNumber));
        } else {
            ocConfigNames.add(configName);
        }
        if (config.dictionaryContains(ASName.k_AS)) {
            if (conversionHandler != null && conversionOptions.isRemoveASKeyFromOCConfigDict()) {
                config.removeValue(ASName.k_AS);
                if (!conversionHandler.asKeyRemovedFromOptionalContentConfig()) {
                    return false;
                }
            } else {
                errors.addErrorCode(new PDFA2CatalogErrorOptionalContentConfigDictHasAsKeyPresent(objectNumber, genNumber));
            }
        }
        if (!errors.errorCodeSet(PDFA2CatalogErrorOrderListDoesNotReferAllOCGs.class) && (orderList = config.getOrderList()) != null) {
            HashSet<PDFOCGroup> ocGroupSet = new HashSet<PDFOCGroup>();
            this.addOCGsToSet(orderList, ocGroupSet);
            if (!this.orderListRefersAllOCGs(ocGroupSet, allOCGs)) {
                if (conversionHandler != null && conversionOptions.isRemoveOrderKeyFromOptionalContentConfig()) {
                    config.removeValue(ASName.k_Order);
                    if (!conversionHandler.orderKeyRemovedFromOptionalContentConfig()) {
                        return false;
                    }
                } else {
                    errors.addErrorCode(new PDFA2CatalogErrorOrderListDoesNotReferAllOCGs(0, 0));
                }
            }
        }
        return true;
    }

    private boolean orderListRefersAllOCGs(Set<PDFOCGroup> ocgSet, PDFOCGroupArray allOCGs) {
        if (allOCGs == null) {
            return ocgSet.isEmpty();
        }
        for (PDFOCGroup oc : allOCGs) {
            if (ocgSet.contains(oc)) {
                ocgSet.remove(oc);
                continue;
            }
            return false;
        }
        return ocgSet.isEmpty();
    }

    private void addOCGsToSet(PDFOCOrderList orderList, Set<PDFOCGroup> ocSet) throws PDFInvalidDocumentException {
        if (orderList == null) {
            return;
        }
        for (PDFOCOrderListContent listContent : orderList) {
            if (listContent instanceof PDFOCGroup) {
                ocSet.add((PDFOCGroup)listContent);
                continue;
            }
            if (!(listContent instanceof PDFOCOrderList)) continue;
            this.addOCGsToSet((PDFOCOrderList)listContent, ocSet);
        }
    }

    private boolean processOutputIntentList(PDFOutputIntentsList intents, TrackingValidationHandler handler, PDFA2ValidationOptions options, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Boolean continueProcessing;
        if (intents == null) {
            return true;
        }
        if (!handler.beginOutputIntentScan()) {
            return false;
        }
        HashSet<PDFICCProfile> foundProfiles = new HashSet<PDFICCProfile>();
        PDFA2OutputIntentErrorMultipleDestOutputProfiles multipleDestOutputProfilesError = null;
        PDFOutputIntent intent = null;
        PDFICCProfile profile = null;
        Iterator iter = intents.iterator();
        while (iter.hasNext() && (continueProcessing = Boolean.valueOf(this.processOutputIntent(intent = (PDFOutputIntent)iter.next(), handler, options, conversionHandler, conversionOptions, false))) != null) {
            if (!continueProcessing.booleanValue()) {
                return false;
            }
            profile = intent.getDestOutputProfile();
            if (foundProfiles.isEmpty()) {
                foundProfiles.add(profile);
                continue;
            }
            if (multipleDestOutputProfilesError != null || foundProfiles.contains(profile)) continue;
            multipleDestOutputProfilesError = new PDFA2OutputIntentErrorMultipleDestOutputProfiles(0, 0, 0);
        }
        if (multipleDestOutputProfilesError != null) {
            multipleDestOutputProfilesError.setNumberOfoutputIntentEntries(foundProfiles.size());
            if (!handler.outputIntentsError(null, new PDFA2ErrorSet<PDFA2AbstractOutputIntentErrorCode>(multipleDestOutputProfilesError))) {
                return false;
            }
        }
        return handler.endOutputIntentScan();
    }

    boolean processOutputIntent(PDFOutputIntent intent, TrackingValidationHandler handler, PDFA2ValidationOptions options, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, boolean clientOutputIntentVerified) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (intent == null) {
            return true;
        }
        PDFA2ErrorSet<PDFA2AbstractOutputIntentErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractOutputIntentErrorCode>();
        PDFICCProfile profile = intent.getDestOutputProfile();
        if (profile == null) {
            return true;
        }
        try {
            if (!DocumentProcessor.processIccProfile(profile, this, errorCodes, handler, options)) {
                return false;
            }
            try {
                ColorSpace cs = profile.getColorSpace();
                if (intent.getSubType().equals((Object)SharedConstraints.k_GTS_PDFA1)) {
                    int noOfComponents = -1;
                    switch (cs.getType()) {
                        case 6: {
                            noOfComponents = 1;
                            break;
                        }
                        case 5: {
                            noOfComponents = 3;
                            break;
                        }
                        case 9: {
                            noOfComponents = 4;
                            break;
                        }
                    }
                    int N = profile.getNumberOfComponents();
                    if (N != noOfComponents) {
                        errorCodes.addErrorCode(new PDFA2OutputIntentErrorIncorrectValueForKeyN(profile.getCosObject().getObjNum(), profile.getCosObject().getObjGen()));
                    }
                    if (conversionHandler != null && noOfComponents != -1) {
                        profile.setNumberOfComponents(noOfComponents);
                        errorCodes.unSetErrorCode(PDFA2OutputIntentErrorIncorrectValueForKeyN.class);
                    }
                }
            }
            catch (PDFException e) {
                errorCodes.addErrorCode(new PDFA2OutputIntentErrorInvalidDestOutputProfile(profile.getCosObject().getObjNum(), profile.getCosObject().getObjGen()));
            }
            if (intent.getSubType() == SharedConstraints.k_GTS_PDFX && intent.getCosDictionary().containsKey((Object)k_DestOutputProfileRef)) {
                errorCodes.addErrorCode(new PDFA2OutputIntentErrorPDFXOutputIntentHasDestOutputProfileRef(intent.getCosObject().getObjNum(), intent.getCosObject().getObjGen()));
            }
        }
        catch (Exception e) {
            errorCodes.addErrorCode(new PDFA2OutputIntentErrorInvalidDestOutputProfile(profile.getCosObject().getObjNum(), profile.getCosObject().getObjGen()));
        }
        if (errorCodes.hasErrors() && !handler.outputIntentsError(intent, errorCodes)) {
            return false;
        }
        if (errorCodes.hasErrors()) {
            if (conversionHandler != null) {
                PDFOutputIntent outputIntent = conversionOptions.getPDFAOutputIntent();
                if (!clientOutputIntentVerified && outputIntent != null && conversionOptions.overWritePDFAOutputIntentSet() && !this.outputIntentReplaced) {
                    PDFOutputIntentsList outputIntentsList = PDFOutputIntentsList.newInstance((PDFDocument)this.document);
                    outputIntentsList.add((PDFCosObjectContainer)outputIntent);
                    intent.getPDFDocument().requireCatalog().setOutputIntents(outputIntentsList);
                    this.outputIntentReplaced = true;
                    conversionHandler.pdfaOutputIntentSet(outputIntent);
                    Boolean continueProcessing = this.processOutputIntent(outputIntent, handler, options, conversionHandler, conversionOptions, true);
                    return continueProcessing == true ? null : Boolean.valueOf(false);
                }
                if (!handler.outputIntentsError(intent, errorCodes)) {
                    return false;
                }
            } else if (!handler.outputIntentsError(intent, errorCodes)) {
                return false;
            }
        }
        return true;
    }

    private static boolean processIccProfile(PDFICCProfile pdfProfile, DocumentProcessor docProcessor, PDFA2ErrorSet<PDFA2AbstractOutputIntentErrorCode> errorSet, TrackingValidationHandler handler, PDFA2ValidationOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int objectNumber = pdfProfile.getCosObject().getObjNum();
        int genNumber = pdfProfile.getCosObject().getObjGen();
        try {
            ICC_ColorSpace iccCS = (ICC_ColorSpace)pdfProfile.getColorSpace();
            ICC_Profile iccProfile = iccCS.getProfile();
            if (iccProfile.getProfileClass() != 1 && iccProfile.getProfileClass() != 2) {
                errorSet.addErrorCode(new PDFA2OutputIntentErrorInvalidDeviceClassProfile(objectNumber, genNumber));
            }
            if (iccCS.getType() != 6 && iccCS.getType() != 5 && iccCS.getType() != 9) {
                errorSet.addErrorCode(new PDFA2OutputIntentErrorInvalidColorSpaceInProfile(objectNumber, genNumber));
            }
            try {
                String profileVersion = String.valueOf(iccProfile.getMajorVersion()) + "." + String.valueOf(iccProfile.getMinorVersion());
                if (!ColorSpaceProcessor.processIccProfile(pdfProfile, new PDFA2OutputIntentErrorICCProfileVersion5OrNewer(profileVersion, objectNumber, genNumber), new PDFA2OutputIntentErrorICCProfileVersionOlderThan2(profileVersion, objectNumber, genNumber), new PDFA2OutputIntentErrorICCProfileVersion3(objectNumber, genNumber), errorSet, docProcessor, handler, options, true)) {
                    return false;
                }
            }
            catch (PDFInvalidContentException e) {
                errorSet.addErrorCode(new PDFA2OutputIntentErrorICCProfileCouldNotBeParsed(objectNumber, genNumber));
            }
        }
        catch (PDFInvalidContentException e) {
            errorSet.addErrorCode(new PDFA2OutputIntentErrorICCProfileCouldNotBeParsed(objectNumber, genNumber));
        }
        return true;
    }

    private static void updateContentStream(FontContext fontContext, DocumentProcessor documentProcessor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument document = documentProcessor.document;
        for (PDFPage page : document.requirePages()) {
            PDFPatternMap patternmap;
            Content content = Content.newInstance((PDFPage)page);
            HashSet<PDFFont> fontsInPage = FontProcessorUtils.getFontsInPage(page);
            DocumentProcessor.updateContentStream(fontContext, fontsInPage, content, documentProcessor);
            PDFXObjectMap pdfxObjectMap = page.getResources().getXObjectMap();
            if (pdfxObjectMap != null) {
                for (Map.Entry entry : pdfxObjectMap.entrySet()) {
                    PDFXObject xobj = (PDFXObject)entry.getValue();
                    if (!(xobj instanceof PDFXObjectForm)) continue;
                    Content xContent = Content.newInstance((PDFXObjectForm)((PDFXObjectForm)xobj));
                    DocumentProcessor.updateContentStream(fontContext, fontsInPage, xContent, documentProcessor);
                }
            }
            if ((patternmap = page.getResources().getPatternMap()) == null) continue;
            Iterator pIter = patternmap.entrySet().iterator();
            while (pIter.hasNext()) {
                PDFPattern pattern = (PDFPattern)((Map.Entry)pIter.next()).getValue();
                if (!(pattern instanceof PDFPatternTiling)) continue;
                Content pContent = Content.newInstance((PDFContents)((PDFPatternTiling)pattern).getContents(), (PDFResources)((PDFPatternTiling)pattern).getResources());
                DocumentProcessor.updateContentStream(fontContext, fontsInPage, pContent, documentProcessor);
            }
        }
    }

    private static void updateContentStream(FontContext fontContext, HashSet<PDFFont> fontsInPage, Content content, DocumentProcessor docProcessor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set<PDFFont> updatedFonts = fontContext.getFontWidthMap().keySet();
        boolean updateStream = false;
        for (PDFFont font : fontsInPage) {
            if (updatedFonts != null & updatedFonts.contains(font)) {
                updateStream = true;
                break;
            }
            if (!fontContext.getFontsWithoutTextShowString().contains(font)) continue;
            updateStream = true;
            break;
        }
        if (updateStream || docProcessor.isSkippedCharacters()) {
            try {
                ContentStreamTransformer.transformContent((Content)content, (IContentStreamFilter)new TextLayoutPreservingFilter(fontContext.getFontWidthMap(), content));
            }
            catch (PDFFontException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
        }
    }

    public void setFontContext(FontContext fontContext) {
        this.fontContext = fontContext;
    }

    public FontContext getFontContext() {
        return this.fontContext;
    }

    private boolean checkAndAddToAssociatedFileSet(PDFCatalog pdfCatalog) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDPart dpart;
        PDFDPartRoot dpartRoot;
        boolean emptyAFEntry = true;
        emptyAFEntry &= this.checkAndAddToAssociatedFileSet(pdfCatalog.getAssociatedFiles());
        PDFMarkInfo markInfo = pdfCatalog.getMarkInfo();
        if (markInfo != null) {
            emptyAFEntry &= this.checkAndAddToAssociatedFileSet(markInfo.getAssociatedFiles());
        }
        if ((dpartRoot = pdfCatalog.getDPartRoot()) != null && (dpart = dpartRoot.getDPartRootNode()) != null) {
            emptyAFEntry &= this.checkAndAddToAssociatedFileSet(dpart.getAssociatedFiles());
            List dpartsListList = dpart.getDParts();
            if (dpartsListList != null) {
                for (List dpartList : dpartsListList) {
                    if (dpartList == null) continue;
                    for (PDFDPart part : dpartList) {
                        if (part == null) continue;
                        emptyAFEntry &= this.checkAndAddToAssociatedFileSet(part.getAssociatedFiles());
                    }
                }
            }
        }
        return emptyAFEntry;
    }

    boolean checkAndAddToAssociatedFileSet(PDFFileSpecificationList fileSpecificationList) {
        if (fileSpecificationList != null) {
            if (fileSpecificationList.isEmpty()) {
                return false;
            }
            for (PDFFileSpecification fileSpec : fileSpecificationList) {
                this.associatedFileSpecList.add(fileSpec.getCosObject());
            }
        }
        return true;
    }

    class UseColor {
        boolean found = false;
        boolean useRGB = false;
        boolean useCMYK = false;

        UseColor() {
        }
    }
}

