/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFieldErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FieldErrorActionNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FieldErrorAdditionalActionsNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FieldErrorNeedAppearancesSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FieldErrorPDFGeneralFailure;

class AcroFormProcessor {
    AcroFormProcessor() {
    }

    static boolean process(PDFInteractiveForm iform, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        if (iform == null) {
            return true;
        }
        if (!validationHandler.beginFormFieldTreeScan()) {
            return false;
        }
        PDFA2ErrorSet<PDFA2AbstractFieldErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractFieldErrorCode>();
        try {
            if (iform.getNeedAppearances()) {
                errorCodes.addErrorCode(new PDFA2FieldErrorNeedAppearancesSet(iform.getCosObject().getObjNum(), iform.getCosObject().getObjGen()));
            }
            for (PDFField field : iform) {
                if (AcroFormProcessor.process(field, conversionOptions, conversionHandler, validationHandler, errorCodes)) continue;
                return false;
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2FieldErrorPDFGeneralFailure(iform.getCosObject().getObjNum(), iform.getCosObject().getObjGen()));
        }
        if (errorCodes.hasErrors() && !validationHandler.formFieldError(errorCodes)) {
            return false;
        }
        return validationHandler.endFormFieldTreeScan();
    }

    static boolean process(PDFField field, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ValidationHandler validationHandler, PDFA2ErrorSet<PDFA2AbstractFieldErrorCode> errorCodes) throws PDFIOException, PDFSecurityException {
        if (field == null) {
            return true;
        }
        if (!validationHandler.beginFormFieldScan(field)) {
            return false;
        }
        int fieldObjNum = field.getCosObject().getObjNum();
        int fieldGenNum = field.getCosObject().getObjGen();
        try {
            if (field.getCosDictionary().containsKey((Object)ASName.k_A)) {
                if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                    CosDictionary actionDict = (CosDictionary)field.getCosDictionary().get(ASName.k_A);
                    PDFAction action = PDFActionFactory.getInstance((CosObject)actionDict);
                    field.getCosDictionary().remove(ASName.k_A);
                    if (!conversionHandler.illegalActionRemoved(action)) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2FieldErrorActionNotAllowed(fieldObjNum, fieldGenNum));
                }
            }
            if (field.getAdditionalActions() != null) {
                if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                    PDFAdditionalActions aa = field.getAdditionalActions();
                    if (field.getDictionaryDictionaryValue(ASName.k_AA) == null && field.isAcrobatAnnotation()) {
                        field.getParent().getCosDictionary().remove(ASName.k_AA);
                    } else {
                        field.getCosDictionary().remove(ASName.k_AA);
                    }
                    if (!conversionHandler.illegalAdditionalActionsRemoved(aa)) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2FieldErrorAdditionalActionsNotAllowed(fieldObjNum, fieldGenNum));
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2FieldErrorPDFGeneralFailure(fieldObjNum, fieldGenNum));
        }
        return validationHandler.endFormFieldScan();
    }
}

