/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontDataCorrupt;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedWidthsInfo;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMissingOrIncompleteWidthsArray;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.ReferencedFontInfoProcessor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

class WidthsProcessor {
    WidthsProcessor() {
    }

    private static boolean compareWidthTypeFont(PDFCIDFontWidths pdfCIDFontWidths, Iterator<Integer> charCodesIter, PDFFontType0 font, Font afeFont, int dw) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        boolean widthsChanged = false;
        double[] dWidths = new double[1];
        while (charCodesIter.hasNext()) {
            Integer charCodeInt = charCodesIter.next();
            int charCode = charCodeInt;
            int gid = font.charCode2gid(charCode);
            int cid = font.getEncoding().getCID(charCode);
            if (gid <= 0) continue;
            dWidths[0] = afeFont.getPDFFontDescription().getAdvance(gid);
            if (!(Math.abs(dWidths[0] - (double)dw) > 1.0)) continue;
            pdfCIDFontWidths.addWidths(dWidths, cid, cid);
            widthsChanged = true;
        }
        return widthsChanged;
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> processWidths(PDFFont font, TreeSet<Integer> tSet, List showStringList, PDFA2ConversionHandler conversionHandler, PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes, FontContext fontContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        if (font == null) {
            return errorCodes;
        }
        int objectNumber = font.getCosObject().getObjNum();
        int genNumber = font.getCosObject().getObjGen();
        if (font instanceof PDFFontSimple) {
            PDFFontSimple simpleFont = (PDFFontSimple)font;
            int firstChar = 0;
            int lastChar = 255;
            int[] Widths = null;
            try {
                firstChar = simpleFont.getFirstChar();
                lastChar = simpleFont.getLastChar();
                Widths = simpleFont.getWidths();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (Widths == null) {
                errorCodes.addErrorCode(new PDFA2FontErrorMissingOrIncompleteWidthsArray(objectNumber, genNumber));
            } else {
                int numChars = lastChar - firstChar + 1;
                if (Widths.length != numChars) {
                    errorCodes.addErrorCode(new PDFA2FontErrorMissingOrIncompleteWidthsArray(objectNumber, genNumber));
                }
            }
            if (conversionHandler != null && (errorCodes.errorCodeSet(PDFA2FontErrorMismatchedWidthsInfo.class) || errorCodes.errorCodeSet(PDFA2FontErrorMissingOrIncompleteWidthsArray.class)) && FontProcessorUtils.embedWidthsArray(simpleFont, null, fontContext, tSet)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorMismatchedWidthsInfo.class);
                errorCodes.unSetErrorCode(PDFA2FontErrorMissingOrIncompleteWidthsArray.class);
                if (!conversionHandler.widthsMetricsUpdated(font)) {
                    return null;
                }
            }
        } else if (font instanceof PDFFontType0 && conversionHandler != null && (errorCodes.errorCodeSet(PDFA2FontErrorMismatchedWidthsInfo.class) || errorCodes.errorCodeSet(PDFA2FontErrorMissingOrIncompleteWidthsArray.class))) {
            PDFFontType0 type0Font = (PDFFontType0)font;
            PDFCIDFont cidFont = type0Font.getDescendantFont();
            HashSet<Integer> charCodes = ReferencedFontInfoProcessor.getReferencedCharCodes(font, showStringList);
            if (charCodes == null) {
                return errorCodes;
            }
            int dw = cidFont.getDW();
            Font afeFont = null;
            try {
                afeFont = font.getAFEFont();
            }
            catch (FontEngineException e3) {
                errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
            }
            PDFCIDFontWidths pdfCIDFontWidths = PDFCIDFontWidths.newInstance((PDFDocument)font.getPDFDocument());
            Iterator<Integer> iter = charCodes.iterator();
            try {
                WidthsProcessor.compareWidthTypeFont(pdfCIDFontWidths, iter, type0Font, afeFont, dw);
            }
            catch (FontEngineException e) {
                errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
            }
            catch (PDFFontException e) {
                errorCodes.addErrorCode(new PDFA2FontErrorPDFGeneralFailure(objectNumber, genNumber));
            }
            cidFont.setDW(dw);
            cidFont.setW(pdfCIDFontWidths);
            errorCodes.unSetErrorCode(PDFA2FontErrorMismatchedWidthsInfo.class);
            errorCodes.unSetErrorCode(PDFA2FontErrorMissingOrIncompleteWidthsArray.class);
            if (!conversionHandler.widthsMetricsUpdated(font)) {
                return null;
            }
        }
        return errorCodes;
    }
}

