/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.font;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCharProcs;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorEmbeddedFontMissingGlyphs;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedWidthsInfo;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeAbsentInFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeIncorrectInFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ContentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TransparencyState;
import java.util.HashSet;

class Type3FontProcessor {
    Type3FontProcessor() {
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> processType3FontErrors(PDFFont font, HashSet<Integer> referencedCharCodes, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, TransparencyState transparencyInfo, PDFA2ConformanceLevel conformanceLevel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (font == null || referencedCharCodes == null) {
            return new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        }
        if (!(font instanceof PDFFontType3)) {
            return new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        }
        int objectNumber = font.getCosObject().getObjNum();
        int genNumber = font.getCosObject().getObjGen();
        CosObject fontTypeCosObj = font.getCosDictionary().get(ASName.k_Type);
        String fontType = fontTypeCosObj instanceof CosName ? fontTypeCosObj.nameValue().asString() : null;
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        FontProcessor.setTypeErrorCodes(font.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, new PDFA2FontErrorTypeIncorrectInFont(fontType, objectNumber, genNumber), new PDFA2FontErrorTypeAbsentInFont(objectNumber, genNumber));
        PDFFontType3 type3 = (PDFFontType3)font;
        PDFResources resources = type3.getResources();
        PDFCharProcs charProcs = type3.getCharProcs();
        if (charProcs == null) {
            return new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        }
        PDFSimpleFontEncoding encoding = type3.getEncoding();
        if (encoding == null) {
            return errorCodes;
        }
        for (Integer charCodeInt : referencedCharCodes) {
            PDFContents charStm;
            double glyphWidth;
            int charCode = charCodeInt;
            ASName charName = encoding.getGlyphNameAsASName(charCode);
            double charProcsWidth = charProcs.getWidth(charName) * type3.getFontMatrix().geta();
            if (Math.abs(charProcsWidth - (glyphWidth = type3.getGlyphWidthDefaultMissingWidth(charCode) * type3.getFontMatrix().geta())) > 0.001) {
                errorCodes.addErrorCode(new PDFA2FontErrorMismatchedWidthsInfo(objectNumber, genNumber));
            }
            if ((charStm = (PDFContents)charProcs.get((Object)charName)) != null) {
                Content content = Content.newInstance((PDFContents)charStm, (PDFResources)resources);
                if (ContentProcessor.process(content, (PDFCosDictionary)charProcs, charName, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null, transparencyInfo)) continue;
                return null;
            }
            errorCodes.addErrorCode(new PDFA2FontErrorEmbeddedFontMissingGlyphs(objectNumber, genNumber));
        }
        FontProcessorUtils.processToUnicodeRequirement(conversionHandler, referencedCharCodes, errorCodes, font, conformanceLevel);
        return errorCodes;
    }
}

