/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.common.TrueTypeCmapSelector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorEmbeddedFontMissingGlyphs;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorEmbeddingFailedFontNotInFontSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorEmbeddingFailedGlyphError;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorEmbeddingFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontDataCorrupt;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedWidthsInfo;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorNotDefGlyphUsed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.UnembeddedFontInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

class ReferencedFontInfoProcessor {
    ReferencedFontInfoProcessor() {
    }

    static HashSet<Integer> getReferencedCharCodes(PDFFont font, List<ASString> showStringList) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font == null || showStringList == null) {
            return null;
        }
        HashSet<Integer> referencedCharCodes = new HashSet<Integer>();
        for (ASString showString : showStringList) {
            if (showString == null) continue;
            List charCodes = null;
            try {
                charCodes = font.getCharCodes(showString.getBytes(), false);
            }
            catch (MissingResourceException e) {
                return referencedCharCodes;
            }
            catch (PDFInvalidDocumentException e) {
                if (e.getCause() instanceof MissingResourceException) {
                    return referencedCharCodes;
                }
                throw e;
            }
            for (List charCodeInfo : charCodes) {
                byte[] charCodeBytes = (byte[])charCodeInfo.get(0);
                if (charCodeBytes == null) continue;
                int charCode = 0;
                for (int i = 0; i < charCodeBytes.length; ++i) {
                    if (i > 0) {
                        charCode <<= 8;
                    }
                    charCode |= charCodeBytes[i] & 0xFF;
                }
                Integer charCodeInt = charCode;
                if (referencedCharCodes.contains(charCodeInt)) continue;
                referencedCharCodes.add(charCodeInt);
            }
        }
        return referencedCharCodes;
    }

    static PDFA2AbstractFontErrorCode getReferencedCPsPostNames(PDFFontSimple font, UnembeddedFontInfo ufInfo, Set<Integer> codePoints, Set<String> postNames) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font == null) {
            return new PDFA2FontErrorEmbeddingFailure(0, 0);
        }
        if (ufInfo == null) {
            return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
        }
        try {
            Font afeFont = font.getAFEFont();
            if (afeFont == null) {
                return new PDFA2FontErrorEmbeddingFailedFontNotInFontSet(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
            }
            PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
            if (afeFontDesc == null) {
                return new PDFA2FontErrorFontDataCorrupt(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
            }
            FontData fontData = font.getAFEFontData();
            if (fontData == null) {
                return new PDFA2FontErrorFontDataCorrupt(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
            }
            PDFFontDescriptor oldFontDesc = font.getFontDescriptor();
            boolean isSymbolic = oldFontDesc != null ? (oldFontDesc.getFlags() & 4) != 0 : false;
            int platformID = -1;
            int platformSpecificID = -1;
            if (fontData instanceof OpenTypeFont && ((OpenTypeFont)fontData).getCFFFont() == null) {
                Set<Integer> charCodeSet;
                OpenTypeFont otFont = (OpenTypeFont)fontData;
                Cmap cmapTable = otFont.cmap;
                if (cmapTable != null) {
                    TrueTypeCmapSelector selector = new TrueTypeCmapSelector();
                    cmapTable.enumerateCmaps((Cmap.CmapSelector)selector);
                    if (isSymbolic && selector.threeZeroExists()) {
                        platformID = 3;
                        platformSpecificID = 0;
                    } else if (!isSymbolic && selector.threeOneExists()) {
                        platformID = 3;
                        platformSpecificID = 1;
                    } else if (selector.oneZeroExists()) {
                        platformID = 1;
                        platformSpecificID = 0;
                    } else if (selector.getCmapCount() > 0) {
                        platformID = selector.getfirstPlatformID();
                        platformSpecificID = selector.getfirstPlatformSpecificID();
                    } else if (isSymbolic) {
                        ufInfo.setCharCodes(null);
                        return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
                    }
                    ufInfo.setPlatformID(platformID);
                    ufInfo.setPlatformSpecificID(platformSpecificID);
                }
                if ((charCodeSet = ufInfo.getCharCodes()) == null) {
                    return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
                }
                Iterator<Integer> iter = charCodeSet.iterator();
                PDFSimpleFontEncoding encoding = font.getEncoding();
                while (iter.hasNext()) {
                    Integer charCodeInt = iter.next();
                    int charCode = charCodeInt;
                    int cp = font.charCode2CodePoint(charCode);
                    if (cp != 0) {
                        codePoints.add(cp);
                        continue;
                    }
                    if (isSymbolic) {
                        ufInfo.setCharCodes(null);
                        return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
                    }
                    if (encoding == null) continue;
                    String glyphName = encoding.getGlyphName(charCode);
                    postNames.add(glyphName);
                }
            }
        }
        catch (FontEngineException e) {
            return new PDFA2FontErrorFontDataCorrupt(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
        }
        ufInfo.setCharCodes(null);
        return null;
    }

    static PDFA2AbstractFontErrorCode getReferencedCharNames(PDFFontSimple font, UnembeddedFontInfo ufInfo, Set<String> glyphNames) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font == null) {
            return new PDFA2FontErrorEmbeddingFailure(0, 0);
        }
        if (ufInfo == null) {
            return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
        }
        Set<Integer> charCodeSet = ufInfo.getCharCodes();
        if (charCodeSet == null) {
            return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
        }
        Iterator<Integer> iter = charCodeSet.iterator();
        LinkedHashMap<Integer, String> charNamesMap = new LinkedHashMap<Integer, String>();
        while (iter.hasNext()) {
            int gid;
            Integer charCodeInt = iter.next();
            int charCode = charCodeInt;
            String glyphName = null;
            try {
                glyphName = font.charCode2glyphName(charCode);
            }
            catch (PDFFontException e) {
                return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
            }
            if (glyphName == null || glyphName.equals(".notdef")) {
                return new PDFA2FontErrorEmbeddingFailedGlyphError(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
            }
            FontData fontData = font.getAFEFontData();
            if (fontData != null && fontData instanceof Type1Font && (gid = ((Type1Font)fontData).charCode2gid(charCode)) <= 0) {
                return new PDFA2FontErrorEmbeddingFailedGlyphError(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
            }
            charNamesMap.put(charCodeInt, glyphName);
            if (glyphNames == null) continue;
            glyphNames.add(glyphName);
        }
        ufInfo.setCharNamesMap(charNamesMap);
        ufInfo.setCharCodes(null);
        return null;
    }

    static PDFA2AbstractFontErrorCode getReferencedCIDsGIDs(PDFFontType0 font, UnembeddedFontInfo ufInfo, Map<Integer, int[]> cidGidMap) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font == null) {
            return new PDFA2FontErrorEmbeddingFailure(0, 0);
        }
        if (ufInfo == null) {
            return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
        }
        Set<Integer> charCodeSet = ufInfo.getCharCodes();
        if (charCodeSet == null || charCodeSet.isEmpty()) {
            return new PDFA2FontErrorEmbeddingFailure(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
        }
        Iterator<Integer> iter = charCodeSet.iterator();
        try {
            while (iter.hasNext()) {
                int[] cidgid = new int[2];
                Integer charCodeInt = iter.next();
                int charCode = charCodeInt;
                cidgid[0] = font.getEncoding().getCID(charCode);
                cidgid[1] = font.charCode2gid(charCode);
                if (cidGidMap.get(charCodeInt) != null) {
                    int[] existingCidGid = cidGidMap.get(charCodeInt);
                    if (existingCidGid[0] == cidgid[0] && existingCidGid[1] == cidgid[1]) continue;
                    return new PDFA2FontErrorEmbeddingFailedGlyphError(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
                }
                Set<Integer> mapValues = cidGidMap.keySet();
                Iterator<Integer> mapIter = mapValues.iterator();
                while (mapIter.hasNext()) {
                    int[] existingCidGid = null;
                    existingCidGid = cidGidMap.get(mapIter.next());
                    if (existingCidGid[0] != cidgid[0] || existingCidGid[1] == cidgid[1]) continue;
                    return new PDFA2FontErrorEmbeddingFailedGlyphError(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
                }
                cidGidMap.put(charCodeInt, cidgid);
            }
        }
        catch (PDFFontException e) {
            return new PDFA2FontErrorFontDataCorrupt(font.getCosObject().getObjNum(), font.getCosObject().getObjGen());
        }
        ufInfo.setCharCodes(null);
        return null;
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> getReferencedGlyphErrors(PDFFont pdffont, HashSet<Integer> referencedCharCodes) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (pdffont == null) {
            return null;
        }
        if (pdffont instanceof PDFFontType3) {
            return null;
        }
        int objectNumber = pdffont.getCosObject().getObjNum();
        int genNumber = pdffont.getCosObject().getObjGen();
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        boolean widthMismatch = false;
        boolean missingGlyph = false;
        Font font = null;
        FontData fontData = null;
        try {
            font = pdffont.getAFEFont();
            if (font != null) {
                fontData = ((FontImpl)font).getFontData();
            }
        }
        catch (FontEngineException e3) {
            errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
        }
        if (font == null || fontData == null) {
            errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
            return errorCodes;
        }
        if (referencedCharCodes == null) {
            return errorCodes;
        }
        Iterator<Integer> iter = referencedCharCodes.iterator();
        try {
            while (iter.hasNext()) {
                double afeGlyphWidth;
                PDFFontType0 type0Font;
                Integer charCodeInt = iter.next();
                int charCode = charCodeInt;
                int gid = pdffont.charCode2gid(charCode);
                if (PDFFontUtils.isGlyphNotDef((PDFFont)pdffont, (int)charCode)) {
                    errorCodes.addErrorCode(new PDFA2FontErrorNotDefGlyphUsed(objectNumber, genNumber));
                }
                PDFFontSimple simpleFont = pdffont instanceof PDFFontSimple ? (PDFFontSimple)pdffont : null;
                PDFFontType0 pDFFontType0 = type0Font = pdffont instanceof PDFFontType0 ? (PDFFontType0)pdffont : null;
                if (type0Font != null && PDFFontUtils.isCMapIdentity((PDFType0FontEncoding)type0Font.getEncoding())) {
                    missingGlyph = gid < 0;
                } else if (simpleFont != null) {
                    if (simpleFont.getEncoding() != null && ".notdef".equals(simpleFont.charCode2glyphName(charCode))) {
                        missingGlyph = gid < 0;
                    } else {
                        boolean bl = missingGlyph = gid <= 0;
                    }
                    if (gid <= 0 && simpleFont.getSubtype() == ASName.k_TrueType && simpleFont.getEncoding() != null && simpleFont.getEncoding().isWinAnsiEncoding() && charCode < 32) {
                        missingGlyph = true;
                        errorCodes.addErrorCode(new PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph(objectNumber, genNumber));
                    }
                } else if (pdffont instanceof PDFFontType0) {
                    if (gid == 0) {
                        PDFType0FontEncoding encoding;
                        int cid;
                        PDFCIDFont descendantFont;
                        missingGlyph = true;
                        if (fontData instanceof OpenTypeFont && (descendantFont = type0Font.getDescendantFont()).getSubType() == ASName.k_CIDFontType2 && descendantFont.getFontDescriptor() != null && descendantFont.getFontDescriptor().containsEmbeddedFont() && descendantFont.cid2gid(cid = (encoding = type0Font.getEncoding()).getCID(charCode)) == 0) {
                            missingGlyph = false;
                        }
                    } else {
                        boolean bl = missingGlyph = gid < 0;
                    }
                }
                if (missingGlyph) {
                    if (!errorCodes.errorCodeSet(PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph.class)) {
                        errorCodes.addErrorCode(new PDFA2FontErrorEmbeddedFontMissingGlyphs(objectNumber, genNumber));
                    }
                    if (missingGlyph && widthMismatch) {
                        return errorCodes;
                    }
                }
                double pdfGlyphWidth = 0.0;
                if (simpleFont != null) {
                    pdfGlyphWidth = simpleFont.getGlyphWidthDefaultMissingWidth(charCode);
                }
                if (type0Font != null) {
                    pdfGlyphWidth = type0Font.getGlyphWidth(charCode);
                }
                if (!(Math.abs(pdfGlyphWidth - (afeGlyphWidth = font.getPDFFontDescription().getAdvance(gid))) > 1.0)) continue;
                errorCodes.addErrorCode(new PDFA2FontErrorMismatchedWidthsInfo(objectNumber, genNumber));
                widthMismatch = true;
                if (!missingGlyph || !widthMismatch) continue;
                return errorCodes;
            }
        }
        catch (FontEngineException e) {
            errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
        }
        catch (PDFFontException e) {
            errorCodes.addErrorCode(new PDFA2FontErrorPDFGeneralFailure(objectNumber, genNumber));
        }
        return errorCodes;
    }
}

