/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;

public class PDFA2Service {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validate(PDFDocument document, PDFA2ConformanceLevel conformance, PDFA2ValidationOptions options, PDFA2ValidationHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            document.getCosDocument().setUseRepairList(false);
            if (conformance == null) {
                throw new PDFInvalidParameterException("A conformance level must be specified.");
            }
            if (options == null) {
                throw new PDFInvalidParameterException("Validation options must be specified.");
            }
            if (handler == null) {
                throw new PDFInvalidParameterException("A validation handler must be specified.");
            }
            DocumentProcessor docProcessor = new DocumentProcessor();
            boolean bl = docProcessor.process(document, conformance, null, null, options, handler);
            return bl;
        }
        finally {
            document.getCosDocument().setUseRepairList(true);
            try {
                XMPService.releaseDocumentMetadata((PDFDocument)document);
            }
            catch (Exception e) {
                throw new PDFRuntimeException("Unexpected exception occured while releasing document metadata", (Throwable)e);
            }
        }
    }

    public static boolean convert(PDFDocument document, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions options, PDFA2ConversionHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (conformance == null) {
            throw new PDFInvalidParameterException("A conformance level must be specified.");
        }
        if (options == null) {
            throw new PDFInvalidParameterException("Conversion options must be specified.");
        }
        if (handler == null) {
            throw new PDFInvalidParameterException("A conversion handler must be specified.");
        }
        DocumentProcessor docProcessor = new DocumentProcessor();
        return docProcessor.process(document, conformance, options, handler, options, handler);
    }

    public static String getVersion(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        return MetadataProcessor.getVersion(document);
    }

    public static String getConformanceLevel(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        return MetadataProcessor.getConformanceLevel(document);
    }

    public static String getAmendmentID(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        return MetadataProcessor.getAmendmentID(document);
    }
}

